/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.model;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteredMemberList
extends AbstractList<Symbol> {
    private final Scope scope;

    public FilteredMemberList(Scope scope) {
        this.scope = scope;
    }

    @Override
    public int size() {
        int cnt = 0;
        Scope.Entry e = this.scope.elems;
        while (e != null) {
            if (!FilteredMemberList.unwanted(e.sym)) {
                ++cnt;
            }
            e = e.sibling;
        }
        return cnt;
    }

    @Override
    public Symbol get(int index) {
        Scope.Entry e = this.scope.elems;
        while (e != null) {
            if (!FilteredMemberList.unwanted(e.sym) && index-- == 0) {
                return e.sym;
            }
            e = e.sibling;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<Symbol> iterator() {
        return new Iterator<Symbol>(){
            private Scope.Entry nextEntry;
            private boolean hasNextForSure;
            {
                this.nextEntry = ((FilteredMemberList)FilteredMemberList.this).scope.elems;
                this.hasNextForSure = false;
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextForSure) {
                    return true;
                }
                while (this.nextEntry != null && FilteredMemberList.unwanted(this.nextEntry.sym)) {
                    this.nextEntry = this.nextEntry.sibling;
                }
                this.hasNextForSure = this.nextEntry != null;
                return this.hasNextForSure;
            }

            @Override
            public Symbol next() {
                if (this.hasNext()) {
                    Symbol result = this.nextEntry.sym;
                    this.nextEntry = this.nextEntry.sibling;
                    this.hasNextForSure = false;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static boolean unwanted(Symbol s) {
        return s == null || (s.flags() & 0x1000L) != 0L;
    }
}

