/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.AbstractLog;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.JavadocClassReader;
import com.sun.tools.javadoc.JavadocEnter;
import com.sun.tools.javadoc.JavadocMemberEnter;
import com.sun.tools.javadoc.JavadocTodo;
import com.sun.tools.javadoc.Messager;
import com.sun.tools.javadoc.ModifierFilter;
import com.sun.tools.javadoc.RootDocImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavadocTool
extends JavaCompiler {
    DocEnv docenv;
    final Messager messager;
    final JavadocClassReader javadocReader;
    final JavadocEnter javadocEnter;
    final Set<JavaFileObject> uniquefiles;
    static final boolean surrogatesSupported = JavadocTool.surrogatesSupported();

    protected JavadocTool(Context context) {
        super(context);
        this.messager = Messager.instance0(context);
        this.javadocReader = JavadocClassReader.instance0(context);
        this.javadocEnter = JavadocEnter.instance0(context);
        this.uniquefiles = new HashSet<JavaFileObject>();
    }

    @Override
    protected boolean keepComments() {
        return true;
    }

    public static JavadocTool make0(Context context) {
        AbstractLog messager = null;
        try {
            JavadocClassReader.preRegister(context);
            JavadocEnter.preRegister(context);
            JavadocMemberEnter.preRegister(context);
            JavadocTodo.preRegister(context);
            messager = Messager.instance0(context);
            return new JavadocTool(context);
        }
        catch (Symbol.CompletionFailure ex) {
            messager.error(-1, ex.getMessage(), new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public RootDocImpl getRootDocImpl(String doclocale, String encoding, ModifierFilter filter, List<String> javaNames, List<String[]> options, Iterable<? extends JavaFileObject> fileObjects, boolean breakiterator, List<String> subPackages, List<String> excludedPackages, boolean docClasses, boolean legacyDoclet, boolean quiet) throws IOException {
        this.docenv = DocEnv.instance(this.context);
        this.docenv.showAccess = filter;
        this.docenv.quiet = quiet;
        this.docenv.breakiterator = breakiterator;
        this.docenv.setLocale(doclocale);
        this.docenv.setEncoding(encoding);
        this.docenv.docClasses = docClasses;
        this.docenv.legacyDoclet = legacyDoclet;
        this.javadocReader.sourceCompleter = docClasses ? null : this.thisCompleter;
        ListBuffer<String> names = new ListBuffer<String>();
        ListBuffer<JCTree.JCCompilationUnit> classTrees = new ListBuffer<JCTree.JCCompilationUnit>();
        ListBuffer<JCTree.JCCompilationUnit> packTrees = new ListBuffer<JCTree.JCCompilationUnit>();
        try {
            StandardJavaFileManager fm = this.docenv.fileManager instanceof StandardJavaFileManager ? (StandardJavaFileManager)this.docenv.fileManager : null;
            List<String> it = javaNames;
            while (it.nonEmpty()) {
                String string = (String)it.head;
                if (!docClasses && fm != null && string.endsWith(".java") && new File(string).exists()) {
                    JavaFileObject fo = fm.getJavaFileObjects(string).iterator().next();
                    this.parse(fo, classTrees, true);
                } else if (this.isValidPackageName(string)) {
                    names = names.append(string);
                } else if (string.endsWith(".java")) {
                    if (fm == null) {
                        throw new IllegalArgumentException();
                    }
                    this.docenv.error(null, "main.file_not_found", string);
                } else {
                    this.docenv.error(null, "main.illegal_package_name", string);
                }
                it = it.tail;
            }
            for (JavaFileObject javaFileObject : fileObjects) {
                this.parse(javaFileObject, classTrees, true);
            }
            if (!docClasses) {
                void var18_23;
                Map<String, List<JavaFileObject>> packageFiles = this.searchSubPackages(subPackages, names, excludedPackages);
                List<String> list = names.toList();
                while (var18_23.nonEmpty()) {
                    String packageName = (String)var18_23.head;
                    this.parsePackageClasses(packageName, packageFiles.get(packageName), packTrees, excludedPackages);
                    List list2 = var18_23.tail;
                }
                if (this.messager.nerrors() != 0) {
                    return null;
                }
                this.docenv.notice("main.Building_tree");
                this.javadocEnter.main(classTrees.toList().appendList(packTrees.toList()));
            }
        }
        catch (Abort ex) {
            // empty catch block
        }
        if (this.messager.nerrors() != 0) {
            return null;
        }
        if (docClasses) {
            return new RootDocImpl(this.docenv, javaNames, options);
        }
        return new RootDocImpl(this.docenv, this.listClasses(classTrees.toList()), names.toList(), options);
    }

    boolean isValidPackageName(String s) {
        int index;
        while ((index = s.indexOf(46)) != -1) {
            if (!JavadocTool.isValidClassName(s.substring(0, index))) {
                return false;
            }
            s = s.substring(index + 1);
        }
        return JavadocTool.isValidClassName(s);
    }

    private void parsePackageClasses(String name, List<JavaFileObject> files, ListBuffer<JCTree.JCCompilationUnit> trees, List<String> excludedPackages) throws IOException {
        if (excludedPackages.contains(name)) {
            return;
        }
        this.docenv.notice("main.Loading_source_files_for_package", name);
        if (files == null) {
            StandardLocation location = this.docenv.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
            ListBuffer<JavaFileObject> lb = new ListBuffer<JavaFileObject>();
            for (JavaFileObject fo : this.docenv.fileManager.list(location, name, EnumSet.of(JavaFileObject.Kind.SOURCE), false)) {
                String binaryName = this.docenv.fileManager.inferBinaryName(location, fo);
                String simpleName = this.getSimpleName(binaryName);
                if (!JavadocTool.isValidClassName(simpleName)) continue;
                lb.append(fo);
            }
            files = lb.toList();
        }
        if (files.nonEmpty()) {
            for (JavaFileObject fo : files) {
                this.parse(fo, trees, false);
            }
        } else {
            this.messager.warning(Messager.NOPOS, "main.no_source_files_for_package", name.replace(File.separatorChar, '.'));
        }
    }

    private void parse(JavaFileObject fo, ListBuffer<JCTree.JCCompilationUnit> trees, boolean trace) {
        if (this.uniquefiles.add(fo)) {
            if (trace) {
                this.docenv.notice("main.Loading_source_file", fo.getName());
            }
            trees.append(this.parse(fo));
        }
    }

    private Map<String, List<JavaFileObject>> searchSubPackages(List<String> subPackages, ListBuffer<String> packages, List<String> excludedPackages) throws IOException {
        HashMap<String, List<JavaFileObject>> packageFiles = new HashMap<String, List<JavaFileObject>>();
        HashMap<String, Boolean> includedPackages = new HashMap<String, Boolean>();
        includedPackages.put("", true);
        for (String p : excludedPackages) {
            includedPackages.put(p, false);
        }
        StandardLocation path = this.docenv.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
        this.searchSubPackages(subPackages, includedPackages, packages, packageFiles, path, EnumSet.of(JavaFileObject.Kind.SOURCE));
        return packageFiles;
    }

    private void searchSubPackages(List<String> subPackages, Map<String, Boolean> includedPackages, ListBuffer<String> packages, Map<String, List<JavaFileObject>> packageFiles, StandardLocation location, Set<JavaFileObject.Kind> kinds) throws IOException {
        for (String subPackage : subPackages) {
            if (!this.isIncluded(subPackage, includedPackages)) continue;
            for (JavaFileObject fo : this.docenv.fileManager.list(location, subPackage, kinds, true)) {
                String binaryName = this.docenv.fileManager.inferBinaryName(location, fo);
                String packageName = this.getPackageName(binaryName);
                String simpleName = this.getSimpleName(binaryName);
                if (!this.isIncluded(packageName, includedPackages) || !JavadocTool.isValidClassName(simpleName)) continue;
                List<JavaFileObject> list = packageFiles.get(packageName);
                list = list == null ? List.of(fo) : list.prepend(fo);
                packageFiles.put(packageName, list);
                if (packages.contains(packageName)) continue;
                packages.add(packageName);
            }
        }
    }

    private String getPackageName(String name) {
        int lastDot = name.lastIndexOf(".");
        return lastDot == -1 ? "" : name.substring(0, lastDot);
    }

    private String getSimpleName(String name) {
        int lastDot = name.lastIndexOf(".");
        return lastDot == -1 ? name : name.substring(lastDot + 1);
    }

    private boolean isIncluded(String packageName, Map<String, Boolean> includedPackages) {
        Boolean b = includedPackages.get(packageName);
        if (b == null) {
            b = this.isIncluded(this.getPackageName(packageName), includedPackages);
            includedPackages.put(packageName, b);
        }
        return b;
    }

    private void searchSubPackage(String packageName, ListBuffer<String> packages, List<String> excludedPackages, Collection<File> pathnames) {
        if (excludedPackages.contains(packageName)) {
            return;
        }
        String packageFilename = packageName.replace('.', File.separatorChar);
        boolean addedPackage = false;
        for (File pathname : pathnames) {
            File f = new File(pathname, packageFilename);
            String[] filenames = f.list();
            if (filenames == null) continue;
            for (String filename : filenames) {
                if (!addedPackage && (JavadocTool.isValidJavaSourceFile(filename) || JavadocTool.isValidJavaClassFile(filename)) && !packages.contains(packageName)) {
                    packages.append(packageName);
                    addedPackage = true;
                    continue;
                }
                if (!JavadocTool.isValidClassName(filename) || !new File(f, filename).isDirectory()) continue;
                this.searchSubPackage(packageName + "." + filename, packages, excludedPackages, pathnames);
            }
        }
    }

    private static boolean isValidJavaClassFile(String file) {
        if (!file.endsWith(".class")) {
            return false;
        }
        String clazzName = file.substring(0, file.length() - ".class".length());
        return JavadocTool.isValidClassName(clazzName);
    }

    private static boolean isValidJavaSourceFile(String file) {
        if (!file.endsWith(".java")) {
            return false;
        }
        String clazzName = file.substring(0, file.length() - ".java".length());
        return JavadocTool.isValidClassName(clazzName);
    }

    private static boolean surrogatesSupported() {
        try {
            boolean b = Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    public static boolean isValidClassName(String s) {
        if (s.length() < 1) {
            return false;
        }
        if (s.equals("package-info")) {
            return true;
        }
        if (surrogatesSupported) {
            int cp = s.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                return false;
            }
            for (int j = Character.charCount(cp); j < s.length(); j += Character.charCount(cp)) {
                cp = s.codePointAt(j);
                if (Character.isJavaIdentifierPart(cp)) continue;
                return false;
            }
        } else {
            if (!Character.isJavaIdentifierStart(s.charAt(0))) {
                return false;
            }
            for (int j = 1; j < s.length(); ++j) {
                if (Character.isJavaIdentifierPart(s.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    List<JCTree.JCClassDecl> listClasses(List<JCTree.JCCompilationUnit> trees) {
        ListBuffer<JCTree.JCClassDecl> result = new ListBuffer<JCTree.JCClassDecl>();
        for (JCTree.JCCompilationUnit t : trees) {
            for (JCTree def : t.defs) {
                if (!def.hasTag(JCTree.Tag.CLASSDEF)) continue;
                result.append((JCTree.JCClassDecl)def);
            }
        }
        return result.toList();
    }
}

