/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.MakeLogReader;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class AnalyzeMakeLog
extends BaseProvider {
    public static final String MAKE_LOG_PROVIDER_ID = "make-log";
    private final Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    private final ProviderProperty<String> MAKE_LOG_PROPERTY;
    private final ProviderProperty<FileSystem> LOG_FILESYSTEM_PROPERTY;
    private Progress progress;

    public AnalyzeMakeLog() {
        this.myProperties.clear();
        this.MAKE_LOG_PROPERTY = new ProviderProperty<String>(){
            private String myPath;

            public String getName() {
                return AnalyzeMakeLog.i18n("Make_Log_File_Name");
            }

            public String getDescription() {
                return AnalyzeMakeLog.i18n("Make_Log_File_Description");
            }

            public String getValue() {
                return this.myPath;
            }

            public void setValue(String value) {
                this.myPath = value;
            }

            public ProviderPropertyType getPropertyType() {
                return ProviderPropertyType.MakeLogPropertyType;
            }
        };
        this.myProperties.put(this.MAKE_LOG_PROPERTY.getPropertyType().key(), this.MAKE_LOG_PROPERTY);
        this.LOG_FILESYSTEM_PROPERTY = new ProviderProperty<FileSystem>(){
            private FileSystem fs;

            public String getName() {
                return "";
            }

            public String getDescription() {
                return "";
            }

            public FileSystem getValue() {
                return this.fs;
            }

            public void setValue(FileSystem value) {
                this.fs = value;
            }

            public ProviderPropertyType<FileSystem> getPropertyType() {
                return ProviderPropertyType.LogFileSystemPropertyType;
            }
        };
        this.myProperties.put(this.LOG_FILESYSTEM_PROPERTY.getPropertyType().key(), this.LOG_FILESYSTEM_PROPERTY);
        this.myProperties.put(this.RESTRICT_SOURCE_ROOT_PROPERTY.getPropertyType().key(), this.RESTRICT_SOURCE_ROOT_PROPERTY);
        this.myProperties.put(this.RESTRICT_COMPILE_ROOT_PROPERTY.getPropertyType().key(), this.RESTRICT_COMPILE_ROOT_PROPERTY);
    }

    public String getID() {
        return MAKE_LOG_PROVIDER_ID;
    }

    public String getName() {
        return AnalyzeMakeLog.i18n("Make_Log_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeMakeLog.i18n("Make_Log_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    @Override
    public boolean isApplicable(ProjectProxy project) {
        String o = (String)this.RESTRICT_COMPILE_ROOT_PROPERTY.getValue();
        if (o == null || o.isEmpty()) {
            this.RESTRICT_COMPILE_ROOT_PROPERTY.setValue((Object)project.getSourceRoot());
            return true;
        }
        return false;
    }

    private FileObject getLog(String set) {
        FSPath log;
        FileObject fo;
        FileSystem fs = (FileSystem)this.LOG_FILESYSTEM_PROPERTY.getValue();
        if (fs == null) {
            fs = CndFileSystemProvider.getLocalFileSystem();
        }
        if ((fo = (log = new FSPath(fs, set)).getFileObject()) != null && fo.isValid() && fo.isData() && fo.canRead()) {
            return fo;
        }
        return null;
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project, Interrupter interrupter) {
        this.init(project);
        String set = (String)this.MAKE_LOG_PROPERTY.getValue();
        if (set == null || set.length() == 0 || this.getLog(set) == null) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeMakeLog.class, (String)"NotFoundMakeLog")));
        }
        return new ApplicableImpl(true, null, null, 80, false, null, null, null, null);
    }

    @Override
    protected List<SourceFileProperties> getSourceFileProperties(String logFileName, Map<String, SourceFileProperties> map, ProjectProxy project, Set<String> dlls, List<String> buildArtifacts, CompileLineStorage storage) {
        String root = (String)this.RESTRICT_COMPILE_ROOT_PROPERTY.getValue();
        if (root == null) {
            root = "";
        }
        List<SourceFileProperties> res = this.runLogReader(this.getLog(logFileName), root, this.progress, project, buildArtifacts, storage);
        this.progress = null;
        return res;
    }

    private List<SourceFileProperties> runLogReader(FileObject logFileObject, String root, Progress progress, ProjectProxy project, List<String> buildArtifacts, CompileLineStorage storage) {
        FileSystem fileSystem = this.getFileSystem(project);
        MakeLogReader reader = new MakeLogReader(logFileObject, root, project, this.getRelocatablePathMapper(), fileSystem);
        List<SourceFileProperties> list = reader.getResults(progress, this.getStopInterrupter(), storage);
        buildArtifacts.addAll(reader.getArtifacts(progress, this.getStopInterrupter(), storage));
        return list;
    }

    public List<Configuration> analyze(final ProjectProxy project, Progress progress, Interrupter interrupter) {
        this.resetStopInterrupter(interrupter);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.init(project);
        this.progress = progress;
        if (!this.getStopInterrupter().cancelled()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myBuildArtifacts;
                private List<String> myIncludedFiles = new ArrayList<String>();

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    return null;
                }

                public List<String> getBuildArtifacts() {
                    String set;
                    if (this.myBuildArtifacts == null && (set = (String)AnalyzeMakeLog.this.MAKE_LOG_PROPERTY.getValue()) != null && set.length() > 0) {
                        this.myBuildArtifacts = Collections.synchronizedList(new ArrayList());
                        this.myFileProperties = AnalyzeMakeLog.this.getSourceFileProperties(new String[]{set}, null, project, null, this.myBuildArtifacts, new CompileLineStorage());
                        AnalyzeMakeLog.this.store(project);
                    }
                    return this.myBuildArtifacts;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    String set;
                    if (this.myFileProperties == null && (set = (String)AnalyzeMakeLog.this.MAKE_LOG_PROPERTY.getValue()) != null && set.length() > 0) {
                        this.myBuildArtifacts = Collections.synchronizedList(new ArrayList());
                        this.myFileProperties = AnalyzeMakeLog.this.getSourceFileProperties(new String[]{set}, null, project, null, this.myBuildArtifacts, new CompileLineStorage());
                        AnalyzeMakeLog.this.store(project);
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeMakeLog.class, (String)id);
    }
}

