/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.jaxws.WSStackUtils;
import org.netbeans.modules.maven.jaxws.WsimportPomInfo;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Resource;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.filesystems.FileObject;

public final class MavenModelUtils {
    private static final String WSIPMORT_GENERATE_PREFIX = "wsimport-generate-";
    private static final String STALE_FILE_DIRECTORY = "${project.build.directory}/jaxws/stale/";
    private static final String STALE_FILE_EXTENSION = ".stale";
    public static final String JAXWS_GROUP_ID = "org.jvnet.jax-ws-commons";
    public static final String JAXWS_ARTIFACT_ID = "jaxws-maven-plugin";
    public static final String JAXWS_PLUGIN_KEY = "org.jvnet.jax-ws-commons:jaxws-maven-plugin";
    private static final String JAXWS_CATALOG = "jax-ws-catalog.xml";
    public static final String JAX_WS_PLUGIN_VERSION = "2.3";

    public static org.netbeans.modules.maven.model.pom.Plugin addJaxWSPlugin(POMModel model) {
        return MavenModelUtils.addJaxWSPlugin(model, null);
    }

    public static org.netbeans.modules.maven.model.pom.Plugin addJaxWSPlugin(POMModel model, String jaxWsVersion) {
        org.netbeans.modules.maven.model.pom.Plugin plugin;
        assert (model.isIntransaction()) : "need to call model modifications under transaction.";
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            bld = model.getFactory().createBuild();
            model.getProject().setBuild(bld);
        }
        if ((plugin = bld.findPluginById(JAXWS_GROUP_ID, JAXWS_ARTIFACT_ID)) != null) {
            return plugin;
        }
        plugin = model.getFactory().createPlugin();
        plugin.setGroupId(JAXWS_GROUP_ID);
        plugin.setArtifactId(JAXWS_ARTIFACT_ID);
        plugin.setVersion(JAX_WS_PLUGIN_VERSION);
        bld.addPlugin(plugin);
        Configuration config = plugin.getConfiguration();
        if (config == null) {
            config = model.getFactory().createConfiguration();
            plugin.setConfiguration(config);
        }
        config.setSimpleParameter("sourceDestDir", "${project.build.directory}/generated-sources/jaxws-wsimport");
        config.setSimpleParameter("xnocompile", "true");
        config.setSimpleParameter("verbose", "true");
        config.setSimpleParameter("extension", "true");
        config.setSimpleParameter("catalog", "${basedir}/src/jax-ws-catalog.xml");
        if (jaxWsVersion != null) {
            config.setSimpleParameter("target", jaxWsVersion);
        }
        Dependency webservicesDep = model.getFactory().createDependency();
        webservicesDep.setGroupId("javax.xml");
        webservicesDep.setArtifactId("webservices-api");
        webservicesDep.setVersion("2.0");
        plugin.addDependency(webservicesDep);
        return plugin;
    }

    public static org.netbeans.modules.maven.model.pom.Plugin addWarPlugin(POMModel model) {
        POMExtensibilityElement webResources;
        Configuration config;
        org.netbeans.modules.maven.model.pom.Plugin plugin;
        assert (model.isIntransaction()) : "need to call model modifications under transaction.";
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            bld = model.getFactory().createBuild();
            model.getProject().setBuild(bld);
        }
        if ((plugin = bld.findPluginById("org.apache.maven.plugins", "maven-war-plugin")) == null) {
            plugin = model.getFactory().createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-war-plugin");
            plugin.setVersion("2.0.2");
            bld.addPlugin(plugin);
        }
        if ((config = plugin.getConfiguration()) == null) {
            config = model.getFactory().createConfiguration();
            plugin.setConfiguration(config);
        }
        if ((webResources = MavenModelUtils.findChild(config.getConfigurationElements(), "webResources")) == null) {
            webResources = model.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"webResources", (boolean)model.getPOMQNames().isNSAware()));
            config.addExtensibilityElement(webResources);
        }
        if (!MavenModelUtils.hasResource(webResources, JAXWS_CATALOG)) {
            POMExtensibilityElement res = model.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"resource", (boolean)model.getPOMQNames().isNSAware()));
            webResources.addExtensibilityElement(res);
            POMExtensibilityElement dir = model.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"directory", (boolean)model.getPOMQNames().isNSAware()));
            dir.setElementText("src");
            res.addExtensibilityElement(dir);
            POMExtensibilityElement tp = model.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"targetPath", (boolean)model.getPOMQNames().isNSAware()));
            tp.setElementText("WEB-INF");
            res.addExtensibilityElement(tp);
            POMExtensibilityElement in = model.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"includes", (boolean)model.getPOMQNames().isNSAware()));
            res.addExtensibilityElement(in);
            POMExtensibilityElement include = model.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"include", (boolean)model.getPOMQNames().isNSAware()));
            include.setElementText(JAXWS_CATALOG);
            in.addExtensibilityElement(include);
            include = model.getFactory().createPOMExtensibilityElement(POMQName.createQName((String)"include", (boolean)model.getPOMQNames().isNSAware()));
            include.setElementText("wsdl/**");
            in.addExtensibilityElement(include);
        }
        return plugin;
    }

    public static void addWsdlResources(POMModel model) {
        Resource res;
        assert (model.isIntransaction());
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            return;
        }
        boolean foundResourceForMetaInf = false;
        boolean mainResourcesFound = false;
        List resources = bld.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                if ("META-INF".equals(resource.getTargetPath()) && ("src".equals(resource.getDirectory()) || "${basedir}/src".equals(resource.getDirectory()))) {
                    foundResourceForMetaInf = true;
                    continue;
                }
                if (!"src/main/resources".equals(resource.getDirectory())) continue;
                mainResourcesFound = true;
            }
        }
        if (!foundResourceForMetaInf) {
            res = model.getFactory().createResource();
            res.setTargetPath("META-INF");
            res.setDirectory("src");
            res.addInclude(JAXWS_CATALOG);
            res.addInclude("wsdl/**");
            bld.addResource(res);
        }
        if (!mainResourcesFound) {
            res = model.getFactory().createResource();
            res.setDirectory("src/main/resources");
            bld.addResource(res);
        }
    }

    private static POMExtensibilityElement findChild(List<POMExtensibilityElement> elems, String name) {
        for (POMExtensibilityElement e : elems) {
            if (!name.equals(e.getQName().getLocalPart())) continue;
            return e;
        }
        return null;
    }

    private static POMExtensibilityElement findElementForValue(List<POMExtensibilityElement> elems, String value) {
        for (POMExtensibilityElement e : elems) {
            if (!value.equals(e.getElementText())) continue;
            return e;
        }
        return null;
    }

    public static void addWsimportExecution(org.netbeans.modules.maven.model.pom.Plugin plugin, String id, String wsdlPath, String originalUrl) {
        MavenModelUtils.addWsimportExecution(plugin, id, wsdlPath, originalUrl, null);
    }

    public static void addWsimportExecution(org.netbeans.modules.maven.model.pom.Plugin plugin, String id, String wsdlPath, String originalUrl, String packageName) {
        POMModel model = plugin.getModel();
        assert (model.isIntransaction());
        org.netbeans.modules.maven.model.pom.PluginExecution exec = model.getFactory().createExecution();
        String uniqueId = MavenModelUtils.getUniqueId(plugin, id);
        exec.setId(WSIPMORT_GENERATE_PREFIX + uniqueId);
        exec.setPhase("generate-sources");
        exec.addGoal("wsimport");
        plugin.addExecution(exec);
        Configuration config = model.getFactory().createConfiguration();
        exec.setConfiguration(config);
        QName qname = POMQName.createQName((String)"wsdlFiles", (boolean)model.getPOMQNames().isNSAware());
        POMExtensibilityElement wsdlFiles = model.getFactory().createPOMExtensibilityElement(qname);
        config.addExtensibilityElement(wsdlFiles);
        if (packageName != null) {
            qname = POMQName.createQName((String)"packageName", (boolean)model.getPOMQNames().isNSAware());
            POMExtensibilityElement packageNameElement = model.getFactory().createPOMExtensibilityElement(qname);
            packageNameElement.setElementText(packageName);
            config.addExtensibilityElement(packageNameElement);
        }
        qname = POMQName.createQName((String)"wsdlFile", (boolean)model.getPOMQNames().isNSAware());
        POMExtensibilityElement wsdlFile = model.getFactory().createPOMExtensibilityElement(qname);
        wsdlFile.setElementText(wsdlPath);
        wsdlFiles.addExtensibilityElement(wsdlFile);
        qname = POMQName.createQName((String)"vmArgs", (boolean)model.getPOMQNames().isNSAware());
        POMExtensibilityElement vmArgs = model.getFactory().createPOMExtensibilityElement(qname);
        config.addExtensibilityElement(vmArgs);
        qname = POMQName.createQName((String)"vmArg", (boolean)model.getPOMQNames().isNSAware());
        POMExtensibilityElement vmArg = model.getFactory().createPOMExtensibilityElement(qname);
        vmArg.setElementText("-Djavax.xml.accessExternalSchema=all");
        vmArgs.addExtensibilityElement(vmArg);
        if (originalUrl != null) {
            qname = POMQName.createQName((String)"wsdlLocation", (boolean)model.getPOMQNames().isNSAware());
            POMExtensibilityElement wsdlLocation = model.getFactory().createPOMExtensibilityElement(qname);
            wsdlLocation.setElementText(originalUrl);
            config.addExtensibilityElement(wsdlLocation);
        }
        qname = POMQName.createQName((String)"staleFile", (boolean)model.getPOMQNames().isNSAware());
        POMExtensibilityElement staleFile = model.getFactory().createPOMExtensibilityElement(qname);
        staleFile.setElementText(STALE_FILE_DIRECTORY + uniqueId + STALE_FILE_EXTENSION);
        config.addExtensibilityElement(staleFile);
    }

    public static void addBindingFile(POMModel model, String id, String bindingFilePath) {
        assert (model.isIntransaction());
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            return;
        }
        org.netbeans.modules.maven.model.pom.Plugin plugin = bld.findPluginById(JAXWS_GROUP_ID, JAXWS_ARTIFACT_ID);
        if (plugin != null) {
            List executions = plugin.getExecutions();
            String execId = WSIPMORT_GENERATE_PREFIX + id;
            for (org.netbeans.modules.maven.model.pom.PluginExecution exec : executions) {
                POMExtensibilityElement bindingFile;
                POMExtensibilityElement bindingFiles;
                if (!execId.equals(exec.getId())) continue;
                Configuration config = exec.getConfiguration();
                if (config == null) break;
                QName qname = POMQName.createQName((String)"bindingDirectory", (boolean)model.getPOMQNames().isNSAware());
                if (config.getChildElementText(qname) == null) {
                    POMExtensibilityElement bindingDir = model.getFactory().createPOMExtensibilityElement(qname);
                    bindingDir.setElementText("${basedir}/src/jaxws-bindings");
                    config.addExtensibilityElement(bindingDir);
                }
                if ((bindingFiles = MavenModelUtils.findChild(config.getConfigurationElements(), "bindingFiles")) == null) {
                    qname = POMQName.createQName((String)"bindingFiles", (boolean)model.getPOMQNames().isNSAware());
                    bindingFiles = model.getFactory().createPOMExtensibilityElement(qname);
                    config.addExtensibilityElement(bindingFiles);
                }
                if ((bindingFile = MavenModelUtils.findElementForValue(bindingFiles.getExtensibilityElements(), bindingFilePath)) != null) break;
                qname = POMQName.createQName((String)"bindingFile", (boolean)model.getPOMQNames().isNSAware());
                bindingFile = model.getFactory().createPOMExtensibilityElement(qname);
                bindingFile.setElementText(bindingFilePath);
                bindingFiles.addExtensibilityElement(bindingFile);
                break;
            }
        }
    }

    public static void removeWsimportExecution(POMModel model, String id) {
        List executions;
        assert (model.isIntransaction());
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            return;
        }
        org.netbeans.modules.maven.model.pom.Plugin plugin = bld.findPluginById(JAXWS_GROUP_ID, JAXWS_ARTIFACT_ID);
        if (plugin != null && (executions = plugin.getExecutions()) != null) {
            for (org.netbeans.modules.maven.model.pom.PluginExecution exec : executions) {
                String execId = WSIPMORT_GENERATE_PREFIX + id;
                if (!execId.equals(exec.getId())) continue;
                plugin.removeExecution(exec);
                break;
            }
        }
    }

    public static void renameWsdlFile(POMModel model, String oldId, String newId, String oldWsdlPath, String newWsdlPath) {
        assert (model.isIntransaction());
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            return;
        }
        org.netbeans.modules.maven.model.pom.Plugin plugin = bld.findPluginById(JAXWS_GROUP_ID, JAXWS_ARTIFACT_ID);
        if (plugin != null) {
            List executions = plugin.getExecutions();
            String execId = WSIPMORT_GENERATE_PREFIX + oldId;
            for (org.netbeans.modules.maven.model.pom.PluginExecution exec : executions) {
                POMExtensibilityElement staleFile;
                Configuration config = exec.getConfiguration();
                if (config == null || !execId.equals(exec.getId())) continue;
                POMExtensibilityElement wsdlFiles = MavenModelUtils.findChild(config.getConfigurationElements(), "wsdlFiles");
                if (wsdlFiles != null) {
                    List files = wsdlFiles.getExtensibilityElements();
                    for (POMExtensibilityElement el : files) {
                        if (!"wsdlFile".equals(el.getQName().getLocalPart()) || !oldWsdlPath.equals(el.getElementText())) continue;
                        el.setElementText(newWsdlPath);
                        break;
                    }
                }
                if ((staleFile = MavenModelUtils.findChild(config.getConfigurationElements(), "staleFile")) != null) {
                    staleFile.setElementText(STALE_FILE_DIRECTORY + newId + STALE_FILE_EXTENSION);
                }
                exec.setId(WSIPMORT_GENERATE_PREFIX + newId);
                break;
            }
        }
    }

    public static void addMetroLibrary(Project project) {
        WSStack<JaxWs> wsStack = new WSStackUtils(project).getWsStack(JaxWs.class);
        String scope = null;
        if (wsStack != null && wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT)) {
            scope = "provided";
        }
        ModelUtils.addDependency((FileObject)project.getProjectDirectory().getFileObject("pom.xml"), (String)"org.glassfish.metro", (String)"webservices-rt", (String)JAX_WS_PLUGIN_VERSION, null, (String)scope, null, (boolean)false);
    }

    public static boolean hasJaxWsAPI(Project project) {
        ClassPath classPath;
        FileObject wsFeature;
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        return srcGroups.length <= 0 || (wsFeature = (classPath = ClassPath.getClassPath((FileObject)srcGroups[0].getRootFolder(), (String)"classpath/boot")).findResource("javax/xml/ws/WebServiceFeature.class")) != null || (wsFeature = (classPath = ClassPath.getClassPath((FileObject)srcGroups[0].getRootFolder(), (String)"classpath/compile")).findResource("javax/xml/ws/WebServiceFeature.class")) != null;
    }

    public static void addJavadoc(Project project) {
        NbMavenProject mavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (mavenProject != null) {
            mavenProject.downloadDependencyAndJavadocSource(false);
        }
    }

    static List<WsimportPomInfo> getWsdlFiles(Project project) {
        MavenProject mavenProject = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        assert (mavenProject != null);
        List plugins = mavenProject.getBuildPlugins();
        ArrayList<WsimportPomInfo> wsdlList = new ArrayList<WsimportPomInfo>();
        for (Plugin plg : plugins) {
            if (!JAXWS_PLUGIN_KEY.equalsIgnoreCase(plg.getKey())) continue;
            List executions = plg.getExecutions();
            for (PluginExecution exec : executions) {
                String execId;
                String bindingPath;
                Xpp3Dom wsdlFile;
                Xpp3Dom wsdlFiles;
                Xpp3Dom conf = (Xpp3Dom)exec.getConfiguration();
                if (conf == null || (wsdlFiles = conf.getChild("wsdlFiles")) == null || (wsdlFile = wsdlFiles.getChild("wsdlFile")) == null) continue;
                WsimportPomInfo pomInfo = new WsimportPomInfo(wsdlFile.getValue());
                Xpp3Dom bindingFiles = conf.getChild("bindingFiles");
                if (bindingFiles != null && (bindingPath = MavenModelUtils.findHandler(bindingFiles)) != null) {
                    pomInfo.setHandlerFile(bindingPath);
                }
                if ((execId = exec.getId()) != null) {
                    if (execId.startsWith(WSIPMORT_GENERATE_PREFIX)) {
                        pomInfo.setId(execId.substring(WSIPMORT_GENERATE_PREFIX.length()));
                    } else {
                        pomInfo.setId(execId);
                    }
                }
                wsdlList.add(pomInfo);
            }
        }
        return wsdlList;
    }

    private static String findHandler(Xpp3Dom parent) {
        for (Xpp3Dom child : parent.getChildren("bindingFile")) {
            String bindingPath = child.getValue();
            if (bindingPath == null || !bindingPath.endsWith("_handler.xml")) continue;
            return bindingPath;
        }
        return null;
    }

    private static void updateLibraryScope(POMModel model, String groupId, String targetScope) {
        assert (model.isIntransaction()) : "need to call model modifications under transaction.";
        Dependency wsDep = model.getProject().findDependencyById(groupId, "webservices-rt", null);
        if (wsDep != null) {
            wsDep.setScope(targetScope);
        }
    }

    static void reactOnServerChanges(Project prj) {
        NbMavenProject nb = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        List deps = nb.getMavenProject().getDependencies();
        String metroScope = null;
        boolean foundMetroDep = false;
        String groupId = null;
        for (org.apache.maven.model.Dependency dep : deps) {
            String scope;
            if ("com.sun.xml.ws".equals(dep.getGroupId()) && "webservices-rt".equals(dep.getArtifactId())) {
                scope = dep.getScope();
                metroScope = scope == null ? "compile" : scope;
                foundMetroDep = true;
                groupId = "com.sun.xml.ws";
                break;
            }
            if (!"org.glassfish.metro".equals(dep.getGroupId()) || !"webservices-rt".equals(dep.getArtifactId())) continue;
            scope = dep.getScope();
            metroScope = scope == null ? "compile" : scope;
            foundMetroDep = true;
            groupId = "org.glassfish.metro";
            break;
        }
        String updateScopeTo = null;
        if (foundMetroDep) {
            WSStack<JaxWs> wsStack = new WSStackUtils(prj).getWsStack(JaxWs.class);
            if (wsStack != null) {
                if (wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT)) {
                    if ("compile".equals(metroScope)) {
                        updateScopeTo = "provided";
                    }
                } else if ("provided".equals(metroScope)) {
                    updateScopeTo = "compile";
                }
            }
            if (updateScopeTo != null) {
                final String targetScope = updateScopeTo;
                final String grpId = groupId;
                ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        MavenModelUtils.updateLibraryScope(model, grpId, targetScope);
                    }
                };
                Utilities.performPOMModelOperations((FileObject)prj.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(operation));
            }
        }
    }

    private static boolean hasResource(POMExtensibilityElement webResources, String resourceName) {
        List resources = webResources.getChildren(POMExtensibilityElement.class);
        for (POMExtensibilityElement res : resources) {
            POMExtensibilityElement includesEl = MavenModelUtils.findChild(res.getExtensibilityElements(), "includes");
            if (includesEl == null) continue;
            List includes = includesEl.getChildren(POMExtensibilityElement.class);
            for (POMExtensibilityElement include : includes) {
                if (!resourceName.equals(include.getElementText())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getUniqueId(org.netbeans.modules.maven.model.pom.Plugin plugin, String id) {
        String result = id;
        List executions = plugin.getExecutions();
        if (executions != null) {
            HashSet<String> execIdSet = new HashSet<String>();
            for (org.netbeans.modules.maven.model.pom.PluginExecution ex : executions) {
                String execId = ex.getId();
                if (execId == null) continue;
                if (execId.startsWith(WSIPMORT_GENERATE_PREFIX)) {
                    execIdSet.add(execId.substring(WSIPMORT_GENERATE_PREFIX.length()));
                    continue;
                }
                execIdSet.add(execId);
            }
            int i = 1;
            while (execIdSet.contains(result)) {
                result = id + "_" + String.valueOf(i++);
            }
        }
        return result;
    }
}

