/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.util;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SymfonyUtils {
    public static final String ACTION_METHOD_PREFIX = "execute";
    public static final String ACTION_CLASS_SUFFIX = "actions";
    private static final String FILE_ACTION = "actions.class.php";
    private static final String FILE_ACTION_RELATIVE = "../actions/actions.class.php";
    private static final String DIR_TEMPLATES = "templates";
    private static final String DIR_TEMPLATES_RELATIVE = "../templates";
    private static final String VIEW_FILE_SUFFIX = "Success";
    private static final String TEMPLATE_REGEX = "%sSuccess(\\.\\w+)?\\.php";

    private SymfonyUtils() {
    }

    public static boolean isView(FileObject fo) {
        File file = FileUtil.toFile((FileObject)fo);
        return DIR_TEMPLATES.equals(file.getParentFile().getName());
    }

    public static boolean isViewWithAction(FileObject fo) {
        return SymfonyUtils.isView(fo) && SymfonyUtils.getAction(fo) != null;
    }

    public static boolean isAction(FileObject fo) {
        return FILE_ACTION.equals(fo.getNameExt());
    }

    public static FileObject getAction(FileObject fo) {
        File parent = FileUtil.toFile((FileObject)fo).getParentFile();
        File action = PropertyUtils.resolveFile((File)parent, (String)FILE_ACTION_RELATIVE);
        if (action.isFile()) {
            return FileUtil.toFileObject((File)action);
        }
        return null;
    }

    public static String getActionName(FileObject view) {
        return SymfonyUtils.getActionName(view.getName());
    }

    static String getActionName(String viewName) {
        String[] parts = viewName.split("\\.");
        return ACTION_METHOD_PREFIX + parts[0].replaceAll("Success$", "").toLowerCase();
    }

    public static List<FileObject> getViews(FileObject fo, PhpBaseElement phpElement) {
        String methodName;
        LinkedList<FileObject> views = new LinkedList<FileObject>();
        if (phpElement instanceof PhpClass.Method && (methodName = phpElement.getName()).startsWith(ACTION_METHOD_PREFIX)) {
            String partName = methodName.substring(ACTION_METHOD_PREFIX.length());
            views.addAll(SymfonyUtils.getViews(fo, partName.substring(0, 1).toLowerCase() + partName.substring(1)));
        }
        return views;
    }

    private static List<FileObject> getViews(FileObject fo, final String viewName) {
        File[] fileViews;
        LinkedList<FileObject> views = new LinkedList<FileObject>();
        File parent = FileUtil.toFile((FileObject)fo).getParentFile();
        File templatesDir = PropertyUtils.resolveFile((File)parent, (String)DIR_TEMPLATES_RELATIVE);
        for (File view : fileViews = templatesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().matches(String.format(SymfonyUtils.TEMPLATE_REGEX, viewName));
            }
        })) {
            views.add(FileUtil.toFileObject((File)view));
        }
        return views;
    }
}

