/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.client;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSession;
import org.apache.maven.wagon.providers.http.httpclient.ConnectionReuseStrategy;
import org.apache.maven.wagon.providers.http.httpclient.HttpEntity;
import org.apache.maven.wagon.providers.http.httpclient.HttpException;
import org.apache.maven.wagon.providers.http.httpclient.HttpHost;
import org.apache.maven.wagon.providers.http.httpclient.HttpRequestInterceptor;
import org.apache.maven.wagon.providers.http.httpclient.HttpResponse;
import org.apache.maven.wagon.providers.http.httpclient.ProtocolVersion;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthSchemeRegistry;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthScope;
import org.apache.maven.wagon.providers.http.httpclient.auth.AuthState;
import org.apache.maven.wagon.providers.http.httpclient.auth.Credentials;
import org.apache.maven.wagon.providers.http.httpclient.client.params.HttpClientParams;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestClientConnControl;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestProxyAuthentication;
import org.apache.maven.wagon.providers.http.httpclient.conn.HttpRoutedConnection;
import org.apache.maven.wagon.providers.http.httpclient.conn.routing.HttpRoute;
import org.apache.maven.wagon.providers.http.httpclient.entity.BufferedHttpEntity;
import org.apache.maven.wagon.providers.http.httpclient.impl.DefaultConnectionReuseStrategy;
import org.apache.maven.wagon.providers.http.httpclient.impl.DefaultHttpClientConnection;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.BasicSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.DigestSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.KerberosSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.NTLMSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.auth.SPNegoSchemeFactory;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.BasicCredentialsProvider;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.HttpAuthenticator;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.ProxyAuthenticationStrategy;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.TunnelRefusedException;
import org.apache.maven.wagon.providers.http.httpclient.message.BasicHttpRequest;
import org.apache.maven.wagon.providers.http.httpclient.params.BasicHttpParams;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpParams;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpProtocolParams;
import org.apache.maven.wagon.providers.http.httpclient.protocol.BasicHttpContext;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpProcessor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpRequestExecutor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.ImmutableHttpProcessor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestContent;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestTargetHost;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestUserAgent;
import org.apache.maven.wagon.providers.http.httpclient.util.EntityUtils;

public class ProxyClient {
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;
    private final HttpParams params;

    public ProxyClient(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(), new RequestProxyAuthentication()});
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
        this.params = params;
    }

    public ProxyClient() {
        this(new BasicHttpParams());
    }

    public HttpParams getParams() {
        return this.params;
    }

    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        ProxyConnection conn = new ProxyConnection(new HttpRoute(proxy));
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse response = null;
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket, this.params);
            }
            String host = target.getHostName();
            int port = target.getPort();
            if (port < 0) {
                port = 80;
            }
            StringBuilder buffer = new StringBuilder(host.length() + 6);
            buffer.append(host);
            buffer.append(':');
            buffer.append(Integer.toString(port));
            String authority = buffer.toString();
            ProtocolVersion ver = HttpProtocolParams.getVersion(this.params);
            BasicHttpRequest connect = new BasicHttpRequest("CONNECT", authority, ver);
            connect.setParams(this.params);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxy), credentials);
            context.setAttribute("http.target_host", target);
            context.setAttribute("http.proxy_host", proxy);
            context.setAttribute("http.connection", conn);
            context.setAttribute("http.request", connect);
            context.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
            context.setAttribute("http.auth.credentials-provider", credsProvider);
            context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
            this.requestExec.preProcess(connect, this.httpProcessor, context);
            response = this.requestExec.execute(connect, conn, context);
            response.setParams(this.params);
            this.requestExec.postProcess(response, this.httpProcessor, context);
            int status = response.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            if (!HttpClientParams.isAuthenticating(this.params)) continue;
            if (!this.authenticator.isAuthenticationRequested(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context) || !this.authenticator.authenticate(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context)) break;
            if (this.reuseStrategy.keepAlive(response, context)) {
                HttpEntity entity = response.getEntity();
                EntityUtils.consume(entity);
                continue;
            }
            conn.close();
        }
        int status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                response.setEntity(new BufferedHttpEntity(entity));
            }
            conn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        return conn.getSocket();
    }

    static class ProxyConnection
    extends DefaultHttpClientConnection
    implements HttpRoutedConnection {
        private final HttpRoute route;

        ProxyConnection(HttpRoute route) {
            this.route = route;
        }

        public HttpRoute getRoute() {
            return this.route;
        }

        public boolean isSecure() {
            return false;
        }

        public SSLSession getSSLSession() {
            return null;
        }

        public Socket getSocket() {
            return super.getSocket();
        }
    }
}

