/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldPanel;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class EncapsulateFieldRefactoringPlugin
extends JavaRefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(EncapsulateFieldRefactoringPlugin.class.getName());
    private ElementHandle<TypeElement> fieldEncloserHandle;
    private Modifier fieldEncloserAccessibility;
    private Set<Modifier> fieldAccessibility;
    private ElementHandle<ExecutableElement> currentGetter;
    private ElementHandle<ExecutableElement> currentSetter;
    private static Set<Modifier> accessModifiers = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC);
    private static List<Modifier> MODIFIERS = Arrays.asList(Modifier.PRIVATE, null, Modifier.PROTECTED, Modifier.PUBLIC);
    private final EncapsulateFieldRefactoring refactoring;
    private TreePathHandle sourceType;

    public EncapsulateFieldRefactoringPlugin(EncapsulateFieldRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        TreePathHandle handle = this.getSourceType();
        FileObject fo = handle.getFileObject();
        return JavaSource.forFileObject((FileObject)fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        this.fireProgressListenerStart(1, 2);
        try {
            javac.toPhase(JavaSource.Phase.RESOLVED);
            this.sourceType = this.refactoring.getSourceType();
            Problem result = EncapsulateFieldRefactoringPlugin.isElementAvail(this.sourceType, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            Element field = this.sourceType.resolveElement((CompilationInfo)javac);
            this.fireProgressListenerStep();
            if (ElementKind.FIELD != field.getKind()) {
                Problem tp = EncapsulateFieldRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongType"));
                return tp;
            }
            TreePath tp = javac.getTrees().getPath(field);
            this.sourceType = TreePathHandle.create((TreePath)tp, (CompilationInfo)javac);
            result = JavaPluginUtils.isSourceElement(field, (CompilationInfo)javac);
            if (result != null) {
                tp = result;
                return tp;
            }
            TypeElement encloser = (TypeElement)field.getEnclosingElement();
            ElementKind classKind = encloser.getKind();
            if (classKind == ElementKind.INTERFACE || classKind == ElementKind.ANNOTATION_TYPE) {
                Problem problem = EncapsulateFieldRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateInIntf"));
                return problem;
            }
            this.fieldEncloserHandle = ElementHandle.create((Element)encloser);
            this.fieldAccessibility = field.getModifiers();
            this.fieldEncloserAccessibility = this.resolveVisibility(encloser);
            Problem problem = result;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        return this.fastCheckParameters(this.refactoring.getGetterName(), this.refactoring.getSetterName(), this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors());
    }

    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        Problem p = null;
        Element field = this.getSourceType().resolveElement((CompilationInfo)javac);
        TypeElement clazz = (TypeElement)field.getEnclosingElement();
        String getname = this.refactoring.getGetterName();
        String setname = this.refactoring.getSetterName();
        ExecutableElement getter = null;
        ExecutableElement setter = null;
        if (getname != null) {
            getter = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)javac, clazz, getname, Collections.emptyList(), true);
        }
        if (getter != null) {
            Types types = javac.getTypes();
            if (!types.isSameType(field.asType(), getter.getReturnType())) {
                String msg = NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongGetter", (Object)getname, (Object)getter.getReturnType().toString());
                p = EncapsulateFieldRefactoringPlugin.createProblem(p, false, msg);
            } else if (RefactoringUtils.isWeakerAccess(this.refactoring.getMethodModifiers(), getter.getModifiers())) {
                String msg = NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateAccessGetter", (Object)getname, (Object)getter.getEnclosingElement().getSimpleName());
                p = EncapsulateFieldRefactoringPlugin.createProblem(p, false, msg);
            }
            if (getter.getEnclosingElement() == field.getEnclosingElement()) {
                this.currentGetter = ElementHandle.create((Element)getter);
            }
        }
        p = this.overridingHasWeakerAccess(p, javac, clazz, getname, "ERR_EncapsulateAccessOverGetter", Collections.emptyList());
        if (setname != null) {
            setter = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)javac, clazz, setname, Collections.singletonList((VariableElement)field), true);
        }
        if (setter != null) {
            if (TypeKind.VOID != setter.getReturnType().getKind()) {
                p = EncapsulateFieldRefactoringPlugin.createProblem(p, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateWrongSetter", (Object)setname, (Object)setter.getReturnType()));
            } else if (RefactoringUtils.isWeakerAccess(this.refactoring.getMethodModifiers(), setter.getModifiers())) {
                String msg = NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateAccessSetter", (Object)setname, (Object)setter.getEnclosingElement().getSimpleName());
                p = EncapsulateFieldRefactoringPlugin.createProblem(p, false, msg);
            }
            if (setter.getEnclosingElement() == field.getEnclosingElement()) {
                this.currentSetter = ElementHandle.create((Element)setter);
            }
        }
        p = this.overridingHasWeakerAccess(p, javac, clazz, setname, "ERR_EncapsulateAccessOverSetter", Collections.emptyList());
        return p;
    }

    private Problem fastCheckParameters(String getter, String setter, Set<Modifier> methodModifier, Set<Modifier> fieldModifier, boolean alwaysUseAccessors) {
        if (getter != null && !Utilities.isJavaIdentifier((String)getter) || setter != null && !Utilities.isJavaIdentifier((String)setter) || getter == null && setter == null) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateMethods"));
        }
        return null;
    }

    private Modifier resolveVisibility(TypeElement clazz) {
        NestingKind nestingKind = clazz.getNestingKind();
        if (nestingKind == NestingKind.ANONYMOUS || nestingKind == NestingKind.LOCAL) {
            return Modifier.PRIVATE;
        }
        Set<Modifier> mods = clazz.getModifiers();
        if (nestingKind == NestingKind.TOP_LEVEL) {
            return mods.contains((Object)Modifier.PUBLIC) ? Modifier.PUBLIC : null;
        }
        if (mods.contains((Object)Modifier.PRIVATE)) {
            return Modifier.PRIVATE;
        }
        Modifier mod1 = this.resolveVisibility((TypeElement)clazz.getEnclosingElement());
        Modifier mod2 = null;
        if (mods.contains((Object)Modifier.PUBLIC)) {
            mod2 = Modifier.PUBLIC;
        } else if (mods.contains((Object)Modifier.PROTECTED)) {
            mod2 = Modifier.PROTECTED;
        }
        return this.max(mod1, mod2);
    }

    private Modifier max(Modifier a, Modifier b) {
        int bi;
        if (a == b) {
            return a;
        }
        int ai = MODIFIERS.indexOf((Object)a);
        return ai > (bi = MODIFIERS.indexOf((Object)b)) ? a : b;
    }

    private static Modifier getAccessibility(Set<Modifier> mods) {
        if (mods.isEmpty()) {
            return null;
        }
        HashSet<Modifier> s = new HashSet<Modifier>(mods);
        s.retainAll(accessModifiers);
        return s.isEmpty() ? null : (Modifier)((Object)s.iterator().next());
    }

    private static Set<Modifier> replaceAccessibility(Modifier currentAccess, Modifier futureAccess, Element elm) {
        HashSet<Modifier> mods = new HashSet<Modifier>(elm.getModifiers());
        if (currentAccess != null) {
            mods.remove((Object)currentAccess);
        }
        if (futureAccess != null) {
            mods.add(futureAccess);
        }
        return mods;
    }

    public static ExecutableElement findMethod(CompilationInfo javac, TypeElement clazz, String name, List<? extends VariableElement> params, boolean includeSupertypes) {
        if (name == null || name.length() == 0) {
            return null;
        }
        TypeElement c = clazz;
        while (true) {
            for (Element element : c.getEnclosedElements()) {
                ExecutableElement m;
                if (ElementKind.METHOD != element.getKind() || !name.contentEquals((m = (ExecutableElement)element).getSimpleName()) || !EncapsulateFieldRefactoringPlugin.compareParams(javac, params, m.getParameters()) || !EncapsulateFieldRefactoringPlugin.isAccessible(javac, clazz, m)) continue;
                return m;
            }
            TypeMirror superType = c.getSuperclass();
            if (!includeSupertypes || superType.getKind() == TypeKind.NONE) {
                return null;
            }
            c = (TypeElement)((DeclaredType)superType).asElement();
        }
    }

    private Problem overridingHasWeakerAccess(Problem p, CompilationController javac, TypeElement clazz, String name, String msgKey, List<? extends VariableElement> params) {
        if (name == null || name.length() == 0) {
            return null;
        }
        ClassIndex classIndex = javac.getClasspathInfo().getClassIndex();
        Set elements = classIndex.getElements(ElementHandle.create((Element)clazz), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        Set<Modifier> methodModifiers = this.refactoring.getMethodModifiers();
        for (ElementHandle elementHandle : elements) {
            TypeElement c = (TypeElement)elementHandle.resolve((CompilationInfo)javac);
            if (c == null) continue;
            for (Element element : c.getEnclosedElements()) {
                ExecutableElement m;
                if (ElementKind.METHOD != element.getKind() || !name.contentEquals((m = (ExecutableElement)element).getSimpleName()) || !EncapsulateFieldRefactoringPlugin.compareParams((CompilationInfo)javac, params, m.getParameters()) || !RefactoringUtils.isWeakerAccess(element.getModifiers(), methodModifiers)) continue;
                String msg = NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)msgKey, (Object)name, (Object)element.getEnclosingElement().getSimpleName());
                return EncapsulateFieldRefactoringPlugin.createProblem(p, false, msg);
            }
        }
        return p;
    }

    private static boolean isAccessible(CompilationInfo javac, TypeElement clazz, Element elm) {
        if (clazz == elm.getEnclosingElement()) {
            return true;
        }
        Set<Modifier> mods = elm.getModifiers();
        if (mods.contains((Object)Modifier.PUBLIC) || mods.contains((Object)Modifier.PROTECTED)) {
            return true;
        }
        if (mods.contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        Elements utils = javac.getElements();
        return utils.getPackageOf(elm) == utils.getPackageOf(clazz);
    }

    private static boolean compareParams(CompilationInfo javac, List<? extends VariableElement> params1, List<? extends VariableElement> params2) {
        Types types = javac.getTypes();
        if (params1.size() == params2.size()) {
            Iterator<? extends VariableElement> it1 = params1.iterator();
            for (VariableElement variableElement : params2) {
                TypeMirror asType;
                TypeMirror veType = types.erasure(variableElement.asType());
                if (veType == (asType = types.erasure(it1.next().asType()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag bag) {
        this.fireProgressListenerStart(3, 9);
        try {
            this.fireProgressListenerStep();
            EncapsulateDesc desc = this.prepareEncapsulator(null);
            if (desc.p != null && desc.p.isFatal()) {
                Problem problem = desc.p;
                return problem;
            }
            Encapsulator encapsulator = new Encapsulator(Collections.singletonList(desc), desc.p, (EncapsulateFieldPanel.InsertPoint)this.refactoring.getContext().lookup(EncapsulateFieldPanel.InsertPoint.class), (EncapsulateFieldPanel.SortBy)this.refactoring.getContext().lookup(EncapsulateFieldPanel.SortBy.class), (EncapsulateFieldPanel.Javadoc)this.refactoring.getContext().lookup(EncapsulateFieldPanel.Javadoc.class));
            Problem problem = this.createAndAddElements(desc.refs, new JavaRefactoringPlugin.TransformTask(this, encapsulator, desc.fieldHandle), bag, this.refactoring);
            Problem problem2 = problem != null ? problem : encapsulator.getProblem();
            return problem2;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    EncapsulateDesc prepareEncapsulator(Problem previousProblem) {
        Set<FileObject> refs = this.getRelevantFiles();
        EncapsulateDesc etask = new EncapsulateDesc();
        if (this.refactoring.isAlwaysUseAccessors() && this.refactoring.getMethodModifiers().contains((Object)Modifier.PRIVATE) && refs.size() > 1) {
            etask.p = EncapsulateFieldRefactoringPlugin.createProblem(previousProblem, true, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateMethodsAccess"));
            return etask;
        }
        if (this.refactoring.isAlwaysUseAccessors() && EncapsulateFieldRefactoringPlugin.getAccessibility(this.refactoring.getMethodModifiers()) == null && refs.size() > 1) {
            etask.p = EncapsulateFieldRefactoringPlugin.createProblem(previousProblem, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateMethodsDefaultAccess"));
        }
        etask.fieldHandle = this.getSourceType();
        etask.refs = refs;
        etask.currentGetter = this.currentGetter;
        etask.currentSetter = this.currentSetter;
        etask.refactoring = this.refactoring;
        return etask;
    }

    private Set<FileObject> getRelevantFiles() {
        HashSet<FileObject> refs;
        FileObject source = this.getSourceType().getFileObject();
        if (this.fieldAccessibility.contains((Object)Modifier.PRIVATE) || this.fieldEncloserAccessibility == Modifier.PRIVATE) {
            refs = Collections.singleton(source);
        } else {
            ClasspathInfo cpinfo = this.fieldEncloserAccessibility == Modifier.PUBLIC && (this.fieldAccessibility.contains((Object)Modifier.PUBLIC) || this.fieldAccessibility.contains((Object)Modifier.PROTECTED)) ? RefactoringUtils.getClasspathInfoFor(true, source) : RefactoringUtils.getClasspathInfoFor(false, source);
            ClassIndex index = cpinfo.getClassIndex();
            refs = index.getResources(this.fieldEncloserHandle, EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            if (!refs.contains(source)) {
                refs = new HashSet<FileObject>(refs);
                refs.add(source);
            }
        }
        return refs;
    }

    private static boolean isSubclassOf(TypeElement subclass, TypeElement superclass) {
        TypeMirror superType = subclass.getSuperclass();
        while (superType.getKind() != TypeKind.NONE) {
            TypeElement superTypeElm = (TypeElement)((DeclaredType)superType).asElement();
            if (superclass == superTypeElm) {
                return true;
            }
            superType = superTypeElm.getSuperclass();
        }
        return false;
    }

    private TreePathHandle getSourceType() {
        return this.sourceType != null ? this.sourceType : this.refactoring.getSourceType();
    }

    static final class EncapsulateDesc {
        Problem p;
        Set<FileObject> refs;
        TreePathHandle fieldHandle;
        VariableElement field;
        private ElementHandle<ExecutableElement> currentGetter;
        private ElementHandle<ExecutableElement> currentSetter;
        private EncapsulateFieldRefactoring refactoring;
        private boolean useAccessors;

        EncapsulateDesc() {
        }
    }

    static final class Encapsulator
    extends RefactoringVisitor {
        private final FileObject sourceFile;
        private final EncapsulateFieldPanel.InsertPoint insertPoint;
        private final EncapsulateFieldPanel.SortBy sortBy;
        private final EncapsulateFieldPanel.Javadoc javadocType;
        private Problem problem;
        private List<EncapsulateDesc> descs;
        private Map<VariableElement, EncapsulateDesc> fields;
        private boolean setterUsed;

        public Encapsulator(List<EncapsulateDesc> descs, Problem problem, EncapsulateFieldPanel.InsertPoint ip, EncapsulateFieldPanel.SortBy sortBy, EncapsulateFieldPanel.Javadoc jd) {
            assert (descs != null && descs.size() > 0);
            this.sourceFile = descs.get((int)0).fieldHandle.getFileObject();
            this.descs = descs;
            this.problem = problem;
            this.insertPoint = ip == null ? EncapsulateFieldPanel.InsertPoint.DEFAULT : ip;
            this.sortBy = sortBy == null ? EncapsulateFieldPanel.SortBy.PAIRS : sortBy;
            this.javadocType = jd == null ? EncapsulateFieldPanel.Javadoc.NONE : jd;
        }

        public Problem getProblem() {
            if (this.setterUsed && this.descs.get(0).refactoring.isGenerateVetoableChangeSupport()) {
                this.problem = EncapsulateFieldRefactoringPlugin.createProblem(this.problem, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulatePropertyVetoException"));
                this.setterUsed = false;
            }
            return this.problem;
        }

        @Override
        public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
            super.setWorkingCopy(workingCopy);
            this.fields = new HashMap<VariableElement, EncapsulateDesc>(this.descs.size());
            for (EncapsulateDesc desc : this.descs) {
                desc.field = (VariableElement)desc.fieldHandle.resolveElement((CompilationInfo)workingCopy);
                this.fields.put(desc.field, desc);
            }
        }

        @Override
        public Tree visitCompilationUnit(CompilationUnitTree node, Element field) {
            return (Tree)this.scan(node.getTypeDecls(), field);
        }

        @Override
        public Tree visitClass(ClassTree node, Element field) {
            Element el;
            TypeElement clazz = (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
            boolean[] origValues = new boolean[this.descs.size()];
            int counter = 0;
            for (EncapsulateDesc desc : this.descs) {
                origValues[counter++] = desc.useAccessors;
                desc.useAccessors = this.resolveUseAccessor(clazz, desc);
            }
            if (this.sourceFile == this.workingCopy.getFileObject() && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) == this.descs.get((int)0).field.getEnclosingElement()) {
                ClassTree nct = node;
                ArrayList<Tree> newMembers = new ArrayList<Tree>();
                int getterIdx = 0;
                VariableTree pcs = null;
                if (this.descs.get(0).refactoring.isGeneratePropertyChangeSupport() && (pcs = this.getPropertyChangeSupport(clazz, "java.beans.PropertyChangeSupport")) == null) {
                    pcs = this.createPropertyChangeSupport("java.beans.PropertyChangeSupport", "propertyChangeSupport");
                    newMembers.add(pcs);
                }
                VariableTree vcs = null;
                if (this.descs.get(0).refactoring.isGenerateVetoableChangeSupport() && (vcs = this.getPropertyChangeSupport(clazz, "java.beans.VetoableChangeSupport")) == null) {
                    vcs = this.createPropertyChangeSupport("java.beans.VetoableChangeSupport", "vetoableChangeSupport");
                    newMembers.add(vcs);
                }
                CodeStyle cs = RefactoringUtils.getCodeStyle((CompilationInfo)this.workingCopy);
                for (EncapsulateDesc desc : this.descs) {
                    MethodTree[] ms;
                    VariableTree propName = this.createPropName(clazz, desc);
                    if (pcs != null) {
                        newMembers.add(propName);
                    }
                    if ((ms = this.createGetterAndSetter(desc.field, desc.refactoring.getGetterName(), desc.refactoring.getSetterName(), desc.refactoring.getMethodModifiers(), cs, pcs, vcs, propName))[0] != null) {
                        newMembers.add(getterIdx++, ms[0]);
                    }
                    if (ms[1] == null) continue;
                    int setterIdx = this.sortBy == EncapsulateFieldPanel.SortBy.GETTERS_FIRST ? newMembers.size() : getterIdx++;
                    newMembers.add(setterIdx, ms[1]);
                }
                if (!newMembers.isEmpty()) {
                    if (this.sortBy == EncapsulateFieldPanel.SortBy.ALPHABETICALLY) {
                        Collections.sort(newMembers, new SortMethodsByNameComparator());
                    }
                    if (this.insertPoint == EncapsulateFieldPanel.InsertPoint.DEFAULT) {
                        nct = GeneratorUtilities.get((WorkingCopy)this.workingCopy).insertClassMembers(node, newMembers);
                    } else {
                        List<? extends Tree> members = node.getMembers();
                        if (this.insertPoint.getIndex() >= members.size()) {
                            for (Tree mt : newMembers) {
                                nct = this.make.addClassMember(nct, mt);
                            }
                        } else {
                            int idx = this.insertPoint.getIndex();
                            for (Tree mt : newMembers) {
                                nct = this.make.insertClassMember(nct, idx++, mt);
                            }
                        }
                    }
                    this.rewrite(node, nct);
                }
            }
            Tree result = (Tree)this.scan(node.getMembers(), field);
            counter = 0;
            for (EncapsulateDesc desc : this.descs) {
                desc.useAccessors = origValues[counter++];
            }
            return result;
        }

        private VariableTree getPropertyChangeSupport(TypeElement node, String support) {
            TypeElement supportElement = this.workingCopy.getElements().getTypeElement(support);
            if (supportElement != null) {
                for (VariableElement el : ElementFilter.fieldsIn(node.getEnclosedElements())) {
                    if (!el.asType().equals(supportElement.asType())) continue;
                    return (VariableTree)this.workingCopy.getTrees().getPath(el).getLeaf();
                }
            }
            return null;
        }

        private VariableTree createPropertyChangeSupport(String support, String supportName) {
            EnumSet<Modifier> mods = EnumSet.of(Modifier.PRIVATE, Modifier.FINAL, Modifier.TRANSIENT);
            return this.make.Variable(this.make.Modifiers(mods), (CharSequence)supportName, (Tree)this.make.QualIdent(support), this.make.QualIdent("new " + support + "(this)"));
        }

        private String getPropertyName(EncapsulateDesc desc) {
            return "PROP_" + desc.field.getSimpleName().toString().toUpperCase();
        }

        private VariableTree createPropName(TypeElement node, EncapsulateDesc get) {
            String propertyName = this.getPropertyName(get);
            while (this.fieldExists(node, propertyName)) {
                propertyName = propertyName + "_1";
            }
            return this.make.Variable(this.make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL)), (CharSequence)propertyName, (Tree)this.make.Identifier((CharSequence)"String"), (ExpressionTree)this.make.Literal((Object)get.field.getSimpleName().toString()));
        }

        private boolean fieldExists(TypeElement clazz, String propertyName) {
            for (VariableElement el : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
                if (!el.getSimpleName().contentEquals(propertyName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Tree visitVariable(VariableTree node, Element field) {
            Element el;
            EncapsulateDesc desc;
            if (this.sourceFile == this.workingCopy.getFileObject() && (desc = this.fields.get(el = this.workingCopy.getTrees().getElement(this.getCurrentPath()))) != null) {
                this.resolveFieldDeclaration(node, desc);
                return node;
            }
            return this.scan((Tree)node.getInitializer(), field);
        }

        @Override
        public Tree visitAssignment(AssignmentTree node, Element field) {
            ExpressionTree variable = node.getVariable();
            boolean isArray = false;
            while (variable.getKind() == Tree.Kind.ARRAY_ACCESS) {
                isArray = true;
                this.scan((Tree)((ArrayAccessTree)variable).getIndex(), field);
                variable = ((ArrayAccessTree)variable).getExpression();
            }
            Element el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), variable));
            EncapsulateDesc desc = this.fields.get(el);
            if (desc != null && desc.useAccessors && desc.refactoring.getSetterName() != null && (isArray || this.checkAssignmentInsideExpression()) && !this.isInConstructorOfFieldClass(this.getCurrentPath(), desc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)desc.currentGetter, (ElementHandle<ExecutableElement>)desc.currentSetter)) {
                if (isArray) {
                    ExpressionTree invkgetter = this.createGetterInvokation(variable, desc.refactoring.getGetterName());
                    this.rewrite(variable, invkgetter);
                } else {
                    ExpressionTree setter = this.createMemberSelection(variable, desc.refactoring.getSetterName());
                    Trees trees = this.workingCopy.getTrees();
                    ExpressionTree expTree = node.getExpression();
                    TreePath varPath = trees.getPath(this.workingCopy.getCompilationUnit(), variable);
                    TreePath expPath = trees.getPath(this.workingCopy.getCompilationUnit(), expTree);
                    TypeMirror varType = trees.getTypeMirror(varPath);
                    TypeMirror expType = trees.getTypeMirror(expPath);
                    ExpressionTree newExpTree = this.workingCopy.getTypes().isSubtype(expType, varType) ? expTree : this.make.TypeCast(this.make.Type(varType), expTree);
                    MethodInvocationTree invksetter = this.make.MethodInvocation(Collections.emptyList(), setter, Collections.singletonList(newExpTree));
                    this.rewrite(node, invksetter);
                    this.setterUsed = true;
                }
            }
            return this.scan((Tree)node.getExpression(), field);
        }

        @Override
        public Tree visitCompoundAssignment(CompoundAssignmentTree node, Element field) {
            ExpressionTree variable = node.getVariable();
            boolean isArray = false;
            while (variable.getKind() == Tree.Kind.ARRAY_ACCESS) {
                isArray = true;
                variable = ((ArrayAccessTree)variable).getExpression();
            }
            Element el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), variable));
            EncapsulateDesc desc = this.fields.get(el);
            if (desc != null && desc.useAccessors && desc.refactoring.getSetterName() != null && (isArray || this.checkAssignmentInsideExpression()) && !this.isInConstructorOfFieldClass(this.getCurrentPath(), desc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)desc.currentGetter, (ElementHandle<ExecutableElement>)desc.currentSetter)) {
                if (isArray) {
                    ExpressionTree invkgetter = this.createGetterInvokation(variable, desc.refactoring.getGetterName());
                    this.rewrite(variable, invkgetter);
                } else {
                    ExpressionTree setter = this.createMemberSelection(variable, desc.refactoring.getSetterName());
                    String s = node.getKind().name();
                    s = s.substring(0, s.length() - "_ASSIGNMENT".length());
                    Tree.Kind operator = Tree.Kind.valueOf(s);
                    ExpressionTree invkgetter = this.createGetterInvokation(variable, desc.refactoring.getGetterName());
                    Trees trees = this.workingCopy.getTrees();
                    ExpressionTree expTree = node.getExpression();
                    TreePath varPath = trees.getPath(this.workingCopy.getCompilationUnit(), variable);
                    TreePath expPath = trees.getPath(this.workingCopy.getCompilationUnit(), expTree);
                    TypeMirror varType = trees.getTypeMirror(varPath);
                    BinaryTree expTreeFake = this.make.Binary(operator, variable, expTree);
                    TypeMirror expType = this.workingCopy.getTreeUtilities().attributeTree((Tree)expTreeFake, trees.getScope(expPath));
                    ExpressionTree newExpTree = this.make.Binary(operator, invkgetter, expTree);
                    if (!this.workingCopy.getTypes().isSubtype(expType, varType)) {
                        newExpTree = this.make.TypeCast(this.make.Type(varType), (ExpressionTree)this.make.Parenthesized(newExpTree));
                    }
                    MethodInvocationTree invksetter = this.make.MethodInvocation(Collections.emptyList(), setter, Collections.singletonList(newExpTree));
                    this.rewrite(node, invksetter);
                }
            }
            return this.scan((Tree)node.getExpression(), field);
        }

        @Override
        public Tree visitUnary(UnaryTree node, Element field) {
            boolean isArrayOrImmutable;
            ExpressionTree t = node.getExpression();
            Tree.Kind kind = node.getKind();
            boolean bl = isArrayOrImmutable = kind != Tree.Kind.POSTFIX_DECREMENT && kind != Tree.Kind.POSTFIX_INCREMENT && kind != Tree.Kind.PREFIX_DECREMENT && kind != Tree.Kind.PREFIX_INCREMENT;
            while (t.getKind() == Tree.Kind.ARRAY_ACCESS) {
                isArrayOrImmutable = true;
                t = ((ArrayAccessTree)t).getExpression();
            }
            Element el = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), t));
            EncapsulateDesc desc = this.fields.get(el);
            if (desc != null && desc.useAccessors && desc.refactoring.getGetterName() != null && (isArrayOrImmutable || this.checkAssignmentInsideExpression()) && !this.isInConstructorOfFieldClass(this.getCurrentPath(), desc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)desc.currentGetter, (ElementHandle<ExecutableElement>)desc.currentSetter)) {
                ExpressionTree invkgetter = this.createGetterInvokation(t, desc.refactoring.getGetterName());
                if (isArrayOrImmutable) {
                    this.rewrite(t, invkgetter);
                } else if (desc.refactoring.getSetterName() != null) {
                    ExpressionTree setter = this.createMemberSelection(node.getExpression(), desc.refactoring.getSetterName());
                    Tree.Kind operator = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.PREFIX_INCREMENT ? Tree.Kind.PLUS : Tree.Kind.MINUS;
                    Trees trees = this.workingCopy.getTrees();
                    ExpressionTree expTree = node.getExpression();
                    TreePath varPath = trees.getPath(this.workingCopy.getCompilationUnit(), expTree);
                    TypeMirror varType = trees.getTypeMirror(varPath);
                    PrimitiveType expType = this.workingCopy.getTypes().getPrimitiveType(TypeKind.INT);
                    ExpressionTree newExpTree = this.make.Binary(operator, invkgetter, (ExpressionTree)this.make.Literal((Object)1));
                    if (!this.workingCopy.getTypes().isSubtype(expType, varType)) {
                        newExpTree = this.make.TypeCast(this.make.Type(varType), (ExpressionTree)this.make.Parenthesized(newExpTree));
                    }
                    MethodInvocationTree invksetter = this.make.MethodInvocation(Collections.emptyList(), setter, Collections.singletonList(newExpTree));
                    this.rewrite(node, invksetter);
                }
            }
            return null;
        }

        @Override
        public Tree visitMemberSelect(MemberSelectTree node, Element field) {
            Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            EncapsulateDesc desc = this.fields.get(el);
            if (desc != null && desc.useAccessors && !this.isInConstructorOfFieldClass(this.getCurrentPath(), desc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)desc.currentGetter, (ElementHandle<ExecutableElement>)desc.currentSetter)) {
                ExpressionTree nodeNew = this.createGetterInvokation(node, desc.refactoring.getGetterName());
                this.rewrite(node, nodeNew);
            }
            return (Tree)super.visitMemberSelect(node, field);
        }

        @Override
        public Tree visitIdentifier(IdentifierTree node, Element field) {
            Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            EncapsulateDesc desc = this.fields.get(el);
            if (desc != null && desc.useAccessors && !this.isInConstructorOfFieldClass(this.getCurrentPath(), desc.field) && !this.isInGetterSetter(this.getCurrentPath(), (ElementHandle<ExecutableElement>)desc.currentGetter, (ElementHandle<ExecutableElement>)desc.currentSetter)) {
                ExpressionTree nodeNew = this.createGetterInvokation(node, desc.refactoring.getGetterName());
                this.rewrite(node, nodeNew);
            }
            return null;
        }

        private boolean checkAssignmentInsideExpression() {
            Tree exp1 = this.getCurrentPath().getLeaf();
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (parent.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                this.problem = EncapsulateFieldRefactoringPlugin.createProblem(this.problem, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateInsideAssignment", (Object)exp1.toString(), (Object)parent.toString(), (Object)FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject())));
                return false;
            }
            return true;
        }

        private ExpressionTree createGetterInvokation(ExpressionTree current, String getterName) {
            if (getterName == null) {
                return current;
            }
            ExpressionTree getter = this.createMemberSelection(current, getterName);
            MethodInvocationTree invkgetter = this.make.MethodInvocation(Collections.emptyList(), getter, Collections.emptyList());
            GeneratorUtilities.get((WorkingCopy)this.workingCopy).copyComments((Tree)current, (Tree)invkgetter, false);
            GeneratorUtilities.get((WorkingCopy)this.workingCopy).copyComments((Tree)current, (Tree)invkgetter, true);
            return invkgetter;
        }

        private ExpressionTree createMemberSelection(ExpressionTree node, String name) {
            ExpressionTree selector;
            ExpressionTree expr = node;
            boolean addParens = false;
            while (expr.getKind() == Tree.Kind.PARENTHESIZED) {
                ParenthesizedTree parens = (ParenthesizedTree)expr;
                expr = parens.getExpression();
                addParens = true;
            }
            if (expr.getKind() == Tree.Kind.MEMBER_SELECT) {
                ExpressionTree select = ((MemberSelectTree)expr).getExpression();
                if (addParens) {
                    select = this.make.Parenthesized(select);
                }
                selector = this.make.MemberSelect(select, (CharSequence)name);
            } else {
                selector = this.make.Identifier((CharSequence)name);
            }
            return selector;
        }

        private MethodTree[] createGetterAndSetter(VariableElement field, String getterName, String setterName, Set<Modifier> useModifiers, CodeStyle cs, VariableTree propertyChange, VariableTree vetoableChange, VariableTree propName) {
            boolean staticMod = field.getModifiers().contains((Object)Modifier.STATIC);
            String fieldName = CodeStyleUtils.removePrefixSuffix((CharSequence)field.getSimpleName(), (String)(staticMod ? cs.getStaticFieldNamePrefix() : cs.getFieldNamePrefix()), (String)(staticMod ? cs.getStaticFieldNameSuffix() : cs.getFieldNameSuffix()));
            String longName = (staticMod ? "" : "this.") + field.getSimpleName();
            String oldName = "old" + CodeStyleUtils.getCapitalizedName((CharSequence)fieldName);
            String parName = staticMod ? "a" + CodeStyleUtils.getCapitalizedName((CharSequence)fieldName) : fieldName;
            String getterBody = "{return " + field.getSimpleName() + ";}";
            StringBuilder setterBody = new StringBuilder();
            setterBody.append("{");
            if (propertyChange != null || vetoableChange != null) {
                setterBody.append(field.asType().toString()).append(" ").append(oldName).append(" = ").append(longName).append(";");
            }
            if (vetoableChange != null) {
                setterBody.append(vetoableChange.getName()).append(".fireVetoableChange(").append(propName.getName()).append(", ").append(oldName).append(", ").append(fieldName).append(");");
            }
            setterBody.append(longName).append(" = ").append(parName).append(";");
            if (propertyChange != null) {
                setterBody.append(propertyChange.getName()).append(".firePropertyChange(").append(propName.getName()).append(", ").append(oldName).append(", ").append(fieldName).append(");");
            }
            setterBody.append("}");
            HashSet<Modifier> mods = new HashSet<Modifier>(useModifiers);
            if (staticMod) {
                mods.add(Modifier.STATIC);
            }
            VariableTree fieldTree = (VariableTree)this.workingCopy.getTrees().getTree(field);
            MethodTree[] result = new MethodTree[2];
            ExecutableElement getterElm = null;
            if (getterName != null) {
                getterElm = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)this.workingCopy, (TypeElement)field.getEnclosingElement(), getterName, Collections.emptyList(), false);
            }
            if (getterElm == null && getterName != null) {
                MethodTree getter;
                result[0] = getter = this.make.Method(this.make.Modifiers(mods), (CharSequence)getterName, fieldTree.getType(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), getterBody, null);
                String jdText = null;
                if (this.javadocType == EncapsulateFieldPanel.Javadoc.COPY) {
                    jdText = this.workingCopy.getElements().getDocComment(field);
                    jdText = this.trimNewLines(jdText);
                }
                if (this.javadocType == EncapsulateFieldPanel.Javadoc.DEFAULT || this.javadocType == EncapsulateFieldPanel.Javadoc.COPY) {
                    String prefix = jdText == null ? "" : jdText + "\n";
                    Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)(prefix + "@return the " + field.getSimpleName()));
                    this.make.addComment((Tree)getter, comment, true);
                }
            }
            ExecutableElement setterElm = null;
            if (setterName != null) {
                setterElm = EncapsulateFieldRefactoringPlugin.findMethod((CompilationInfo)this.workingCopy, (TypeElement)field.getEnclosingElement(), setterName, Collections.singletonList(field), false);
            }
            if (setterElm == null && setterName != null) {
                MethodTree setter;
                VariableTree paramTree = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)parName, fieldTree.getType(), null);
                result[1] = setter = this.make.Method(this.make.Modifiers(mods), (CharSequence)setterName, (Tree)this.make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(paramTree), vetoableChange == null ? Collections.emptyList() : Collections.singletonList(this.make.QualIdent("java.beans.PropertyVetoException")), setterBody.toString(), null);
                String jdText = null;
                if (this.javadocType == EncapsulateFieldPanel.Javadoc.COPY) {
                    jdText = this.workingCopy.getElements().getDocComment(field);
                    jdText = this.trimNewLines(jdText);
                }
                if (this.javadocType == EncapsulateFieldPanel.Javadoc.DEFAULT || this.javadocType == EncapsulateFieldPanel.Javadoc.COPY) {
                    String prefix = jdText == null ? "" : jdText + "\n";
                    Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)(prefix + String.format("@param %s the %s to set", parName, fieldName)));
                    this.make.addComment((Tree)setter, comment, true);
                }
            }
            return result;
        }

        private String trimNewLines(String javadoc) {
            int st;
            if (javadoc == null) {
                return null;
            }
            int len = javadoc.length();
            int off = 0;
            char[] val = javadoc.toCharArray();
            for (st = 0; st < len && Character.isWhitespace(val[off + st]); ++st) {
            }
            while (st < len && Character.isWhitespace(val[off + len - 1])) {
                --len;
            }
            return st > 0 || len < val.length ? javadoc.substring(st, len) : javadoc;
        }

        private void resolveFieldDeclaration(VariableTree node, EncapsulateDesc desc) {
            Modifier currentAccess = EncapsulateFieldRefactoringPlugin.getAccessibility(desc.field.getModifiers());
            Modifier futureAccess = EncapsulateFieldRefactoringPlugin.getAccessibility(desc.refactoring.getFieldModifiers());
            ModifiersTree newModTree = null;
            if (currentAccess != futureAccess) {
                newModTree = this.make.Modifiers(EncapsulateFieldRefactoringPlugin.replaceAccessibility(currentAccess, futureAccess, desc.field), node.getModifiers().getAnnotations());
            }
            if (node.getModifiers().getFlags().contains((Object)Modifier.FINAL) && desc.refactoring.getSetterName() != null) {
                ModifiersTree mot = newModTree == null ? node.getModifiers() : newModTree;
                HashSet<Modifier> flags = new HashSet<Modifier>(mot.getFlags());
                flags.remove((Object)Modifier.FINAL);
                newModTree = this.make.Modifiers(flags, mot.getAnnotations());
            }
            if (newModTree != null) {
                VariableTree newNode = this.make.Variable(newModTree, (CharSequence)node.getName(), node.getType(), node.getInitializer());
                this.rewrite(node, newNode);
            }
        }

        private boolean resolveUseAccessor(TypeElement where, EncapsulateDesc desc) {
            if (desc.refactoring.isAlwaysUseAccessors()) {
                return true;
            }
            Set<Modifier> mods = desc.refactoring.getFieldModifiers();
            if (mods.contains((Object)Modifier.PRIVATE)) {
                return where != desc.field.getEnclosingElement();
            }
            if (mods.contains((Object)Modifier.PROTECTED)) {
                if (EncapsulateFieldRefactoringPlugin.isSubclassOf(where, (TypeElement)desc.field.getEnclosingElement())) {
                    return false;
                }
                return this.workingCopy.getElements().getPackageOf(where) != this.workingCopy.getElements().getPackageOf(desc.field);
            }
            if (mods.contains((Object)Modifier.PUBLIC)) {
                return false;
            }
            return this.workingCopy.getElements().getPackageOf(where) != this.workingCopy.getElements().getPackageOf(desc.field);
        }

        private boolean isInConstructorOfFieldClass(TreePath path, Element field) {
            Tree leaf = path.getLeaf();
            Tree.Kind kind = leaf.getKind();
            while (true) {
                switch (kind) {
                    case METHOD: {
                        boolean result;
                        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
                            return false;
                        }
                        Element m = this.workingCopy.getTrees().getElement(path);
                        boolean bl = result = m.getKind() == ElementKind.CONSTRUCTOR && (m.getEnclosingElement() == field.getEnclosingElement() || EncapsulateFieldRefactoringPlugin.isSubclassOf((TypeElement)m.getEnclosingElement(), (TypeElement)field.getEnclosingElement()));
                        if (m.getKind() == ElementKind.CONSTRUCTOR && m.getEnclosingElement() != field.getEnclosingElement() && EncapsulateFieldRefactoringPlugin.isSubclassOf((TypeElement)m.getEnclosingElement(), (TypeElement)field.getEnclosingElement()) && this.fields.get(field).refactoring.getFieldModifiers().contains((Object)Modifier.PRIVATE)) {
                            this.problem = EncapsulateFieldRefactoringPlugin.createProblem(this.problem, false, NbBundle.getMessage(EncapsulateFieldRefactoringPlugin.class, (String)"ERR_EncapsulateInsideConstructor", (Object)field.getSimpleName(), (Object)m.getEnclosingElement().getSimpleName()));
                        }
                        return result;
                    }
                    case COMPILATION_UNIT: 
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: 
                    case NEW_CLASS: {
                        return false;
                    }
                }
                path = path.getParentPath();
                leaf = path.getLeaf();
                kind = leaf.getKind();
            }
        }

        private boolean isInGetterSetter(TreePath path, ElementHandle<ExecutableElement> currentGetter, ElementHandle<ExecutableElement> currentSetter) {
            if (this.sourceFile != this.workingCopy.getFileObject()) {
                return false;
            }
            Tree leaf = path.getLeaf();
            Tree.Kind kind = leaf.getKind();
            while (true) {
                switch (kind) {
                    case METHOD: {
                        if (this.workingCopy.getTreeUtilities().isSynthetic(path)) {
                            return false;
                        }
                        Element m = this.workingCopy.getTrees().getElement(path);
                        return currentGetter != null && m == currentGetter.resolve((CompilationInfo)this.workingCopy) || currentSetter != null && m == currentSetter.resolve((CompilationInfo)this.workingCopy);
                    }
                    case COMPILATION_UNIT: 
                    case ANNOTATION_TYPE: 
                    case CLASS: 
                    case ENUM: 
                    case INTERFACE: 
                    case NEW_CLASS: {
                        return false;
                    }
                }
                path = path.getParentPath();
                leaf = path.getLeaf();
                kind = leaf.getKind();
            }
        }

        private static final class SortMethodsByNameComparator
        implements Comparator<Tree> {
            private SortMethodsByNameComparator() {
            }

            @Override
            public int compare(Tree o1, Tree o2) {
                if (o1.getKind() == Tree.Kind.VARIABLE) {
                    if (o2.getKind() == Tree.Kind.VARIABLE) {
                        return ((VariableTree)o1).getName().toString().compareTo(((VariableTree)o2).getName().toString());
                    }
                    return -11;
                }
                if (o2.getKind() == Tree.Kind.VARIABLE) {
                    return 1;
                }
                return ((MethodTree)o1).getName().toString().compareTo(((MethodTree)o2).getName().toString());
            }
        }
    }
}

