/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.util.Exceptions;

class VarUsageVisitor
extends RefactoringVisitor {
    private final TypeElement superTypeElement;
    private final TypeElement subTypeElement;
    private boolean isReplCandidate = true;

    VarUsageVisitor(TypeElement subTypeElement, WorkingCopy workingCopy, TypeElement superTypeElem) {
        try {
            this.setWorkingCopy(workingCopy);
        }
        catch (ToPhaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.superTypeElement = superTypeElem;
        this.subTypeElement = subTypeElement;
    }

    @Override
    public Tree visitReturn(ReturnTree node, Element p) {
        ExpressionTree expression = node.getExpression();
        this.checkReturnType(expression, p);
        return (Tree)super.visitReturn(node, p);
    }

    private void checkReturnType(ExpressionTree expression, Element p) {
        if (expression == null || p == null) {
            return;
        }
        if (expression.getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree ident = (IdentifierTree)expression;
            this.checkReturnType(ident, p);
        } else if (expression.getKind() == Tree.Kind.CONDITIONAL_EXPRESSION) {
            ConditionalExpressionTree cet = (ConditionalExpressionTree)expression;
            this.checkReturnType(cet.getFalseExpression(), p);
            this.checkReturnType(cet.getTrueExpression(), p);
        }
    }

    private void checkReturnType(IdentifierTree ident, Element p) {
        Element el = this.asElement(ident);
        if (el.equals(p)) {
            MethodTree method = (MethodTree)JavaPluginUtils.findMethod(this.getCurrentPath()).getLeaf();
            TypeMirror returnType = this.workingCopy.getTrees().getTypeMirror(this.workingCopy.getTrees().getPath(this.workingCopy.getCompilationUnit(), method.getReturnType()));
            if (!this.workingCopy.getTypes().isSubtype(this.superTypeElement.asType(), returnType)) {
                this.isReplCandidate = false;
            }
        }
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree memSelectTree, Element refVarElem) {
        Element methodElement = this.asElement(memSelectTree);
        Element varElement = this.asElement(memSelectTree.getExpression());
        if (!refVarElem.equals(varElement)) {
            return (Tree)super.visitMemberSelect(memSelectTree, refVarElem);
        }
        boolean isAssgCmptble = this.isMemberAvailable(this.subTypeElement, methodElement, this.superTypeElement);
        if (!isAssgCmptble) {
            this.isReplCandidate = false;
        }
        return (Tree)super.visitMemberSelect(memSelectTree, refVarElem);
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree node, Element p) {
        List<? extends ExpressionTree> arguments = node.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            Element element;
            ExpressionTree argument = arguments.get(i);
            Element argElement = this.asElement(argument);
            if (!p.equals(argElement) || (element = this.asElement(node)).getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            VariableElement parameter = method.getParameters().get(i);
            Types types = this.workingCopy.getTypes();
            TypeMirror parameterType = parameter.asType();
            if (parameterType.getKind().equals((Object)TypeKind.TYPEVAR)) {
                TypeVariable typeVariable = (TypeVariable)parameterType;
                TypeMirror upperBound = typeVariable.getUpperBound();
                TypeMirror lowerBound = typeVariable.getLowerBound();
                if (upperBound != null && !types.isSubtype(this.superTypeElement.asType(), upperBound)) {
                    this.isReplCandidate = false;
                }
                if (lowerBound == null || types.isSubtype(lowerBound, this.superTypeElement.asType())) continue;
                this.isReplCandidate = false;
                continue;
            }
            if (types.isAssignable(this.superTypeElement.asType(), parameterType)) continue;
            this.isReplCandidate = false;
        }
        return (Tree)super.visitMethodInvocation(node, p);
    }

    @Override
    public Tree visitAssignment(AssignmentTree assgnTree, Element refVarElem) {
        ExpressionTree exprnTree = assgnTree.getExpression();
        Element exprElement = this.asElement(exprnTree);
        if (!refVarElem.equals(exprElement)) {
            return (Tree)super.visitAssignment(assgnTree, refVarElem);
        }
        ExpressionTree varExprTree = assgnTree.getVariable();
        VariableElement varElement = (VariableElement)this.asElement(varExprTree);
        this.isReplCandidate = this.isReplacableAssgnmt(varElement) && this.isReplCandidate;
        return (Tree)super.visitAssignment(assgnTree, refVarElem);
    }

    @Override
    public Tree visitVariable(VariableTree varTree, Element refVarElem) {
        ExpressionTree initTree = varTree.getInitializer();
        if (null == initTree) {
            return (Tree)super.visitVariable(varTree, refVarElem);
        }
        Element exprElement = this.asElement(initTree);
        if (!refVarElem.equals(exprElement)) {
            return (Tree)super.visitVariable(varTree, refVarElem);
        }
        VariableElement varElement = (VariableElement)this.asElement(varTree);
        this.isReplCandidate = this.isReplacableAssgnmt(varElement) && this.isReplCandidate;
        return (Tree)super.visitVariable(varTree, refVarElem);
    }

    @Override
    public Tree visitMethod(MethodTree node, Element p) {
        List<? extends VariableTree> parameters = node.getParameters();
        for (VariableTree variableTree : parameters) {
            Element var = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), variableTree));
            if (!p.equals(var)) continue;
            TypeElement classElement = (TypeElement)this.workingCopy.getTrees().getElement(JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, this.getCurrentPath(), true, true, true, true, false));
            List<ExecutableElement> methods = ElementFilter.methodsIn(this.workingCopy.getElements().getAllMembers(classElement));
            String methodName = node.getName().toString();
            for (ExecutableElement method : methods) {
                if (!methodName.equals(method.getSimpleName().toString()) || node.getParameters().size() != method.getParameters().size()) continue;
                ExecutableElement element = (ExecutableElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
                boolean sameParameters = true;
                for (int j = 0; j < node.getParameters().size(); ++j) {
                    TypeMirror exType = method.getParameters().get(j).asType();
                    VariableElement vari = element.getParameters().get(j);
                    TypeMirror type = p.equals(vari) ? this.superTypeElement.asType() : vari.asType();
                    if (this.workingCopy.getTypes().isSameType(exType, type)) continue;
                    sameParameters = false;
                }
                if (!sameParameters) continue;
                this.isReplCandidate = false;
            }
        }
        return (Tree)super.visitMethod(node, p);
    }

    private boolean isMemberAvailable(TypeElement subTypeElement, Element methodElement, TypeElement superTypeElement) {
        ElementKind memberKind = methodElement.getKind();
        if (ElementKind.METHOD.equals((Object)memberKind)) {
            return this.isMethodAvailable(subTypeElement, (ExecutableElement)methodElement, superTypeElement);
        }
        return this.isHidingMember(subTypeElement, methodElement, superTypeElement);
    }

    private boolean isMethodAvailable(TypeElement subTypeElement, ExecutableElement execElem, TypeElement superTypeElement) {
        Elements elements = this.workingCopy.getElements();
        List<? extends Element> memberElements = elements.getAllMembers(superTypeElement);
        for (Element element : memberElements) {
            if (!ElementKind.METHOD.equals((Object)element.getKind())) continue;
            if (execElem.getModifiers().contains((Object)Modifier.STATIC) && elements.hides(execElem, element)) {
                return true;
            }
            if (!execElem.equals(element) && !elements.overrides(execElem, (ExecutableElement)element, subTypeElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isHidingMember(TypeElement subTypeElement, Element variableElement, TypeElement superTypeElement) {
        Elements elements = this.workingCopy.getElements();
        List<? extends Element> memberElements = elements.getAllMembers(superTypeElement);
        for (Element element : memberElements) {
            if (!variableElement.equals(element) && !elements.hides(variableElement, element)) continue;
            return true;
        }
        return false;
    }

    private boolean isReplacableAssgnmt(VariableElement varElement) {
        DeclaredType declType;
        TypeElement varType;
        return this.isDeclaredType(varElement.asType()) && this.isAssignable(this.superTypeElement, varType = (TypeElement)(declType = (DeclaredType)varElement.asType()).asElement());
    }

    boolean isReplaceCandidate() {
        return this.isReplCandidate;
    }

    private boolean isAssignable(TypeElement typeFrom, TypeElement typeTo) {
        Types types = this.workingCopy.getTypes();
        return types.isAssignable(typeFrom.asType(), typeTo.asType());
    }

    private Element asElement(Tree tree) {
        Trees treeUtil = this.workingCopy.getTrees();
        TreePath treePath = treeUtil.getPath(this.workingCopy.getCompilationUnit(), tree);
        Element element = treeUtil.getElement(treePath);
        return element;
    }

    private boolean isDeclaredType(TypeMirror type) {
        return TypeKind.DECLARED.equals((Object)type.getKind());
    }
}

