/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class WhereUsedPanelMethod
extends WhereUsedPanel.WhereUsedInnerPanel {
    private static final long serialVersionUID = 1L;
    private final transient ChangeListener parent;
    private final TreePathHandle tph;
    private JRadioButton btn_overriders;
    private JRadioButton btn_usages;
    private JRadioButton btn_usages_overriders;
    private ButtonGroup buttonGroup1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel label;
    private JLabel lbl_usagesof;
    private JCheckBox searchInComments;
    private JCheckBox searchOverloaded;
    private static EmptyImageIcon EMPTY_IMAGE_ICON;

    public WhereUsedPanelMethod(ChangeListener parent, TreePathHandle element, List<Pair<Pair<String, Icon>, TreePathHandle>> classes) {
        this.parent = parent;
        this.tph = element;
        this.initComponents();
        this.jComboBox1.setRenderer(new ComboBoxRenderer());
        this.jComboBox1.setModel(new DefaultComboBoxModel<Pair>(classes.toArray(new Pair[classes.size()])));
        this.jComboBox1.setSelectedIndex(1 % this.jComboBox1.getItemCount());
        this.jComboBox1.setEnabled(classes.size() > 1);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.lbl_usagesof = new JLabel();
        this.btn_usages = new JRadioButton();
        this.btn_overriders = new JRadioButton();
        this.btn_usages_overriders = new JRadioButton();
        this.searchOverloaded = new JCheckBox();
        this.label.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/refactoring/java/resources/warning_16.png")));
        this.label.setText("<<Element>>");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanelMethod.class).getString("LBL_SearchInComents"));
        this.searchInComments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WhereUsedPanelMethod.this.searchInCommentsItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"WhereUsedPanelMethod.jLabel1.text"));
        this.jComboBox1.setModel(new DefaultComboBoxModel<JLabel>(new JLabel[]{this.label}));
        Mnemonics.setLocalizedText((JLabel)this.lbl_usagesof, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"LBL_UsagesOfElement"));
        this.buttonGroup1.add(this.btn_usages);
        this.btn_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.btn_usages, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"LBL_FindUsages"));
        this.buttonGroup1.add(this.btn_overriders);
        Mnemonics.setLocalizedText((AbstractButton)this.btn_overriders, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"LBL_FindOverridingMethods"));
        this.buttonGroup1.add(this.btn_usages_overriders);
        Mnemonics.setLocalizedText((AbstractButton)this.btn_usages_overriders, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"LBL_FindUsagesOverridingMethods"));
        this.searchOverloaded.setSelected(RefactoringModule.getOption("searchOverloaded.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchOverloaded, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"WhereUsedPanelMethod.searchOverloaded.text"));
        this.searchOverloaded.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WhereUsedPanelMethod.this.searchOverloadedItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lbl_usagesof).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchOverloaded).addComponent(this.btn_usages_overriders).addComponent(this.btn_usages).addComponent(this.searchInComments).addComponent(this.btn_overriders)).addGap(0, 0, Short.MAX_VALUE))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbl_usagesof).addComponent(this.label)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchInComments).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_usages).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_overriders).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_usages_overriders).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchOverloaded).addGap(0, 0, 0)));
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", b);
    }

    private void searchOverloadedItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchOverloaded.whereUsed", b);
    }

    @Override
    void initialize(final Element element, CompilationController info) {
        ExecutableElement method = (ExecutableElement)element;
        final Set<Modifier> modifiers = method.getModifiers();
        final Icon labelIcon = ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers());
        final String labelText = UIUtilities.createHeader(method, info.getElements().isDeprecated(element), false, false, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension preferredSize = WhereUsedPanelMethod.this.label.getPreferredSize();
                WhereUsedPanelMethod.this.label.setText(labelText);
                WhereUsedPanelMethod.this.label.setIcon(labelIcon);
                WhereUsedPanelMethod.this.label.setPreferredSize(preferredSize);
                WhereUsedPanelMethod.this.label.setMinimumSize(preferredSize);
                WhereUsedPanelMethod.this.btn_usages.setVisible(!modifiers.contains((Object)Modifier.STATIC));
                WhereUsedPanelMethod.this.btn_overriders.setVisible(!modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.PRIVATE) && element.getKind() != ElementKind.CONSTRUCTOR);
                WhereUsedPanelMethod.this.btn_usages_overriders.setVisible(WhereUsedPanelMethod.this.btn_usages.isVisible() && WhereUsedPanelMethod.this.btn_overriders.isVisible());
            }
        });
    }

    String getMethodDeclaringClass() {
        Pair selectedItem = (Pair)this.jComboBox1.getSelectedItem();
        return (String)((Pair)selectedItem.first()).first();
    }

    public TreePathHandle getMethodHandle() {
        Pair selectedItem = (Pair)this.jComboBox1.getSelectedItem();
        return selectedItem == null ? this.tph : (TreePathHandle)selectedItem.second();
    }

    public boolean isMethodFromBaseClass() {
        return this.jComboBox1.getSelectedIndex() > 0;
    }

    public boolean isMethodOverriders() {
        return this.btn_overriders.isSelected() || this.btn_usages_overriders.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.btn_usages.isSelected() || this.btn_usages_overriders.isSelected();
    }

    @Override
    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public boolean isSearchOverloaded() {
        return this.searchOverloaded.isSelected();
    }

    private static Icon getEmptyIcon() {
        if (EMPTY_IMAGE_ICON == null) {
            EMPTY_IMAGE_ICON = new EmptyImageIcon();
        }
        return EMPTY_IMAGE_ICON;
    }

    private static class EmptyImageIcon
    implements Icon {
        private static final int WIDTH = 16;
        private static final int HEIGHT = 16;

        private EmptyImageIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    private static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                if (value instanceof String) {
                    this.setText((String)value);
                    this.setIcon(WhereUsedPanelMethod.getEmptyIcon());
                } else {
                    Pair selectedPair = (Pair)value;
                    this.setText((String)((Pair)selectedPair.first()).first());
                    this.setIcon((Icon)((Pair)selectedPair.first()).second());
                }
            } else {
                this.setText(null);
                this.setIcon(WhereUsedPanelMethod.getEmptyIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

