/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffVisualizer;
import org.netbeans.modules.mercurial.remote.FileStatus;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.remote.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.remote.ui.diff.ExportDiffAction;
import org.netbeans.modules.mercurial.remote.ui.diff.Setup;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.ExportDiffSupport;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ExportDiffChangesAction
extends ContextAction {
    private static final Logger LOG = Logger.getLogger(ExportDiffChangesAction.class.getName());

    @Override
    protected boolean enable(Node[] nodes) {
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource) {
            return true;
        }
        VCSContext context = HgUtils.getCurrentContext(nodes);
        if (!HgUtils.isFromHgRepository(context)) {
            return false;
        }
        return Lookup.getDefault().lookup(DiffProvider.class) != null;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ExportDiffChanges";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        this.performContextAction(nodes, false);
    }

    void performContextAction(Node[] nodes, final boolean singleDiffSetup) {
        VCSFileProxy[] roots;
        boolean noop;
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        TopComponent activated = TopComponent.getRegistry().getActivated();
        Collection<Setup> setups = null;
        if (activated instanceof DiffSetupSource) {
            setups = ((DiffSetupSource)activated).getSetups();
            noop = setups.isEmpty();
        } else {
            VCSFileProxy[] files = HgUtils.getModifiedFiles(context, 6612, false);
            boolean bl = noop = files.length == 0;
        }
        if (noop) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportDiffChangesAction.class, (String)"BK3001"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        VCSFileProxy[] vCSFileProxyArray = roots = setups == null ? HgUtils.getActionRoots(context) : this.getRoots(setups);
        if (roots == null || roots.length == 0) {
            LOG.log(Level.INFO, "Null roots for {0}", context.getRootFiles());
            return;
        }
        VCSFileProxy contextFile = roots[0];
        final VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(contextFile);
        ExportDiffSupport exportDiffSupport = new ExportDiffSupport(new VCSFileProxy[]{contextFile}, HgModuleConfig.getDefault(root).getPreferences()){

            public void writeDiffFile(final VCSFileProxy toFile) {
                ExportDiffAction.saveFolderToPrefs(toFile);
                RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                HgProgressSupport ps = new HgProgressSupport(){

                    @Override
                    protected void perform() {
                        ExportDiffChangesAction.this.async(this, root, context, toFile, singleDiffSetup);
                    }
                };
                ps.start(rp, root, NbBundle.getMessage(ExportDiffChangesAction.class, (String)"LBL_ExportChanges_Progress")).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    private void async(HgProgressSupport progress, VCSFileProxy root, VCSContext context, VCSFileProxy destination, boolean singleDiffSetup) {
        ArrayList<Setup> setups;
        Mercurial hg = Mercurial.getInstance();
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource) {
            if (!singleDiffSetup) {
                setups = new ArrayList<Setup>(((DiffSetupSource)activated).getSetups());
            } else {
                DiffNode node = (DiffNode)((Object)context.getElements().lookup(DiffNode.class));
                if (node != null) {
                    setups = new ArrayList<Setup>(Collections.singletonList(node.getSetup()));
                } else {
                    LOG.log(Level.INFO, "No DiffNode in the context: {0}", new Object[]{context.getElements().lookup(Object.class)});
                    return;
                }
            }
            Iterator i = setups.iterator();
            while (i.hasNext()) {
                Setup setup = (Setup)((Object)i.next());
                VCSFileProxy file = setup.getBaseFile();
                if (root.equals((Object)hg.getRepositoryRoot(file))) continue;
                i.remove();
            }
        } else {
            VCSFileProxy[] files = HgUtils.getModifiedFiles(context, 6612, false);
            setups = new ArrayList(files.length);
            for (int i = 0; i < files.length; ++i) {
                VCSFileProxy file = files[i];
                if (!root.equals((Object)hg.getRepositoryRoot(file))) continue;
                Mercurial.LOG.log(Level.FINE, "preparing setup {0}", file);
                Setup setup = new Setup(file, null, 0);
                Mercurial.LOG.log(Level.FINE, "setup prepared {0}", setup.getBaseFile());
                setups.add(setup);
            }
        }
        this.exportDiff(setups, destination, root, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDiff(List<Setup> setups, VCSFileProxy destination, VCSFileProxy root, HgProgressSupport progress) {
        boolean success = false;
        OutputStream out = null;
        int exportedFiles = 0;
        OutputLogger logger = progress.getLogger();
        try {
            if (root == null) {
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_BadSelection_Prompt"), NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_BadSelection_Title"), -1, 0, null, null);
                DialogDisplayer.getDefault().notify(nd);
                return;
            }
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_EXPORT_CHANGES_TITLE"));
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_EXPORT_CHANGES_TITLE_SEP"));
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_EXPORT_CHANGES", (Object)destination));
            String sep = System.getProperty("line.separator");
            this.ensureParentExists(destination);
            out = new BufferedOutputStream(VCSFileProxySupport.getOutputStream((VCSFileProxy)destination));
            out.write(("# This patch file was generated by NetBeans IDE" + sep).getBytes("utf8"));
            out.write(("# Following Index: paths are relative to: " + root.getPath() + sep).getBytes("utf8"));
            out.write(("# This patch can be applied using context Tools: Patch action on respective folder." + sep).getBytes("utf8"));
            out.write(("# It uses platform neutral UTF-8 encoding and \\n newlines." + sep).getBytes("utf8"));
            out.write(("# Above lines and this line are ignored by the patching process." + sep).getBytes("utf8"));
            Collections.sort(setups, new Comparator<Setup>(){

                @Override
                public int compare(Setup o1, Setup o2) {
                    return o1.getBaseFile().getPath().compareTo(o2.getBaseFile().getPath());
                }
            });
            Iterator<Setup> it = setups.iterator();
            int i = 0;
            while (it.hasNext()) {
                String filePath;
                Setup setup = it.next();
                VCSFileProxy file = setup.getBaseFile();
                Mercurial.LOG.log(Level.FINE, "exporting setup {0}", file.getName());
                logger.output(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_Export_Changes_Exporting", (Object)file.getName()));
                if (file.isDirectory()) continue;
                progress.setDisplayName(file.getName());
                String index = "Index: ";
                String rootPath = root.getPath();
                String relativePath = filePath = file.getPath();
                if (filePath.startsWith(rootPath)) {
                    relativePath = filePath.substring(rootPath.length() + 1);
                    index = index + relativePath + sep;
                    out.write(index.getBytes("utf8"));
                }
                this.exportDiff(setup, relativePath, out);
                ++i;
            }
            exportedFiles = i;
            success = true;
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"MSG_EXPORT_CHANGES_DONE"));
        }
        catch (IOException ex) {
            logger.outputInRed(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"BK3003"));
            Mercurial.LOG.log(Level.INFO, NbBundle.getMessage(ExportDiffChangesAction.class, (String)"BK3003"), ex);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException alreadyClosed) {}
            }
            if (success) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExportDiffChangesAction.class, (String)"BK3004", (Object)exportedFiles));
                if (exportedFiles == 0) {
                    VCSFileProxySupport.delete((VCSFileProxy)destination);
                } else {
                    VCSFileProxySupport.openFile((VCSFileProxy)destination);
                }
            } else {
                VCSFileProxySupport.delete((VCSFileProxy)destination);
            }
            logger.output("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDiff(Setup setup, String relativePath, OutputStream out) throws IOException {
        Difference[] differences;
        setup.initSources();
        DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        Reader r1 = null;
        Reader r2 = null;
        FileStatus fileStatus = setup.getInfo().getStatus(null);
        try {
            if (fileStatus == null || !fileStatus.isCopied()) {
                r1 = setup.getFirstSource().createReader();
            }
            if (r1 == null) {
                r1 = new StringReader("");
            }
            if ((r2 = setup.getSecondSource().createReader()) == null) {
                r2 = new StringReader("");
            }
            differences = diff.computeDiff(r1, r2);
        }
        finally {
            if (r1 != null) {
                try {
                    r1.close();
                }
                catch (Exception e) {}
            }
            if (r2 != null) {
                try {
                    r2.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            int i;
            r1 = null;
            if (fileStatus == null || !fileStatus.isCopied()) {
                r1 = setup.getFirstSource().createReader();
            }
            if (r1 == null) {
                r1 = new StringReader("");
            }
            if ((r2 = setup.getSecondSource().createReader()) == null) {
                r2 = new StringReader("");
            }
            TextDiffVisualizer.TextDiffInfo info = new TextDiffVisualizer.TextDiffInfo(relativePath, relativePath, null, null, r1, r2, differences);
            info.setContextMode(true, 3);
            String diffText = TextDiffVisualizer.differenceToUnifiedDiffText((TextDiffVisualizer.TextDiffInfo)info);
            ByteArrayInputStream is = new ByteArrayInputStream(diffText.getBytes("utf8"));
            while ((i = ((InputStream)is).read()) != -1) {
                out.write(i);
            }
        }
        finally {
            if (r1 != null) {
                try {
                    r1.close();
                }
                catch (Exception e) {}
            }
            if (r2 != null) {
                try {
                    r2.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void ensureParentExists(VCSFileProxy destination) {
        VCSFileProxy parent = destination.getParentFile();
        if (parent != null) {
            VCSFileProxySupport.mkdirs((VCSFileProxy)parent);
        }
    }

    private VCSFileProxy[] getRoots(Collection<Setup> setups) {
        HashSet<VCSFileProxy> roots = new HashSet<VCSFileProxy>(setups.size());
        for (Setup setup : setups) {
            VCSFileProxy f = setup.getBaseFile();
            if (f == null) continue;
            roots.add(f);
        }
        return roots.toArray(new VCSFileProxy[roots.size()]);
    }
}

