/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.properties;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.properties.HgPropertiesNode;
import org.netbeans.modules.mercurial.remote.ui.properties.PropertiesPanel;
import org.netbeans.modules.mercurial.remote.ui.properties.PropertiesTable;
import org.netbeans.modules.mercurial.remote.util.HgRepositoryContextCache;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HgProperties
implements ListSelectionListener {
    public static final String HGPROPNAME_USERNAME = "username";
    public static final String HGPROPNAME_DEFAULT_PULL = "default-pull";
    public static final String HGPROPNAME_DEFAULT_PUSH = "default-push";
    private PropertiesPanel panel;
    private VCSFileProxy root;
    private final PropertiesTable propTable;
    private HgProgressSupport support;
    private HgPropertiesNode[] initHgProps;
    private int lastIndex = -1;

    public HgProperties(PropertiesPanel panel, PropertiesTable propTable, VCSFileProxy root) {
        this.panel = panel;
        this.propTable = propTable;
        this.root = root;
        propTable.getTable().getSelectionModel().setSelectionMode(0);
        propTable.getTable().getSelectionModel().addListSelectionListener(this);
        this.refreshProperties();
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.panel;
    }

    public void setPropertiesPanel(PropertiesPanel panel) {
        this.panel = panel;
    }

    public VCSFileProxy getRoot() {
        return this.root;
    }

    public void setRoot(VCSFileProxy root) {
        this.root = root;
    }

    protected String getPropertyValue() {
        return this.panel.txtAreaValue.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshProperties() {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(this.root);
        try {
            this.support = new HgProgressSupport(){

                @Override
                protected void perform() {
                    Properties props = HgModuleConfig.getDefault(HgProperties.this.root).getProperties(HgProperties.this.root);
                    if (props == null) {
                        return;
                    }
                    HgPropertiesNode[] hgProps = new HgPropertiesNode[props.size()];
                    HgProperties.access$102(HgProperties.this, new HgPropertiesNode[props.size()]);
                    int i = 0;
                    Enumeration<?> e = props.propertyNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        String tmp = props.getProperty(name);
                        String value = tmp != null ? tmp : "";
                        hgProps[i] = new HgPropertiesNode(name, value);
                        ((HgProperties)HgProperties.this).initHgProps[i] = new HgPropertiesNode(name, value);
                        ++i;
                    }
                    HgProperties.this.propTable.setNodes(hgProps);
                }
            };
            this.support.start(rp, this.root, NbBundle.getMessage(HgProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties() {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(this.root);
        try {
            this.support = new HgProgressSupport(){

                @Override
                protected void perform() {
                    HgPropertiesNode[] hgPropertiesNodes = HgProperties.this.propTable.getNodes();
                    try {
                        for (int i = 0; i < hgPropertiesNodes.length; ++i) {
                            boolean bPropChanged;
                            String hgPropertyName = hgPropertiesNodes[i].getName();
                            String hgPropertyValue = hgPropertiesNodes[i].getValue();
                            boolean bl = bPropChanged = !HgProperties.this.initHgProps[i].getValue().equals(hgPropertyValue);
                            if (!bPropChanged || hgPropertyValue.trim().length() < 0) continue;
                            if (hgPropertyName.equals(HgProperties.HGPROPNAME_USERNAME) && !HgModuleConfig.getDefault(HgProperties.this.root).isUserNameValid(hgPropertyValue).booleanValue()) {
                                JOptionPane.showMessageDialog(null, NbBundle.getMessage(HgProperties.class, (String)"MSG_WARN_USER_NAME_TEXT"), NbBundle.getMessage(HgProperties.class, (String)"MSG_WARN_FIELD_TITLE"), 2);
                                continue;
                            }
                            HgModuleConfig.getDefault(HgProperties.this.root).setProperty(HgProperties.this.root, hgPropertyName, hgPropertyValue);
                        }
                    }
                    catch (IOException ex) {
                        HgModuleConfig.notifyParsingError();
                    }
                    HgRepositoryContextCache.getInstance().reset();
                }
            };
            this.support.start(rp, this.root, NbBundle.getMessage(HgProperties.class, (String)"LBL_Properties_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    public void updateLastSelection() {
        HgPropertiesNode[] hgPropertiesNodes = this.propTable.getNodes();
        if (this.lastIndex >= 0) {
            hgPropertiesNodes[this.lastIndex].setValue(this.getPropertyValue());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.propTable.getTable().getSelectedRow();
        if (index < 0) {
            this.lastIndex = -1;
            return;
        }
        HgPropertiesNode[] hgPropertiesNodes = this.propTable.getNodes();
        if (this.lastIndex >= 0) {
            hgPropertiesNodes[this.lastIndex].setValue(this.getPropertyValue());
        }
        this.panel.txtAreaValue.setText(hgPropertiesNodes[index].getValue());
        this.lastIndex = index;
    }

    static /* synthetic */ HgPropertiesNode[] access$102(HgProperties x0, HgPropertiesNode[] x1) {
        x0.initHgProps = x1;
        return x1;
    }
}

