/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.mercurial.remote.ui.properties.HgPropertiesNode;
import org.netbeans.modules.mercurial.remote.ui.properties.PropertiesTableModel;
import org.openide.util.NbBundle;

public class PropertiesTable
implements AncestorListener,
TableModelListener {
    public static final String[] PROPERTIES_COLUMNS = new String[]{"name", "value"};
    private PropertiesTableModel tableModel;
    private JTable table;
    private JComponent component;
    private String[] columns;

    public PropertiesTable(JLabel label, String[] columns) {
        this.init(label, columns);
    }

    private void init(JLabel label, String[] columns) {
        this.tableModel = new PropertiesTableModel(columns);
        this.tableModel.addTableModelListener(this);
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new PropertiesTableCellRenderer());
        this.table.setRowHeight(this.table.getRowHeight());
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 30);
        this.component.setPreferredSize(new Dimension(340, 150));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesTable.class, (String)"ACSD_PropertiesTable"));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertiesTable.class, (String)"ACSN_PropertiesTable"));
        label.setLabelFor(this.table);
        this.setColumns(columns);
    }

    public void setColumns(String[] clmns) {
        if (Arrays.equals(this.columns, clmns)) {
            return;
        }
        this.columns = clmns;
        this.tableModel.setColumns(clmns);
        this.setDefaultColumnSize();
    }

    public JTable getTable() {
        return this.table;
    }

    private void setDefaultColumnSize() {
        int width = this.table.getWidth();
        TableColumnModel columnModel = this.table.getColumnModel();
        if (this.columns == null || columnModel == null) {
            return;
        }
        if (columnModel.getColumnCount() != this.columns.length) {
            return;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            String col = this.columns[i];
            if (col.equals("name")) {
                columnModel.getColumn(i).setPreferredWidth(width * 20 / 100);
                continue;
            }
            if (!col.equals("value")) continue;
            columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void dataChanged() {
        int idx = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (idx != -1) {
            this.table.getSelectionModel().addSelectionInterval(idx, idx);
        }
    }

    public int[] getSelectedItems() {
        return this.table.getSelectedRows();
    }

    public HgPropertiesNode[] getNodes() {
        return this.tableModel.getNodes();
    }

    public void setNodes(HgPropertiesNode[] nodes) {
        this.tableModel.setNodes(nodes);
    }

    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void ancestorAdded(AncestorEvent arg0) {
        this.setDefaultColumnSize();
    }

    @Override
    public void ancestorRemoved(AncestorEvent arg0) {
    }

    @Override
    public void ancestorMoved(AncestorEvent arg0) {
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        this.table.repaint();
    }

    public class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            Component renderer = super.getTableCellRendererComponent(table, value, hasFocus, hasFocus, rowIndex, columnIndex);
            if (renderer instanceof JComponent) {
                String strValue = PropertiesTable.this.tableModel.getNode(rowIndex).getValue();
                ((JComponent)renderer).setToolTipText(strValue);
            }
            this.setToolTipText(value.toString());
            return renderer;
        }
    }
}

