/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.pull;

import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.pull.PullAction;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.ui.repository.Repository;
import org.netbeans.modules.mercurial.remote.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.remote.ui.wizards.CloneRepositoryWizardPanel;
import org.netbeans.modules.mercurial.remote.util.HgProjectUtils;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PullOtherAction
extends ContextAction {
    public static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/pull-setting.png";

    public PullOtherAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PullOther";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        VCSFileProxy[] roots = HgUtils.getActionRoots(context);
        if (roots == null || roots.length == 0) {
            return;
        }
        VCSFileProxy root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        int repositoryModeMask = 100;
        String title = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Location");
        final JButton pullButton = new JButton();
        final Repository repository = new Repository(repositoryModeMask, title, true, root);
        repository.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pullButton.setEnabled(repository.isValid());
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)pullButton, (String)NbBundle.getMessage(PullOtherAction.class, (String)"CTL_Pull_Action_Pull"));
        pullButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullOtherAction.class, (String)"ACSD_Pull_Action_Pull"));
        pullButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullOtherAction.class, (String)"ACSN_Pull_Action_Pull"));
        JButton cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(PullOtherAction.class, (String)"CTL_Pull_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PullOtherAction.class, (String)"ACSD_Pull_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PullOtherAction.class, (String)"ACSN_Pull_Action_Cancel"));
        boolean dataValid = repository.isValid();
        pullButton.setEnabled(dataValid);
        Object option = repository.show(NbBundle.getMessage(PullOtherAction.class, (String)"CTL_PullDialog_Title"), new HelpCtx(PullOtherAction.class), new Object[]{pullButton, cancelButton}, true, "hg.pull.dialog");
        if (option == pullButton) {
            HgURL pullSource;
            try {
                pullSource = repository.getUrl();
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Could not pull because of invalid URI." + repository.getUrlString());
                Mercurial.LOG.log(Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Invalid URI: " + repository.getUrlString());
                return;
            }
            PullOtherAction.pull(context, root, pullSource, repository.getRepositoryConnection());
        }
    }

    private static void pull(VCSContext ctx, final VCSFileProxy root, final HgURL pullSource, final RepositoryConnection rc) {
        if (root == null || pullSource == null) {
            return;
        }
        final String fromPrjName = NbBundle.getMessage(PullAction.class, (String)"MSG_EXTERNAL_REPOSITORY");
        final String toPrjName = HgProjectUtils.getProjectName(root);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                if (rc != null) {
                    HgModuleConfig.getDefault(root).insertRecentUrl(rc);
                }
                PullAction.performPull(PullAction.PullType.OTHER, root, pullSource, fromPrjName, toPrjName, null, null, this);
            }
        };
        support.start(rp, root, NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_PROGRESS"));
    }
}

