/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.queues;

import java.awt.Color;
import java.awt.EventQueue;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.config.HgConfigFiles;
import org.netbeans.modules.mercurial.remote.ui.queues.Bundle;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;

class QUtils {
    private static final Set<VCSFileProxy> acceptedQueuesWarning = Collections.synchronizedSet(new HashSet(5));
    private static final String HG_EXTENSION_QUEUES = "mq";
    private static final String HG_EXTENSION_QUEUES_WITH_PREFIX = "hgext.mq";

    private QUtils() {
    }

    static boolean isMQEnabledExtension(VCSFileProxy root) {
        boolean accepted;
        if (acceptedQueuesWarning.contains(root)) {
            accepted = true;
        } else {
            assert (!EventQueue.isDispatchThread());
            HgConfigFiles config = HgConfigFiles.getSysInstance(root);
            config.doReload();
            if (config.getException() != null) {
                Mercurial.LOG.log(Level.INFO, null, config.getException());
                accepted = true;
            } else {
                boolean bl = accepted = config.containsProperty("extensions", HG_EXTENSION_QUEUES) || config.containsProperty("extensions", HG_EXTENSION_QUEUES_WITH_PREFIX);
            }
            if (!accepted) {
                config = new HgConfigFiles(root);
                if (config.getException() != null) {
                    Mercurial.LOG.log(Level.INFO, null, config.getException());
                    accepted = true;
                } else {
                    boolean bl = accepted = config.containsProperty("extensions", HG_EXTENSION_QUEUES) || config.containsProperty("extensions", HG_EXTENSION_QUEUES_WITH_PREFIX);
                }
            }
            if (!accepted) {
                JTextPane textPane = new JTextPane();
                textPane.setOpaque(false);
                textPane.setEditable(false);
                textPane.setBackground(new Color(0, 0, 0, 0));
                textPane.setContentType("text/html");
                textPane.setText(Bundle.MSG_PreparingAction_disabled_mq_confirmation_text());
                textPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            URL url = e.getURL();
                            HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                            displayer.showURL(url);
                        }
                    }
                });
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)textPane, Bundle.LBL_PreparingAction_disabled_mq_confirmation_title(), 0, 2);
                boolean bl = accepted = NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
            if (accepted) {
                acceptedQueuesWarning.add(root);
            }
        }
        return accepted;
    }
}

