/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.remote.ui.repository.RepositoryDialogPanel;
import org.netbeans.modules.mercurial.remote.ui.repository.RepositoryPanel;
import org.netbeans.modules.mercurial.remote.util.HgRepositoryContextCache;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class Repository
implements ActionListener,
FocusListener,
ItemListener {
    public static final int FLAG_URL_ENABLED = 4;
    public static final int FLAG_ACCEPT_REVISION = 8;
    public static final int FLAG_SHOW_HINTS = 32;
    public static final int FLAG_SHOW_PROXY = 64;
    private static final String LOCAL_URL_HELP = "file:/repository_path";
    private static final String HTTP_URL_HELP = "http://hostname/repository_path";
    private static final String HTTPS_URL_HELP = "https://hostname/repository_path";
    private static final String STATIC_HTTP_URL_HELP = "static-http://hostname/repository_path";
    private static final String SSH_URL_HELP = "ssh://hostname/repository_path";
    private RepositoryPanel repositoryPanel;
    private boolean valid = true;
    private List<ChangeListener> listeners;
    private final ChangeEvent changeEvent = new ChangeEvent(this);
    private RepositoryConnection repositoryConnection;
    private HgURL url;
    public static final String PROP_VALID = "valid";
    private String message;
    private int modeMask;
    private Dimension maxNeededSize;
    private boolean bPushPull;
    private static int HG_PUSH_PULL_VERT_PADDING = 30;
    private JTextComponent urlComboEditor;
    private Document urlDoc;
    private Document usernameDoc;
    private Document passwordDoc;
    private Document tunnelCmdDoc;
    private boolean urlBeingSelectedFromPopup = false;
    private final VCSFileProxy root;
    private Map<String, String> storedPaths = Collections.emptyMap();
    private static final Set<String> SKIPPED_PATHS = new HashSet<String>(Arrays.asList("default-pull", "default", "default-push", "default-push"));

    public Repository(int modeMask, String titleLabel, boolean bPushPull, VCSFileProxy repositoryRoot) {
        this.modeMask = modeMask;
        this.root = repositoryRoot;
        this.initPanel();
        this.repositoryPanel.titleLabel.setText(titleLabel);
        this.repositoryPanel.urlComboBox.setEnabled(this.isSet(4));
        this.repositoryPanel.urlComboBox.setRenderer(new UrlRenderer());
        this.repositoryPanel.tunnelHelpLabel.setVisible(this.isSet(32));
        this.repositoryPanel.tipLabel.setVisible(this.isSet(32));
        if (bPushPull) {
            this.updateVisibility("foo:");
        } else {
            this.updateVisibility("https:");
        }
        this.maxNeededSize = this.repositoryPanel.getPreferredSize();
        this.repositoryPanel.savePasswordCheckBox.setSelected(HgModuleConfig.getDefault(this.root).getSavePassword());
        this.repositoryPanel.schedulePostInitRoutine(new Runnable(){

            @Override
            public void run() {
                Repository.this.refreshUrlHistory();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (e.getSource() == this.repositoryPanel.proxySettingsButton);
        this.onProxyConfiguration();
    }

    private void onProxyConfiguration() {
        OptionsDisplayer.getDefault().open("General");
    }

    private void initPanel() {
        this.repositoryPanel = new RepositoryPanel(this.root);
        this.urlComboEditor = (JTextComponent)this.repositoryPanel.urlComboBox.getEditor().getEditorComponent();
        this.urlDoc = this.urlComboEditor.getDocument();
        this.usernameDoc = this.repositoryPanel.userTextField.getDocument();
        this.passwordDoc = this.repositoryPanel.userPasswordField.getDocument();
        this.tunnelCmdDoc = this.repositoryPanel.tunnelCommandTextField.getDocument();
        DocumentChangeHandler documentListener = new DocumentChangeHandler();
        this.urlDoc.addDocumentListener(documentListener);
        this.passwordDoc.addDocumentListener(documentListener);
        this.usernameDoc.addDocumentListener(documentListener);
        this.tunnelCmdDoc.addDocumentListener(documentListener);
        this.repositoryPanel.savePasswordCheckBox.addItemListener(this);
        this.repositoryPanel.urlComboBox.addItemListener(this);
        this.repositoryPanel.proxySettingsButton.addActionListener(this);
        this.repositoryPanel.userPasswordField.addFocusListener(this);
        this.tweakComboBoxEditor();
    }

    private void tweakComboBoxEditor() {
        ComboBoxEditor origEditor = this.repositoryPanel.urlComboBox.getEditor();
        if (origEditor.getClass() == UrlComboBoxEditor.class) {
            assert (false);
            return;
        }
        this.repositoryPanel.urlComboBox.setEditor(new UrlComboBoxEditor(origEditor));
    }

    public void refreshUrlHistory() {
        this.repositoryPanel.urlComboBox.setModel(new DefaultComboBoxModel(this.createPresetComboEntries()));
        this.urlComboEditor.selectAll();
    }

    private Vector<?> createPresetComboEntries() {
        assert (this.repositoryPanel.urlComboBox.isEditable());
        List<RepositoryConnection> recentUrls = HgModuleConfig.getDefault(this.root).getRecentUrls();
        HgURL.Scheme[] schemes = HgURL.Scheme.values();
        List pathNames = Collections.emptyList();
        this.storedPaths = Collections.emptyMap();
        if (this.root != null) {
            Map<String, String> paths = HgRepositoryContextCache.getInstance().getPathValues(this.root);
            Iterator<Map.Entry<String, String>> it = paths.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                String storedUrl = e.getValue();
                boolean remove = true;
                if (!storedUrl.isEmpty()) {
                    try {
                        remove = false;
                        HgURL hgUrl = new HgURL(storedUrl);
                    }
                    catch (URISyntaxException ex) {
                        VCSFileProxy f = VCSFileProxy.createFileProxy((VCSFileProxy)this.root, (String)storedUrl).normalizeFile();
                        if (f.isDirectory()) {
                            e.setValue(f.getPath());
                        }
                        Mercurial.LOG.log(Level.INFO, "Repository: Unknown stored path {0}:{1}", new Object[]{e.getKey(), storedUrl});
                        remove = true;
                    }
                }
                if (!remove) continue;
                it.remove();
            }
            pathNames = new ArrayList<String>(paths.keySet());
            for (String skippedPath : SKIPPED_PATHS) {
                String predefinedUrl = paths.get(skippedPath);
                if (predefinedUrl != null) {
                    try {
                        RepositoryConnection rc = new RepositoryConnection(predefinedUrl);
                        if (!recentUrls.contains(rc)) {
                            recentUrls.add(rc);
                        }
                    }
                    catch (URISyntaxException ex) {
                        // empty catch block
                    }
                }
                pathNames.remove(skippedPath);
            }
            Collections.sort(pathNames);
            this.storedPaths = paths;
        }
        Vector<Object> result = new Vector<Object>(recentUrls.size() + schemes.length + pathNames.size());
        result.addAll(pathNames);
        result.addAll(recentUrls);
        for (HgURL.Scheme scheme : schemes) {
            result.add(Repository.createURIPrefixForScheme(scheme));
        }
        return result;
    }

    private static String createURIPrefixForScheme(HgURL.Scheme scheme) {
        if (scheme == HgURL.Scheme.FILE) {
            return (Object)((Object)scheme) + ":/";
        }
        return (Object)((Object)scheme) + "://";
    }

    private void quickValidateUrl() {
        String toValidate = this.getUrlString();
        String errMsg = this.storedPaths.containsValue(toValidate) ? null : HgURL.validateQuickly(toValidate);
        if (errMsg == null) {
            this.setValid();
        } else {
            this.setValid(false, errMsg);
        }
    }

    private void onUrlChange() {
        if (!this.urlBeingSelectedFromPopup) {
            this.repositoryConnection = null;
            this.url = null;
            this.repositoryPanel.userTextField.setText(null);
            this.repositoryPanel.userPasswordField.setText(null);
            this.repositoryPanel.tunnelCommandTextField.setText(null);
            this.repositoryPanel.savePasswordCheckBox.setSelected(false);
        }
        this.quickValidateUrl();
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.updateVisibility(this.getUrlString());
    }

    private void updateVisibility(String selectedUrlString) {
        boolean authFields = false;
        boolean proxyFields = false;
        boolean sshFields = false;
        this.repositoryPanel.chooseFolderButton.setVisible(false);
        if (selectedUrlString.startsWith("http:")) {
            this.repositoryPanel.tipLabel.setText(HTTP_URL_HELP);
            authFields = true;
            proxyFields = true;
        } else if (selectedUrlString.startsWith("https:")) {
            this.repositoryPanel.tipLabel.setText(HTTPS_URL_HELP);
            authFields = true;
            proxyFields = true;
        } else if (selectedUrlString.startsWith("static-http:")) {
            this.repositoryPanel.tipLabel.setText(STATIC_HTTP_URL_HELP);
            authFields = true;
            proxyFields = true;
        } else if (selectedUrlString.startsWith("ssh")) {
            this.repositoryPanel.tipLabel.setText(this.getSVNTunnelTip(selectedUrlString));
            sshFields = true;
        } else if (selectedUrlString.startsWith("file:")) {
            this.repositoryPanel.tipLabel.setText(LOCAL_URL_HELP);
            this.repositoryPanel.chooseFolderButton.setVisible(true);
        } else {
            this.repositoryPanel.tipLabel.setText(NbBundle.getMessage(Repository.class, (String)"MSG_Repository_Url_Help", (Object[])new Object[]{LOCAL_URL_HELP, HTTP_URL_HELP, HTTPS_URL_HELP, STATIC_HTTP_URL_HELP, SSH_URL_HELP}));
        }
        this.repositoryPanel.userPasswordField.setVisible(authFields);
        this.repositoryPanel.passwordLabel.setVisible(authFields);
        this.repositoryPanel.userTextField.setVisible(authFields);
        this.repositoryPanel.leaveBlankLabel.setVisible(authFields);
        this.repositoryPanel.userLabel.setVisible(authFields);
        this.repositoryPanel.savePasswordCheckBox.setVisible(false);
        this.repositoryPanel.proxySettingsButton.setVisible(proxyFields && (this.modeMask & 0x40) != 0);
        this.repositoryPanel.savePasswordCheckBox.setVisible(false);
        this.repositoryPanel.tunnelCommandTextField.setVisible(false);
        this.repositoryPanel.tunnelCommandLabel.setVisible(false);
        this.repositoryPanel.tunnelLabel.setVisible(false);
        this.repositoryPanel.tunnelHelpLabel.setVisible(false);
    }

    public void setEditable(boolean editable) {
        assert (EventQueue.isDispatchThread());
        this.repositoryPanel.urlComboBox.setEnabled(editable && this.isSet(4));
        this.repositoryPanel.userTextField.setEnabled(editable && this.valid);
        this.repositoryPanel.userPasswordField.setEnabled(editable && this.valid);
        this.repositoryPanel.savePasswordCheckBox.setEnabled(editable && this.valid);
        this.repositoryPanel.tunnelCommandTextField.setEnabled(editable && this.valid);
        this.repositoryPanel.proxySettingsButton.setEnabled(editable && this.valid);
    }

    private String getSVNTunnelTip(String urlString) {
        return SSH_URL_HELP;
    }

    public String getUrlString() {
        String value = this.urlComboEditor.getText().trim();
        String storedUrl = this.storedPaths.get(value);
        if (storedUrl != null) {
            value = storedUrl;
        }
        return value;
    }

    private String getUsername() {
        return this.repositoryPanel.userTextField.getText().trim();
    }

    private char[] getPassword() {
        return this.repositoryPanel.userPasswordField.getPassword();
    }

    private String getExternalCommand() {
        return this.repositoryPanel.tunnelCommandTextField.getText();
    }

    private boolean isSavePassword() {
        return this.repositoryPanel.savePasswordCheckBox.isSelected();
    }

    public HgURL getUrl() throws URISyntaxException {
        this.prepareUrl();
        assert (this.url != null);
        return this.url;
    }

    public RepositoryConnection getRepositoryConnection() {
        this.prepareRepositoryConnection();
        assert (this.repositoryConnection != null);
        return this.repositoryConnection;
    }

    private void prepareUrl() throws URISyntaxException {
        if (this.url != null) {
            return;
        }
        String urlString = this.getUrlString();
        String username = this.getUsername();
        this.url = username.length() == 0 ? new HgURL(urlString) : new HgURL(urlString, username, this.getPassword());
    }

    private void prepareRepositoryConnection() {
        if (this.repositoryConnection != null) {
            return;
        }
        String extCommand = this.getExternalCommand();
        boolean savePassword = this.isSavePassword();
        this.repositoryConnection = new RepositoryConnection(this.url, extCommand, savePassword);
    }

    private void onUsernameChange() {
        this.repositoryConnection = null;
        this.url = null;
    }

    private void onPasswordChange() {
        this.repositoryConnection = null;
        this.url = null;
    }

    private void onTunnelCommandChange() {
        this.repositoryConnection = null;
    }

    private void onSavePasswordChange() {
        this.repositoryConnection = null;
    }

    public RepositoryPanel getPanel() {
        return this.repositoryPanel;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void setValid() {
        this.setValid(true, "");
    }

    public void setInvalid() {
        this.setValid(false, "");
    }

    private void setValid(boolean valid, String message) {
        if (valid == this.valid && message.equals(this.message)) {
            return;
        }
        if (valid != this.valid) {
            this.repositoryPanel.proxySettingsButton.setEnabled(valid);
            this.repositoryPanel.userPasswordField.setEnabled(valid);
            this.repositoryPanel.userTextField.setEnabled(valid);
        }
        this.valid = valid;
        this.message = message;
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ChangeListener l : this.listeners) {
                l.stateChanged(this.changeEvent);
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>(4);
        }
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.repositoryPanel.userPasswordField) {
            this.repositoryPanel.userPasswordField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.repositoryPanel.urlComboBox) {
            if (evt.getStateChange() == 1) {
                this.comboBoxItemSelected(evt.getItem());
            }
        } else if (source == this.repositoryPanel.savePasswordCheckBox) {
            this.onSavePasswordChange();
        } else assert (false);
    }

    private void comboBoxItemSelected(Object selectedItem) {
        if (selectedItem.getClass() == String.class) {
            this.urlPrefixSelected();
        } else if (selectedItem instanceof RepositoryConnection) {
            this.repositoryConnectionSelected((RepositoryConnection)selectedItem);
        } else assert (false);
    }

    private void urlPrefixSelected() {
        this.repositoryPanel.userTextField.setText(null);
        this.repositoryPanel.userPasswordField.setText(null);
        this.repositoryPanel.tunnelCommandTextField.setText(null);
        this.repositoryPanel.savePasswordCheckBox.setSelected(false);
        this.url = null;
        this.repositoryConnection = null;
    }

    private void repositoryConnectionSelected(RepositoryConnection rc) {
        this.repositoryPanel.userTextField.setText(rc.getUsername());
        this.repositoryPanel.userPasswordField.setText(null);
        this.repositoryPanel.tunnelCommandTextField.setText(rc.getExternalCommand());
        this.repositoryPanel.savePasswordCheckBox.setSelected(rc.isSavePassword());
        this.url = rc.getUrl();
        this.repositoryConnection = rc;
    }

    public void setTipVisible(Boolean flag) {
        this.repositoryPanel.tipLabel.setVisible(flag);
    }

    public boolean show(String title, HelpCtx helpCtx, boolean setMaxNeddedSize) {
        RepositoryDialogPanel corectPanel = new RepositoryDialogPanel();
        corectPanel.panel.setLayout(new BorderLayout());
        RepositoryPanel p = this.getPanel();
        if (setMaxNeddedSize) {
            if (this.bPushPull) {
                this.maxNeededSize.setSize(this.maxNeededSize.width, this.maxNeededSize.height + HG_PUSH_PULL_VERT_PADDING);
            }
            p.setPreferredSize(this.maxNeededSize);
        }
        corectPanel.panel.add((Component)p, "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)corectPanel, title);
        this.showDialog(dialogDescriptor, helpCtx, null);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Object show(String title, HelpCtx helpCtx, Object[] options, boolean setMaxNeededSize, String name) {
        RepositoryDialogPanel corectPanel = new RepositoryDialogPanel();
        corectPanel.panel.setLayout(new BorderLayout());
        corectPanel.panel.add((Component)this.getPanel(), "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)corectPanel, title);
        RepositoryPanel p = this.getPanel();
        if (setMaxNeededSize) {
            if (this.bPushPull) {
                this.maxNeededSize.setSize(this.maxNeededSize.width, this.maxNeededSize.height + HG_PUSH_PULL_VERT_PADDING);
            }
            p.setPreferredSize(this.maxNeededSize);
        }
        if (options != null) {
            dialogDescriptor.setOptions(options);
        }
        this.showDialog(dialogDescriptor, helpCtx, name);
        return dialogDescriptor.getValue();
    }

    private void showDialog(DialogDescriptor dialogDescriptor, HelpCtx helpCtx, String name) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(helpCtx);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        if (name != null) {
            dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(HgModuleConfig.getDefault(this.root).getPreferences(), name));
        }
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Repository.class, (String)"ACSD_RepositoryPanel"));
        dialog.setVisible(true);
    }

    private boolean isSet(int flag) {
        return (this.modeMask & flag) != 0;
    }

    private class UrlRenderer
    extends DefaultListCellRenderer {
        private UrlRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String url;
            if (value instanceof String && (url = (String)Repository.this.storedPaths.get((String)value)) != null) {
                value = value + " (" + url + ")";
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private final class DocumentChangeHandler
    implements DocumentListener {
        DocumentChangeHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged(e);
        }

        private void textChanged(DocumentEvent e) {
            assert (EventQueue.isDispatchThread());
            Document modifiedDocument = e.getDocument();
            assert (modifiedDocument != null);
            assert (modifiedDocument == Repository.this.urlDoc || !Repository.this.urlBeingSelectedFromPopup);
            if (modifiedDocument == Repository.this.urlDoc) {
                Repository.this.onUrlChange();
            } else if (modifiedDocument == Repository.this.usernameDoc) {
                Repository.this.onUsernameChange();
            } else if (modifiedDocument == Repository.this.passwordDoc) {
                Repository.this.onPasswordChange();
            } else if (modifiedDocument == Repository.this.tunnelCmdDoc) {
                Repository.this.onTunnelCommandChange();
            }
        }
    }

    private final class UrlComboBoxEditor
    implements ComboBoxEditor,
    DocumentListener {
        private final ComboBoxEditor origEditor;
        private Reference<RepositoryConnection> repoConnRef;

        private UrlComboBoxEditor(ComboBoxEditor originalEditor) {
            this.origEditor = originalEditor;
            ((JTextComponent)originalEditor.getEditorComponent()).getDocument().addDocumentListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setItem(Object anObject) {
            Repository.this.urlBeingSelectedFromPopup = true;
            try {
                this.setItemImpl(anObject);
            }
            finally {
                Repository.this.urlBeingSelectedFromPopup = false;
            }
        }

        private void setItemImpl(Object anObject) {
            assert (Repository.this.urlBeingSelectedFromPopup);
            if (anObject instanceof RepositoryConnection) {
                RepositoryConnection repoConn = (RepositoryConnection)anObject;
                this.repoConnRef = new WeakReference<RepositoryConnection>(repoConn);
                this.origEditor.setItem(repoConn.getUrl().toUrlStringWithoutUserInfo());
            } else {
                this.clearRepoConnRef();
                this.origEditor.setItem(anObject);
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.origEditor.getEditorComponent();
        }

        @Override
        public Object getItem() {
            RepositoryConnection repoConn = this.getRepoConn();
            if (repoConn != null) {
                return repoConn;
            }
            return this.origEditor.getItem();
        }

        @Override
        public void selectAll() {
            this.origEditor.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.origEditor.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.origEditor.removeActionListener(l);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        private void textChanged() {
            if (Repository.this.urlBeingSelectedFromPopup) {
                return;
            }
            this.clearRepoConnRef();
        }

        private RepositoryConnection getRepoConn() {
            RepositoryConnection repoConn;
            if (this.repoConnRef != null && (repoConn = this.repoConnRef.get()) != null) {
                return repoConn;
            }
            return null;
        }

        private void clearRepoConnRef() {
            if (this.repoConnRef != null) {
                this.repoConnRef.clear();
            }
        }
    }
}

