/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.mercurial.remote.ui.update.ConflictResolvedAction;
import org.netbeans.modules.mercurial.remote.ui.update.RevertModifications;
import org.netbeans.modules.mercurial.remote.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RevertModificationsAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/get_clean.png";

    public RevertModificationsAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        if (!HgUtils.isFromHgRepository(context) || ctxFiles == null || ctxFiles.isEmpty()) {
            return false;
        }
        Set roots = context.getRootFiles();
        if (roots == null) {
            return false;
        }
        for (VCSFileProxy root : roots) {
            FileInformation info = Mercurial.getInstance().getFileStatusCache().getCachedStatus(root);
            if (info == null || info.getStatus() != 4) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_GetClean";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        RevertModificationsAction.revert(context);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    public static void revert(VCSContext ctx) {
        final VCSFileProxy[] files = HgUtils.getActionRoots(ctx);
        if (files == null || files.length == 0) {
            return;
        }
        final VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(files[0]);
        RevertModifications revertModifications = new RevertModifications(repository, Arrays.asList(files).contains(repository) ? null : files);
        if (!revertModifications.showDialog()) {
            return;
        }
        final String revStr = revertModifications.getSelectionRevision();
        final boolean doBackup = revertModifications.isBackupRequested();
        final boolean removeNewFiles = revertModifications.isRemoveNewFilesRequested();
        HgModuleConfig.getDefault(repository).setRemoveNewFilesOnRevertModifications(removeNewFiles);
        HgModuleConfig.getDefault(repository).setBackupOnRevertModifications(doBackup);
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                RevertModificationsAction.performRevert(repository, revStr, files, doBackup, removeNewFiles, this.getLogger());
            }
        };
        support.start(rp, repository, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Revert_Progress"));
    }

    public static void performRevert(VCSFileProxy repository, String revStr, VCSFileProxy file, boolean doBackup, OutputLogger logger) {
        ArrayList<VCSFileProxy> revertFiles = new ArrayList<VCSFileProxy>();
        revertFiles.add(file);
        RevertModificationsAction.performRevert(repository, revStr, revertFiles, doBackup, false, logger);
    }

    public static void performRevert(VCSFileProxy repository, String revStr, VCSFileProxy[] files, boolean doBackup, boolean removeNewFiles, OutputLogger logger) {
        ArrayList<VCSFileProxy> revertFiles = new ArrayList<VCSFileProxy>();
        revertFiles.addAll(Arrays.asList(files));
        RevertModificationsAction.performRevert(repository, revStr, revertFiles, doBackup, removeNewFiles, logger);
    }

    public static void performRevert(final VCSFileProxy repository, final String revStr, final List<VCSFileProxy> revertFiles, final boolean doBackup, final boolean removeNewFiles, final OutputLogger logger) {
        try {
            logger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_TITLE"));
            logger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_TITLE_SEP"));
            if (revStr != null && NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Revision_Default").startsWith(revStr)) {
                logger.output(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_NOTHING"));
                logger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_DONE"));
                logger.outputInRed("");
                return;
            }
            if (revertFiles.isEmpty()) {
                logger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_NOFILES"));
                logger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_DONE"));
                logger.outputInRed("");
                return;
            }
            logger.output(revStr == null ? NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_REVISION_PARENT") : NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_REVISION_STR", (Object)revStr));
            for (VCSFileProxy file : revertFiles) {
                logger.output(file.getPath());
            }
            logger.output("");
            HgUtils.runWithoutIndexing(new Callable<Void>(){

                @Override
                public Void call() throws HgException {
                    FileStatusCache cache;
                    VCSFileProxy[] conflictFiles;
                    HgCommand.doRevert(repository, revertFiles, revStr, doBackup, logger);
                    if (removeNewFiles) {
                        HgCommand.doPurge(repository, revertFiles, HgUtils.getNotSharablePaths(repository, revertFiles), logger);
                    }
                    if ((conflictFiles = (cache = Mercurial.getInstance().getFileStatusCache()).listFiles(revertFiles.toArray(new VCSFileProxy[0]), 64)).length != 0) {
                        ConflictResolvedAction.conflictResolved(repository, conflictFiles);
                    }
                    return null;
                }
            }, revertFiles);
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        Mercurial.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, new HashSet<VCSFileProxy>(revertFiles)));
        logger.outputInRed(NbBundle.getMessage(RevertModificationsAction.class, (String)"MSG_REVERT_DONE"));
        logger.outputInRed("");
    }
}

