/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.FileStatus;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.WorkingCopyInfo;
import org.netbeans.modules.mercurial.remote.config.HgConfigFiles;
import org.netbeans.modules.mercurial.remote.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.queues.QPatch;
import org.netbeans.modules.mercurial.remote.ui.queues.Queue;
import org.netbeans.modules.mercurial.remote.ui.repository.HgURL;
import org.netbeans.modules.mercurial.remote.ui.repository.UserCredentialsSupport;
import org.netbeans.modules.mercurial.remote.ui.tag.HgTag;
import org.netbeans.modules.mercurial.remote.util.Bundle;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.KeyringSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;
import org.openide.util.NetworkSettings;
import org.openide.util.Utilities;

public abstract class HgCommand<T>
implements Callable<T> {
    public static final String HG_COMMAND = "hg";
    public static final String HG_WINDOWS_EXE = ".exe";
    public static final String HG_WINDOWS_BAT = ".bat";
    public static final String HG_WINDOWS_CMD = ".cmd";
    public static final String[] HG_WINDOWS_EXECUTABLES = new String[]{"hg.exe", "hg.bat", "hg.cmd"};
    public static final String HG_COMMAND_PLACEHOLDER = "hg";
    public static final String HGK_COMMAND = "hgk";
    private static final String HG_DIFF_CMD = "diff";
    private static final String HG_OPT_STAT = "--stat";
    private static final String HG_STATUS_CMD = "status";
    private static final String HG_OPT_REPOSITORY = "--repository";
    private static final String HG_OPT_BUNDLE = "--bundle";
    private static final String HG_OPT_CWD_CMD = "--cwd";
    private static final String HG_OPT_USERNAME = "--user";
    private static final String HG_OPT_CLOSE_BRANCH = "--close-branch";
    private static final String HG_OPT_FOLLOW = "--follow";
    private static final String HG_FLAG_REV_CMD = "--rev";
    private static final String HG_STATUS_FLAG_TIP_CMD = "tip";
    private static final String HG_STATUS_FLAG_INTERESTING_COPIES_CMD = "-marduC";
    private static final String HG_STATUS_FLAG_INTERESTING_CMD = "-mardu";
    private static final String HG_HEAD_STR = "HEAD";
    private static final String HG_FLAG_DATE_CMD = "--date";
    private static final String HG_COMMIT_CMD = "commit";
    private static final String HG_COMMIT_OPT_LOGFILE_CMD = "--logfile";
    private static final String HG_COMMIT_TEMPNAME = "hgcommit";
    private static final String HG_COMMIT_TEMPNAME_SUFFIX = ".hgm";
    private static final String HG_COMMIT_DEFAULT_MESSAGE = "[no commit message]";
    private static final String HG_REVERT_CMD = "revert";
    private static final String HG_REVERT_NOBACKUP_CMD = "--no-backup";
    private static final String HG_PURGE_CMD = "purge";
    private static final String HG_EXT_PURGE = "extensions.purge=";
    private static final String HG_ADD_CMD = "add";
    private static final String HG_TIP_CONST = "tip";
    private static final String HG_CREATE_CMD = "init";
    private static final String HG_CLONE_CMD = "clone";
    private static final String HG_UPDATE_ALL_CMD = "update";
    private static final String HG_UPDATE_FORCE_ALL_CMD = "-C";
    private static final String HG_REMOVE_CMD = "remove";
    private static final String HG_REMOVE_FLAG_FORCE_CMD = "--force";
    private static final String HG_LOG_CMD = "log";
    private static final String HG_TIP_CMD = "tip";
    private static final String HG_OUT_CMD = "out";
    private static final String HG_LOG_LIMIT_ONE_CMD = "-l 1";
    private static final String HG_LOG_LIMIT_CMD = "-l";
    private static final String HG_PARENT_CMD = "parents";
    private static final String HG_PARAM_BRANCH = "-b";
    private static final String HG_PARAM_PUSH_NEW_BRANCH = "--new-branch";
    private static final String HG_LOG_NO_MERGES_CMD = "-M";
    private static final String HG_LOG_DEBUG_CMD = "--debug";
    private static final String HG_LOG_REVISION_OUT = "rev:";
    private static final String HG_LOG_AUTHOR_OUT = "auth:";
    private static final String HG_LOG_USER_OUT = "user:";
    private static final String HG_LOG_DESCRIPTION_OUT = "desc:";
    private static final String HG_LOG_DATE_OUT = "date:";
    private static final String HG_LOG_ID_OUT = "id:";
    private static final String HG_LOG_PARENTS_OUT = "parents:";
    private static final String HG_LOG_FILEMODS_OUT = "file_mods:";
    private static final String HG_LOG_FILEADDS_OUT = "file_adds:";
    private static final String HG_LOG_FILEDELS_OUT = "file_dels:";
    private static final String HG_LOG_FILECOPIESS_OUT = "file_copies:";
    private static final String HG_LOG_BRANCHES_OUT = "branches:";
    private static final String HG_LOG_TAGS_OUT = "tags:";
    private static final String HG_LOG_ENDCS_OUT = "endCS:";
    private static final String HG_LOG_PATCH_CMD = "-p";
    private static final String HG_LOG_TEMPLATE_EXPORT_FILE_CMD = "--template=# Mercurial Export File Diff\\n# changeset: \\t{rev}:{node|short}\\n# user:\\t\\t{author}\\n# date:\\t\\t{date|isodate}\\n# summary:\\t{desc}\\n\\n";
    private static final String HG_REV_TEMPLATE_CMD = "--template={rev}\\n";
    private static final String HG_CAT_CMD = "cat";
    private static final String HG_FLAG_OUTPUT_CMD = "--output";
    private static final String HG_COMMONANCESTOR_CMD = "debugancestor";
    private static final String HG_ANNOTATE_CMD = "annotate";
    private static final String HG_ANNOTATE_FLAGN_CMD = "--number";
    private static final String HG_ANNOTATE_FLAGU_CMD = "--user";
    private static final String HG_ANNOTATE_FLAGL_CMD = "--line-number";
    private static final String HG_EXPORT_CMD = "export";
    private static final String HG_IMPORT_CMD = "import";
    private static final String HG_RENAME_CMD = "rename";
    private static final String HG_RENAME_AFTER_CMD = "-A";
    private static final String HG_COPY_CMD = "copy";
    private static final String HG_COPY_AFTER_CMD = "-A";
    private static final String HG_NEWEST_FIRST = "--newest-first";
    private static final String HG_RESOLVE_CMD = "resolve";
    private static final String HG_RESOLVE_MARK_RESOLVED = "--mark";
    private static final String HG_MQ_EXT_CMD = "extensions.mq=";
    private static final String HG_QPATCHES_NAME = "patches";
    private static final String HG_QQUEUE_CMD = "qqueue";
    private static final String HG_QSERIES_CMD = "qseries";
    private static final String HG_OPT_SUMMARY = "--summary";
    private static final String HG_OPT_LIST = "--list";
    private static final String HG_QGOTO_CMD = "qgoto";
    private static final String HG_QPOP_CMD = "qpop";
    private static final String HG_QPUSH_CMD = "qpush";
    private static final String HG_OPT_ALL = "--all";
    private static final String HG_QCREATE_CMD = "qnew";
    private static final String HG_QREFRESH_PATCH = "qrefresh";
    private static final String HG_OPT_EXCLUDE = "--exclude";
    private static final String HG_OPT_SHORT = "--short";
    private static final String HG_QFINISH_CMD = "qfinish";
    private static final String QUEUE_ACTIVE = "(active)";
    protected static final String HG_REBASE_CMD = "rebase";
    private static final String HG_MERGE_CMD = "merge";
    private static final String HG_MERGE_FORCE_CMD = "-f";
    private static final String HG_MERGE_ENV = "EDITOR=success || $TEST -s";
    protected static final String HG_MERGE_SIMPLE_TOOL = "ui.merge=internal:merge";
    private static final String HG_PULL_CMD = "pull";
    private static final String HG_UPDATE_CMD = "-u";
    private static final String HG_PUSH_CMD = "push";
    private static final String HG_BUNDLE_CMD = "bundle";
    private static final String HG_UNBUNDLE_CMD = "unbundle";
    private static final String HG_ROLLBACK_CMD = "rollback";
    private static final String HG_BACKOUT_CMD = "backout";
    private static final String HG_BACKOUT_MERGE_CMD = "--merge";
    private static final String HG_BACKOUT_COMMIT_MSG_CMD = "-m";
    private static final String HG_REV_CMD = "-r";
    private static final String HG_BASE_CMD = "--base";
    private static final String HG_OPTION_GIT = "--git";
    private static final String HG_STRIP_CMD = "strip";
    private static final String HG_STRIP_EXT_CMD = "extensions.mq=";
    private static final String HG_STRIP_NOBACKUP_CMD = "-n";
    private static final String HG_STRIP_FORCE_MULTIHEAD_CMD = "-f";
    private static final String HG_VERIFY_CMD = "verify";
    private static final String HG_VERSION_CMD = "version";
    private static final String HG_INCOMING_CMD = "incoming";
    private static final String HG_OUTGOING_CMD = "outgoing";
    private static final String HG_VIEW_CMD = "view";
    private static final String HG_VERBOSE_CMD = "-v";
    private static final String HG_CONFIG_OPTION_CMD = "--config";
    private static final String HG_FETCH_EXT_CMD = "extensions.fetch=";
    private static final String HG_FETCH_CMD = "fetch";
    public static final String HG_PROXY_ENV = "http_proxy=";
    private static final String HG_UPDATE_NEEDED_ERR = "(run 'hg update' to get a working copy)";
    public static final String HG_MERGE_CONFLICT_ERR = "conflicts detected in ";
    public static final String HG_MERGE_FAILED1_ERR = "merging";
    public static final String HG_MERGE_FAILED2_ERR = "failed!";
    public static final String HG_MERGE_FAILED3_ERR = "incomplete!";
    private static final String HG_MERGE_MULTIPLE_HEADS_ERR = "abort: repo has ";
    private static final String HG_MERGE_UNCOMMITTED_ERR = "abort: outstanding uncommitted merges";
    private static final String HG_MERGE_UNAVAILABLE_ERR = "is not recognized as an internal or external command";
    private static final String HG_NO_CHANGES_ERR = "no changes found";
    private static final String HG_CREATE_NEW_BRANCH_ERR = "abort: push creates new remote ";
    private static final String HG_HEADS_CREATED_ERR = "(+1 heads)";
    private static final String HG_NO_HG_CMD_FOUND_ERR = "hg: not found";
    private static final String HG_ARG_LIST_TOO_LONG_ERR = "Arg list too long";
    private static final String HG_ARGUMENT_LIST_TOO_LONG_ERR = "Argument list too long";
    private static final String HG_HEADS_CMD = "heads";
    private static final String HG_BRANCHES_CMD = "branches";
    private static final String HG_BRANCH_CMD = "branch";
    private static final String HG_TAG_CMD = "tag";
    private static final String HG_TAG_OPT_MESSAGE = "--message";
    private static final String HG_TAG_OPT_REMOVE = "--remove";
    private static final String HG_TAG_OPT_REVISION = "--rev";
    private static final String HG_TAG_OPT_LOCAL = "--local";
    private static final String HG_TAGS_CMD = "tags";
    private static final String HG_NO_REPOSITORY_ERR = "There is no Mercurial repository here";
    private static final String HG_NO_RESPONSE_ERR = "no suitable response from remote hg!";
    private static final String HG_NOT_REPOSITORY_ERR = "does not appear to be an hg repository";
    private static final String HG_REPOSITORY = "repository";
    private static final String HG_NOT_FOUND_ERR = "not found!";
    private static final String HG_UPDATE_SPAN_BRANCHES_ERR = "abort: update spans branches";
    private static final String HG_UPDATE_CROSS_BRANCHES_ERR = "abort: crosses branches";
    private static final String HG_ALREADY_TRACKED_ERR = " already tracked!";
    private static final String HG_NOT_TRACKED_ERR = " no tracked!";
    private static final String HG_CANNOT_READ_COMMIT_MESSAGE_ERR = "abort: can't read commit message";
    private static final String HG_CANNOT_RUN_ERR = "Cannot run program";
    private static final String HG_ABORT_ERR = "abort: ";
    private static final String HG_ABORT_PUSH_ERR = "abort: push creates new remote ";
    private static final String HG_ABORT_NO_FILES_TO_COPY_ERR = "abort: no files to copy";
    private static final String HG_ABORT_NO_DEFAULT_PUSH_ERR = "abort: repository default-push not found!";
    private static final String HG_ABORT_NO_DEFAULT_ERR = "abort: repository default not found!";
    private static final String HG_ABORT_POSSIBLE_PROXY_ERR = "abort: error: node name or service name not known";
    private static final String HG_ABORT_UNCOMMITTED_CHANGES_ERR = "abort: outstanding uncommitted changes";
    private static final String HG_BACKOUT_MERGE_NEEDED_ERR = "(use \"backout --merge\" if you want to auto-merge)";
    private static final String HG_ABORT_BACKOUT_MERGE_CSET_ERR = "abort: cannot back out a merge changeset without --parent";
    private static final String HG_COMMIT_AFTER_MERGE_ERR = "abort: cannot partially commit a merge (do not specify files or patterns)";
    private static final String HG_ADDING = "adding";
    private static final String HG_WARNING_PERFORMANCE_FILES_OVER = ": files over";
    private static final String HG_WARNING_PERFORMANCE_CAUSE_PROBLEMS = "cause memory and performance problems";
    private static final String HG_ABORT_CANNOT_FOLLOW_NONEXISTENT_FILE = "cannot follow nonexistent file";
    private static final String HG_NO_CHANGE_NEEDED_ERR = "no change needed";
    private static final String HG_NO_ROLLBACK_ERR = "no rollback information available";
    private static final String HG_NO_UPDATES_ERR = "0 files updated, 0 files merged, 0 files removed, 0 files unresolved";
    private static final String HG_NO_VIEW_ERR = "hg: unknown command 'view'";
    private static final String HG_HGK_NOT_FOUND_ERR = "sh: hgk: not found";
    private static final String HG_NO_SUCH_FILE_ERR = "no such file";
    private static final String HG_NO_REV_STRIP_ERR = "abort: unknown revision";
    private static final String HG_LOCAL_CHANGES_STRIP_ERR = "abort: local changes found";
    private static final String HG_MULTIPLE_HEADS_STRIP_ERR = "no rollback information available";
    private static final char HG_STATUS_CODE_MODIFIED = 'm';
    private static final char HG_STATUS_CODE_ADDED = 'a';
    private static final char HG_STATUS_CODE_REMOVED = 'r';
    private static final char HG_STATUS_CODE_CLEAN = 'c';
    private static final char HG_STATUS_CODE_DELETED = 'A';
    private static final char HG_STATUS_CODE_NOTTRACKED = '_';
    private static final char HG_STATUS_CODE_IGNORED = 'i';
    private static final char HG_STATUS_CODE_CONFLICT = 'u';
    private static final char HG_STATUS_CODE_ABORT = '\u00c3';
    public static final String HG_STR_CONFLICT_EXT = ".conflict~";
    private static final String HG_EPOCH_PLUS_ONE_YEAR = "1971-01-01";
    private static final String HG_AUTHORIZATION_REQUIRED_ERR = "authorization required";
    private static final String HG_AUTHORIZATION_FAILED_ERR = "authorization failed";
    public static final String COMMIT_AFTER_MERGE = "commitAfterMerge";
    private static final String ENV_HGPLAIN = "HGPLAIN";
    private static final String ENV_HGENCODING = "HGENCODING";
    public static final String ENCODING = HgCommand.getEncoding();
    private static final String HG_LOG_FULL_CHANGESET_NAME = "log-full-changeset.tmpl";
    private static final String HG_LOG_ONLY_FILE_COPIES_CHANGESET_NAME = "log-only-file-copies-changeset.tmpl";
    private static final String HG_LOG_BASIC_CHANGESET_NAME = "log-no-files-changeset.tmpl";
    private static final String HG_LOG_CHANGESET_GENERAL_NAME = "changeset.tmpl";
    private static final String HG_LOG_STYLE_NAME = "log.style";
    private static final String HG_ARGUMENT_STYLE = "--style=";
    private static final int MAC_MAX_COMMANDLINE_SIZE = 64000;
    private static final int UNIX_MAX_COMMANDLINE_SIZE = 128000;
    private static final int MAX_COMMANDLINE_SIZE;
    private static final HashSet<String> WORKING_COPY_PARENT_MODIFYING_COMMANDS;
    private static final HashSet<String> REPOSITORY_NOMODIFICATION_COMMANDS;
    private static final String HG_FLAG_TOPO = "--topo";
    private static final String CMD_EXE = "cmd.exe";
    private static final ThreadLocal<Boolean> doNotAddHgPlain;
    private static final ThreadLocal<Boolean> disabledUI;
    private static Boolean topoAvailable;
    private static final Set<VCSFileProxy> loggedRepositories;
    private static final Set<String> noLogCommands;

    public static List<String> doMerge(VCSFileProxy repository, String revStr) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        ArrayList<String> env = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_MERGE_CMD);
        command.add("-f");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (HgModuleConfig.getDefault(repository).isInternalMergeToolEnabled()) {
            command.add(HG_CONFIG_OPTION_CMD);
            command.add(HG_MERGE_SIMPLE_TOOL);
        }
        if (revStr != null) {
            command.add(revStr);
        }
        env.add(HG_MERGE_ENV);
        List<String> list = HgCommand.execEnv(repository, command, env);
        return list;
    }

    public static List<String> doUpdateAll(VCSFileProxy repository, boolean bForce, String revision, boolean bThrowException) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_UPDATE_ALL_CMD);
        command.add(HG_VERBOSE_CMD);
        if (bForce) {
            command.add(HG_UPDATE_FORCE_ALL_CMD);
        }
        if (HgModuleConfig.getDefault(repository).isInternalMergeToolEnabled()) {
            command.add(HG_CONFIG_OPTION_CMD);
            command.add(HG_MERGE_SIMPLE_TOOL);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (revision != null) {
            command.add(revision);
        }
        List<String> list = HgCommand.exec(repository, command);
        if (bThrowException && !list.isEmpty()) {
            if (HgCommand.isErrorUpdateSpansBranches(list.get(0))) {
                HgCommand.handleError(command, list, Bundle.MSG_WARN_UPDATE_MERGE_TEXT(), OutputLogger.getLogger(repository));
            } else if (HgCommand.isMergeAbortUncommittedMsg(list.get(0))) {
                HgCommand.handleError(command, list, Bundle.MSG_WARN_UPDATE_COMMIT_TEXT(), OutputLogger.getLogger(repository));
            } else if (HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), OutputLogger.getLogger(repository));
            }
        }
        return list;
    }

    public static List<String> doUpdateAll(VCSFileProxy repository, boolean bForce, String revision) throws HgException {
        return HgCommand.doUpdateAll(repository, bForce, revision, true);
    }

    public static List<String> doRollback(VCSFileProxy repository, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_ROLLBACK_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        List<String> list = HgCommand.exec(repository, command);
        if (list.isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ROLLBACK_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doBackout(VCSFileProxy repository, String revision, boolean doMerge, String commitMsg, OutputLogger logger) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> env = new ArrayList<String>();
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_BACKOUT_CMD);
        if (doMerge) {
            command.add(HG_BACKOUT_MERGE_CMD);
            env.add(HG_MERGE_ENV);
        }
        if (commitMsg != null && !commitMsg.equals("")) {
            command.add(HG_BACKOUT_COMMIT_MSG_CMD);
            command.add(commitMsg);
        } else {
            command.add(HG_BACKOUT_COMMIT_MSG_CMD);
            command.add(NbBundle.getMessage(HgCommand.class, (String)"MSG_BACKOUT_MERGE_COMMIT_MSG", (Object)revision));
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (revision != null) {
            command.add(HG_REV_CMD);
            command.add(revision);
        }
        if ((list = doMerge ? HgCommand.execEnv(repository, command, env) : HgCommand.exec(repository, command)).isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_BACKOUT_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doStrip(VCSFileProxy repository, String revision, boolean doForceMultiHead, boolean doBackup, OutputLogger logger) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_STRIP_CMD);
        if (doForceMultiHead) {
            command.add("-f");
        }
        if (!doBackup) {
            command.add(HG_STRIP_NOBACKUP_CMD);
        }
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (revision != null) {
            command.add(revision);
        }
        if ((list = HgCommand.exec(repository, command)).isEmpty() && doBackup) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_STRIP_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doVerify(VCSFileProxy repository, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_VERIFY_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        List<String> list = HgCommand.exec(repository, command);
        if (list.isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_VERIFY_FAILED"), logger);
        }
        return list;
    }

    public static String getHgVersion(VCSFileProxy root) {
        List<String> list;
        try {
            list = HgCommand.execForVersionCheck(root);
        }
        catch (HgException ex) {
            return null;
        }
        if (!list.isEmpty()) {
            int start = list.get(0).indexOf(40);
            int end = list.get(0).indexOf(41);
            if (start != -1 && end != -1) {
                return list.get(0).substring(start + 9, end);
            }
        }
        return null;
    }

    public static List<String> doPull(VCSFileProxy repository, String revision, String branch, OutputLogger logger) throws HgException {
        List<String> list;
        String defaultPull;
        String proxy;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_PULL_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (HgModuleConfig.getDefault(repository).isInternalMergeToolEnabled()) {
            command.add(HG_CONFIG_OPTION_CMD);
            command.add(HG_MERGE_SIMPLE_TOOL);
        }
        if (revision != null) {
            command.add("--rev");
            command.add(revision);
        }
        if (branch != null) {
            command.add(HG_PARAM_BRANCH);
            command.add(branch);
        }
        if ((proxy = HgCommand.getGlobalProxyIfNeeded(defaultPull = new HgConfigFiles(repository).getDefaultPull(false), true, logger)) != null) {
            ArrayList<String> env = new ArrayList<String>();
            env.add(HG_PROXY_ENV + proxy);
            list = HgCommand.execEnv(repository, command, env);
        } else {
            list = HgCommand.exec(repository, command);
        }
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
        }
        return list;
    }

    public static List<String> doUnbundle(VCSFileProxy repository, VCSFileProxy bundle, boolean update, OutputLogger logger) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_VERBOSE_CMD);
        command.add(HG_UNBUNDLE_CMD);
        if (update) {
            command.add(HG_UPDATE_CMD);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (HgModuleConfig.getDefault(repository).isInternalMergeToolEnabled()) {
            command.add(HG_CONFIG_OPTION_CMD);
            command.add(HG_MERGE_SIMPLE_TOOL);
        }
        if (bundle != null) {
            command.add(bundle.getPath());
        }
        if (!(list = HgCommand.exec(repository, command)).isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
        }
        return list;
    }

    public static List<String> doIncoming(VCSFileProxy repository, String revision, String branch, OutputLogger logger) throws HgException {
        List<String> cmdOutput;
        String defaultPull;
        String proxy;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_INCOMING_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (revision != null) {
            command.add("--rev");
            command.add(revision);
        }
        if (branch != null) {
            command.add(HG_PARAM_BRANCH);
            command.add(branch);
        }
        if ((proxy = HgCommand.getGlobalProxyIfNeeded(defaultPull = new HgConfigFiles(repository).getDefaultPull(false), false, null)) != null) {
            ArrayList<String> env = new ArrayList<String>();
            env.add(HG_PROXY_ENV + proxy);
            cmdOutput = HgCommand.execEnv(repository, command, env);
        } else {
            cmdOutput = HgCommand.exec(repository, command);
        }
        if (!cmdOutput.isEmpty() && HgCommand.isErrorAbort(cmdOutput.get(cmdOutput.size() - 1))) {
            HgCommand.handleError(command, cmdOutput, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
        }
        return cmdOutput;
    }

    public static List<String> doIncoming(VCSFileProxy repository, HgURL from, String revision, String branch, VCSFileProxy bundle, OutputLogger logger, boolean showSaveCredentialsOption) throws HgException {
        if (repository == null || from == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPull(false);
        command.hgCommandType = HG_INCOMING_CMD;
        command.logger = logger;
        command.outputDetails = false;
        command.remoteUrl = from;
        command.repository = repository;
        if (revision != null) {
            command.additionalOptions.add("--rev");
            command.additionalOptions.add(revision);
        }
        if (branch != null) {
            command.additionalOptions.add(HG_PARAM_BRANCH);
            command.additionalOptions.add(branch);
        }
        command.additionalOptions.add(HG_VERBOSE_CMD);
        command.showSaveOption = showSaveCredentialsOption;
        if (bundle != null) {
            command.additionalOptions.add(HG_OPT_BUNDLE);
            command.additionalOptions.add(bundle.getPath());
        }
        command.urlPathProperties = new String[]{"default", "default-pull"};
        List<String> retval = command.invoke();
        return retval;
    }

    public static List<String> doOutgoing(VCSFileProxy repository, HgURL toUrl, String revision, String branch, OutputLogger logger, boolean showSaveCredentialsOption) throws HgException {
        if (repository == null || toUrl == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPush(false);
        command.hgCommandType = HG_OUTGOING_CMD;
        command.logger = logger;
        command.outputDetails = false;
        command.remoteUrl = toUrl;
        command.repository = repository;
        if (revision != null) {
            command.additionalOptions.add("--rev");
            command.additionalOptions.add(revision);
        }
        if (branch != null) {
            command.additionalOptions.add(HG_PARAM_BRANCH);
            command.additionalOptions.add(branch);
        }
        command.additionalOptions.add(HG_VERBOSE_CMD);
        VCSFileProxy tempFolder = null;
        try {
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.additionalOptions.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_BASIC_CHANGESET_NAME));
            command.showSaveOption = showSaveCredentialsOption;
            command.urlPathProperties = new String[]{"default-push"};
            List<String> list = command.invoke();
            return list;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    public static List<String> doPush(VCSFileProxy repository, HgURL toUrl, String revision, String branch, boolean allowNewBranch, OutputLogger logger, boolean showSaveCredentialsOption) throws HgException {
        if (repository == null || toUrl == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.acquireCredentialsFirst = true;
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPush(false);
        command.hgCommandType = HG_PUSH_CMD;
        command.logger = logger;
        command.remoteUrl = toUrl;
        command.repository = repository;
        if (revision != null) {
            command.additionalOptions.add("--rev");
            command.additionalOptions.add(revision);
        }
        if (branch != null) {
            command.additionalOptions.add(HG_PARAM_BRANCH);
            command.additionalOptions.add(branch);
            command.additionalOptions.add(HG_PARAM_PUSH_NEW_BRANCH);
        } else if (allowNewBranch) {
            command.additionalOptions.add(HG_PARAM_PUSH_NEW_BRANCH);
        }
        command.urlPathProperties = new String[]{"default-push"};
        List<String> retval = command.invoke();
        return retval;
    }

    @Override
    public abstract T call() throws HgException;

    public static <T> T runWithoutUI(Callable<T> callable) throws HgException {
        try {
            disabledUI.set(true);
            T t = callable.call();
            return t;
        }
        catch (HgException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            disabledUI.remove();
        }
    }

    private static String getGlobalProxyIfNeeded(String defaultPath, boolean bOutputDetails, OutputLogger logger) {
        String proxy = null;
        if (defaultPath != null && (defaultPath.startsWith("http:") || defaultPath.startsWith("https:"))) {
            URI uri = null;
            try {
                uri = new URI(defaultPath);
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
            String proxyHost = NetworkSettings.getProxyHost((URI)uri);
            if (proxyHost != null && proxyHost.length() > 0) {
                proxy = proxyHost;
                String proxyPort = NetworkSettings.getProxyPort((URI)uri);
                assert (proxyPort != null);
                proxy = proxy + (!proxyPort.equals("") ? ":" + proxyPort : "");
            }
        }
        if (proxy != null && bOutputDetails) {
            logger.output(NbBundle.getMessage(HgCommand.class, (String)"MSG_USING_PROXY_INFO", proxy));
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> doFetch(VCSFileProxy repository, HgURL from, String revision, boolean enableFetchExtension, OutputLogger logger) throws HgException {
        if (repository == null || from == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPull(false);
        command.hgCommandType = HG_FETCH_CMD;
        command.logger = logger;
        command.outputDetails = false;
        command.remoteUrl = from;
        command.repository = repository;
        if (revision != null) {
            command.additionalOptions.add("--rev");
            command.additionalOptions.add(revision);
        }
        command.additionalOptions.add(HG_VERBOSE_CMD);
        if (enableFetchExtension && !"false".equals(System.getProperty("versioning.mercurial.enableFetchExtension"))) {
            command.additionalOptions.add(HG_CONFIG_OPTION_CMD);
            command.additionalOptions.add(HG_FETCH_EXT_CMD);
        }
        if (HgModuleConfig.getDefault(repository).isInternalMergeToolEnabled()) {
            command.additionalOptions.add(HG_CONFIG_OPTION_CMD);
            command.additionalOptions.add(HG_MERGE_SIMPLE_TOOL);
        }
        command.showSaveOption = true;
        command.urlPathProperties = new String[]{"default", "default-pull"};
        try {
            if ("false".equals(System.getProperty("versioning.mercurial.enableFetchExtension"))) {
                doNotAddHgPlain.set(true);
            }
            List<String> list = command.invoke();
            return list;
        }
        finally {
            doNotAddHgPlain.remove();
        }
    }

    public static List<HgLogMessage> processLogMessages(VCSFileProxy root, List<VCSFileProxy> files, List<String> list) {
        return HgCommand.processLogMessages(root, files, list, false);
    }

    public static List<HgLogMessage> processLogMessages(VCSFileProxy root, List<VCSFileProxy> files, List<String> list, boolean revertOrder) {
        ArrayList<HgLogMessage> messages = new ArrayList<HgLogMessage>();
        ArrayList<String> filesShortPaths = new ArrayList<String>();
        String rootPath = root.getPath();
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if (list != null && !list.isEmpty()) {
            if (files != null) {
                for (VCSFileProxy f : files) {
                    String shortPath;
                    if (!f.isFile() || !(shortPath = f.getPath()).startsWith(rootPath) || shortPath.length() <= rootPath.length()) continue;
                    filesShortPaths.add(shortPath.substring(rootPath.length()));
                }
            }
            String fc = null;
            String fd = null;
            String fa = null;
            String fm = null;
            String parents = null;
            String id = null;
            String date = null;
            String desc = null;
            String username = null;
            String author = null;
            String rev = null;
            String tags = "";
            String branches = "";
            boolean bEnd = false;
            boolean stillInMessage = false;
            for (String s : list) {
                if (s.indexOf(HG_LOG_REVISION_OUT) == 0) {
                    rev = s.substring(HG_LOG_REVISION_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_AUTHOR_OUT) == 0) {
                    author = s.substring(HG_LOG_AUTHOR_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_USER_OUT) == 0) {
                    username = s.substring(HG_LOG_USER_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_DESCRIPTION_OUT) == 0) {
                    desc = s.substring(HG_LOG_DESCRIPTION_OUT.length()).trim();
                    stillInMessage = true;
                } else if (s.indexOf(HG_LOG_DATE_OUT) == 0) {
                    date = s.substring(HG_LOG_DATE_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_ID_OUT) == 0) {
                    id = s.substring(HG_LOG_ID_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_PARENTS_OUT) == 0) {
                    parents = s.substring(HG_LOG_PARENTS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_FILEMODS_OUT) == 0) {
                    fm = s.substring(HG_LOG_FILEMODS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_FILEADDS_OUT) == 0) {
                    fa = s.substring(HG_LOG_FILEADDS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_FILEDELS_OUT) == 0) {
                    fd = s.substring(HG_LOG_FILEDELS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_FILECOPIESS_OUT) == 0) {
                    fc = s.substring(HG_LOG_FILECOPIESS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_BRANCHES_OUT) == 0) {
                    branches = s.substring(HG_LOG_BRANCHES_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_TAGS_OUT) == 0) {
                    tags = s.substring(HG_LOG_TAGS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_ENDCS_OUT) == 0) {
                    stillInMessage = false;
                    bEnd = true;
                } else if (stillInMessage) {
                    desc = desc + "\n" + s;
                }
                if (!(rev != null & bEnd)) continue;
                HgLogMessage hgMsg = new HgLogMessage(rootPath, filesShortPaths, rev, author, username, desc, date, id, parents, fm, fa, fd, fc, branches, tags);
                messages.add(hgMsg);
                fc = null;
                fd = null;
                fa = null;
                fm = null;
                parents = null;
                id = null;
                date = null;
                desc = null;
                author = null;
                rev = null;
                bEnd = false;
            }
        }
        if (revertOrder) {
            Collections.reverse(messages);
        }
        return messages;
    }

    private static HgBranch[] processBranches(List<String> lines, List<HgLogMessage> heads) {
        ArrayList<HgBranch> branches = new ArrayList<HgBranch>();
        Pattern p = Pattern.compile("^(.+)(\\b\\d+):(\\S+)(.*)$");
        for (String line : lines) {
            Matcher m = p.matcher(line);
            if (!m.matches()) {
                Mercurial.LOG.log(Level.WARNING, "HgCommand.processBranches(): Failed when matching: {0}", new Object[]{line});
                continue;
            }
            String branchName = m.group(1).trim();
            String revNumber = m.group(2).trim();
            String changeSetId = m.group(3).trim();
            String status = m.group(4).trim().toLowerCase(Locale.getDefault());
            HgLogMessage info = null;
            for (HgLogMessage head : heads) {
                if (!head.getRevisionNumber().equals(revNumber) && !head.getCSetShortID().equals(changeSetId)) continue;
                info = head;
            }
            if (info == null) {
                Mercurial.LOG.log(Level.WARNING, "HgCommand.processBranches(): Failed when pairing branch with head info : {0}:{1}:{2}\n{3}", new Object[]{branchName, revNumber, changeSetId, heads});
                continue;
            }
            boolean closed = false;
            boolean active = true;
            if (status.contains("inactive")) {
                active = false;
            } else if (status.contains("closed")) {
                closed = true;
            }
            branches.add(new HgBranch(branchName, info, closed, active));
        }
        return branches.toArray(new HgBranch[branches.size()]);
    }

    private static HgTag[] processTags(List<String> lines, VCSFileProxy repository, OutputLogger logger) throws HgException {
        ArrayList<HgTag> tags = new ArrayList<HgTag>();
        Pattern p = Pattern.compile("^(.+)(\\b\\d+):(\\S+)(.*)$");
        class TagInfo {
            String name;
            String revNumber;
            String changeSetId;
            boolean local;

            TagInfo(String tagName, String revNumber, String changeSetId, boolean local) {
                this.name = tagName;
                this.revNumber = revNumber;
                this.changeSetId = changeSetId;
                this.local = local;
            }
        }
        ArrayList<TagInfo> tagInfos = new ArrayList<TagInfo>(lines.size());
        ArrayList<String> revisions = new ArrayList<String>(lines.size());
        for (String line : lines) {
            Matcher m = p.matcher(line);
            if (!m.matches()) {
                Mercurial.LOG.log(Level.WARNING, "HgCommand.processTags(): Failed when matching: {0}", new Object[]{line});
                continue;
            }
            String tagName = m.group(1).trim();
            String revNumber = m.group(2).trim();
            String changeSetId = m.group(3).trim();
            String status = m.group(4).trim().toLowerCase(Locale.getDefault());
            boolean local = false;
            if (status.contains("local")) {
                local = true;
            }
            tagInfos.add(new TagInfo(tagName, revNumber, changeSetId, local));
            revisions.add(revNumber);
        }
        List<String> list = HgCommand.doLog(repository, revisions, -1, logger);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        List<HgLogMessage> messages = HgCommand.processLogMessages(repository, null, list, false);
        for (TagInfo t : tagInfos) {
            HgLogMessage info = null;
            for (HgLogMessage head : messages) {
                if (!head.getRevisionNumber().equals(t.revNumber) && !head.getCSetShortID().equals(t.changeSetId)) continue;
                info = head;
            }
            if (info == null) {
                Mercurial.LOG.log(Level.WARNING, "HgCommand.processTags(): Failed when pairing tag with commit info : {0}:{1}:{2}\n{3}", new Object[]{t.name, t.revNumber, t.changeSetId, messages});
                continue;
            }
            tags.add(new HgTag(t.name, info, t.local, !"tip".equals(t.name)));
        }
        return tags.toArray(new HgTag[tags.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getIncomingMessages(VCSFileProxy root, String toRevision, String branchName, boolean bShowMerges, boolean bGetFileInfo, boolean getParents, int limitRevisions, OutputLogger logger) throws HgException {
        List<Object> messages = Collections.emptyList();
        try {
            List<String> list = HgCommand.doIncomingForSearch(root, toRevision, branchName, bShowMerges, bGetFileInfo, getParents, limitRevisions, logger);
            messages = HgCommand.processLogMessages(root, null, list, true);
        }
        finally {
            logger.closeLog();
        }
        return messages.toArray(new HgLogMessage[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getOutMessages(VCSFileProxy root, String toRevision, String branchName, boolean bShowMerges, boolean getParents, int limitRevisions, OutputLogger logger) throws HgException {
        List<Object> messages = Collections.emptyList();
        try {
            List<String> list = HgCommand.doOutForSearch(root, toRevision, branchName, bShowMerges, getParents, limitRevisions, logger);
            messages = HgCommand.processLogMessages(root, null, list, true);
        }
        finally {
            logger.closeLog();
        }
        return messages.toArray(new HgLogMessage[0]);
    }

    public static HgLogMessage[] getLogMessagesNoFileInfo(VCSFileProxy root, Set<VCSFileProxy> files, String fromRevision, String toRevision, boolean bShowMerges, int limitRevisions, List<String> branchNames, OutputLogger logger) {
        return HgCommand.getLogMessages(root, files, fromRevision, toRevision, bShowMerges, false, true, limitRevisions, branchNames, logger, true);
    }

    public static HgLogMessage[] getLogMessagesNoFileInfo(VCSFileProxy root, Set<VCSFileProxy> files, int limit, OutputLogger logger) {
        return HgCommand.getLogMessages(root, files, "0", "tip", true, false, true, limit, Collections.emptyList(), logger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getLogMessages(VCSFileProxy root, Set<VCSFileProxy> files, String fromRevision, String toRevision, boolean bShowMerges, boolean bGetFileInfo, boolean getParents, int limit, List<String> branchNames, OutputLogger logger, boolean ascOrder) {
        List<HgLogMessage> messages = Collections.emptyList();
        try {
            String headRev = HgCommand.getLastRevision(root, null);
            if (headRev == null) {
                HgLogMessage[] hgLogMessageArray = messages.toArray(new HgLogMessage[0]);
                return hgLogMessageArray;
            }
            ArrayList<VCSFileProxy> filesList = files != null ? new ArrayList<VCSFileProxy>(files) : null;
            List<String> list = HgCommand.doLog(root, filesList, fromRevision, toRevision, headRev, bShowMerges, bGetFileInfo, getParents, limit, branchNames, logger);
            messages = HgCommand.processLogMessages(root, filesList, list, ascOrder);
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            if (logger != null) {
                logger.closeLog();
            }
        }
        return messages.toArray(new HgLogMessage[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getRevisionInfo(VCSFileProxy root, List<String> revisions, OutputLogger logger) {
        List<HgLogMessage> messages = Collections.emptyList();
        try {
            List<String> list = HgCommand.doLog(root, revisions, -1, logger);
            messages = HgCommand.processLogMessages(root, null, list, false);
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            if (logger != null) {
                logger.closeLog();
            }
        }
        return messages.toArray(new HgLogMessage[0]);
    }

    public static Boolean hasHistory(VCSFileProxy repository) {
        if (repository == null) {
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_LOG_LIMIT_ONE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        try {
            List<String> list = HgCommand.exec(repository, command);
            if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
                return false;
            }
            return !list.isEmpty();
        }
        catch (HgException e) {
            return false;
        }
    }

    private static VCSFileProxy getPreviousName(VCSFileProxy repository, VCSFileProxy file, String revision, boolean tryHard) throws HgException {
        if (repository == null) {
            return null;
        }
        if (revision == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_OPT_FOLLOW);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add("--rev");
        command.add(revision);
        List<String> list = null;
        VCSFileProxy tempFolder = null;
        try {
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_ONLY_FILE_COPIES_CHANGESET_NAME));
            command.add(file.getPath());
            list = HgCommand.exec(repository, command);
            if (list.isEmpty() || HgCommand.isErrorAbort(list.get(0))) {
                VCSFileProxy vCSFileProxy = null;
                return vCSFileProxy;
            }
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        catch (HgException e) {
            Mercurial.LOG.log(Level.WARNING, "command: {0}", HgUtils.replaceHttpPassword(command));
            Mercurial.LOG.log(e instanceof HgException.HgCommandCanceledException ? Level.FINE : Level.INFO, null, e);
            throw e;
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
        if (!tryHard) {
            String[] fileNames = list.get(0).split("\t");
            for (int j = 0; j < fileNames.length / 2; ++j) {
                VCSFileProxy name = VCSFileProxy.createFileProxy((VCSFileProxy)repository, (String)fileNames[2 * j]);
                if (!name.equals((Object)file)) continue;
                return VCSFileProxy.createFileProxy((VCSFileProxy)repository, (String)fileNames[2 * j + 1]);
            }
        }
        return null;
    }

    private static List<String> doLog(VCSFileProxy repository, List<VCSFileProxy> files, String from, String to, String headRev, boolean bShowMerges, boolean bGetFileInfo, boolean getAllParents, int limit, List<String> branchNames, OutputLogger logger) throws HgException {
        ArrayList<String> dateConstraints = new ArrayList<String>();
        String dateStr = HgCommand.handleRevDates(from, to);
        if (dateStr != null) {
            dateConstraints.add(HG_FLAG_DATE_CMD);
            dateConstraints.add(dateStr);
        }
        List<String> list = null;
        for (String lastRev : new String[]{null, headRev}) {
            String revStr = HgCommand.handleRevNumbers(from, to, lastRev);
            if (revStr == null) {
                return Collections.emptyList();
            }
            ArrayList<String> constraints = new ArrayList<String>(dateConstraints);
            if (dateStr == null) {
                constraints.add("--rev");
                constraints.add(revStr);
            }
            if ((list = HgCommand.doLog(repository, files, constraints, bShowMerges, bGetFileInfo, getAllParents, limit, branchNames, logger)).size() <= 0 || lastRev != null || !HgCommand.isNoRevStrip(list.get(0))) break;
        }
        return list;
    }

    private static List<String> doLog(VCSFileProxy repository, List<String> revisions, int limit, OutputLogger logger) throws HgException {
        ArrayList<String> constraints = new ArrayList<String>(revisions.size() * 2);
        for (String rev : revisions) {
            constraints.add("--rev");
            constraints.add(rev);
        }
        return HgCommand.doLog(repository, null, constraints, true, false, false, limit, Collections.emptyList(), logger);
    }

    private static List<String> doLog(VCSFileProxy repository, List<VCSFileProxy> files, List<String> revisionConstraints, boolean bShowMerges, boolean bGetFileInfo, boolean getParents, int limit, List<String> branchNames, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        if (files != null && files.isEmpty()) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_VERBOSE_CMD);
        if (limit > 0) {
            command.add(HG_LOG_LIMIT_CMD);
            command.add(Integer.toString(limit));
        }
        boolean doFollow = false;
        if (files != null) {
            doFollow = true;
            for (VCSFileProxy f : files) {
                if (!f.isDirectory()) continue;
                doFollow = false;
                break;
            }
        }
        if (doFollow) {
            command.add(HG_OPT_FOLLOW);
        }
        if (!bShowMerges) {
            command.add(HG_LOG_NO_MERGES_CMD);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (getParents) {
            command.add(HG_LOG_DEBUG_CMD);
        }
        for (String rc : revisionConstraints) {
            command.add(rc);
        }
        for (String branch : branchNames) {
            command.add(HG_PARAM_BRANCH);
            command.add(branch);
        }
        VCSFileProxy tempFolder = null;
        try {
            List<String> list;
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.add(HgCommand.prepareLogTemplate(tempFolder, bGetFileInfo ? HG_LOG_FULL_CHANGESET_NAME : HG_LOG_BASIC_CHANGESET_NAME));
            if (files != null) {
                for (VCSFileProxy f : files) {
                    command.add(f.getPath());
                }
            }
            if (!(list = HgCommand.exec(repository, command)).isEmpty()) {
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                } else if (!HgCommand.isFollowNotAllowed(list.get(0)) && HgCommand.isErrorAbort(list.get(0)) && !HgCommand.isNoRevStrip(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                }
            }
            List<String> list2 = list;
            return list2;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    public static HgLogMessage doTip(VCSFileProxy repository, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add("tip");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        VCSFileProxy tempFolder = null;
        try {
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_BASIC_CHANGESET_NAME));
            List<String> list = HgCommand.exec(repository, command);
            if (!list.isEmpty()) {
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                } else if (HgCommand.isErrorAbort(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                }
            }
            List<HgLogMessage> messages = HgCommand.processLogMessages(repository, null, list, false);
            HgLogMessage hgLogMessage = messages.get(0);
            return hgLogMessage;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    public static List<String> doOutForSearch(VCSFileProxy repository, String to, String branchName, boolean bShowMerges, boolean getParents, int limit, OutputLogger logger) throws HgException {
        String revStr;
        if (repository == null) {
            return null;
        }
        String defaultPush = new HgConfigFiles(repository).getDefaultPush(false);
        if (HgUtils.isNullOrEmpty(defaultPush)) {
            Mercurial.LOG.log(Level.FINE, "No push url, falling back to command without target");
        } else {
            try {
                HgURL pushUrl = new HgURL(defaultPush);
                return HgCommand.doOutForSearch(repository, pushUrl, to, branchName, bShowMerges, getParents, limit, logger);
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.INFO, "Invalid push url: {0}, falling back to command without target", defaultPush);
            }
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_OUT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_NEWEST_FIRST);
        if (!bShowMerges) {
            command.add(HG_LOG_NO_MERGES_CMD);
        }
        if (getParents) {
            command.add(HG_LOG_DEBUG_CMD);
        }
        if ((revStr = HgCommand.handleIncomingRev(to)) != null) {
            command.add("--rev");
            command.add(revStr);
        }
        if (branchName != null) {
            command.add(HG_PARAM_BRANCH);
            command.add(branchName);
        }
        if (limit > 0) {
            command.add(HG_LOG_LIMIT_CMD);
            command.add(Integer.toString(limit));
        }
        VCSFileProxy tempFolder = null;
        try {
            List<String> list;
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_BASIC_CHANGESET_NAME));
            String proxy = HgCommand.getGlobalProxyIfNeeded(defaultPush, false, null);
            if (proxy != null) {
                ArrayList<String> env = new ArrayList<String>();
                env.add(HG_PROXY_ENV + proxy);
                list = HgCommand.execEnv(repository, command, env);
            } else {
                list = HgCommand.exec(repository, command);
            }
            if (!list.isEmpty() && !HgCommand.isErrorNoDefaultPush(list.get(0))) {
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                } else if (HgCommand.isErrorAbort(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                }
            }
            List<String> list2 = list;
            return list2;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    private static List<String> doOutForSearch(VCSFileProxy repository, HgURL repositoryUrl, String to, String branchName, boolean bShowMerges, boolean getParents, int limit, OutputLogger logger) throws HgException {
        String revStr;
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPush(false);
        command.hgCommandType = HG_OUTGOING_CMD;
        command.logger = logger;
        command.outputDetails = false;
        command.remoteUrl = repositoryUrl;
        command.repository = repository;
        command.additionalOptions.add(HG_OPT_REPOSITORY);
        command.additionalOptions.add(repository.getPath());
        command.additionalOptions.add(HG_NEWEST_FIRST);
        if (!bShowMerges) {
            command.additionalOptions.add(HG_LOG_NO_MERGES_CMD);
        }
        if (getParents) {
            command.additionalOptions.add(HG_LOG_DEBUG_CMD);
        }
        if ((revStr = HgCommand.handleIncomingRev(to)) != null) {
            command.additionalOptions.add("--rev");
            command.additionalOptions.add(revStr);
        }
        if (branchName != null) {
            command.additionalOptions.add(HG_PARAM_BRANCH);
            command.additionalOptions.add(branchName);
        }
        if (limit > 0) {
            command.additionalOptions.add(HG_LOG_LIMIT_CMD);
            command.additionalOptions.add(Integer.toString(limit));
        }
        VCSFileProxy tempFolder = null;
        try {
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.additionalOptions.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_BASIC_CHANGESET_NAME));
            command.showSaveOption = true;
            command.urlPathProperties = new String[]{"default-push"};
            List<String> list = command.invoke();
            return list;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    public static List<String> doIncomingForSearch(VCSFileProxy repository, String to, String branchName, boolean bShowMerges, boolean bGetFileInfo, boolean getParents, int limit, OutputLogger logger) throws HgException {
        String revStr;
        if (repository == null) {
            return null;
        }
        String defaultPull = new HgConfigFiles(repository).getDefaultPull(false);
        if (HgUtils.isNullOrEmpty(defaultPull)) {
            Mercurial.LOG.log(Level.FINE, "No pull url, falling back to command without target");
        } else {
            try {
                HgURL pullUrl = new HgURL(defaultPull);
                return HgCommand.doIncomingForSearch(repository, pullUrl, to, branchName, bShowMerges, bGetFileInfo, getParents, limit, logger);
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.INFO, "Invalid pull url: {0}, falling back to command without target", defaultPull);
            }
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_INCOMING_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_NEWEST_FIRST);
        if (!bShowMerges) {
            command.add(HG_LOG_NO_MERGES_CMD);
        }
        if (getParents) {
            command.add(HG_LOG_DEBUG_CMD);
        }
        if ((revStr = HgCommand.handleIncomingRev(to)) != null) {
            command.add("--rev");
            command.add(revStr);
        }
        if (branchName != null) {
            command.add(HG_PARAM_BRANCH);
            command.add(branchName);
        }
        if (limit > 0) {
            command.add(HG_LOG_LIMIT_CMD);
            command.add(Integer.toString(limit));
        }
        VCSFileProxy tempFolder = null;
        try {
            List<String> list;
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.add(HgCommand.prepareLogTemplate(tempFolder, bGetFileInfo ? HG_LOG_FULL_CHANGESET_NAME : HG_LOG_BASIC_CHANGESET_NAME));
            String proxy = HgCommand.getGlobalProxyIfNeeded(defaultPull, false, null);
            if (proxy != null) {
                ArrayList<String> env = new ArrayList<String>();
                env.add(HG_PROXY_ENV + proxy);
                list = HgCommand.execEnv(repository, command, env);
            } else {
                list = HgCommand.exec(repository, command);
            }
            if (!list.isEmpty() && !HgCommand.isErrorNoDefaultPath(list.get(0))) {
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                } else if (HgCommand.isErrorAbort(list.get(0)) || HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                }
            }
            List<String> list2 = list;
            return list2;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    public static List<HgLogMessage> getBundleChangesets(VCSFileProxy repository, VCSFileProxy bundleFile, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_INCOMING_CMD);
        command.add(bundleFile.getPath());
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        VCSFileProxy tempFolder = null;
        try {
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_BASIC_CHANGESET_NAME));
            List<String> list = HgCommand.exec(repository, command);
            if (!list.isEmpty()) {
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                } else if (HgCommand.isErrorAbort(list.get(0)) || HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                }
            }
            List<HgLogMessage> list2 = HgCommand.processLogMessages(repository, null, list);
            return list2;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    private static List<String> doIncomingForSearch(VCSFileProxy repository, HgURL repositoryUrl, String to, String branchName, boolean bShowMerges, boolean bGetFileInfo, boolean getParents, int limit, OutputLogger logger) throws HgException {
        String revStr;
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPull(false);
        command.hgCommandType = HG_INCOMING_CMD;
        command.logger = logger;
        command.outputDetails = false;
        command.remoteUrl = repositoryUrl;
        command.repository = repository;
        command.additionalOptions.add(HG_VERBOSE_CMD);
        command.additionalOptions.add(HG_OPT_REPOSITORY);
        command.additionalOptions.add(repository.getPath());
        command.additionalOptions.add(HG_NEWEST_FIRST);
        if (!bShowMerges) {
            command.additionalOptions.add(HG_LOG_NO_MERGES_CMD);
        }
        if (getParents) {
            command.additionalOptions.add(HG_LOG_DEBUG_CMD);
        }
        if ((revStr = HgCommand.handleIncomingRev(to)) != null) {
            command.additionalOptions.add("--rev");
            command.additionalOptions.add(revStr);
        }
        if (branchName != null) {
            command.additionalOptions.add(HG_PARAM_BRANCH);
            command.additionalOptions.add(branchName);
        }
        if (limit > 0) {
            command.additionalOptions.add(HG_LOG_LIMIT_CMD);
            command.additionalOptions.add(Integer.toString(limit));
        }
        command.showSaveOption = true;
        command.urlPathProperties = new String[]{"default", "default-pull"};
        VCSFileProxy tempFolder = null;
        try {
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.additionalOptions.add(HgCommand.prepareLogTemplate(tempFolder, bGetFileInfo ? HG_LOG_FULL_CHANGESET_NAME : HG_LOG_BASIC_CHANGESET_NAME));
            List<String> list = command.invoke();
            return list;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    private static String handleRevDates(String from, String to) {
        Date fromDate = null;
        Date toDate = null;
        Date currentDate = new Date();
        Date epochPlusOneDate = null;
        try {
            epochPlusOneDate = new SimpleDateFormat("yyyy-MM-dd").parse(HG_EPOCH_PLUS_ONE_YEAR);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            if (from != null) {
                fromDate = new SimpleDateFormat("yyyy-MM-dd").parse(from);
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            if (to != null) {
                toDate = new SimpleDateFormat("yyyy-MM-dd").parse(to);
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if (fromDate != null && toDate == null && to == null) {
            toDate = currentDate;
            to = new SimpleDateFormat("yyyy-MM-dd").format(toDate);
        }
        if (fromDate == null && from == null && toDate != null) {
            fromDate = epochPlusOneDate;
            from = HG_EPOCH_PLUS_ONE_YEAR;
        }
        if (fromDate != null && toDate == null && to != null || fromDate == null && from != null && toDate != null) {
            HgUtils.warningDialog(HgCommand.class, "MSG_SEARCH_HISTORY_TITLE", "MSG_SEARCH_HISTORY_WARN_BOTHDATES_NEEDED_TEXT");
            return null;
        }
        if (fromDate != null && toDate != null) {
            if (epochPlusOneDate != null && fromDate.before(epochPlusOneDate)) {
                fromDate = epochPlusOneDate;
                from = HG_EPOCH_PLUS_ONE_YEAR;
            }
            if (currentDate != null && toDate.after(currentDate)) {
                toDate = currentDate;
                to = new SimpleDateFormat("yyyy-MM-dd").format(toDate);
            }
            if (fromDate.after(toDate)) {
                HgUtils.warningDialog(HgCommand.class, "MSG_SEARCH_HISTORY_TITLE", "MSG_SEARCH_HISTORY_WARN_FROM_BEFORE_TODATE_NEEDED_TEXT");
                return null;
            }
            return from + " to " + to;
        }
        return null;
    }

    private static String handleIncomingRev(String to) {
        if (to != null && (to.equalsIgnoreCase("tip") || to.equalsIgnoreCase(HG_HEAD_STR))) {
            to = "tip";
        }
        return to;
    }

    private static String handleRevNumbers(String from, String to, String headRev) {
        int fromInt = -1;
        int toInt = -1;
        int headRevInt = -1;
        if (headRev != null && from != null && (from.equalsIgnoreCase("tip") || from.equalsIgnoreCase(HG_HEAD_STR))) {
            from = headRev;
        }
        if (headRev != null && to != null && (to.equalsIgnoreCase("tip") || to.equalsIgnoreCase(HG_HEAD_STR))) {
            to = headRev;
        }
        try {
            fromInt = Integer.parseInt(from);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            toInt = Integer.parseInt(to);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            if (headRev != null) {
                headRevInt = Integer.parseInt(headRev);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (headRevInt > -1 && toInt > headRevInt) {
            to = headRev;
            toInt = headRevInt;
        }
        if (headRevInt > -1 && fromInt > headRevInt) {
            return null;
        }
        String revStr = null;
        if (fromInt > -1 && toInt > -1) {
            revStr = to + ":" + from;
        } else if (fromInt > -1) {
            revStr = (headRevInt != -1 ? headRevInt + ":" : "tip:") + from;
        } else if (toInt > -1) {
            revStr = to + ":0";
        }
        if (revStr == null) {
            if (to == null) {
                to = "tip";
            }
            if (from == null) {
                from = "0";
            }
            revStr = to + ":" + from;
        }
        return revStr;
    }

    public static void doCat(VCSFileProxy repository, VCSFileProxy file, VCSFileProxy outFile, OutputLogger logger) throws HgException {
        HgCommand.doCat(repository, file, outFile, null, true, logger);
    }

    public static void doCat(VCSFileProxy repository, VCSFileProxy file, VCSFileProxy outFile, String revision, OutputLogger logger) throws HgException {
        HgCommand.doCat(repository, file, outFile, revision, logger, true);
    }

    public static void doCat(VCSFileProxy repository, VCSFileProxy file, VCSFileProxy outFile, String revision, OutputLogger logger, boolean tryHard) throws HgException {
        HgCommand.doCat(repository, file, outFile, revision, true, logger);
    }

    public static void doCat(VCSFileProxy repository, VCSFileProxy file, VCSFileProxy outFile, String revision, boolean retry, OutputLogger logger) throws HgException {
        HgCommand.doCat(repository, file, outFile, revision, retry, logger, true);
    }

    public static void doCat(VCSFileProxy repository, VCSFileProxy file, VCSFileProxy outFile, String revision, boolean retry, OutputLogger logger, boolean tryHard) throws HgException {
        if (repository == null) {
            return;
        }
        if (file == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_CAT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_FLAG_OUTPUT_CMD);
        command.add(outFile.getPath());
        if (revision != null) {
            command.add("--rev");
            command.add(revision);
        }
        try {
            command.add(VCSFileProxySupport.getCanonicalPath((VCSFileProxy)file));
        }
        catch (IOException e) {
            Mercurial.LOG.log(Level.WARNING, "command: {0}", HgUtils.replaceHttpPassword(command));
            Mercurial.LOG.log(Level.INFO, null, e);
            throw new HgException(e.getMessage());
        }
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        if (VCSFileProxySupport.length((VCSFileProxy)outFile) == 0L && retry) {
            if (revision == null) {
                FileInformation fi = HgCommand.getStatus(repository, Collections.singletonList(file), null, null, true).get(file);
                if (fi != null && fi.getStatus(null) != null && fi.getStatus(null).getOriginalFile() != null) {
                    HgCommand.doCat(repository, fi.getStatus(null).getOriginalFile(), outFile, revision, false, logger);
                }
            } else {
                try {
                    String newRevision = Integer.toString(Integer.parseInt(revision) + 1);
                    VCSFileProxy prevFile = HgCommand.getPreviousName(repository, file, newRevision, tryHard);
                    if (prevFile != null) {
                        HgCommand.doCat(repository, prevFile, outFile, revision, false, logger);
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
    }

    public static HgLogMessage.HgRevision getCommonAncestor(VCSFileProxy repository, String rootURL, String rev1, String rev2, OutputLogger logger) throws HgException {
        HgLogMessage.HgRevision res = HgCommand.getCommonAncestor(repository, rootURL, rev1, rev2, false, logger);
        if (res == null) {
            res = HgCommand.getCommonAncestor(repository, rootURL, rev1, rev2, true, logger);
        }
        return res;
    }

    private static HgLogMessage.HgRevision getCommonAncestor(VCSFileProxy repository, String rootURL, String rev1, String rev2, boolean bUseIndex, OutputLogger logger) throws HgException {
        if (rootURL == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_COMMONANCESTOR_CMD);
        if (bUseIndex) {
            command.add(".hg/store/00changelog.i");
        }
        command.add(rev1);
        command.add(rev2);
        command.add(HG_OPT_REPOSITORY);
        command.add(rootURL);
        command.add(HG_OPT_CWD_CMD);
        command.add(rootURL);
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty()) {
            String[] splits = list.get(0).split(":");
            String tmp = splits != null && splits.length >= 1 ? splits[0] : null;
            String tmpId = splits != null && splits.length >= 2 ? splits[1] : null;
            int tmpRev = -1;
            try {
                tmpRev = Integer.parseInt(tmp);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            return tmpRev > -1 ? new HgLogMessage.HgRevision(tmpId, tmp) : null;
        }
        return null;
    }

    public static void doCreate(VCSFileProxy root, OutputLogger logger) throws HgException {
        if (root == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_CREATE_CMD);
        command.add(root.getPath());
        List<String> list = HgCommand.exec(root, command);
        if (!list.isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_CREATE_FAILED"), logger);
        }
    }

    public static List<String> doClone(VCSFileProxy repository, VCSFileProxy target, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        return HgCommand.doClone(new HgURL(repository), target, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> doClone(HgURL repository, VCSFileProxy target, OutputLogger logger) throws HgException {
        if (repository == null || target == null) {
            return null;
        }
        VCSFileProxy parentTarget = target.getParentFile();
        try {
            if (!VCSFileProxySupport.mkdirs((VCSFileProxy)parentTarget) && !parentTarget.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : {0}", parentTarget.getPath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException e) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : {0} threw SecurityException {1}", new Object[]{parentTarget.getPath(), e.getMessage()});
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        List<String> list = null;
        boolean retry = true;
        PasswordAuthentication credentials = null;
        String rawUrl = repository.toUrlStringWithoutUserInfo();
        HgURL url = repository;
        while (retry) {
            retry = false;
            ArrayList<Object> command = new ArrayList<Object>();
            command.add(HgCommand.getHgCommand());
            command.add(HG_CLONE_CMD);
            command.add(HG_VERBOSE_CMD);
            command.add(url);
            command.add(target);
            String proxy = HgCommand.getGlobalProxyIfNeeded(url.toUrlStringWithoutUserInfo(), true, logger);
            if (proxy != null) {
                ArrayList<String> env = new ArrayList<String>();
                env.add(HG_PROXY_ENV + proxy);
                list = HgCommand.execEnv(target, command, env);
            } else {
                list = HgCommand.exec(target, command);
            }
            try {
                if (list.isEmpty()) continue;
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                    continue;
                }
                if (HgCommand.isErrorNoResponse(list.get(list.size() - 1))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_RESPONSE_ERR"), logger);
                    continue;
                }
                if (HgCommand.isErrorAbort(list.get(0)) || HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                    if ((credentials = HgCommand.handleAuthenticationError(list, target, rawUrl, credentials == null ? "" : credentials.getUserName(), new UserCredentialsSupport(), HG_CLONE_CMD)) != null) {
                        retry = true;
                        continue;
                    }
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                    continue;
                }
                if (url.getPassword() == null) continue;
                try {
                    HgModuleConfig.getDefault(target).setProperty(target, "default-pull", new HgURL(url.toUrlStringWithoutUserInfo(), url.getUsername(), null).toCompleteUrlString());
                }
                catch (URISyntaxException ex) {
                    Mercurial.LOG.log(Level.INFO, null, ex);
                }
                catch (IOException ex) {
                    Mercurial.LOG.log(Level.INFO, null, ex);
                }
                KeyringSupport.save((String)"versioning.mercurial.url.", (String)url.toHgCommandStringWithNoPassword(), (char[])((char[])url.getPassword().clone()), null);
            }
            finally {
                if (url == repository) continue;
                url.clearPassword();
            }
        }
        return list;
    }

    public static void doCommit(VCSFileProxy repository, List<VCSFileProxy> commitFiles, String commitMessage, OutputLogger logger) throws HgException {
        HgCommand.doCommit(repository, commitFiles, commitMessage, null, false, logger);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doCommit(VCSFileProxy repository, List<VCSFileProxy> commitFiles, String commitMessage, String user, boolean closeBranch, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_COMMIT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        if (user == null) {
            String projectUserName = new HgConfigFiles(repository).getUserName(false);
            String globalUsername = HgModuleConfig.getDefault(repository).getSysUserName();
            if (projectUserName != null && projectUserName.length() > 0) {
                user = projectUserName;
            } else if (globalUsername != null && globalUsername.length() > 0) {
                user = globalUsername;
            }
        }
        if (user != null) {
            command.add("--user");
            command.add(user);
        }
        if (closeBranch) {
            command.add(HG_OPT_CLOSE_BRANCH);
        }
        VCSFileProxy tempfile = null;
        try {
            if (commitMessage == null || commitMessage.length() == 0) {
                commitMessage = HG_COMMIT_DEFAULT_MESSAGE;
            }
            tempfile = VCSFileProxySupport.createTempFile((VCSFileProxy)VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)true), (String)HG_COMMIT_TEMPNAME, (String)HG_COMMIT_TEMPNAME_SUFFIX, (boolean)true);
            BufferedWriter out = new BufferedWriter(ENCODING == null ? new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)tempfile), "UTF-8") : new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)tempfile), ENCODING));
            out.write(commitMessage);
            out.close();
            command.add(HG_COMMIT_OPT_LOGFILE_CMD);
            command.add(tempfile.getPath());
            String repoPath = repository.getPath();
            if (!repoPath.endsWith("/")) {
                repoPath = repoPath + "/";
            }
            for (VCSFileProxy f : commitFiles) {
                if (f.getPath().length() <= repoPath.length()) {
                    command.add(f.getPath());
                    continue;
                }
                command.add(f.getPath().substring(repoPath.length()));
            }
            List<String> list = HgCommand.exec(repository, command);
            if (!list.isEmpty() && HgCommand.isCommitAfterMerge(list.get(list.size() - 1))) {
                throw new HgException(COMMIT_AFTER_MERGE);
            }
            if (!list.isEmpty() && (HgCommand.isErrorNotTracked(list.get(0)) || HgCommand.isErrorCannotReadCommitMsg(list.get(0)) || HgCommand.isErrorAbort(list.get(list.size() - 1)) || HgCommand.isErrorAbort(list.get(0)))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMIT_FAILED"), logger);
            }
            if (commitMessage == null || tempfile == null) return;
        }
        catch (IOException ex) {
            try {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_FAILED_TO_READ_COMMIT_MESSAGE"));
            }
            catch (Throwable throwable) {
                if (commitMessage == null || tempfile == null) throw throwable;
                VCSFileProxySupport.delete(tempfile);
                throw throwable;
            }
        }
        VCSFileProxySupport.delete((VCSFileProxy)tempfile);
        return;
    }

    public static void doRename(VCSFileProxy repository, VCSFileProxy sourceFile, VCSFileProxy destFile, OutputLogger logger) throws HgException {
        HgCommand.doRename(repository, sourceFile, destFile, false, logger);
    }

    private static void doRename(VCSFileProxy repository, VCSFileProxy sourceFile, VCSFileProxy destFile, boolean bAfter, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_RENAME_CMD);
        if (bAfter) {
            command.add("-A");
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        String repoPath = repository.getPath();
        if (!repoPath.endsWith("/")) {
            repoPath = repoPath + "/";
        }
        command.add(sourceFile.getPath().substring(repoPath.length()));
        command.add(destFile.getPath().substring(repoPath.length()));
        List<String> list = HgCommand.exec(repository, command);
        if (!(list.isEmpty() || !HgCommand.isErrorAbort(list.get(list.size() - 1)) || bAfter && HgCommand.isErrorAbortNoFilesToCopy(list.get(list.size() - 1)))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_RENAME_FAILED"), logger);
        }
    }

    public static void doRenameAfter(VCSFileProxy repository, VCSFileProxy sourceFile, VCSFileProxy destFile, OutputLogger logger) throws HgException {
        HgCommand.doRename(repository, sourceFile, destFile, true, logger);
    }

    public static void doCopy(VCSFileProxy repository, VCSFileProxy sourceFile, VCSFileProxy destFile, boolean bAfter, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_COPY_CMD);
        if (bAfter) {
            command.add("-A");
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        command.add(sourceFile.getPath().substring(repository.getPath().length() + 1));
        command.add(destFile.getPath().substring(repository.getPath().length() + 1));
        List<String> list = HgCommand.exec(repository, command);
        if (!(list.isEmpty() || !HgCommand.isErrorAbort(list.get(list.size() - 1)) || bAfter && HgCommand.isErrorAbortNoFilesToCopy(list.get(list.size() - 1)))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COPY_FAILED"), logger);
        }
    }

    public static void doAdd(VCSFileProxy repository, List<VCSFileProxy> addFiles, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        if (addFiles.isEmpty()) {
            return;
        }
        ArrayList<String> basicCommand = new ArrayList<String>();
        basicCommand.add(HgCommand.getHgCommand());
        basicCommand.add(HG_ADD_CMD);
        basicCommand.add(HG_OPT_REPOSITORY);
        basicCommand.add(repository.getPath());
        List<List<String>> attributeGroups = HgCommand.splitAttributes(repository, basicCommand, addFiles, false);
        for (List<String> attributes : attributeGroups) {
            ArrayList<String> command = new ArrayList<String>(basicCommand);
            command.addAll(attributes);
            List<String> list = HgCommand.exec(repository, command);
            if (list.isEmpty() || HgCommand.isErrorAlreadyTracked(list.get(0)) || HgCommand.isAddingLine(list.get(0)) || !HgCommand.getFilesWithPerformanceWarning(list).isEmpty()) continue;
            HgCommand.handleError(command, list, list.get(0), logger);
        }
    }

    public static void doRevert(VCSFileProxy repository, List<VCSFileProxy> revertFiles, String revision, boolean doBackup, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        if (revertFiles.isEmpty()) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_REVERT_CMD);
        if (!doBackup) {
            command.add(HG_REVERT_NOBACKUP_CMD);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (revision != null) {
            command.add("--rev");
            command.add(revision);
        }
        for (VCSFileProxy f : revertFiles) {
            command.add(f.getPath());
        }
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorNoChangeNeeded(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_REVERT_FAILED"), logger);
        }
    }

    public static void doPurge(VCSFileProxy repository, List<VCSFileProxy> revertFiles, List<String> excludedPaths, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_PURGE_CMD);
        command.add(HG_CONFIG_OPTION_CMD);
        command.add(HG_EXT_PURGE);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        for (String excluded : excludedPaths) {
            command.add(HG_OPT_EXCLUDE);
            command.add(excluded);
        }
        for (VCSFileProxy f : revertFiles) {
            command.add(f.getPath());
        }
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_REVERT_FAILED"), logger);
        }
    }

    public static void doAdd(VCSFileProxy repository, VCSFileProxy file, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_ADD_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(file.getPath());
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAlreadyTracked(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ALREADY_TRACKED"), logger);
        }
    }

    public static List<String> doAnnotate(VCSFileProxy repository, VCSFileProxy file, String revision, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_ANNOTATE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (revision != null) {
            command.add("--rev");
            command.add(revision);
        }
        command.add(HG_ANNOTATE_FLAGN_CMD);
        command.add("--user");
        command.add(HG_ANNOTATE_FLAGL_CMD);
        command.add(HG_OPT_FOLLOW);
        command.add(file.getPath());
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorNoSuchFile(list.get(0))) {
                String rev;
                list = revision == null ? ((rev = HgCommand.getLastRevision(repository, file)) != null ? HgCommand.doAnnotate(repository, file, rev, logger) : null) : null;
            }
        }
        return list;
    }

    public static List<String> doAnnotate(VCSFileProxy repository, VCSFileProxy file, OutputLogger logger) throws HgException {
        return HgCommand.doAnnotate(repository, file, null, logger);
    }

    public static String getBranch(VCSFileProxy repository) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_BRANCH_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static List<String> getHeadRevisions(VCSFileProxy repository) throws HgException {
        return HgCommand.getHeadInfo(repository, true, HG_REV_TEMPLATE_CMD, false);
    }

    public static HgLogMessage[] getHeadRevisionsInfo(VCSFileProxy repository, boolean onlyTopologicalHeads, OutputLogger logger) throws HgException {
        List<String> list = HgCommand.getHeadInfo(repository, onlyTopologicalHeads, HG_LOG_BASIC_CHANGESET_NAME, true);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        List<HgLogMessage> messages = HgCommand.processLogMessages(repository, null, list, false);
        return messages.toArray(new HgLogMessage[messages.size()]);
    }

    public static HgBranch[] getBranches(VCSFileProxy repository, OutputLogger logger) throws HgException {
        List<String> list = HgCommand.getHeadInfo(repository, false, HG_LOG_BASIC_CHANGESET_NAME, true);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        List<HgLogMessage> heads = HgCommand.processLogMessages(repository, null, list, false);
        list = HgCommand.getBranches(repository);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        return HgCommand.processBranches(list, heads);
    }

    public static void markBranch(VCSFileProxy repository, String branchName, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_BRANCH_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(branchName);
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        WorkingCopyInfo.refreshAsync(repository);
    }

    public static HgTag[] getTags(VCSFileProxy repository, OutputLogger logger) throws HgException {
        List<String> list = HgCommand.getTags(repository);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        return HgCommand.processTags(list, repository, logger);
    }

    public static void createTag(VCSFileProxy repository, String tagName, String message, String revision, boolean isLocal, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_TAG_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (isLocal) {
            command.add(HG_TAG_OPT_LOCAL);
        } else if (message != null && !message.isEmpty()) {
            command.add(HG_TAG_OPT_MESSAGE);
            command.add(message);
        }
        if (revision != null && !revision.isEmpty()) {
            command.add("--rev");
            command.add(revision);
        }
        command.add(tagName);
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
    }

    public static void removeTag(VCSFileProxy repository, String tagName, boolean isLocal, String message, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_TAG_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (isLocal) {
            command.add(HG_TAG_OPT_LOCAL);
        } else if (message != null && !message.isEmpty()) {
            command.add(HG_TAG_OPT_MESSAGE);
            command.add(message);
        }
        command.add(HG_TAG_OPT_REMOVE);
        command.add(tagName);
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
    }

    private static List<String> getHeadInfo(VCSFileProxy repository, boolean topo, String template, boolean useStyle) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_HEADS_CMD);
        if (topo && (topoAvailable = Boolean.valueOf(Boolean.TRUE.equals(topoAvailable) || topoAvailable == null && HgUtils.hasTopoOption(Mercurial.getInstance().getVersion(repository)))).booleanValue()) {
            command.add(HG_FLAG_TOPO);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        VCSFileProxy tempFolder = null;
        try {
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            if (useStyle) {
                command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_BASIC_CHANGESET_NAME));
            } else {
                command.add(template);
            }
            List<String> output = HgCommand.exec(repository, command);
            if (topo && topoAvailable.booleanValue() && output.contains("hg heads: option --topo not recognized")) {
                topoAvailable = false;
                List<String> list = HgCommand.getHeadInfo(repository, topo, template, useStyle);
                return list;
            }
            List<String> list = output;
            return list;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    private static List<String> getBranches(VCSFileProxy repository) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_BRANCHES_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        return HgCommand.exec(repository, command);
    }

    private static List<String> getTags(VCSFileProxy repository) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_TAGS_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        return HgCommand.exec(repository, command);
    }

    public static String getLastRevision(VCSFileProxy repository, VCSFileProxy file) throws HgException {
        return HgCommand.getLastChange(repository, file, HG_REV_TEMPLATE_CMD);
    }

    private static String getLastChange(VCSFileProxy repository, VCSFileProxy file, String template) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_LOG_LIMIT_ONE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(template);
        if (file != null) {
            command.add(file.getPath());
        }
        if (!(list = HgCommand.exec(repository, command)).isEmpty()) {
            return new StringBuffer(list.get(0)).toString();
        }
        return null;
    }

    public static HgLogMessage.HgRevision getParent(VCSFileProxy repository, VCSFileProxy file, String revision) throws HgException {
        if (repository == null) {
            return null;
        }
        HgLogMessage.HgRevision parentRevision = HgLogMessage.HgRevision.EMPTY;
        List<HgLogMessage> revisions = HgCommand.getParents(repository, file, revision);
        if (revisions.size() > 1) {
            String rev1 = revisions.get(0).getRevisionNumber();
            String rev2 = revisions.get(1).getRevisionNumber();
            parentRevision = HgCommand.getCommonAncestor(repository, repository.getPath(), rev1, rev2, OutputLogger.getLogger(null));
        } else if (revisions.size() == 1) {
            parentRevision = revisions.get(0).getHgRevision();
        }
        return parentRevision;
    }

    public static List<HgLogMessage> getParents(VCSFileProxy repository, VCSFileProxy file, String revision) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_PARENT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        if (revision != null) {
            command.add("--rev");
            command.add(revision);
        }
        VCSFileProxy tempFolder = null;
        try {
            List<String> list;
            tempFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)false);
            command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_BASIC_CHANGESET_NAME));
            if (file != null) {
                command.add(file.getPath());
            }
            if (!(list = HgCommand.exec(repository, command)).isEmpty()) {
                if (HgCommand.isErrorNotFoundInManifest(list.get(0))) {
                    List<HgLogMessage> list2 = Collections.emptyList();
                    return list2;
                }
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), OutputLogger.getLogger(null));
                } else if (HgCommand.isErrorAbort(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), OutputLogger.getLogger(null));
                }
            }
            List<HgLogMessage> list3 = HgCommand.processLogMessages(repository, file == null ? Collections.emptyList() : Collections.singletonList(file), list);
            return list3;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            if (tempFolder != null) {
                VCSFileProxySupport.delete((VCSFileProxy)tempFolder);
            }
        }
    }

    public static Map<VCSFileProxy, FileInformation> getStatus(VCSFileProxy repository, List<VCSFileProxy> files, String revisionFrom, String revisionTo) throws HgException {
        return HgCommand.getStatus(repository, files, revisionFrom, revisionTo, true);
    }

    public static Map<VCSFileProxy, FileInformation> getStatus(VCSFileProxy repository, List<VCSFileProxy> files, String revisionFrom, String revisionTo, boolean detectCopies) throws HgException {
        return HgCommand.getStatusWithFlags(repository, files, detectCopies ? HG_STATUS_FLAG_INTERESTING_COPIES_CMD : HG_STATUS_FLAG_INTERESTING_CMD, revisionFrom, revisionTo);
    }

    public static void doRemove(VCSFileProxy repository, List<VCSFileProxy> removeFiles, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        if (removeFiles.isEmpty()) {
            return;
        }
        ArrayList<String> basicCommand = new ArrayList<String>();
        basicCommand.add(HgCommand.getHgCommand());
        basicCommand.add(HG_REMOVE_CMD);
        basicCommand.add(HG_OPT_REPOSITORY);
        basicCommand.add(repository.getPath());
        basicCommand.add(HG_REMOVE_FLAG_FORCE_CMD);
        List<List<String>> attributeGroups = HgCommand.splitAttributes(repository, basicCommand, removeFiles, false);
        for (List<String> attributes : attributeGroups) {
            ArrayList<String> command = new ArrayList<String>(basicCommand);
            command.addAll(attributes);
            List<String> list = HgCommand.exec(repository, command);
            if (list.isEmpty()) continue;
            HgCommand.handleError(command, list, list.get(0), logger);
        }
    }

    public static void doRemove(VCSFileProxy repository, VCSFileProxy f, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_REMOVE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_REMOVE_FLAG_FORCE_CMD);
        try {
            command.add(VCSFileProxySupport.getCanonicalPath((VCSFileProxy)f));
        }
        catch (IOException ioe) {
            Mercurial.LOG.log(Level.WARNING, ioe.getMessage(), ioe);
            command.add(f.getPath());
        }
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAlreadyTracked(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ALREADY_TRACKED"), logger);
        }
    }

    public static List<String> doExport(VCSFileProxy repository, String revStr, String outputFileName, OutputLogger logger) throws HgException {
        List<String> list;
        VCSFileProxy fileTarget = VCSFileProxySupport.getResource((VCSFileProxy)repository, (String)outputFileName);
        VCSFileProxy parentTarget = fileTarget.getParentFile();
        try {
            if (!VCSFileProxySupport.mkdir((VCSFileProxy)parentTarget) && !parentTarget.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : {0}", parentTarget.getPath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException e) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : {0} threw SecurityException {1}", new Object[]{parentTarget.getPath(), e.getMessage()});
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_EXPORT_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPTION_GIT);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_FLAG_OUTPUT_CMD);
        command.add(outputFileName);
        if (revStr != null) {
            command.add(revStr);
        }
        if (!(list = HgCommand.exec(repository, command)).isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_EXPORT_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doBundle(VCSFileProxy repository, String revBase, String revTo, VCSFileProxy outputFile, OutputLogger logger) throws HgException {
        VCSFileProxy parentTarget = outputFile.getParentFile();
        try {
            if (!VCSFileProxySupport.mkdirs((VCSFileProxy)parentTarget) && !parentTarget.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdirs() failed for : {0}", parentTarget.getPath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException e) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : {0} threw SecurityException {1}", new Object[]{parentTarget.getPath(), e.getMessage()});
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_BUNDLE_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_BASE_CMD);
        command.add(revBase);
        if (revTo != null) {
            command.add(HG_REV_CMD);
            command.add(revTo);
        }
        command.add(outputFile.getPath());
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_BUNDLE_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doExportFileDiff(VCSFileProxy repository, VCSFileProxy file, String revStr, String outputFileName, OutputLogger logger) throws HgException {
        VCSFileProxy fileTarget = VCSFileProxySupport.getResource((VCSFileProxy)repository, (String)outputFileName);
        VCSFileProxy parentTarget = fileTarget.getParentFile();
        try {
            if (!VCSFileProxySupport.mkdir((VCSFileProxy)parentTarget) && !parentTarget.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : {0}", parentTarget.getPath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException e) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : {0} threw SecurityException {1}", new Object[]{parentTarget.getPath(), e.getMessage()});
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_REV_CMD);
        command.add(revStr);
        command.add(HG_LOG_TEMPLATE_EXPORT_FILE_CMD);
        command.add(HG_LOG_PATCH_CMD);
        command.add(HG_OPTION_GIT);
        command.add(file.getPath());
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_EXPORT_FAILED"), logger);
        } else {
            HgCommand.writeOutputFileDiff(list, outputFileName);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOutputFileDiff(List<String> list, String outputFileName) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new FileWriter(outputFileName));
            for (String s : list) {
                pw.println(s);
                pw.flush();
            }
        }
    }

    public static List<String> doImport(VCSFileProxy repository, VCSFileProxy patchFile, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_IMPORT_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        command.add(patchFile.getPath());
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            logger.output(list);
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_IMPORT_FAILED"), logger);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<VCSFileProxy, FileInformation> getStatusWithFlags(VCSFileProxy repository, List<VCSFileProxy> dirs, String statusFlags, String revFrom, String revTo) throws HgException {
        Map<VCSFileProxy, FileInformation> map;
        block5: {
            if (repository == null) {
                return null;
            }
            long startTime = 0L;
            if (Mercurial.STATUS_LOG.isLoggable(Level.FINER)) {
                Mercurial.STATUS_LOG.log(Level.FINER, "getStatusWithFlags: starting for {0}", dirs);
                startTime = System.currentTimeMillis();
            }
            try {
                map = HgCommand.doRepositoryDirStatusCmd(repository, dirs, statusFlags, revFrom, revTo);
                if (!Mercurial.STATUS_LOG.isLoggable(Level.FINER)) break block5;
            }
            catch (Throwable throwable) {
                if (Mercurial.STATUS_LOG.isLoggable(Level.FINER)) {
                    Mercurial.STATUS_LOG.log(Level.FINER, "getStatusWithFlags for {0} lasted {1}", new Object[]{dirs, System.currentTimeMillis() - startTime});
                }
                throw throwable;
            }
            Mercurial.STATUS_LOG.log(Level.FINER, "getStatusWithFlags for {0} lasted {1}", new Object[]{dirs, System.currentTimeMillis() - startTime});
        }
        return map;
    }

    private static String getRelativePathFromStatusLine(String statusLine, String repositoryPath) {
        String path = statusLine.substring(2);
        return path;
    }

    private static VCSFileProxy getFileFromStatusLine(String statusLine, VCSFileProxy repository) {
        String repositoryPath = repository.getPath();
        String path = HgCommand.getRelativePathFromStatusLine(statusLine, repositoryPath);
        VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)repository, (String)path);
        return file;
    }

    private static FileInformation getFileInformationFromStatusLine(String status) {
        FileInformation info = null;
        if (status == null || status.length() == 0) {
            return new FileInformation(8, null, false);
        }
        char c0 = status.charAt(0);
        char c1 = status.charAt(1);
        switch (c0 + c1) {
            case 109: {
                info = new FileInformation(16, null, false);
                break;
            }
            case 97: {
                info = new FileInformation(4096, null, false);
                break;
            }
            case 114: {
                info = new FileInformation(256, null, false);
                break;
            }
            case 99: {
                info = new FileInformation(8, null, false);
                break;
            }
            case 65: {
                info = new FileInformation(2048, null, false);
                break;
            }
            case 105: {
                info = new FileInformation(2, null, false);
                break;
            }
            case 95: {
                info = new FileInformation(4, null, false);
                break;
            }
            case 117: {
                info = new FileInformation(64, null, false);
                break;
            }
            case 195: {
                info = new FileInformation(1, null, false);
                break;
            }
            default: {
                info = new FileInformation(0, null, false);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<VCSFileProxy, FileInformation> doRepositoryDirStatusCmd(VCSFileProxy repository, List<VCSFileProxy> dirs, String statusFlags, String rev1, String rev2) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_STATUS_CMD);
        command.add(statusFlags);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        List<List<String>> attributeGroups = HgCommand.splitAttributes(repository, command, dirs, true);
        boolean workDirStatus = true;
        boolean skipMidChanges = false;
        if (rev1 != null) {
            command.add("--rev");
            if (rev2 == null || HgLogMessage.HgRevision.CURRENT.getRevisionNumber().equals(rev2)) {
                skipMidChanges = !HgLogMessage.HgRevision.BASE.getRevisionNumber().equals(rev1);
                command.add(rev1);
            } else {
                skipMidChanges = true;
                command.add(rev1 + ":" + rev2);
                workDirStatus = false;
            }
        }
        ArrayList<String> commandOutput = new ArrayList<String>();
        ArrayList<String> changedPaths = skipMidChanges ? new ArrayList<String>() : null;
        for (List<String> attributes : attributeGroups) {
            if (changedPaths != null) {
                changedPaths.addAll(HgCommand.getListOfChangedFiles(repository, attributes, rev1, rev2));
            }
            ArrayList<String> finalCommand = new ArrayList<String>(command);
            finalCommand.addAll(attributes);
            List<String> list = HgCommand.exec(repository, finalCommand);
            if (!list.isEmpty() && HgCommand.isErrorNoRepository(list.get(0))) {
                OutputLogger logger = OutputLogger.getLogger(repository);
                try {
                    HgCommand.handleError(finalCommand, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                }
                finally {
                    logger.closeLog();
                }
            }
            if (workDirStatus && HgUtils.hasResolveCommand(Mercurial.getInstance().getVersion(repository))) {
                try {
                    List<String> unresolved = HgCommand.getUnresolvedFiles(repository, attributes);
                    list.addAll(unresolved);
                }
                catch (HgException ex) {
                    // empty catch block
                }
            }
            commandOutput.addAll(list);
        }
        Map<VCSFileProxy, FileInformation> infos = HgCommand.processStatusResult(commandOutput, repository, statusFlags, changedPaths);
        if (Mercurial.LOG.isLoggable(Level.FINE)) {
            if (commandOutput.size() < 10) {
                Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status list {2}", new Object[]{repository.getPath(), statusFlags, commandOutput});
            } else {
                Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status list has {2} elements", new Object[]{repository.getPath(), statusFlags, commandOutput.size()});
            }
        }
        return infos;
    }

    private static List<String> getUnresolvedFiles(VCSFileProxy repository, List<String> attributes) throws HgException {
        assert (attributes != null);
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_RESOLVE_CMD);
        command.add(HG_LOG_LIMIT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        command.addAll(attributes);
        List<String> list = HgCommand.exec(repository, command);
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            String line = it.next();
            if (line.length() >= 2 && line.charAt(0) + line.charAt(1) == 117) continue;
            it.remove();
        }
        return list;
    }

    public static QPatch[] qListSeries(VCSFileProxy repository) throws HgException {
        Queue activeQueue = null;
        for (Queue q : HgCommand.qListQueues(repository)) {
            if (!q.isActive()) continue;
            activeQueue = q;
        }
        if (activeQueue == null) {
            return new QPatch[0];
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_QSERIES_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_SUMMARY);
        List<String> list = HgCommand.exec(repository, command);
        QPatch[] patches = list.isEmpty() ? new QPatch[]{} : HgCommand.parsePatches(list, activeQueue);
        return patches;
    }

    public static Map<Queue, QPatch[]> qListAvailablePatches(VCSFileProxy repository) throws HgException {
        LinkedHashMap<Queue, QPatch[]> patches = new LinkedHashMap<Queue, QPatch[]>();
        LinkedHashMap<Queue, QPatch[]> otherPatches = new LinkedHashMap<Queue, QPatch[]>();
        for (Queue q : HgCommand.qListQueues(repository)) {
            if (q.isActive()) {
                patches.put(q, HgCommand.qListSeries(repository));
                continue;
            }
            otherPatches.put(q, HgCommand.qListSeries(repository, q.getName()));
        }
        patches.putAll(otherPatches);
        return patches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QPatch[] qListSeries(VCSFileProxy repository, String queueName) throws HgException {
        Queue q = new Queue(queueName, false);
        ArrayList<QPatch> patches = new ArrayList<QPatch>();
        VCSFileProxy seriesFile = HgCommand.getQSeriesFile(repository, queueName);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(seriesFile.getInputStream(false), "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#")) {
                    patches.add(new QPatch(line, null, q, false));
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, ex.getMessage());
            Mercurial.LOG.log(Level.FINE, null, ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        return patches.toArray(new QPatch[patches.size()]);
    }

    public static Queue[] qListQueues(VCSFileProxy repository) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_QQUEUE_CMD);
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        command.add(HG_OPT_LIST);
        List<String> list = HgCommand.exec(repository, command);
        Queue[] queues = list.isEmpty() ? new Queue[]{} : HgCommand.parseQueues(list);
        return queues;
    }

    public static void qSwitchQueue(VCSFileProxy repository, String queueName, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_QQUEUE_CMD);
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        command.add(queueName);
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_QQUEUE_SWITCH_FAILED"), logger);
        }
    }

    public static List<String> qPushPatches(VCSFileProxy repository, String onTopPatch, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_QPUSH_CMD);
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        if (onTopPatch == null) {
            command.add(HG_OPT_ALL);
        } else {
            command.add(onTopPatch);
        }
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_QPUSH_FAILED"), logger);
        }
        return list;
    }

    public static void qPopPatches(VCSFileProxy repository, String onTopPatch, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_QPOP_CMD);
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        if (onTopPatch == null) {
            command.add(HG_OPT_ALL);
        } else {
            command.add(onTopPatch);
        }
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_QPOP_FAILED"), logger);
        }
    }

    public static List<String> qGoToPatch(VCSFileProxy repository, String patch, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_QGOTO_CMD);
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        command.add(patch);
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_QGOTO_FAILED"), logger);
        }
        return list;
    }

    private static QPatch[] parsePatches(List<String> list, Queue q) {
        ArrayList<QPatch> patches = new ArrayList<QPatch>(list.size());
        Pattern p = Pattern.compile("^\\s*(\\b\\d+)\\s([AU])\\s([^:]+?):\\s?(.*)$");
        for (String line : list) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String status = m.group(2);
            String id = m.group(3);
            String message = m.group(4);
            patches.add(new QPatch(id, message, q, "A".equals(status)));
        }
        if (patches.isEmpty() && !list.isEmpty()) {
            Mercurial.LOG.log(Level.INFO, "parsePatches(): No qpatches found: {0}", list);
        }
        return patches.toArray(new QPatch[patches.size()]);
    }

    private static Queue[] parseQueues(List<String> list) {
        ArrayList<Queue> queues = new ArrayList<Queue>(list.size());
        for (String line : list) {
            line = line.trim();
            boolean active = false;
            if (line.endsWith(QUEUE_ACTIVE)) {
                active = true;
                line = line.substring(0, line.length() - QUEUE_ACTIVE.length()).trim();
            }
            queues.add(new Queue(line, active));
        }
        if (queues.isEmpty() && !list.isEmpty()) {
            Mercurial.LOG.log(Level.INFO, "parseQueues(): No qqueue found: {0}", list);
        }
        return queues.toArray(new Queue[queues.size()]);
    }

    public static void qCreatePatch(VCSFileProxy repository, Collection<VCSFileProxy> includedFiles, Collection<VCSFileProxy> excludedFiles, String patchId, String commitMessage, String user, OutputLogger logger) throws HgException {
        HgCommand.qCreateRefreshPatch(repository, includedFiles, excludedFiles, patchId, commitMessage, user, logger);
    }

    public static void qRefreshPatch(VCSFileProxy repository, Collection<VCSFileProxy> includedFiles, Collection<VCSFileProxy> excludedFiles, String commitMessage, String user, OutputLogger logger) throws HgException {
        HgCommand.qCreateRefreshPatch(repository, includedFiles, excludedFiles, null, commitMessage, user, logger);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void qCreateRefreshPatch(VCSFileProxy repository, Collection<VCSFileProxy> includedFiles, Collection<VCSFileProxy> excludedFiles, String patchId, String commitMessage, String user, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(patchId == null ? HG_QREFRESH_PATCH : HG_QCREATE_CMD);
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        String projectUserName = new HgConfigFiles(repository).getUserName(false);
        String globalUsername = HgModuleConfig.getDefault(repository).getSysUserName();
        if (user == null) {
            if (projectUserName != null && projectUserName.length() > 0) {
                user = projectUserName;
            } else if (globalUsername != null && globalUsername.length() > 0) {
                user = globalUsername;
            }
        }
        if (user != null) {
            command.add("--user");
            command.add(user);
        }
        VCSFileProxy tempfile = null;
        try {
            if (commitMessage == null || commitMessage.length() == 0) {
                commitMessage = HG_COMMIT_DEFAULT_MESSAGE;
            }
            tempfile = VCSFileProxySupport.createTempFile((VCSFileProxy)VCSFileProxySupport.getTempFolder((VCSFileProxy)repository, (boolean)true), (String)HG_COMMIT_TEMPNAME, (String)HG_COMMIT_TEMPNAME_SUFFIX, (boolean)true);
            BufferedWriter out = new BufferedWriter(ENCODING == null ? new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)tempfile), "UTF-8") : new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)tempfile), ENCODING));
            out.write(commitMessage);
            out.close();
            command.add(HG_COMMIT_OPT_LOGFILE_CMD);
            command.add(tempfile.getPath());
            if (patchId == null) {
                command.add(HG_OPT_SHORT);
                for (VCSFileProxy f : excludedFiles) {
                    command.add(HG_OPT_EXCLUDE);
                    command.add(f.getPath());
                }
            } else {
                if (includedFiles.isEmpty()) {
                    command.add(HG_OPT_EXCLUDE);
                    command.add("*");
                }
                command.add(patchId);
            }
            for (VCSFileProxy f : includedFiles) {
                if (f.getPath().length() <= repository.getPath().length()) {
                    command.add(f.getPath());
                    continue;
                }
                command.add(f.getPath().substring(repository.getPath().length() + 1));
            }
            List<String> list = HgCommand.exec(repository, command);
            if (!list.isEmpty() && HgCommand.isCommitAfterMerge(list.get(list.size() - 1))) {
                throw new HgException(COMMIT_AFTER_MERGE);
            }
            if (!list.isEmpty() && (HgCommand.isErrorNotTracked(list.get(0)) || HgCommand.isErrorCannotReadCommitMsg(list.get(0)) || HgCommand.isErrorAbort(list.get(list.size() - 1)) || HgCommand.isErrorAbort(list.get(0)))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
            if (commitMessage == null || tempfile == null) return;
        }
        catch (IOException ex) {
            try {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_FAILED_TO_READ_COMMIT_MESSAGE"));
            }
            catch (Throwable throwable) {
                if (commitMessage == null || tempfile == null) throw throwable;
                VCSFileProxySupport.delete(tempfile);
                throw throwable;
            }
        }
        VCSFileProxySupport.delete((VCSFileProxy)tempfile);
        return;
    }

    public static void qFinishPatches(VCSFileProxy repository, String patch, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_QFINISH_CMD);
        command.add(HG_CONFIG_OPTION_CMD);
        command.add("extensions.mq=");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        command.add(patch);
        List<String> list = HgCommand.exec(repository, command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
        }
    }

    private static List<String> execEnv(VCSFileProxy repository, List<? extends Object> command, List<String> env) throws HgException {
        return HgCommand.execEnv(command, env, true, repository);
    }

    /*
     * Exception decompiling
     */
    private static List<String> execEnv(List<? extends Object> command, List<String> env, boolean logUsage, VCSFileProxy repo) throws HgException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setGlobalEnvVariables(Map<String, String> environment) {
        if (!Boolean.TRUE.equals(doNotAddHgPlain.get())) {
            environment.put(ENV_HGPLAIN, "true");
        }
        if (ENCODING != null) {
            environment.put(ENV_HGENCODING, ENCODING);
        }
    }

    private static void logCommand(List<? extends Object> command) {
        if (Mercurial.LOG.isLoggable(Level.FINE)) {
            if (command.size() > 10) {
                ArrayList<String> smallCommand = new ArrayList<String>();
                int count = 0;
                Iterator<? extends Object> i = command.iterator();
                while (i.hasNext()) {
                    smallCommand.add((String)i.next());
                    if (count++ <= 10) continue;
                }
                Mercurial.LOG.log(Level.FINE, "execEnv(): {0}", smallCommand);
            } else {
                Mercurial.LOG.log(Level.FINE, "execEnv(): {0}", command);
            }
        }
    }

    private static List<String> exec(List<? extends Object> command, ProcessBuilder pb) throws HgException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader input = null;
        BufferedReader error = null;
        Process proc = null;
        try {
            proc = pb.call();
            input = new BufferedReader(ENCODING == null ? new InputStreamReader(proc.getInputStream(), "UTF-8") : new InputStreamReader(proc.getInputStream(), ENCODING));
            final BufferedReader errorReader = error = new BufferedReader(ENCODING == null ? new InputStreamReader(proc.getErrorStream(), "UTF-8") : new InputStreamReader(proc.getErrorStream(), ENCODING));
            final ArrayList errorOutput = new ArrayList();
            final BufferedReader inputReader = input;
            final ArrayList inputOutput = new ArrayList();
            Thread errorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = errorReader.readLine()) != null) {
                            if (HgCommand.skipErrorLine(line)) continue;
                            errorOutput.add(line);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            errorThread.start();
            Thread inputThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = inputReader.readLine()) != null) {
                            inputOutput.add(line);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            inputThread.start();
            try {
                inputThread.join();
                errorThread.join();
            }
            catch (InterruptedException ex) {
                Mercurial.LOG.log(Level.FINE, "execEnv():  process interrupted {0}", ex);
                if (proc != null) {
                    proc.destroy();
                }
                throw new HgException.HgCommandCanceledException(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_CANCELLED"));
            }
            list.addAll(inputOutput);
            input.close();
            input = null;
            list.addAll(errorOutput);
            error.close();
            error = null;
            try {
                proc.waitFor();
                if (proc.exitValue() == 255) {
                    Mercurial.LOG.log(Level.FINE, "execEnv():  process returned 255");
                    if (list.isEmpty()) {
                        Mercurial.LOG.log(Level.SEVERE, "command: {0}", command);
                        throw new HgException.HgTooLongArgListException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_EXECUTE_COMMAND"));
                    }
                }
            }
            catch (InterruptedException e) {
                Mercurial.LOG.log(Level.FINE, "execEnv():  process interrupted {0}", e);
            }
        }
        catch (InterruptedIOException e) {
            Mercurial.LOG.log(Level.FINE, "execEnv():  execEnv(): InterruptedIOException {0}", e);
            if (proc != null) {
                proc.destroy();
            }
            throw new HgException.HgCommandCanceledException(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_CANCELLED"));
        }
        catch (IOException e) {
            Mercurial.LOG.log(HG_VERSION_CMD.equals(command.get(1)) ? Level.FINE : Level.INFO, "execEnv():  execEnv(): IOException", e);
            if (HgCommand.isErrorArgsTooLong(e.getMessage())) {
                assert (command.size() > 2);
                throw new HgException.HgTooLongArgListException(NbBundle.getMessage(HgCommand.class, (String)"MSG_ARG_LIST_TOO_LONG_ERR", (Object)HgCommand.getHgCommandName(command), (Object)(command.size() - 2)));
            }
            if (HgCommand.isErrorNoHg(e.getMessage()) || HgCommand.isErrorCannotRun(e.getMessage())) {
                throw new HgException(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_MSG"));
            }
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_EXECUTE_COMMAND"));
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioex) {}
                input = null;
            }
            if (error != null) {
                try {
                    error.close();
                }
                catch (IOException ioex) {}
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VCSFileProxy createOutputStyleFile(List<? extends Object> cmdLine, VCSFileProxy repo) throws IOException {
        VCSFileProxy result = null;
        for (Object object : cmdLine) {
            String str;
            if (object == null) {
                assert (false);
                continue;
            }
            if (object.getClass() != String.class || !(str = (String)object).startsWith("--template=")) continue;
            if (result != null) {
                assert (false) : "implementation not ready for multiple templates on one command line";
                continue;
            }
            String template = str.substring("--template=".length());
            VCSFileProxy tempFile = VCSFileProxySupport.createTempFile((VCSFileProxy)VCSFileProxySupport.getTempFolder((VCSFileProxy)repo, (boolean)true), (String)"hg-output-style", null, (boolean)true);
            OutputStreamWriter writer = ENCODING == null ? new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)tempFile), "UTF-8") : new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)tempFile), ENCODING);
            try {
                ((Writer)writer).append("changeset = ").append('\"').append(template).append('\"');
            }
            finally {
                if (writer != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException ex) {}
                }
            }
            result = tempFile;
        }
        return result;
    }

    private static List<String> toCommandList(List<? extends Object> cmdLine, VCSFileProxy styleFile, VCSFileProxy repo) {
        if (cmdLine.isEmpty()) {
            return cmdLine;
        }
        ArrayList<String> result = new ArrayList<String>(cmdLine.size() + 2);
        boolean first = true;
        for (Object object : cmdLine) {
            if (object == null) {
                assert (false);
                continue;
            }
            if (object == "hg") {
                result.addAll(HgCommand.makeHgLauncherCommandLine(repo));
            } else if (object.getClass() == String.class) {
                String str = (String)object;
                if (str.startsWith("--template=") && styleFile != null) {
                    result.add("--style");
                    result.add(styleFile.getPath());
                } else {
                    result.add(str);
                }
            } else if (object instanceof HgURL) {
                if (first) {
                    assert (false);
                    result.add(object.toString());
                } else {
                    result.add(((HgURL)object).toHgCommandUrlString());
                }
            } else if (object instanceof VCSFileProxy) {
                result.add(((VCSFileProxy)object).getPath());
            } else {
                assert (false);
                result.add(object.toString());
            }
            first = false;
        }
        assert (!result.isEmpty());
        HgCommand.modifyArguments(result);
        return result;
    }

    private static void modifyArguments(List<String> result) {
        if (CMD_EXE.equals(result.get(0))) {
            StringBuilder commandArg = new StringBuilder();
            int pos = 0;
            ListIterator<String> it = result.listIterator();
            while (it.hasNext()) {
                String arg = it.next();
                if (pos >= 2) {
                    it.remove();
                    commandArg.append(arg.replace(" ", "\" \"")).append(' ');
                }
                ++pos;
            }
            assert (result.size() == 2);
            int len = commandArg.length();
            result.add((len == 0 ? commandArg : commandArg.delete(len - 1, len)).toString());
        }
    }

    private static boolean skipErrorLine(String errorLine) {
        boolean skip = false;
        if (errorLine.startsWith("warning:")) {
            skip = true;
        } else {
            for (String s : new String[]{"is deprecated:"}) {
                if (!errorLine.contains(s)) continue;
                skip = true;
                break;
            }
        }
        return skip;
    }

    protected static List<String> exec(VCSFileProxy repository, List<? extends Object> command) throws HgException {
        if (!Mercurial.getInstance().isAvailable(repository)) {
            return new ArrayList<String>();
        }
        return HgCommand.execEnv(repository, command, null);
    }

    private static List<String> execForVersionCheck(VCSFileProxy root) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_VERSION_CMD);
        return HgCommand.execEnv(command, null, false, root);
    }

    protected static String getHgCommand() {
        return "hg";
    }

    private static List<String> makeHgLauncherCommandLine(VCSFileProxy repo) {
        String defaultPath = HgModuleConfig.getDefault(repo).getExecutableBinaryPath();
        if (defaultPath == null || defaultPath.length() == 0) {
            return Collections.singletonList("hg");
        }
        VCSFileProxy f = VCSFileProxySupport.getResource((VCSFileProxy)repo, (String)defaultPath);
        VCSFileProxy launcherFile = f.isFile() ? f : VCSFileProxy.createFileProxy((VCSFileProxy)f, (String)"hg");
        String launcherPath = launcherFile.getPath();
        List<String> result = Collections.singletonList(launcherPath);
        return result;
    }

    protected static void handleError(List<? extends Object> command, List<String> cmdOutput, String message, OutputLogger logger) throws HgException {
        if (command != null && cmdOutput != null && logger != null) {
            Mercurial.LOG.log(Level.WARNING, "command: {0}", command);
            Mercurial.LOG.log(Level.WARNING, "output: {0}", HgUtils.replaceHttpPassword(cmdOutput));
            logger.outputInRed(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ERR"));
            logger.output(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_INFO_ERR", command, HgUtils.replaceHttpPassword(cmdOutput)));
        }
        if (cmdOutput != null && !cmdOutput.isEmpty() && (HgCommand.isErrorPossibleProxyIssue(cmdOutput.get(0)) || HgCommand.isErrorPossibleProxyIssue(cmdOutput.get(cmdOutput.size() - 1)))) {
            boolean bConfirmSetProxy = HgUtils.confirmDialog(HgCommand.class, "MSG_POSSIBLE_PROXY_ISSUE_TITLE", "MSG_POSSIBLE_PROXY_ISSUE_QUERY");
            if (bConfirmSetProxy) {
                OptionsDisplayer.getDefault().open("General");
            }
        } else {
            throw new HgException(message);
        }
    }

    private static PasswordAuthentication handleAuthenticationError(List<String> cmdOutput, VCSFileProxy repository, String url, String userName, UserCredentialsSupport credentialsSupport, String hgCommand) throws HgException {
        return HgCommand.handleAuthenticationError(cmdOutput, repository, url, userName, credentialsSupport, hgCommand, true);
    }

    private static PasswordAuthentication handleAuthenticationError(List<String> cmdOutput, VCSFileProxy repository, String url, String userName, UserCredentialsSupport credentialsSupport, String hgCommand, boolean showLoginDialog) throws HgException {
        PasswordAuthentication credentials = null;
        String msg = cmdOutput.get(cmdOutput.size() - 1).toLowerCase(Locale.getDefault());
        if (HgCommand.isAuthMsg(msg) && showLoginDialog) {
            credentials = credentialsSupport.getUsernamePasswordCredentials(repository, url, userName);
        }
        return credentials;
    }

    public static boolean isAuthMsg(String msg) {
        return msg.contains(HG_AUTHORIZATION_REQUIRED_ERR) || msg.contains(HG_AUTHORIZATION_FAILED_ERR);
    }

    public static boolean isMergeNeededMsg(String msg) {
        return msg.contains("run") && msg.contains("hg heads") && msg.contains("to see heads") && msg.contains("hg merge") && msg.contains("to merge");
    }

    public static boolean isUpdateNeededMsg(String msg) {
        return msg.contains(HG_UPDATE_NEEDED_ERR);
    }

    public static boolean isHeadsNeededMsg(String msg) {
        return msg.contains("run") && msg.contains("hg heads") && msg.contains("to see heads");
    }

    public static boolean isBackoutMergeNeededMsg(String msg) {
        return msg.indexOf(HG_BACKOUT_MERGE_NEEDED_ERR) > -1;
    }

    public static boolean isMergeFailedMsg(String msg) {
        return msg.indexOf(HG_MERGE_FAILED1_ERR) > -1 && (msg.indexOf(HG_MERGE_FAILED2_ERR) > -1 || msg.indexOf(HG_MERGE_FAILED3_ERR) > -1);
    }

    public static boolean isConflictDetectedInMsg(String msg) {
        return msg.indexOf(HG_MERGE_CONFLICT_ERR) > -1;
    }

    public static boolean isMergeUnavailableMsg(String msg) {
        return msg.indexOf(HG_MERGE_UNAVAILABLE_ERR) > -1;
    }

    public static boolean isMergeAbortMultipleHeadsMsg(String msg) {
        return msg.indexOf(HG_MERGE_MULTIPLE_HEADS_ERR) > -1;
    }

    public static boolean isMergeAbortUncommittedMsg(String msg) {
        return msg.indexOf(HG_MERGE_UNCOMMITTED_ERR) > -1;
    }

    public static boolean isNoChanges(String msg) {
        return msg.indexOf(HG_NO_CHANGES_ERR) > -1;
    }

    private static boolean isErrorNoDefaultPush(String msg) {
        return msg.indexOf(HG_ABORT_NO_DEFAULT_PUSH_ERR) > -1;
    }

    private static boolean isErrorNoDefaultPath(String msg) {
        return msg.indexOf(HG_ABORT_NO_DEFAULT_ERR) > -1;
    }

    private static boolean isErrorPossibleProxyIssue(String msg) {
        return msg.indexOf(HG_ABORT_POSSIBLE_PROXY_ERR) > -1;
    }

    private static boolean isErrorNoRepository(String msg) {
        return msg.indexOf(HG_NO_REPOSITORY_ERR) > -1 || msg.indexOf(HG_NOT_REPOSITORY_ERR) > -1 || msg.indexOf(HG_REPOSITORY) > -1 && msg.indexOf(HG_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorNoHg(String msg) {
        return msg.indexOf(HG_NO_HG_CMD_FOUND_ERR) > -1;
    }

    private static boolean isErrorArgsTooLong(String msg) {
        return msg.indexOf(HG_ARG_LIST_TOO_LONG_ERR) > -1 || msg.contains(HG_ARGUMENT_LIST_TOO_LONG_ERR);
    }

    private static boolean isErrorCannotRun(String msg) {
        return msg.indexOf(HG_CANNOT_RUN_ERR) > -1;
    }

    private static boolean isErrorUpdateSpansBranches(String msg) {
        return msg.indexOf(HG_UPDATE_SPAN_BRANCHES_ERR) > -1 || msg.contains(HG_UPDATE_CROSS_BRANCHES_ERR);
    }

    private static boolean isErrorAlreadyTracked(String msg) {
        return msg.indexOf(HG_ALREADY_TRACKED_ERR) > -1;
    }

    private static boolean isErrorNotTracked(String msg) {
        return msg.indexOf(HG_NOT_TRACKED_ERR) > -1;
    }

    private static boolean isErrorNotFound(String msg) {
        return msg.indexOf(HG_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorCannotReadCommitMsg(String msg) {
        return msg.indexOf(HG_CANNOT_READ_COMMIT_MESSAGE_ERR) > -1;
    }

    protected static boolean isErrorAbort(String msg) {
        return msg.indexOf(HG_ABORT_ERR) > -1;
    }

    protected static boolean isFollowNotAllowed(String msg) {
        return (msg = msg.toLowerCase(Locale.getDefault())).contains(HG_ABORT_CANNOT_FOLLOW_NONEXISTENT_FILE) || msg.contains("cannot follow file not in parent revision");
    }

    public static boolean isErrorAbortPush(String msg) {
        return msg.indexOf("abort: push creates new remote ") > -1;
    }

    public static boolean isErrorAbortNoFilesToCopy(String msg) {
        return msg.indexOf(HG_ABORT_NO_FILES_TO_COPY_ERR) > -1;
    }

    public static boolean isCommitAfterMerge(String msg) {
        return msg.indexOf(HG_COMMIT_AFTER_MERGE_ERR) > -1;
    }

    private static boolean isErrorNoChangeNeeded(String msg) {
        return msg.indexOf(HG_NO_CHANGE_NEEDED_ERR) > -1;
    }

    public static boolean isCreateNewBranch(String msg) {
        return msg.indexOf("abort: push creates new remote ") > -1;
    }

    public static boolean isHeadsCreated(String msg) {
        return msg.indexOf(HG_HEADS_CREATED_ERR) > -1;
    }

    public static boolean isNoRollbackPossible(String msg) {
        return msg.indexOf("no rollback information available") > -1;
    }

    public static boolean isNoRevStrip(String msg) {
        return msg.indexOf(HG_NO_REV_STRIP_ERR) > -1;
    }

    public static boolean isLocalChangesStrip(String msg) {
        return msg.indexOf(HG_LOCAL_CHANGES_STRIP_ERR) > -1;
    }

    public static boolean isMultipleHeadsStrip(String msg) {
        return msg.indexOf("no rollback information available") > -1;
    }

    public static boolean isUncommittedChangesBackout(String msg) {
        return msg.indexOf(HG_ABORT_UNCOMMITTED_CHANGES_ERR) > -1;
    }

    public static boolean isMergeChangesetBackout(String msg) {
        return msg.indexOf(HG_ABORT_BACKOUT_MERGE_CSET_ERR) > -1;
    }

    public static boolean isNoUpdates(String msg) {
        return msg.indexOf(HG_NO_UPDATES_ERR) > -1;
    }

    private static boolean isErrorNoView(String msg) {
        return msg.indexOf(HG_NO_VIEW_ERR) > -1;
    }

    private static boolean isErrorHgkNotFound(String msg) {
        return msg.indexOf(HG_HGK_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorNoSuchFile(String msg) {
        return msg.toLowerCase(Locale.ENGLISH).indexOf(HG_NO_SUCH_FILE_ERR) > -1;
    }

    private static boolean isErrorNoResponse(String msg) {
        return msg.indexOf(HG_NO_RESPONSE_ERR) > -1;
    }

    private static boolean isAddingLine(String msg) {
        return msg.toLowerCase(Locale.ENGLISH).indexOf(HG_ADDING) > -1;
    }

    private static boolean isErrorNotFoundInManifest(String msg) {
        return msg.toLowerCase(Locale.ENGLISH).contains("not found in manifest");
    }

    private static List<String> getFilesWithPerformanceWarning(List<String> list) {
        ArrayList<String> fileList = new ArrayList<String>();
        for (String line : list) {
            int pos = line.indexOf(HG_WARNING_PERFORMANCE_FILES_OVER);
            if (pos <= 0 || !line.contains(HG_WARNING_PERFORMANCE_CAUSE_PROBLEMS)) continue;
            fileList.add(line.substring(0, pos));
        }
        return fileList;
    }

    public static void markAsResolved(final VCSFileProxy repository, VCSFileProxy file, OutputLogger logger) throws HgException {
        List<String> list;
        if (file == null) {
            return;
        }
        if (!HgUtils.hasResolveCommand(Mercurial.getInstance().getVersion(repository))) {
            return;
        }
        final ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_RESOLVE_CMD);
        command.add(HG_RESOLVE_MARK_RESOLVED);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(file.normalizeFile().getPath());
        try {
            list = Mercurial.getInstance().runWithoutExternalEvents(repository, HG_RESOLVE_CMD, new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return HgCommand.exec(repository, command);
                }
            });
        }
        catch (HgException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Mercurial.LOG.log(Level.WARNING, null, ex);
            return;
        }
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
    }

    public static void deleteConflictFile(VCSFileProxy file) {
        VCSFileProxySupport.delete((VCSFileProxy)VCSFileProxySupport.getResource((VCSFileProxy)file, (String)(file + HG_STR_CONFLICT_EXT)));
        boolean success = true;
        Mercurial.LOG.log(Level.FINE, "deleteConflictFile(): File: {0} {1}", new Object[]{file + HG_STR_CONFLICT_EXT, success ? "Deleted" : "Not Deleted"});
    }

    public static boolean existsConflictFile(VCSFileProxy path) {
        VCSFileProxy file = VCSFileProxySupport.getResource((VCSFileProxy)path, (String)(path + HG_STR_CONFLICT_EXT));
        boolean bExists = file.canWrite();
        if (bExists) {
            Mercurial.LOG.log(Level.FINE, "existsConflictFile(): File: {0} {1}", new Object[]{path + HG_STR_CONFLICT_EXT, "Exists"});
        }
        return bExists;
    }

    private static boolean isTooLongCommand(VCSFileProxy repository, int commandSize) {
        return VCSFileProxySupport.isMac((VCSFileProxy)repository) && commandSize > MAX_COMMANDLINE_SIZE;
    }

    private static String getHgCommandName(List<? extends Object> commandList) {
        String commandName = null;
        if (commandList.size() > 1 && "hg".equals(commandList.get(0))) {
            commandName = commandList.get(1).toString();
        }
        return commandName;
    }

    private static boolean changesParents(String hgCommand) {
        return WORKING_COPY_PARENT_MODIFYING_COMMANDS.contains(hgCommand);
    }

    private static boolean modifiesRepository(String hgCommand) {
        return !REPOSITORY_NOMODIFICATION_COMMANDS.contains(hgCommand);
    }

    private static VCSFileProxy getRepositoryFromCommand(List<? extends Object> commandList, String hgCommand, VCSFileProxy repo) {
        VCSFileProxy repositoryFile = null;
        boolean isRepositoryArgument = false;
        ListIterator<? extends Object> it = commandList.listIterator();
        while (it.hasNext()) {
            Object argument = it.next();
            if (isRepositoryArgument || HG_CLONE_CMD.equals(hgCommand) && !it.hasNext()) {
                repositoryFile = VCSFileProxySupport.getResource((VCSFileProxy)repo, (String)argument.toString());
                break;
            }
            if (!HG_OPT_REPOSITORY.equals(argument)) continue;
            isRepositoryArgument = true;
        }
        return repositoryFile;
    }

    private static void logExternalRepositories(VCSFileProxy repository, String hgCommand) {
        HgConfigFiles hgConfigFiles;
        if (!noLogCommands.contains(hgCommand) && loggedRepositories.add(repository) && (hgConfigFiles = new HgConfigFiles(repository)).getException() == null) {
            boolean empty = true;
            for (Map.Entry<Object, Object> prop : hgConfigFiles.getProperties("paths").entrySet()) {
                if (prop.getValue().toString().isEmpty()) continue;
                empty = false;
                Utils.logVCSExternalRepository((String)"HG", (String)prop.getValue().toString());
            }
            if (empty) {
                Utils.logVCSExternalRepository((String)"HG", null);
            }
        }
    }

    protected HgCommand() {
    }

    private static String getEncoding() {
        String enc = null;
        String prop = System.getProperty("mercurial.encoding", "");
        if (!prop.isEmpty()) {
            try {
                if (Charset.isSupported(prop)) {
                    enc = prop;
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (enc == null) {
                Mercurial.LOG.log(Level.WARNING, "Unsupported encoding {0}, using default", prop);
            }
        }
        return enc;
    }

    private static VCSFileProxy getQSeriesFile(VCSFileProxy repository, String queueName) {
        String folderName = HG_QPATCHES_NAME;
        if (!HG_QPATCHES_NAME.equals(queueName)) {
            folderName = folderName + "-" + queueName;
        }
        return VCSFileProxy.createFileProxy((VCSFileProxy)HgUtils.getHgFolderForRoot(repository), (String)(folderName + "/" + "series"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getListOfChangedFiles(VCSFileProxy repository, List<String> attributes, String rev1, String rev2) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_DIFF_CMD);
        command.add(HG_OPT_STAT);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getPath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getPath());
        if (rev1 != null) {
            command.add("--rev");
            if (rev2 == null || HgLogMessage.HgRevision.CURRENT.getRevisionNumber().equals(rev2)) {
                command.add(rev1);
            } else {
                command.add(rev1 + ":" + rev2);
            }
        }
        command.addAll(attributes);
        List<String> list = HgCommand.exec(repository, command);
        ArrayList<String> changedFiles = new ArrayList<String>(list.size());
        if (!list.isEmpty() && HgCommand.isErrorNoRepository(list.get(0))) {
            OutputLogger logger = OutputLogger.getLogger(repository);
            try {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            }
            finally {
                logger.closeLog();
            }
        }
        Pattern p = Pattern.compile("^ (.+)\\s*\\|.*?$");
        for (String line : list) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            String path = m.group(1);
            while (path.endsWith(" ")) {
                path = path.substring(0, path.length() - 1);
            }
            changedFiles.add(path);
        }
        return changedFiles;
    }

    private static Map<VCSFileProxy, FileInformation> processStatusResult(List<String> commandOutput, VCSFileProxy repository, String statusFlags, List<String> changedPaths) {
        HashMap<VCSFileProxy, FileInformation> repositoryFiles = new HashMap<VCSFileProxy, FileInformation>(commandOutput.size());
        VCSFileProxy file = null;
        FileInformation prev_info = null;
        String repositoryPath = repository.getPath();
        for (String statusLine : commandOutput) {
            if (statusLine.isEmpty()) continue;
            FileInformation info = HgCommand.getFileInformationFromStatusLine(statusLine);
            Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): status line {0}  info {1}", new Object[]{statusLine, info});
            if (statusLine.length() > 0) {
                if (statusLine.charAt(0) == ' ') {
                    if (file != null) {
                        VCSFileProxy original = HgCommand.getFileFromStatusLine(statusLine, repository);
                        prev_info = new FileInformation(prev_info.getStatus(), new FileStatus(file, original), false);
                        Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): prev_info {0}  filePath {1}", new Object[]{prev_info, file});
                        continue;
                    }
                    Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status line {2} filepath == nullfor prev_info ", new Object[]{repository.getPath(), statusFlags, statusLine});
                    continue;
                }
                if (file != null) {
                    repositoryFiles.put(file, prev_info);
                }
            }
            if (info.getStatus() == 1 || info.getStatus() == 0) continue;
            if (changedPaths != null && (info.getStatus() & 0x10) != 0 && !changedPaths.contains(HgCommand.getRelativePathFromStatusLine(statusLine, repositoryPath))) {
                file = null;
                continue;
            }
            file = HgCommand.getFileFromStatusLine(statusLine, repository);
            if (HgCommand.existsConflictFile(file)) {
                info = new FileInformation(64, null, false);
                Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): CONFLICT repository path: {0} status flags: {1} status line {2} CONFLICT {3}", new Object[]{repository.getPath(), statusFlags, statusLine, file + HG_STR_CONFLICT_EXT});
            }
            prev_info = info;
        }
        if (prev_info != null) {
            repositoryFiles.put(file, prev_info);
        }
        return repositoryFiles;
    }

    private static String prepareLogTemplate(VCSFileProxy temporaryFolder, String changesetFileName) throws IOException {
        InputStream isChangeset = HgCommand.class.getResourceAsStream(changesetFileName);
        InputStream isStyle = HgCommand.class.getResourceAsStream(HG_LOG_STYLE_NAME);
        VCSFileProxy styleFile = VCSFileProxy.createFileProxy((VCSFileProxy)temporaryFolder, (String)HG_LOG_STYLE_NAME);
        VCSFileProxy changesetFile = VCSFileProxy.createFileProxy((VCSFileProxy)temporaryFolder, (String)HG_LOG_CHANGESET_GENERAL_NAME);
        Utils.copyStreamsCloseAll((OutputStream)VCSFileProxySupport.getOutputStream((VCSFileProxy)changesetFile), (InputStream)isChangeset);
        Utils.copyStreamsCloseAll((OutputStream)VCSFileProxySupport.getOutputStream((VCSFileProxy)styleFile), (InputStream)isStyle);
        return HG_ARGUMENT_STYLE + styleFile.getPath();
    }

    private static List<List<String>> splitAttributes(VCSFileProxy repository, List<String> basicCommand, List<VCSFileProxy> files, boolean includeFolders) {
        ArrayList<List<String>> attributes = new ArrayList<List<String>>();
        int basicCommandSize = 0;
        boolean cwdParamIncluded = false;
        for (String s : basicCommand) {
            if (HG_OPT_CWD_CMD.equals(s)) {
                cwdParamIncluded = true;
            }
            basicCommandSize += s.length() + 1;
        }
        if (!cwdParamIncluded) {
            basicCommand.add(HG_OPT_CWD_CMD);
            basicCommand.add(repository.getPath());
            basicCommandSize += HG_OPT_CWD_CMD.length() + repository.getPath().length() + 2;
        }
        ListIterator<VCSFileProxy> iterator = files.listIterator();
        while (iterator.hasNext()) {
            ArrayList<String> commandAttributes = new ArrayList<String>();
            int commandSize = basicCommandSize;
            boolean fileAdded = false;
            while (iterator.hasNext()) {
                VCSFileProxy f = iterator.next();
                if (!includeFolders && f.isDirectory()) continue;
                String filePath = HgCommand.getPathParameter(repository, f);
                if (fileAdded && HgCommand.isTooLongCommand(repository, commandSize += filePath.length() + 1)) {
                    Mercurial.LOG.fine("splitAttributes: files in loop");
                    iterator.previous();
                    break;
                }
                commandAttributes.add(filePath);
                fileAdded = true;
            }
            attributes.add(commandAttributes);
        }
        return attributes;
    }

    private static String getPathParameter(VCSFileProxy root, VCSFileProxy file) {
        String filePath;
        String rootPath = root.getPath();
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if ((filePath = file.getPath()).startsWith(rootPath)) {
            filePath = filePath.substring(rootPath.length());
        } else if (!file.exists()) {
            try {
                filePath = VCSFileProxySupport.getCanonicalPath((VCSFileProxy)file);
                if (filePath.startsWith(rootPath)) {
                    filePath = filePath.substring(rootPath.length());
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return filePath;
    }

    static {
        String maxCmdSizeProp = System.getProperty("mercurial.maxCommandlineSize");
        if (maxCmdSizeProp == null) {
            maxCmdSizeProp = "";
        }
        int maxCmdSize = 0;
        try {
            maxCmdSize = Integer.parseInt(maxCmdSizeProp);
        }
        catch (NumberFormatException e) {
            maxCmdSize = 0;
        }
        if (maxCmdSize < 1024) {
            maxCmdSize = Utilities.isMac() ? 64000 : 128000;
        }
        MAX_COMMANDLINE_SIZE = maxCmdSize;
        WORKING_COPY_PARENT_MODIFYING_COMMANDS = new HashSet<String>(Arrays.asList(HG_BACKOUT_CMD, HG_CLONE_CMD, HG_COMMIT_CMD, HG_CREATE_CMD, HG_FETCH_CMD, HG_IMPORT_CMD, HG_MERGE_CMD, HG_PULL_CMD, HG_ROLLBACK_CMD, HG_QCREATE_CMD, HG_QGOTO_CMD, HG_QFINISH_CMD, HG_QPOP_CMD, HG_QPUSH_CMD, HG_QREFRESH_PATCH, HG_REBASE_CMD, HG_STRIP_CMD, HG_TAG_CMD, HG_UNBUNDLE_CMD, HG_UPDATE_ALL_CMD));
        REPOSITORY_NOMODIFICATION_COMMANDS = new HashSet<String>(Arrays.asList(HG_ANNOTATE_CMD, HG_BRANCH_CMD, HG_BRANCHES_CMD, HG_BUNDLE_CMD, HG_CAT_CMD, HG_DIFF_CMD, HG_EXPORT_CMD, HG_HEADS_CMD, HG_INCOMING_CMD, HG_LOG_CMD, HG_OUTGOING_CMD, HG_OUT_CMD, HG_PARENT_CMD, HG_PUSH_CMD, HG_RESOLVE_CMD, HG_QSERIES_CMD, HG_QQUEUE_CMD, HG_STATUS_CMD, HG_TAG_CMD, HG_TAGS_CMD, "tip", HG_VERIFY_CMD, HG_VERSION_CMD, HG_VIEW_CMD));
        doNotAddHgPlain = new ThreadLocal();
        disabledUI = new ThreadLocal();
        loggedRepositories = new HashSet<VCSFileProxy>();
        noLogCommands = new HashSet<String>(Arrays.asList(HG_BRANCH_CMD, HG_BRANCHES_CMD, HG_CAT_CMD, HG_HEADS_CMD, HG_PARENT_CMD, HG_RESOLVE_CMD, HG_STATUS_CMD, HG_DIFF_CMD, HG_TAGS_CMD, HG_VERSION_CMD));
    }

    private static class InterRepositoryCommand {
        protected VCSFileProxy repository;
        protected HgURL remoteUrl;
        protected OutputLogger logger;
        protected String hgCommand = HgCommand.getHgCommand();
        protected String hgCommandType;
        protected String defaultUrl;
        protected boolean acquireCredentialsFirst;
        protected boolean outputDetails = true;
        protected List<String> additionalOptions = new ArrayList<String>();
        protected UserCredentialsSupport credentialsSupport;
        protected boolean showSaveOption;
        protected String[] urlPathProperties = new String[0];
        private PasswordAuthentication credentials;

        private void saveCredentials(String propertyName) {
            try {
                HgModuleConfig.getDefault(this.repository).setProperty(this.repository, propertyName, new HgURL(this.remoteUrl.toHgCommandUrlString(), this.credentials.getUserName(), null).toCompleteUrlString());
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
            catch (IOException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<String> invoke() throws HgException {
            char[] password;
            List list = null;
            boolean retry = true;
            boolean showLoginWindow = !Boolean.TRUE.equals(disabledUI.get());
            this.credentials = null;
            String rawUrl = this.remoteUrl.toUrlStringWithoutUserInfo();
            if (this.remoteUrl.getUsername() != null && this.remoteUrl.getPassword() == null && (password = KeyringSupport.read((String)"versioning.mercurial.url.", (String)this.remoteUrl.toHgCommandStringWithNoPassword())) != null) {
                this.credentials = new PasswordAuthentication(this.remoteUrl.getUsername(), password);
            }
            HgURL url = this.remoteUrl;
            this.credentialsSupport = new UserCredentialsSupport();
            this.credentialsSupport.setShowSaveOption(this.showSaveOption);
            try {
                while (retry) {
                    retry = false;
                    try {
                        if (this.credentials != null) {
                            url = new HgURL(this.remoteUrl.toHgCommandUrlString(), this.credentials.getUserName(), this.credentials.getPassword());
                        }
                    }
                    catch (URISyntaxException ex) {
                        Mercurial.LOG.log(Level.SEVERE, null, ex);
                        return list;
                    }
                    ArrayList<Object> command = new ArrayList<Object>();
                    command.add(this.hgCommand);
                    command.add(this.hgCommandType);
                    for (String s : this.additionalOptions) {
                        command.add(s);
                    }
                    command.add(HgCommand.HG_OPT_REPOSITORY);
                    command.add(this.repository.getPath());
                    command.add(url);
                    String proxy = HgCommand.getGlobalProxyIfNeeded(this.defaultUrl, this.outputDetails, this.logger);
                    if (proxy != null) {
                        ArrayList<String> env = new ArrayList<String>();
                        env.add(HgCommand.HG_PROXY_ENV + proxy);
                        list = HgCommand.execEnv(this.repository, command, env);
                    } else {
                        list = HgCommand.exec(this.repository, command);
                    }
                    if (url != this.remoteUrl) {
                        url.clearPassword();
                    }
                    if (list.isEmpty() || !HgCommand.isErrorAbort(list.get(list.size() - 1)) || HgCommand.HG_PUSH_CMD.equals(this.hgCommandType) && HgCommand.isErrorAbortPush((String)list.get(list.size() - 1))) continue;
                    this.credentials = HgCommand.handleAuthenticationError(list, this.repository, rawUrl, this.credentials == null ? "" : this.credentials.getUserName(), this.credentialsSupport, this.hgCommandType, showLoginWindow);
                    if (this.credentials != null) {
                        retry = true;
                        if (this.credentials == null) continue;
                        try {
                            KeyringSupport.save((String)"versioning.mercurial.url.", (String)new HgURL(this.remoteUrl.toHgCommandUrlString(), this.credentials.getUserName(), null).toHgCommandStringWithNoPassword(), (char[])((char[])this.credentials.getPassword().clone()), null);
                            continue;
                        }
                        catch (URISyntaxException ex) {
                            Mercurial.LOG.log(Level.SEVERE, null, ex);
                            continue;
                        }
                    }
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), this.logger);
                }
                return list;
            }
            finally {
                if (this.credentials != null) {
                    this.savePathProperties();
                    Arrays.fill(this.credentials.getPassword(), '\u0000');
                }
            }
        }

        private void savePathProperties() {
            if (this.credentialsSupport != null && this.credentialsSupport.shallSaveValues()) {
                for (String pathProp : this.urlPathProperties) {
                    this.saveCredentials(pathProp);
                }
            }
        }
    }

    protected static final class CommandParameters {
        private final ArrayList<String> arguments;
        private final String commandName;

        public CommandParameters(String commandName) {
            this.commandName = commandName;
            this.arguments = new ArrayList();
        }

        public CommandParameters add(String parameter) {
            this.arguments.add(parameter);
            return this;
        }

        public CommandParameters addVerboseOption() {
            this.arguments.add(HgCommand.HG_VERBOSE_CMD);
            return this;
        }

        public CommandParameters addConfigOption(String configOption) {
            this.arguments.add(HgCommand.HG_CONFIG_OPTION_CMD);
            this.arguments.add(configOption);
            return this;
        }

        public CommandParameters addRepositoryLocation(String repositoryRootLocation) {
            this.arguments.add(HgCommand.HG_OPT_REPOSITORY);
            this.arguments.add(repositoryRootLocation);
            return this;
        }

        public List<String> toCommand() {
            ArrayList<String> command = new ArrayList<String>(this.arguments.size() + 2);
            command.add(HgCommand.getHgCommand());
            command.add(this.commandName);
            command.addAll(this.arguments);
            return command;
        }
    }
}

