/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.javamodel.JavadocModel;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.view.widget.EditorPaneWidget;
import org.netbeans.modules.websvc.design.view.widget.FlushableWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.netbeans.modules.websvc.design.view.widget.TabWidget;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DescriptionWidget
extends FlushableWidget
implements TabWidget {
    private static RequestProcessor REQUEST_PROCESSOR;
    private MethodModel method;
    private transient JavadocModel model;
    private transient Widget buttons;
    private transient ImageLabelWidget headerLabelWidget;
    private transient Widget tabComponent;
    private transient DescriptionListener listener;

    public DescriptionWidget(ObjectScene scene, MethodModel method) {
        super(scene, 0, 12, 1, BORDER_COLOR);
        this.method = method;
        this.model = method.getJavadoc();
        this.listener = new DescriptionListener();
        this.createContent();
    }

    @Override
    public void flushContent() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doFlush();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DescriptionWidget.this.doFlush();
                }
            });
        }
    }

    @Override
    protected Paint getTitlePaint(Rectangle bounds) {
        return TITLE_COLOR_DESC;
    }

    private void doFlush() {
        if (this.listener.isDirty()) {
            this.listener.setDirty(false);
            this.setJavaDoc(this.listener.getContent());
            this.model = this.method.getJavadoc();
        }
    }

    private void createContent() {
        this.populateContentWidget(this.getContentWidget());
        this.headerLabelWidget = new ImageLabelWidget(this.getScene(), this.getIcon(), this.getTitle());
        this.headerLabelWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)5);
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)4);
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)8));
        this.buttons.addChild((Widget)this.getExpanderWidget());
        this.getHeaderWidget().addChild(this.buttons);
    }

    private void populateContentWidget(Widget parentWidget) {
        EditorPaneWidget descPaneWidget = new EditorPaneWidget(this.getScene(), this.model.getText(), "text/java");
        descPaneWidget.setBorder(BorderFactory.createEmptyBorder((int)1));
        descPaneWidget.setEditable(true);
        descPaneWidget.addDocumentListener(this.listener);
        parentWidget.addChild((Widget)descPaneWidget);
    }

    @Override
    public Object hashKey() {
        return this.model;
    }

    @Override
    public String getTitle() {
        return NbBundle.getMessage(DescriptionWidget.class, (String)"LBL_Description");
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public Widget getComponentWidget() {
        if (this.tabComponent == null) {
            this.tabComponent = this.createContentWidget();
            this.populateContentWidget(this.tabComponent);
        }
        return this.tabComponent;
    }

    private void setJavaDoc(final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (REQUEST_PROCESSOR == null) {
                REQUEST_PROCESSOR = new RequestProcessor(DescriptionWidget.class);
            }
            REQUEST_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    DescriptionWidget.this.setJavaDoc(text);
                }
            });
        } else {
            this.method.setJavadoc(text);
        }
    }

    static class DescriptionListener
    implements DocumentListener {
        private boolean isDirty;
        private String content;

        DescriptionListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.setContent(e);
            this.setDirty(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setContent(e);
            this.setDirty(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setContent(e);
            this.setDirty(true);
        }

        private void setContent(DocumentEvent e) {
            block2: {
                try {
                    this.content = e.getDocument().getText(0, e.getDocument().getLength());
                }
                catch (BadLocationException ex) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }

        private String getContent() {
            return this.content;
        }

        private void setDirty(boolean dirty) {
            this.isDirty = dirty;
        }

        private boolean isDirty() {
            return this.isDirty;
        }
    }
}

