/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend;

import org.clang.basic.CharSourceRange;
import org.clang.basic.ClangGlobals;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.LangOptions;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.StoredDiagnostic;
import org.clang.frontend.impl.DiagnosticRendererStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.PointerUnion;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.raw_svector_ostream;

public abstract class DiagnosticRenderer
implements Destructors.ClassWithDestructor {
    protected LangOptions LangOpts;
    protected IntrusiveRefCntPtr<DiagnosticOptions> DiagOpts;
    protected SourceLocation LastLoc;
    protected SourceLocation LastIncludeLoc;
    protected DiagnosticsEngine.Level LastLevel;

    protected DiagnosticRenderer(LangOptions LangOpts, DiagnosticOptions DiagOpts) {
        this.LangOpts = LangOpts;
        this.DiagOpts = new IntrusiveRefCntPtr((Object)DiagOpts);
        this.LastLoc = new SourceLocation();
        this.LastIncludeLoc = new SourceLocation();
        this.LastLevel = DiagnosticsEngine.Level.Ignored;
    }

    public void $destroy() {
    }

    protected abstract void emitDiagnosticMessage(SourceLocation var1, PresumedLoc var2, DiagnosticsEngine.Level var3, StringRef var4, ArrayRef<CharSourceRange> var5, SourceManager var6, PointerUnion<Diagnostic, StoredDiagnostic> var7);

    protected abstract void emitDiagnosticLoc(SourceLocation var1, PresumedLoc var2, DiagnosticsEngine.Level var3, ArrayRef<CharSourceRange> var4, SourceManager var5);

    private void emitBasicNote(StringRef Message) {
        this.emitDiagnosticMessage(new SourceLocation(), new PresumedLoc(), DiagnosticsEngine.Level.Note, new StringRef(Message), (ArrayRef<CharSourceRange>)ArrayRef.None(), null, (PointerUnion<Diagnostic, StoredDiagnostic>)new PointerUnion());
    }

    protected abstract void emitCodeContext(SourceLocation var1, DiagnosticsEngine.Level var2, SmallVectorImpl<CharSourceRange> var3, ArrayRef<FixItHint> var4, SourceManager var5);

    protected abstract void emitIncludeLocation(SourceLocation var1, PresumedLoc var2, SourceManager var3);

    protected abstract void emitImportLocation(SourceLocation var1, PresumedLoc var2, StringRef var3, SourceManager var4);

    protected abstract void emitBuildingModuleLocation(SourceLocation var1, PresumedLoc var2, StringRef var3, SourceManager var4);

    protected void beginDiagnostic(PointerUnion<Diagnostic, StoredDiagnostic> D, DiagnosticsEngine.Level Level2) {
    }

    protected void endDiagnostic(PointerUnion<Diagnostic, StoredDiagnostic> D, DiagnosticsEngine.Level Level2) {
    }

    private void emitIncludeStack(SourceLocation Loc, PresumedLoc PLoc, DiagnosticsEngine.Level Level2, SourceManager SM) {
        SourceLocation IncludeLoc = PLoc.getIncludeLoc();
        if (ClangGlobals.$eq_SourceLocation((SourceLocation)this.LastIncludeLoc, (SourceLocation)IncludeLoc)) {
            return;
        }
        this.LastIncludeLoc.$assign(IncludeLoc);
        if (!((DiagnosticOptions)this.DiagOpts.$arrow()).ShowNoteIncludeStack && Level2 == DiagnosticsEngine.Level.Note) {
            return;
        }
        if (IncludeLoc.isValid()) {
            this.emitIncludeStackRecursively(IncludeLoc, SM);
        } else {
            this.emitModuleBuildStack(SM);
            this.emitImportStack(Loc, SM);
        }
    }

    private void emitIncludeStackRecursively(SourceLocation Loc, SourceManager SM) {
        if (Loc.isInvalid()) {
            this.emitModuleBuildStack(SM);
            return;
        }
        PresumedLoc PLoc = SM.getPresumedLoc(Loc, ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowPresumedLoc);
        if (PLoc.isInvalid()) {
            return;
        }
        std.pair Imported = SM.getModuleImportLoc(Loc);
        if (((SourceLocation)Imported.first).isValid()) {
            this.emitImportStackRecursively((SourceLocation)Imported.first, (StringRef)Imported.second, SM);
            return;
        }
        this.emitIncludeStackRecursively(PLoc.getIncludeLoc(), SM);
        this.emitIncludeLocation(Loc, PLoc, SM);
    }

    private void emitImportStack(SourceLocation Loc, SourceManager SM) {
        if (Loc.isInvalid()) {
            this.emitModuleBuildStack(SM);
            return;
        }
        std.pair NextImportLoc = SM.getModuleImportLoc(Loc);
        this.emitImportStackRecursively((SourceLocation)NextImportLoc.first, (StringRef)NextImportLoc.second, SM);
    }

    private void emitImportStackRecursively(SourceLocation Loc, StringRef ModuleName, SourceManager SM) {
        if (Loc.isInvalid()) {
            return;
        }
        PresumedLoc PLoc = SM.getPresumedLoc(Loc, ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowPresumedLoc);
        if (PLoc.isInvalid()) {
            return;
        }
        std.pair NextImportLoc = SM.getModuleImportLoc(Loc);
        this.emitImportStackRecursively((SourceLocation)NextImportLoc.first, (StringRef)NextImportLoc.second, SM);
        this.emitImportLocation(Loc, PLoc, ModuleName, SM);
    }

    private void emitModuleBuildStack(SourceManager SM) {
        ArrayRef Stack = SM.getModuleBuildStack();
        int N = Stack.size();
        for (int I = 0; I != N; ++I) {
            SourceManager CurSM = ((FullSourceLoc)((std.pair)Stack.$at((int)I)).second).getManager();
            SourceLocation CurLoc = (SourceLocation)((std.pair)Stack.$at((int)I)).second;
            this.emitBuildingModuleLocation(CurLoc, CurSM.getPresumedLoc(CurLoc, ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowPresumedLoc), new StringRef((std.string)((std.pair)Stack.$at((int)I)).first), CurSM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitCaret(SourceLocation Loc, DiagnosticsEngine.Level Level2, ArrayRef<CharSourceRange> Ranges, ArrayRef<FixItHint> Hints, SourceManager SM) {
        SmallVector SpellingRanges = null;
        try {
            SpellingRanges = new SmallVector(4, (Object)new CharSourceRange());
            DiagnosticRendererStatics.mapDiagnosticRanges(Loc, Ranges, (SmallVectorImpl<CharSourceRange>)SpellingRanges, SM);
            this.emitCodeContext(Loc, Level2, (SmallVectorImpl<CharSourceRange>)SpellingRanges, Hints, SM);
        }
        finally {
            if (SpellingRanges != null) {
                SpellingRanges.$destroy();
            }
        }
    }

    private void emitMacroExpansions(SourceLocation Loc, DiagnosticsEngine.Level Level2, ArrayRef<CharSourceRange> Ranges, ArrayRef<FixItHint> Hints, SourceManager SM, uint.ref MacroDepth) {
        this.emitMacroExpansions(Loc, Level2, Ranges, Hints, SM, MacroDepth, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitMacroExpansions(SourceLocation Loc, DiagnosticsEngine.Level Level2, ArrayRef<CharSourceRange> Ranges, ArrayRef<FixItHint> Hints, SourceManager SM, uint.ref MacroDepth, long OnMacroInst) {
        SmallVector SpellingRanges = null;
        raw_svector_ostream Message = null;
        try {
            boolean Suppressed;
            assert (!Loc.isInvalid()) : "must have a valid source location here";
            SourceLocation OneLevelUp = SM.getImmediateMacroCallerLoc(Loc);
            if (OneLevelUp.isMacroID()) {
                this.emitMacroExpansions(OneLevelUp, Level2, Ranges, Hints, SM, MacroDepth, OnMacroInst + 1L);
            } else {
                MacroDepth.$set(OnMacroInst + 1L);
            }
            long MacroSkipStart = 0L;
            long MacroSkipEnd = 0L;
            if (MacroDepth.$deref() > (long)((DiagnosticOptions)this.DiagOpts.$arrow()).MacroBacktraceLimit && ((DiagnosticOptions)this.DiagOpts.$arrow()).MacroBacktraceLimit != 0) {
                MacroSkipStart = ((DiagnosticOptions)this.DiagOpts.$arrow()).MacroBacktraceLimit / 2 + ((DiagnosticOptions)this.DiagOpts.$arrow()).MacroBacktraceLimit % 2;
                MacroSkipEnd = MacroDepth.$deref() - (long)(((DiagnosticOptions)this.DiagOpts.$arrow()).MacroBacktraceLimit / 2);
            }
            boolean bl = Suppressed = OnMacroInst >= MacroSkipStart && OnMacroInst < MacroSkipEnd;
            if (Suppressed) {
                if (OnMacroInst == MacroSkipStart) {
                    raw_svector_ostream _Message = null;
                    try {
                        SmallString MessageStorage = new SmallString(200);
                        _Message = new raw_svector_ostream(MessageStorage);
                        _Message.$out((CharSequence)"(skipping ").$out(MacroSkipEnd - MacroSkipStart).$out((CharSequence)" expansions in backtrace; use -fmacro-backtrace-limit=0 to see all)");
                        this.emitBasicNote(_Message.str());
                    }
                    finally {
                        if (_Message != null) {
                            _Message.$destroy();
                        }
                    }
                }
                return;
            }
            SourceLocation SpellingLoc = new SourceLocation(Loc);
            if (SM.isMacroArgExpansion(Loc)) {
                SpellingLoc.$assign((SourceLocation)SM.getImmediateExpansionRange((SourceLocation)Loc).first);
            }
            SpellingLoc.$assign(SM.getSpellingLoc(SpellingLoc));
            SpellingRanges = new SmallVector(4, (Object)new CharSourceRange());
            DiagnosticRendererStatics.mapDiagnosticRanges(Loc, Ranges, (SmallVectorImpl<CharSourceRange>)SpellingRanges, SM);
            SmallString MessageStorage = new SmallString(100);
            Message = new raw_svector_ostream(MessageStorage);
            StringRef MacroName = DiagnosticRendererStatics.getImmediateMacroName(Loc, SM, this.LangOpts);
            if (MacroName.empty()) {
                Message.$out((CharSequence)"expanded from here");
            } else {
                Message.$out((CharSequence)"expanded from macro '").$out(MacroName).$out((CharSequence)"'");
            }
            this.emitDiagnostic(SpellingLoc, DiagnosticsEngine.Level.Note, Message.str(), (ArrayRef<CharSourceRange>)new ArrayRef((SmallVectorImpl)SpellingRanges), (ArrayRef<FixItHint>)ArrayRef.None(), SM);
        }
        finally {
            if (Message != null) {
                Message.$destroy();
            }
            if (SpellingRanges != null) {
                SpellingRanges.$destroy();
            }
        }
    }

    public void emitDiagnostic(SourceLocation Loc, DiagnosticsEngine.Level Level2, StringRef Message, ArrayRef<CharSourceRange> Ranges, ArrayRef<FixItHint> FixItHints, SourceManager SM) {
        this.emitDiagnostic(Loc, Level2, Message, Ranges, FixItHints, SM, (PointerUnion<Diagnostic, StoredDiagnostic>)new PointerUnion(Diagnostic.class, StoredDiagnostic.class, (Object)null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emitDiagnostic(SourceLocation Loc, DiagnosticsEngine.Level Level2, StringRef Message, ArrayRef<CharSourceRange> Ranges, ArrayRef<FixItHint> FixItHints, SourceManager SM, PointerUnion<Diagnostic, StoredDiagnostic> D) {
        assert (SM != null || Loc.isInvalid());
        this.beginDiagnostic(D, Level2);
        if (!Loc.isValid()) {
            this.emitDiagnosticMessage(Loc, new PresumedLoc(), Level2, Message, Ranges, SM, D);
        } else {
            SmallVector MutableRanges = null;
            SmallVector MergedFixits = null;
            try {
                MutableRanges = new SmallVector(20, (type.iterator)Ranges.begin(), (type.iterator)Ranges.end(), (Object)new CharSourceRange());
                MergedFixits = new SmallVector(8, (Object)new FixItHint());
                if (!FixItHints.empty()) {
                    DiagnosticRendererStatics.mergeFixits(FixItHints, SM, this.LangOpts, (SmallVectorImpl<FixItHint>)MergedFixits);
                    FixItHints.$assign(new ArrayRef((SmallVectorImpl)MergedFixits));
                }
                type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)FixItHints.begin());
                type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)FixItHints.end());
                while (I.$noteq((Object)E)) {
                    if (((FixItHint)I.$star()).RemoveRange.isValid()) {
                        MutableRanges.push_back((Object)((FixItHint)I.$star()).RemoveRange);
                    }
                    I.$preInc();
                }
                SourceLocation UnexpandedLoc = new SourceLocation(Loc);
                Loc.$assign(SM.getFileLoc(Loc));
                PresumedLoc PLoc = SM.getPresumedLoc(Loc, ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowPresumedLoc);
                this.emitIncludeStack(Loc, PLoc, Level2, SM);
                this.emitDiagnosticMessage(Loc, PLoc, Level2, Message, Ranges, SM, D);
                this.emitCaret(Loc, Level2, (ArrayRef<CharSourceRange>)new ArrayRef((SmallVectorImpl)MutableRanges), FixItHints, SM);
                if (UnexpandedLoc.isValid() && UnexpandedLoc.isMacroID()) {
                    uint.ref MacroDepth = NativePointer.create_uint$ref((long)0L);
                    this.emitMacroExpansions(UnexpandedLoc, Level2, (ArrayRef<CharSourceRange>)new ArrayRef((SmallVectorImpl)MutableRanges), FixItHints, SM, MacroDepth);
                }
            }
            finally {
                if (MergedFixits != null) {
                    MergedFixits.$destroy();
                }
                if (MutableRanges != null) {
                    MutableRanges.$destroy();
                }
            }
        }
        this.LastLoc.$assign(Loc);
        this.LastLevel = Level2;
        this.endDiagnostic(D, Level2);
    }

    public void emitStoredDiagnostic(StoredDiagnostic Diag) {
        this.emitDiagnostic((SourceLocation)Diag.getLocation(), Diag.getLevel(), Diag.getMessage(), (ArrayRef<CharSourceRange>)Diag.getRanges(), (ArrayRef<FixItHint>)Diag.getFixIts(), Diag.getLocation().isValid() ? Diag.getLocation().getManager() : null, (PointerUnion<Diagnostic, StoredDiagnostic>)new PointerUnion(Diagnostic.class, StoredDiagnostic.class, (Object)Diag));
    }
}

