/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend;

import org.clang.basic.DenseMapInfoFileID;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticConsumer;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.spi.PreprocessorImplementation;
import org.clang.frontend.TextDiagnosticBuffer;
import org.clang.frontend.impl.RegexDirective;
import org.clang.frontend.impl.StandardDirective;
import org.clang.frontend.impl.VerifyDiagnosticConsumerStatics;
import org.clang.frontend.impl.VerifyFileTracker;
import org.clang.lex.CommentHandler;
import org.clang.lex.HeaderSearch;
import org.clang.lex.Preprocessor;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.support.Regex;
import org.llvm.support.llvm;

public class VerifyDiagnosticConsumer
extends DiagnosticConsumer
implements CommentHandler,
Destructors.ClassWithDestructor {
    private DiagnosticsEngine Diags;
    private DiagnosticConsumer PrimaryClient;
    private std_ptr.unique_ptr<DiagnosticConsumer> PrimaryClientOwner;
    private std_ptr.unique_ptr<TextDiagnosticBuffer> Buffer;
    private Preprocessor CurrentPreprocessor;
    private LangOptions LangOpts;
    private SourceManager SrcManager;
    private long ActiveSourceFiles;
    private type.ref<DirectiveStatus> Status;
    private ExpectedData ED;
    private DenseMap<FileID, FileEntry> ParsedFiles;
    private DenseMap<FileID, UnparsedFileStatus> UnparsedFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CheckDiagnostics() {
        std_ptr.unique_ptr Owner = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            DiagnosticConsumer CurClient = this.Diags.getClient();
            Owner = this.Diags.takeClient();
            this.Diags.setClient(this.PrimaryClient, false);
            if (this.UnparsedFiles.size() > 0) {
                SmallPtrSet ParsedFileCache = null;
                try {
                    ParsedFileCache = new SmallPtrSet(FileEntry.DenseMapInfo, 8);
                    DenseMapIterator I = (DenseMapIterator)Native.$tryClone((NativeCloneable)this.ParsedFiles.begin());
                    DenseMapIterator End = (DenseMapIterator)Native.$tryClone((NativeCloneable)this.ParsedFiles.end());
                    while (I.$noteq(End)) {
                        FileEntry FE = (FileEntry)I.$star().second;
                        if (FE != null) {
                            ParsedFileCache.insert((Object)FE);
                        }
                        I.$preInc();
                    }
                    I = (DenseMapIterator)Native.$tryClone((NativeCloneable)this.UnparsedFiles.begin());
                    End = (DenseMapIterator)Native.$tryClone((NativeCloneable)this.UnparsedFiles.end());
                    while (I.$noteq(End)) {
                        UnparsedFileStatus Status = (UnparsedFileStatus)I.$star().second;
                        FileEntry FE = Status.getFile();
                        if ((FE == null || !ParsedFileCache.count((Object)FE)) && Status.foundDirectives()) {
                            llvm.report_fatal_error((Twine)new Twine(NativePointer.$((String)"-verify directives found after rather than during normal parsing of "), new StringRef(FE != null ? FE.getName() : NativePointer.$((String)"(unknown)"))));
                        }
                        I.$preInc();
                    }
                    this.UnparsedFiles.clear();
                }
                finally {
                    if (ParsedFileCache != null) {
                        ParsedFileCache.$destroy();
                    }
                }
            }
            if (this.SrcManager != null) {
                if (this.Status.$deref() == DirectiveStatus.HasNoDirectives) {
                    $c.clean((Object)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(450L))).setForceEmit());
                    ++this.NumErrors;
                    this.Status.$set((Object)DirectiveStatus.HasNoDirectivesReported);
                }
                this.NumErrors = (int)((long)this.NumErrors + VerifyDiagnosticConsumerStatics.CheckResults(this.Diags, this.SrcManager, (TextDiagnosticBuffer)((Object)this.Buffer.$star()), this.ED));
            } else {
                this.NumErrors = (int)((long)this.NumErrors + (VerifyDiagnosticConsumerStatics.PrintUnexpected(this.Diags, null, ((TextDiagnosticBuffer)((Object)this.Buffer.$arrow())).err_begin(), ((TextDiagnosticBuffer)((Object)this.Buffer.$arrow())).err_end(), NativePointer.$((String)"error")) + VerifyDiagnosticConsumerStatics.PrintUnexpected(this.Diags, null, ((TextDiagnosticBuffer)((Object)this.Buffer.$arrow())).warn_begin(), ((TextDiagnosticBuffer)((Object)this.Buffer.$arrow())).warn_end(), NativePointer.$((String)"warn")) + VerifyDiagnosticConsumerStatics.PrintUnexpected(this.Diags, null, ((TextDiagnosticBuffer)((Object)this.Buffer.$arrow())).note_begin(), ((TextDiagnosticBuffer)((Object)this.Buffer.$arrow())).note_end(), NativePointer.$((String)"note"))));
            }
            this.Diags.setClient(CurClient, Owner.release() != null);
            this.Buffer.reset((Object)new TextDiagnosticBuffer());
            this.ED.Reset();
        }
        finally {
            if (Owner != null) {
                Owner.$destroy();
            }
            $c.$destroy();
        }
    }

    private void setSourceManager(SourceManager SM) {
        assert (this.SrcManager == null || this.SrcManager == SM) : "SourceManager changed!";
        this.SrcManager = SM;
    }

    public VerifyDiagnosticConsumer(DiagnosticsEngine Diags_) {
        this.Diags = Diags_;
        this.PrimaryClient = this.Diags.getClient();
        this.PrimaryClientOwner = this.Diags.takeClient();
        this.Buffer = new std_ptr.unique_ptr((Object)new TextDiagnosticBuffer());
        this.CurrentPreprocessor = null;
        this.LangOpts = null;
        this.SrcManager = null;
        this.ActiveSourceFiles = 0L;
        this.Status = NativePointer.create_type$ref((Object)((Object)DirectiveStatus.HasNoDirectives));
        this.ED = new ExpectedData();
        this.ParsedFiles = new DenseMap((DenseMapInfo)new DenseMapInfoFileID(), null);
        this.UnparsedFiles = new DenseMap((DenseMapInfo)new DenseMapInfoFileID(), null);
        if (this.Diags.hasSourceManager()) {
            this.setSourceManager(this.Diags.getSourceManager());
        }
    }

    public void $destroy() {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            assert (this.ActiveSourceFiles == 0L) : "Incomplete parsing of source files!";
            assert (this.CurrentPreprocessor == null) : "CurrentPreprocessor should be invalid!";
            this.SrcManager = null;
            this.CheckDiagnostics();
            $c.clean($c.track(this.Diags.takeClient()).release());
        }
        finally {
            $c.$destroy();
        }
        this.UnparsedFiles.$destroy();
        this.ParsedFiles.$destroy();
        this.ED.$destroy();
        this.Buffer.$destroy();
        this.PrimaryClientOwner.$destroy();
        super.$destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BeginSourceFile(LangOptions LangOpts, PreprocessorImplementation PP) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            if (++this.ActiveSourceFiles == 1L && PP != null) {
                this.CurrentPreprocessor = (Preprocessor)PP;
                this.LangOpts = LangOpts;
                this.setSourceManager(((Preprocessor)PP).getSourceManager());
                ((Preprocessor)PP).addCommentHandler((CommentHandler)this);
                ((Preprocessor)PP).addPPCallbacks($c.track(new std_ptr.unique_ptr($c.track(llvm.make_unique((Object)((Object)new VerifyFileTracker(this, this.SrcManager)))))));
                $c.clean();
            }
            assert (PP == null || this.CurrentPreprocessor == PP) : "Preprocessor changed!";
            this.PrimaryClient.BeginSourceFile(LangOpts, PP);
        }
        finally {
            $c.$destroy();
        }
    }

    public void EndSourceFile() {
        assert (this.ActiveSourceFiles != 0L) : "No active source files!";
        this.PrimaryClient.EndSourceFile();
        if (--this.ActiveSourceFiles == 0L) {
            if (this.CurrentPreprocessor != null) {
                this.CurrentPreprocessor.removeCommentHandler((CommentHandler)this);
            }
            this.CheckDiagnostics();
            this.CurrentPreprocessor = null;
            this.LangOpts = null;
        }
    }

    public void UpdateParsedFileStatus(SourceManager SM, FileID FID, ParsedStatus PS) {
        this.setSourceManager(SM);
        if (FID.isInvalid()) {
            return;
        }
        FileEntry FE = SM.getFileEntryForID(new FileID(FID));
        if (PS == ParsedStatus.IsParsed) {
            this.UnparsedFiles.erase((Object)FID);
            this.ParsedFiles.insert(std.make_pair((Object)FID, (Object)FE));
        } else if (!this.ParsedFiles.count((Object)FID) && !this.UnparsedFiles.count((Object)FID)) {
            boolean FoundDirectives = PS == ParsedStatus.IsUnparsedNoDirectives ? false : this.LangOpts == null || VerifyDiagnosticConsumerStatics.findDirectives(SM, new FileID(FID), this.LangOpts);
            this.UnparsedFiles.insert(std.make_pair((Object)FID, (Object)new UnparsedFileStatus(FE, FoundDirectives)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean HandleComment(Preprocessor PP, SourceRange Comment) {
        std.string C2 = null;
        try {
            SourceManager SM = PP.getSourceManager();
            if (this.SrcManager != null && SM != this.SrcManager) {
                boolean bl = false;
                return bl;
            }
            SourceLocation CommentBegin = Comment.getBegin();
            char.ptr CommentRaw = Native.$tryClone((char.ptr)SM.getCharacterData(new SourceLocation(CommentBegin)));
            StringRef C = new StringRef(CommentRaw, SM.getCharacterData(Comment.getEnd()).$sub((abstract_iterator)CommentRaw));
            if (C.empty()) {
                boolean bl = false;
                return bl;
            }
            int loc = C.find(NativePointer.$((char)'\\'));
            if (loc == StringRef.npos) {
                VerifyDiagnosticConsumerStatics.ParseDirective(new StringRef(C), this.ED, SM, PP, new SourceLocation(CommentBegin), this.Status);
                boolean bl = false;
                return bl;
            }
            C2 = new std.string();
            C2.reserve(C.size());
            int last = 0;
            while (true) {
                if (loc == StringRef.npos || loc == C.size()) break;
                llvm.$addassign_str_StringRef((std.string)C2, (StringRef)C.substr(last, loc - last));
                last = loc + 1;
                if (C.$at(last) == NativePointer.$((char)'\n') || C.$at(last) == NativePointer.$((char)'\r')) {
                    if (++last < C.size() && (C.$at(last) == NativePointer.$((char)'\n') || C.$at(last) == NativePointer.$((char)'\r')) && C.$at(last) != C.$at(last - 1)) {
                        ++last;
                    }
                } else {
                    C2.$addassign(NativePointer.$((char)'\\'));
                }
                loc = C.find(NativePointer.$((char)'\\'), last);
            }
            llvm.$addassign_str_StringRef((std.string)C2, (StringRef)C.substr(last));
            if (!C2.empty()) {
                VerifyDiagnosticConsumerStatics.ParseDirective(new StringRef(C2), this.ED, SM, PP, new SourceLocation(CommentBegin), this.Status);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (C2 != null) {
                C2.$destroy();
            }
        }
    }

    public void HandleDiagnostic(DiagnosticsEngine.Level DiagLevel, Diagnostic Info) {
        SourceLocation Loc;
        if (Info.hasSourceManager()) {
            if (this.SrcManager != null && Info.getSourceManager() != this.SrcManager) {
                return;
            }
            this.setSourceManager(Info.getSourceManager());
        }
        if (this.SrcManager != null && (Loc = new SourceLocation(Info.getLocation())).isValid()) {
            HeaderSearch HS;
            ParsedStatus PS = ParsedStatus.IsUnparsed;
            Loc.$assignMove(this.SrcManager.getExpansionLoc(new SourceLocation(Loc)));
            FileID FID = this.SrcManager.getFileID(new SourceLocation(Loc));
            FileEntry FE = this.SrcManager.getFileEntryForID(new FileID(FID));
            if (FE != null && this.CurrentPreprocessor != null && this.SrcManager.isLoadedFileID(new FileID(FID)) && (HS = this.CurrentPreprocessor.getHeaderSearchInfo()).findModuleForHeader(FE).$boolean()) {
                PS = ParsedStatus.IsUnparsedNoDirectives;
            }
            this.UpdateParsedFileStatus(this.SrcManager, new FileID(FID), PS);
        }
        ((TextDiagnosticBuffer)((Object)this.Buffer.$arrow())).HandleDiagnostic(DiagLevel, Info);
    }

    public static final class ParsedStatus
    extends Enum<ParsedStatus> {
        public static final /* enum */ ParsedStatus IsParsed = new ParsedStatus(0L);
        public static final /* enum */ ParsedStatus IsUnparsed = new ParsedStatus(IsParsed.getValue() + 1);
        public static final /* enum */ ParsedStatus IsUnparsedNoDirectives = new ParsedStatus(IsUnparsed.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ParsedStatus[] $VALUES;

        public static ParsedStatus[] values() {
            return (ParsedStatus[])$VALUES.clone();
        }

        public static ParsedStatus valueOf(String name) {
            return Enum.valueOf(ParsedStatus.class, name);
        }

        public static ParsedStatus valueOf(int val) {
            ParsedStatus out;
            ParsedStatus parsedStatus = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private ParsedStatus(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new ParsedStatus[]{IsParsed, IsUnparsed, IsUnparsedNoDirectives};
        }

        private static final class Values {
            private static final ParsedStatus[] VALUES;
            private static final ParsedStatus[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ParsedStatus kind : ParsedStatus.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ParsedStatus[min < 0 ? 1 - min : 0];
                VALUES = new ParsedStatus[max >= 0 ? 1 + max : 0];
                for (ParsedStatus kind : ParsedStatus.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ParsedStatus)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ParsedStatus)kind).value] = kind;
                }
            }
        }
    }

    private static class UnparsedFileStatus {
        private ADTAliases.PointerInt2Pair<FileEntry> Data;

        public UnparsedFileStatus(FileEntry File, boolean FoundDirectives) {
            this.Data = new ADTAliases.PointerInt2Pair((Object)File, FoundDirectives);
        }

        public FileEntry getFile() {
            return (FileEntry)this.Data.getPointer();
        }

        public boolean foundDirectives() {
            return this.Data.getInt() != 0;
        }

        public UnparsedFileStatus(UnparsedFileStatus $Prm0) {
            this.Data = new ADTAliases.PointerInt2Pair($Prm0.Data);
        }

        public String toString() {
            return "Data=" + this.Data;
        }
    }

    public static final class DirectiveStatus
    extends Enum<DirectiveStatus> {
        public static final /* enum */ DirectiveStatus HasNoDirectives = new DirectiveStatus(0L);
        public static final /* enum */ DirectiveStatus HasNoDirectivesReported = new DirectiveStatus(HasNoDirectives.getValue() + 1);
        public static final /* enum */ DirectiveStatus HasExpectedNoDiagnostics = new DirectiveStatus(HasNoDirectivesReported.getValue() + 1);
        public static final /* enum */ DirectiveStatus HasOtherExpectedDirectives = new DirectiveStatus(HasExpectedNoDiagnostics.getValue() + 1);
        private final int value;
        private static final /* synthetic */ DirectiveStatus[] $VALUES;

        public static DirectiveStatus[] values() {
            return (DirectiveStatus[])$VALUES.clone();
        }

        public static DirectiveStatus valueOf(String name) {
            return Enum.valueOf(DirectiveStatus.class, name);
        }

        public static DirectiveStatus valueOf(int val) {
            DirectiveStatus out;
            DirectiveStatus directiveStatus = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private DirectiveStatus(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new DirectiveStatus[]{HasNoDirectives, HasNoDirectivesReported, HasExpectedNoDiagnostics, HasOtherExpectedDirectives};
        }

        private static final class Values {
            private static final DirectiveStatus[] VALUES;
            private static final DirectiveStatus[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (DirectiveStatus kind : DirectiveStatus.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new DirectiveStatus[min < 0 ? 1 - min : 0];
                VALUES = new DirectiveStatus[max >= 0 ? 1 + max : 0];
                for (DirectiveStatus kind : DirectiveStatus.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((DirectiveStatus)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((DirectiveStatus)kind).value] = kind;
                }
            }
        }
    }

    public static class ExpectedData
    implements Destructors.ClassWithDestructor {
        public std.vector<std_ptr.unique_ptr<Directive>> Errors = new std.vector((Object)null);
        public std.vector<std_ptr.unique_ptr<Directive>> Warnings = new std.vector((Object)null);
        public std.vector<std_ptr.unique_ptr<Directive>> Remarks = new std.vector((Object)null);
        public std.vector<std_ptr.unique_ptr<Directive>> Notes = new std.vector((Object)null);

        public void Reset() {
            this.Errors.clear();
            this.Warnings.clear();
            this.Remarks.clear();
            this.Notes.clear();
        }

        public void $destroy() {
            this.Notes.$destroy();
            this.Remarks.$destroy();
            this.Warnings.$destroy();
            this.Errors.$destroy();
        }

        public String toString() {
            return "Errors=" + this.Errors + ", Warnings=" + this.Warnings + ", Remarks=" + this.Remarks + ", Notes=" + this.Notes;
        }
    }

    public static abstract class Directive
    implements Destructors.ClassWithDestructor {
        public static long MaxCount = 0xFFFFFFFFL;
        public SourceLocation DirectiveLoc;
        public SourceLocation DiagnosticLoc;
        public std.string Text;
        public long Min;
        public long Max;
        public boolean MatchAnyLine;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static std_ptr.unique_ptr<Directive> create(boolean RegexKind, SourceLocation DirectiveLoc, SourceLocation DiagnosticLoc, boolean MatchAnyLine, StringRef Text, long Min, long Max) {
            std.string RegexStr = null;
            JavaCleaner $c = Native.$createJavaCleaner();
            try {
                if (!RegexKind) {
                    std_ptr.unique_ptr unique_ptr2 = (std_ptr.unique_ptr)$c.clean((Object)new std_ptr.unique_ptr($c.track(llvm.make_unique((Object)new StandardDirective(DirectiveLoc, DiagnosticLoc, MatchAnyLine, Text, Min, Max)))));
                    return unique_ptr2;
                }
                RegexStr = new std.string();
                StringRef S = new StringRef(Text);
                while (!S.empty()) {
                    if (S.startswith((CharSequence)"{{")) {
                        S.$assignMove(S.drop_front(2));
                        int RegexMatchLength = S.find((CharSequence)"}}");
                        assert (RegexMatchLength != StringRef.npos);
                        RegexStr.$addassign(NativePointer.$((String)"("));
                        RegexStr.append((char.iterator)S.data(), RegexMatchLength);
                        RegexStr.$addassign(NativePointer.$((String)")"));
                        S.$assignMove(S.drop_front(RegexMatchLength + 2));
                        continue;
                    }
                    int VerbatimMatchLength = S.find((CharSequence)"{{");
                    if (VerbatimMatchLength == StringRef.npos) {
                        VerbatimMatchLength = S.size();
                    }
                    $c.clean((Object)RegexStr.$addassign((std.string)$c.track((Object)Regex.escape((StringRef)S.substr(0, VerbatimMatchLength)))));
                    S.$assignMove(S.drop_front(VerbatimMatchLength));
                }
                std_ptr.unique_ptr unique_ptr3 = (std_ptr.unique_ptr)$c.clean((Object)new std_ptr.unique_ptr($c.track(llvm.make_unique((Object)new RegexDirective(DirectiveLoc, DiagnosticLoc, MatchAnyLine, Text, Min, Max, new StringRef(RegexStr))))));
                return unique_ptr3;
            }
            finally {
                if (RegexStr != null) {
                    RegexStr.$destroy();
                }
                $c.$destroy();
            }
        }

        public void $destroy() {
            this.Text.$destroy();
        }

        public abstract boolean isValid(std.string var1);

        public abstract boolean match(StringRef var1);

        protected Directive(SourceLocation DirectiveLoc, SourceLocation DiagnosticLoc, boolean MatchAnyLine, StringRef Text, long Min, long Max) {
            this.DirectiveLoc = new SourceLocation(DirectiveLoc);
            this.DiagnosticLoc = new SourceLocation(DiagnosticLoc);
            this.Text = Text.$basic_string();
            this.Min = Min;
            this.Max = Max;
            this.MatchAnyLine = MatchAnyLine;
            assert (!DirectiveLoc.isInvalid()) : "DirectiveLoc is invalid!";
            assert (!DiagnosticLoc.isInvalid()) : "DiagnosticLoc is invalid!";
        }

        private Directive(Directive $Prm0) {
            throw new UnsupportedOperationException("Deleted");
        }

        private void $assign(Directive $Prm0) {
            throw new UnsupportedOperationException("Deleted");
        }

        public String toString() {
            return "DirectiveLoc=" + this.DirectiveLoc + ", DiagnosticLoc=" + this.DiagnosticLoc + ", Text=" + this.Text + ", Min=" + this.Min + ", Max=" + this.Max + ", MatchAnyLine=" + this.MatchAnyLine;
        }
    }
}

