/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.CharSourceRange;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.frontend.DependencyCollector;
import org.clang.lex.PPCallbacks;
import org.clang.lex.Token;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.support.sys.path;

public class DepCollectorPPCallbacks
extends PPCallbacks
implements Destructors.ClassWithDestructor {
    public DependencyCollector DepCollector;
    public SourceManager SM;

    public DepCollectorPPCallbacks(DependencyCollector L, SourceManager SM) {
        this.DepCollector = L;
        this.SM = SM;
    }

    public void FileChanged(SourceLocation Loc, PPCallbacks.FileChangeReason Reason, SrcMgr.CharacteristicKind FileType, FileID PrevFID) {
        if (Reason != PPCallbacks.FileChangeReason.EnterFile) {
            return;
        }
        FileEntry FE = this.SM.getFileEntryForID(this.SM.getFileID(this.SM.getExpansionLoc(new SourceLocation(Loc))));
        if (FE == null) {
            return;
        }
        StringRef Filename = new StringRef(FE.getName());
        while (Filename.size() > 2 && Filename.$at(0) == NativePointer.$((char)'.') && path.is_separator((byte)Filename.$at(1))) {
            Filename = new StringRef(Filename.substr(1));
            while (path.is_separator((byte)Filename.$at(0))) {
                Filename = new StringRef(Filename.substr(1));
            }
        }
        this.DepCollector.maybeAddDependency(new StringRef(Filename), false, FileType != SrcMgr.CharacteristicKind.C_User, false, false);
    }

    public void InclusionDirective(SourceLocation HashLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange, FileEntry File, StringRef SearchPath, StringRef RelativePath, Module Imported) {
        if (File == null) {
            this.DepCollector.maybeAddDependency(new StringRef(FileName), false, false, false, true);
        }
    }

    public void EndOfMainFile() {
        this.DepCollector.finishedMainFile();
    }

    public void $destroy() {
        super.$destroy();
    }

    public String toString() {
        return "DepCollector=" + this.DepCollector + ", SM=" + this.SM + super.toString();
    }
}

