/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.hibernate.completion.HibernateCompletionDocumentation;
import org.netbeans.modules.hibernate.editor.HibernateEditorUtil;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public abstract class HibernateCompletionItem
implements CompletionItem {
    protected int substitutionOffset;
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";

    public static HibernateCompletionItem createAttribValueItem(int substitutionOffset, String displayText, String docText) {
        return new AttribValueItem(substitutionOffset, displayText, docText);
    }

    public static HibernateCompletionItem createPackageItem(int substitutionOffset, String packageName, boolean deprecated) {
        return new PackageItem(substitutionOffset, packageName, deprecated);
    }

    public static HibernateCompletionItem createTypeItem(int substitutionOffset, TypeElement elem, ElementHandle<TypeElement> elemHandle, boolean deprecated, boolean smartItem) {
        return new ClassItem(substitutionOffset, elem, elemHandle, deprecated, smartItem);
    }

    public static HibernateCompletionItem createClassPropertyItem(int substitutionOffset, VariableElement variableElem, ElementHandle<VariableElement> elemHandle, boolean deprecated) {
        return new ClassPropertyItem(substitutionOffset, variableElem, elemHandle, deprecated);
    }

    public static HibernateCompletionItem createDatabaseTableItem(int substitutionOffset, String name) {
        return new DatabaseTableItem(substitutionOffset, name);
    }

    public static HibernateCompletionItem createDatabaseColumnItem(int substitutionOffset, String name, boolean pk) {
        return new DatabaseColumnItem(substitutionOffset, name, pk);
    }

    public static HibernateCompletionItem createCascadeStyleItem(int substitutionOffset, String displayText, String docText) {
        return new CascadeStyleItem(substitutionOffset, displayText, docText);
    }

    public static HibernateCompletionItem createHbMappingFileItem(int substitutionOffset, String displayText) {
        return new HbMappingFileItem(substitutionOffset, displayText);
    }

    public static HibernateCompletionItem createHbPropertyValueItem(int substitutionOffset, String displayText) {
        return new HbPropertyValueItem(substitutionOffset, displayText);
    }

    protected HibernateCompletionItem(int substitutionOffset) {
        this.substitutionOffset = substitutionOffset;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        CharSequence prefix = this.getInsertPrefix();
        String text = prefix.toString();
        if (toAdd != null) {
            text = text + toAdd;
        }
        doc.atomicLock();
        try {
            Position position = doc.createPosition(offset);
            doc.remove(offset, len);
            doc.insertString(position.getOffset(), text.toString(), null);
        }
        catch (BadLocationException ble) {
        }
        finally {
            doc.atomicUnlock();
        }
    }

    protected CharSequence getSubstitutionText() {
        return this.getInsertPrefix();
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected ImageIcon getIcon() {
        return null;
    }

    public abstract String getDisplayText();

    public static int getImportanceLevel(String fqn) {
        int weight = 50;
        if (fqn.startsWith("java.lang") || fqn.startsWith("java.util")) {
            weight -= 10;
        } else if (fqn.startsWith("org.omg") || fqn.startsWith("org.apache")) {
            weight += 10;
        } else if (fqn.startsWith("com.sun") || fqn.startsWith("com.ibm") || fqn.startsWith("com.apple")) {
            weight += 20;
        } else if (fqn.startsWith("sun") || fqn.startsWith("sunw") || fqn.startsWith("netscape")) {
            weight += 30;
        }
        return weight;
    }

    public static CharSequence getElementName(Element el, boolean fqn) {
        if (el == null || el.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(el, fqn);
    }

    private static class ElementNameVisitor
    extends SimpleElementVisitor6<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitPackage(PackageElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }
    }

    private static class HbPropertyValueItem
    extends HibernateCompletionItem {
        private String displayText;

        public HbPropertyValueItem(int substitutionOffset, String displayText) {
            super(substitutionOffset);
            this.displayText = displayText;
        }

        public int getSortPriority() {
            if (this.displayText.startsWith("--")) {
                return 101;
            }
            if (this.displayText.equals("true")) {
                return 98;
            }
            if (this.displayText.equals("false")) {
                return 99;
            }
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }
    }

    private static class HbMappingFileItem
    extends HibernateCompletionItem {
        private static final String HB_MAPPING_ICON = "org/netbeans/modules/hibernate/resources/hibernate-mapping.png";
        private String displayText;

        public HbMappingFileItem(int substitutionOffset, String displayText) {
            super(substitutionOffset);
            this.displayText = displayText;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)HB_MAPPING_ICON, (boolean)false);
        }
    }

    private static class CascadeStyleItem
    extends HibernateCompletionItem {
        private String displayText;
        private String docText;

        public CascadeStyleItem(int substitutionOffset, String displayText, String docText) {
            super(substitutionOffset);
            this.displayText = displayText;
            this.docText = docText;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
            if (evt.getID() == 400 && evt.getKeyChar() == ',') {
                Completion.get().hideDocumentation();
                JTextComponent component = (JTextComponent)evt.getSource();
                int caretOffset = component.getSelectionEnd();
                this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, Character.toString(evt.getKeyChar()));
                Completion.get().showCompletion();
                evt.consume();
            }
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    if (CascadeStyleItem.this.docText != null) {
                        HibernateCompletionDocumentation documentation = HibernateCompletionDocumentation.getAttribValueDoc(CascadeStyleItem.this.docText);
                        resultSet.setDocumentation((CompletionDocumentation)documentation);
                    }
                    resultSet.finish();
                }
            });
        }
    }

    private static class DatabaseColumnItem
    extends HibernateCompletionItem {
        private static final String COLUMN_ICON = "org/netbeans/modules/hibernate/resources/completion/column.gif";
        private static final String PK_COLUMN_ICON = "org/netbeans/modules/hibernate/resources/completion/columnPrimary.gif";
        private String displayText;
        private boolean pk;

        public DatabaseColumnItem(int substitutionOffset, String columnName, boolean pk) {
            super(substitutionOffset);
            this.displayText = columnName;
            this.pk = pk;
        }

        public int getSortPriority() {
            if (this.pk) {
                return 1;
            }
            return 5;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        protected ImageIcon getIcon() {
            if (this.pk) {
                return ImageUtilities.loadImageIcon((String)PK_COLUMN_ICON, (boolean)false);
            }
            return ImageUtilities.loadImageIcon((String)COLUMN_ICON, (boolean)false);
        }
    }

    private static class DatabaseTableItem
    extends HibernateCompletionItem {
        private static final String TABLE_ICON = "org/netbeans/modules/hibernate/resources/completion/table.gif";
        private String displayText;

        public DatabaseTableItem(int substitutionOffset, String name) {
            super(substitutionOffset);
            this.displayText = name;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)TABLE_ICON, (boolean)false);
        }
    }

    private static class AttribValueItem
    extends HibernateCompletionItem {
        private String displayText;
        private String docText;

        public AttribValueItem(int substitutionOffset, String displayText, String docText) {
            super(substitutionOffset);
            this.displayText = displayText;
            this.docText = docText;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayText;
        }

        public CharSequence getInsertPrefix() {
            return this.displayText;
        }

        @Override
        public String getDisplayText() {
            return this.displayText;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayText;
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    if (AttribValueItem.this.docText != null) {
                        HibernateCompletionDocumentation documentation = HibernateCompletionDocumentation.getAttribValueDoc(AttribValueItem.this.docText);
                        resultSet.setDocumentation((CompletionDocumentation)documentation);
                    }
                    resultSet.finish();
                }
            });
        }
    }

    private static class PackageItem
    extends HibernateCompletionItem {
        private static final String PACKAGE = "org/netbeans/modules/java/editor/resources/package.gif";
        private static final String PACKAGE_COLOR = "<font color=#005600>";
        private static ImageIcon icon;
        private boolean deprecated;
        private String simpleName;
        private String sortText;
        private String leftText;

        public PackageItem(int substitutionOffset, String packageFQN, boolean deprecated) {
            super(substitutionOffset);
            int idx = packageFQN.lastIndexOf(46);
            this.simpleName = idx < 0 ? packageFQN : packageFQN.substring(idx + 1);
            this.deprecated = deprecated;
            this.sortText = this.simpleName + "#" + packageFQN;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        public void processKeyEvent(KeyEvent evt) {
            if (evt.getID() == 400 && evt.getKeyChar() == '.') {
                Completion.get().hideDocumentation();
                JTextComponent component = (JTextComponent)evt.getSource();
                int caretOffset = component.getSelectionEnd();
                this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, Character.toString(evt.getKeyChar()));
                Completion.get().showCompletion();
                evt.consume();
            }
        }

        @Override
        public String getDisplayText() {
            return this.simpleName;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)PACKAGE, (boolean)false);
            }
            return icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(PACKAGE_COLOR);
                if (this.deprecated) {
                    sb.append(HibernateCompletionItem.STRIKE);
                }
                sb.append(this.simpleName);
                if (this.deprecated) {
                    sb.append(HibernateCompletionItem.STRIKE_END);
                }
                sb.append(HibernateCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }
    }

    private static class ClassItem
    extends HibernateCompletionItem {
        private static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private ElementHandle<TypeElement> elemHandle;
        private boolean deprecated;
        private String displayName;
        private String enclName;
        private String sortText;
        private String leftText;
        private boolean smartItem;

        public ClassItem(int substitutionOffset, TypeElement elem, ElementHandle<TypeElement> elemHandle, boolean deprecated, boolean smartItem) {
            super(substitutionOffset);
            this.elemHandle = elemHandle;
            this.deprecated = deprecated;
            this.displayName = smartItem ? elem.getSimpleName().toString() : this.getRelativeName(elem);
            this.enclName = ClassItem.getElementName(elem.getEnclosingElement(), true).toString();
            this.sortText = this.displayName + ClassItem.getImportanceLevel(this.enclName) + "#" + this.enclName;
            this.smartItem = smartItem;
        }

        private String getRelativeName(TypeElement elem) {
            StringBuilder sb = new StringBuilder();
            sb.append(elem.getSimpleName().toString());
            Element parent = elem.getEnclosingElement();
            while (parent.getKind() != ElementKind.PACKAGE) {
                sb.insert(0, parent.getSimpleName().toString() + "$");
                parent = parent.getEnclosingElement();
            }
            return sb.toString();
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.smartItem ? "" : this.elemHandle.getBinaryName();
        }

        @Override
        public String getDisplayText() {
            return this.displayName;
        }

        @Override
        protected CharSequence getSubstitutionText() {
            return this.elemHandle.getBinaryName();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getColor());
                if (this.deprecated) {
                    sb.append(HibernateCompletionItem.STRIKE);
                }
                sb.append(this.displayName);
                if (this.deprecated) {
                    sb.append(HibernateCompletionItem.STRIKE_END);
                }
                if (this.smartItem && this.enclName != null && this.enclName.length() > 0) {
                    sb.append(HibernateCompletionItem.COLOR_END);
                    sb.append(PKG_COLOR);
                    sb.append(" (");
                    sb.append(this.enclName);
                    sb.append(")");
                }
                sb.append(HibernateCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        protected String getColor() {
            return CLASS_COLOR;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)CLASS, (boolean)false);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(final CompletionResultSet resultSet, Document doc, int caretOffset) {
                    try {
                        JavaSource js = HibernateEditorUtil.getJavaSource(doc);
                        if (js == null) {
                            return;
                        }
                        js.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController cc) throws Exception {
                                cc.toPhase(JavaSource.Phase.RESOLVED);
                                Element element = ClassItem.this.elemHandle.resolve((CompilationInfo)cc);
                                if (element == null) {
                                    return;
                                }
                                HibernateCompletionDocumentation doc = HibernateCompletionDocumentation.createJavaDoc(cc, element);
                                resultSet.setDocumentation((CompletionDocumentation)doc);
                            }
                        }, false);
                        resultSet.finish();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }, EditorRegistry.lastFocusedComponent());
        }
    }

    private static class ClassPropertyItem
    extends HibernateCompletionItem {
        private static final String FIELD_ICON = "org/netbeans/modules/editor/resources/completion/field_16.png";
        private ElementHandle<VariableElement> elemHandle;
        private boolean deprecated;
        private String displayName;

        public ClassPropertyItem(int substitutionOffset, VariableElement elem, ElementHandle<VariableElement> elemHandle, boolean deprecated) {
            super(substitutionOffset);
            this.elemHandle = elemHandle;
            this.deprecated = deprecated;
            this.displayName = elem.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.displayName;
        }

        public CharSequence getInsertPrefix() {
            return this.displayName;
        }

        @Override
        public String getDisplayText() {
            return this.displayName;
        }

        @Override
        protected String getLeftHtmlText() {
            return this.displayName;
        }

        @Override
        protected ImageIcon getIcon() {
            return ImageUtilities.loadImageIcon((String)FIELD_ICON, (boolean)false);
        }

        @Override
        public CompletionTask createDocumentationTask() {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                protected void query(final CompletionResultSet resultSet, Document doc, int caretOffset) {
                    try {
                        JavaSource js = HibernateEditorUtil.getJavaSource(doc);
                        if (js == null) {
                            return;
                        }
                        js.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController cc) throws Exception {
                                cc.toPhase(JavaSource.Phase.RESOLVED);
                                Element element = ClassPropertyItem.this.elemHandle.resolve((CompilationInfo)cc);
                                if (element == null) {
                                    return;
                                }
                                HibernateCompletionDocumentation doc = HibernateCompletionDocumentation.createJavaDoc(cc, element);
                                resultSet.setDocumentation((CompletionDocumentation)doc);
                            }
                        }, false);
                        resultSet.finish();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }, EditorRegistry.lastFocusedComponent());
        }
    }
}

