/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hyperlink;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkEnv;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.hibernate.hyperlink.JavaClassHyperlinkProcessor;
import org.netbeans.modules.hibernate.hyperlink.ResourceHyperlinkProcessor;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;

public class HibernateCfgHyperlinkProvider
implements HyperlinkProvider {
    private BaseDocument lastDocument = null;
    private HyperlinkProcessor currentProcessor;
    private Map<String, HyperlinkProcessor> attribValueProcessors = new HashMap<String, HyperlinkProcessor>();

    public HibernateCfgHyperlinkProvider() {
        ResourceHyperlinkProcessor resourceHyperlinkProcessor = new ResourceHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("mapping", "resource", resourceHyperlinkProcessor);
        JavaClassHyperlinkProcessor classHyperlinkProcessor = new JavaClassHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("mapping", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("class-cache", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("collection-cache", "collection", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("listener", "class", classHyperlinkProcessor);
    }

    private void registerAttribValueHyperlinkPoint(String tagName, String attribName, HyperlinkProcessor processor) {
        this.attribValueProcessors.put(this.createRegisteredName(tagName, attribName), processor);
    }

    public boolean isHyperlinkPoint(Document document, int offset) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        BaseDocument doc = (BaseDocument)document;
        if (!(doc.getSyntaxSupport() instanceof XMLSyntaxSupport)) {
            return false;
        }
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        this.currentProcessor = env.getType().isValueHyperlink() ? this.locateHyperlinkProcessor(env.getTagName(), env.getAttribName(), this.attribValueProcessors) : null;
        return this.currentProcessor != null;
    }

    public int[] getHyperlinkSpan(Document document, int offset) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        if (this.currentProcessor == null) {
            return null;
        }
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        return this.currentProcessor.getSpan(env);
    }

    public void performClickAction(Document document, int offset) {
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        if (this.currentProcessor != null) {
            this.currentProcessor.process(env);
        }
    }

    protected String createRegisteredName(String nodeName, String attributeName) {
        StringBuilder builder = new StringBuilder();
        if (nodeName != null && nodeName.trim().length() > 0) {
            builder.append("/nodeName=");
            builder.append(nodeName);
        } else {
            builder.append("/nodeName=");
            builder.append("*");
        }
        if (attributeName != null && attributeName.trim().length() > 0) {
            builder.append("/attribute=");
            builder.append(attributeName);
        }
        return builder.toString();
    }

    private HyperlinkProcessor locateHyperlinkProcessor(String nodeName, String attributeName, Map<String, HyperlinkProcessor> processors) {
        String key = this.createRegisteredName(nodeName, attributeName);
        if (processors.containsKey(key)) {
            return processors.get(key);
        }
        key = this.createRegisteredName("*", attributeName);
        if (processors.containsKey(key)) {
            return processors.get(key);
        }
        return null;
    }
}

