/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.BreadcrumbsElementImpl;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.StatementNode;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsController;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsElement;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public final class BreadCrumbsFactory {
    private static final RequestProcessor RP = new RequestProcessor("C/C++ BreadCrumbsFactory", 1, false, false);

    private BreadCrumbsFactory() {
    }

    public static void createBreadCrumbs(long caretLineNo, Node selectedNode, JEditorPane jEditorPane, DataObject cdo, AtomicBoolean canceled, CharSequence text) {
        if (!(selectedNode instanceof CppDeclarationNode)) {
            return;
        }
        Document doc = jEditorPane.getDocument();
        if (!BreadcrumbsController.areBreadCrumsEnabled((Document)doc)) {
            return;
        }
        Node node = selectedNode;
        LinkedList<Node> list = new LinkedList<Node>();
        do {
            list.addFirst(node);
        } while ((node = node.getParentNode()) != null);
        BreadcrumbsElementImpl breadcrumbsElement = new BreadcrumbsElementImpl(null, (Node)list.removeFirst(), cdo, canceled, text);
        breadcrumbsElement.setParent(new BreadcrumbsElementImpl.BreadcrumbsRoot(cdo, breadcrumbsElement));
        while (!list.isEmpty()) {
            boolean found = false;
            node = (Node)list.removeFirst();
            for (BreadcrumbsElement b : breadcrumbsElement.getChildren()) {
                if (!(b instanceof BreadcrumbsElementImpl) || ((BreadcrumbsElementImpl)b).getNode() != node) continue;
                breadcrumbsElement = (BreadcrumbsElementImpl)b;
                found = true;
                break;
            }
            if (found) continue;
            break;
        }
        if (canceled != null && canceled.get()) {
            return;
        }
        boolean deep = false;
        if (breadcrumbsElement.getNode() == selectedNode) {
            CsmObject csmObject = ((CppDeclarationNode)selectedNode).getCsmObject();
            int startOffset = -1;
            int endOffset = -1;
            if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
                startOffset = ((CsmOffsetable)csmObject).getStartOffset();
                endOffset = ((CsmOffsetable)csmObject).getEndOffset();
            }
            if ((long)startOffset < caretLineNo && caretLineNo < (long)endOffset && CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                deep = true;
            }
        }
        RP.post((Runnable)new Body(breadcrumbsElement, doc, caretLineNo, deep, canceled));
    }

    private static final class Body
    implements Runnable {
        private BreadcrumbsElement selected;
        private final long caretLineNo;
        private final Document doc;
        private final boolean deep;
        private final AtomicBoolean canceled;

        private Body(BreadcrumbsElement selected, Document doc, long caretLineNo, boolean deep, AtomicBoolean canceled) {
            this.selected = selected;
            this.caretLineNo = caretLineNo;
            this.doc = doc;
            this.deep = deep;
            this.canceled = canceled;
        }

        @Override
        public void run() {
            if (this.deep) {
                boolean advance;
                do {
                    if (this.canceled != null && this.canceled.get()) {
                        return;
                    }
                    advance = false;
                    for (BreadcrumbsElement child : this.selected.getChildren()) {
                        if (this.canceled != null && this.canceled.get()) {
                            return;
                        }
                        if (!(child instanceof StatementNode)) continue;
                        int start = ((StatementNode)child).getStartOffset();
                        int end = ((StatementNode)child).getEndOffset();
                        if ((long)start > this.caretLineNo || this.caretLineNo >= (long)end) continue;
                        this.selected = child;
                        advance = true;
                    }
                } while (advance);
            }
            BreadcrumbsController.setBreadcrumbs((Document)this.doc, (BreadcrumbsElement)this.selected);
        }
    }
}

