/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.TypeDescriptorInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class DescriptorComponent
extends Component {
    protected Vector<ClassDescriptorInfo> classVector = new Vector();
    protected TypeDescriptorInfo typeDescInfo;

    public DescriptorComponent(JCPackage jCPackage) {
        super(jCPackage);
        this.typeDescInfo = new TypeDescriptorInfo(jCPackage);
    }

    public void add(JCClass jCClass) {
        if (this.classVector.size() < 255) {
            ClassDescriptorInfo classDescriptorInfo = new ClassDescriptorInfo(jCClass, this.typeDescInfo);
            this.classVector.addElement(classDescriptorInfo);
        } else {
            Msg.error("cap.5", null);
            System.exit(1);
        }
    }

    @Override
    public int dataSize() {
        int n = 1;
        for (ClassDescriptorInfo classDescriptorInfo : this.classVector) {
            n += classDescriptorInfo.size();
        }
        return n += this.typeDescInfo.size();
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeByte(this.classVector.size());
            for (ClassDescriptorInfo classDescriptorInfo : this.classVector) {
                byte[] byArray2 = classDescriptorInfo.toByteArray();
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            Object object = this.typeDescInfo.toByteArray();
            dataOutputStream.write((byte[])object, 0, ((Object)object).length);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Count: " + this.classVector.size() + Msg.eol);
        for (ClassDescriptorInfo classDescriptorInfo : this.classVector) {
            stringBuffer.append("Class_descriptor_info: " + Msg.eol);
            stringBuffer.append(classDescriptorInfo);
            stringBuffer.append(Msg.eol);
        }
        stringBuffer.append("type_descriptor_info:" + Msg.eol);
        stringBuffer.append(this.typeDescInfo);
        return stringBuffer.toString();
    }

    static class MethodDescriptorInfo {
        private JCMethod method;
        private TypeDescriptorInfo typeInfo;
        private int token;
        private int access_flags;
        private static final int ACC_PUBLIC = 1;
        private static final int ACC_PRIVATE = 2;
        private static final int ACC_PROTECTED = 4;
        private static final int ACC_STATIC = 8;
        private static final int ACC_FINAL = 16;
        private static final int ACC_ABSTRACT = 64;
        private static final int ACC_INIT = 128;

        MethodDescriptorInfo(JCMethod jCMethod, TypeDescriptorInfo typeDescriptorInfo) {
            this.method = jCMethod;
            this.typeInfo = typeDescriptorInfo;
            MethodIdentifier methodIdentifier = jCMethod.getMethodIdentifier();
            this.token = methodIdentifier == null ? 255 : methodIdentifier.getMethodToken();
            int n = jCMethod.getAttributes();
            this.access_flags |= Modifier.isPublic(n) ? 1 : 0;
            this.access_flags |= Modifier.isPrivate(n) ? 2 : 0;
            this.access_flags |= Modifier.isProtected(n) ? 4 : 0;
            this.access_flags |= Modifier.isStatic(n) ? 8 : 0;
            this.access_flags |= Modifier.isFinal(n) ? 16 : 0;
            this.access_flags |= Modifier.isAbstract(n) ? 64 : 0;
            if (jCMethod.getName().indexOf("<init>(") != -1) {
                this.access_flags |= 0x80;
            }
        }

        int size() {
            return 12;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeByte(this.token);
                dataOutputStream.writeByte(this.access_flags);
                JCClass jCClass = this.method.getParentClass();
                if (Modifier.isInterface(jCClass.getAttributes()) && Modifier.isAbstract(this.method.getAttributes())) {
                    dataOutputStream.writeShort(0);
                } else {
                    dataOutputStream.writeShort(this.method.getRelocAddr());
                }
                dataOutputStream.writeShort(this.typeInfo.getOffset(this.method));
                dataOutputStream.writeShort(this.method.size() - this.method.getMethodHeader().length);
                ExceptionTable exceptionTable = this.method.getExceptionTable();
                if (exceptionTable != null) {
                    dataOutputStream.writeShort(exceptionTable.count());
                    dataOutputStream.writeShort((exceptionTable.getRelocAddr() - 1) / 8);
                } else {
                    dataOutputStream.writeShort(0);
                    dataOutputStream.writeShort(0);
                }
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
            return byteArrayOutputStream.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Token: " + this.token + ", access_flags: " + Msg.toHexString((byte)this.access_flags) + Msg.eol);
            JCClass jCClass = this.method.getParentClass();
            if (Modifier.isInterface(jCClass.getAttributes()) && Modifier.isAbstract(this.method.getAttributes())) {
                stringBuffer.append("method_offset: 0x0000");
            } else {
                stringBuffer.append("method_offset: " + Msg.toHexString((short)this.method.getRelocAddr()));
            }
            stringBuffer.append(", type_offset: " + Msg.toHexString((short)this.typeInfo.getOffset(this.method)));
            stringBuffer.append(", bytecode_count: " + (this.method.size() - this.method.getMethodHeader().length));
            stringBuffer.append(Msg.eol);
            ExceptionTable exceptionTable = this.method.getExceptionTable();
            if (exceptionTable != null) {
                stringBuffer.append("exception table count: " + exceptionTable.count());
                stringBuffer.append(", exception table index: " + (exceptionTable.getRelocAddr() - 4) / 8);
            } else {
                stringBuffer.append("exception table size: 0");
                stringBuffer.append(", exception table index: 0");
            }
            return stringBuffer.toString();
        }
    }

    static class FieldDescriptorInfo {
        private Field field;
        private JCClass c;
        private TypeDescriptorInfo typeInfo;
        private int token;
        private int type;
        private int tag1;
        private int tag2;
        private int tag3;
        private int access_flags;
        private static final int ACC_PUBLIC = 1;
        private static final int ACC_PRIVATE = 2;
        private static final int ACC_PROTECTED = 4;
        private static final int ACC_STATIC = 8;
        private static final int ACC_FINAL = 16;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        FieldDescriptorInfo(JCClass jCClass, Field field, TypeDescriptorInfo typeDescriptorInfo) {
            this.c = jCClass;
            this.field = field;
            this.typeInfo = typeDescriptorInfo;
            FieldIdentifier fieldIdentifier = field.getFieldIdentifier();
            this.token = fieldIdentifier == null ? 255 : fieldIdentifier.getFieldToken();
            int n = field.getAttributes();
            this.access_flags |= Modifier.isPublic(n) ? 1 : 0;
            this.access_flags |= Modifier.isPrivate(n) ? 2 : 0;
            this.access_flags |= Modifier.isProtected(n) ? 4 : 0;
            this.access_flags |= Modifier.isStatic(n) ? 8 : 0;
            this.access_flags |= Modifier.isFinal(n) ? 16 : 0;
            if ((this.access_flags & 8) != 0) {
                this.tag2 = (field.getRelocAddr() & 0xFF00) >> 8;
                this.tag3 = field.getRelocAddr() & 0xFF;
            } else {
                this.tag1 = (this.c.getRelocAddr() & 0xFF00) >> 8;
                this.tag2 = this.c.getRelocAddr() & 0xFF;
                this.tag3 = fieldIdentifier.getFieldToken();
            }
            FieldDescriptor fieldDescriptor = field.getDescriptor();
            if (fieldDescriptor.isPrimitive()) {
                String string = fieldDescriptor.getDescriptorString();
                if (string.equals("Z")) {
                    this.type = 32770;
                    return;
                } else if (string.equals("B")) {
                    this.type = 32771;
                    return;
                } else if (string.equals("S")) {
                    this.type = 32772;
                    return;
                } else {
                    if (!string.equals("I")) throw new InternalError();
                    this.type = 32773;
                }
                return;
            } else {
                this.type = typeDescriptorInfo.getOffset(field);
            }
        }

        int size() {
            return 7;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeByte(this.token);
                dataOutputStream.writeByte(this.access_flags);
                dataOutputStream.writeByte(this.tag1);
                dataOutputStream.writeByte(this.tag2);
                dataOutputStream.writeByte(this.tag3);
                dataOutputStream.writeShort(this.type);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
            return byteArrayOutputStream.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("token: " + this.token + ", access_flags: " + Msg.toHexString((byte)this.access_flags));
            stringBuffer.append(" // " + this.field.getName() + Msg.eol);
            stringBuffer.append("field_ref: 0x" + Msg.toHexString((byte)this.tag1));
            stringBuffer.append(":0x" + Msg.toHexString((byte)this.tag2));
            stringBuffer.append(":0x" + Msg.toHexString((byte)this.tag3));
            stringBuffer.append(", type: 0x" + Msg.toHexString((short)this.type));
            return stringBuffer.toString();
        }
    }

    static class ClassDescriptorInfo {
        private JCClass c;
        private Vector<InterfaceTable> interfaceVector;
        private Vector<FieldDescriptorInfo> fieldVector;
        private Vector<MethodDescriptorInfo> methodVector;
        private TypeDescriptorInfo typeInfo;
        private int token;
        private int access_flags;
        private static final int ACC_PUBLIC = 1;
        private static final int ACC_FINAL = 16;
        private static final int ACC_INTERFACE = 64;
        private static final int ACC_ABSTRACT = 128;

        ClassDescriptorInfo(JCClass jCClass, TypeDescriptorInfo typeDescriptorInfo) {
            Object object;
            Object object2;
            int n;
            this.c = jCClass;
            this.typeInfo = typeDescriptorInfo;
            this.token = jCClass.getClassIdentifier().getClassToken();
            if (this.token >= Short.MAX_VALUE) {
                this.token = 255;
            }
            this.access_flags |= Modifier.isPublic(n = jCClass.getAttributes()) ? 1 : 0;
            this.access_flags |= Modifier.isFinal(n) ? 16 : 0;
            this.access_flags |= Modifier.isInterface(n) ? 64 : 0;
            this.access_flags |= Modifier.isAbstract(n) ? 128 : 0;
            this.interfaceVector = new Vector();
            this.fieldVector = new Vector();
            this.methodVector = new Vector();
            Enumeration<Object> enumeration = jCClass.interfaceElements();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                this.interfaceVector.addElement((InterfaceTable)object2);
            }
            enumeration = jCClass.fieldElements();
            while (enumeration.hasMoreElements()) {
                object2 = (Field)enumeration.nextElement();
                if (Modifier.isFinal(((Member)object2).getAttributes()) && Modifier.isStatic(((Member)object2).getAttributes()) && ((Field)object2).getDescriptor().isPrimitive()) continue;
                object = new FieldDescriptorInfo(jCClass, (Field)object2, typeDescriptorInfo);
                this.fieldVector.addElement((FieldDescriptorInfo)object);
            }
            enumeration = jCClass.methodElements();
            while (enumeration.hasMoreElements()) {
                object2 = (JCMethod)enumeration.nextElement();
                object = new MethodDescriptorInfo((JCMethod)object2, typeDescriptorInfo);
                this.methodVector.addElement((MethodDescriptorInfo)object);
            }
        }

        int size() {
            int n = 9;
            n += this.interfaceVector.size() * 2;
            for (FieldDescriptorInfo object : this.fieldVector) {
                n += object.size();
            }
            for (MethodDescriptorInfo methodDescriptorInfo : this.methodVector) {
                n += methodDescriptorInfo.size();
            }
            return n;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeByte(this.token);
                dataOutputStream.writeByte(this.access_flags);
                dataOutputStream.writeShort(this.c.getRelocAddr());
                dataOutputStream.writeByte(this.interfaceVector.size());
                dataOutputStream.writeShort(this.fieldVector.size());
                dataOutputStream.writeShort(this.methodVector.size());
                for (InterfaceTable object : this.interfaceVector) {
                    if (object.isResolved()) {
                        int n = object.resolve().getRelocAddr();
                        dataOutputStream.writeShort(n);
                        continue;
                    }
                    JCPackage jCPackage = object.getParentClass().getParentPackage();
                    PackageIdentifier packageIdentifier = object.getClassIdentifier().getPackageIdentifier();
                    dataOutputStream.writeByte(jCPackage.getPackageToken(packageIdentifier) | 0x80);
                    dataOutputStream.writeByte(object.getClassIdentifier().getClassToken());
                }
                for (FieldDescriptorInfo fieldDescriptorInfo : this.fieldVector) {
                    byte[] byArray = fieldDescriptorInfo.toByteArray();
                    dataOutputStream.write(byArray, 0, byArray.length);
                }
                for (MethodDescriptorInfo methodDescriptorInfo : this.methodVector) {
                    byte[] byArray = methodDescriptorInfo.toByteArray();
                    dataOutputStream.write(byArray, 0, byArray.length);
                }
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
            return byteArrayOutputStream.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("token: " + this.token + ", access_flags: " + Msg.toHexString((byte)this.access_flags) + Msg.eol);
            stringBuffer.append("interface_count: " + this.interfaceVector.size());
            stringBuffer.append(", field_count: " + this.fieldVector.size());
            stringBuffer.append(", method_count: " + this.methodVector.size() + Msg.eol);
            stringBuffer.append("interfaces:" + Msg.eol);
            for (InterfaceTable object : this.interfaceVector) {
                if (object.isResolved()) {
                    int n = object.resolve().getRelocAddr();
                    stringBuffer.append(Msg.toHexString((short)n));
                    continue;
                }
                JCPackage jCPackage = object.getParentClass().getParentPackage();
                PackageIdentifier packageIdentifier = object.getClassIdentifier().getPackageIdentifier();
                stringBuffer.append(Msg.toHexString((byte)(jCPackage.getPackageToken(packageIdentifier) | 0x80)));
                stringBuffer.append(".");
                stringBuffer.append(Msg.toHexString((byte)object.getClassIdentifier().getClassToken()));
            }
            stringBuffer.append("field_descriptor_info:" + Msg.eol);
            for (FieldDescriptorInfo fieldDescriptorInfo : this.fieldVector) {
                stringBuffer.append(fieldDescriptorInfo + Msg.eol);
            }
            stringBuffer.append("method_descriptor_info:" + Msg.eol);
            for (MethodDescriptorInfo methodDescriptorInfo : this.methodVector) {
                stringBuffer.append(methodDescriptorInfo + Msg.eol);
            }
            return stringBuffer.toString();
        }
    }
}

