/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.base.syntax;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.asm.base.syntax.AntlrScanner;
import org.netbeans.modules.cnd.asm.base.syntax.AntlrToken;
import org.netbeans.modules.cnd.asm.base.syntax.IdentResolver;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmBaseTokenId;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmHighlightLexer;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmToken;
import org.netbeans.modules.cnd.asm.model.lang.syntax.AsmTokenId;

public class AntlrLexer
implements AsmHighlightLexer {
    private final AntlrScanner scanner;
    private final IdentResolver resolver;
    private int length;
    private static final int ERROR_LIMIT = 100;
    private int errorsNumber;

    public AntlrLexer(AntlrScanner scanner, IdentResolver resolver) {
        this.scanner = scanner;
        this.resolver = resolver;
        this.length = 0;
    }

    public AsmTokenId nextToken() {
        int start = this.scanner.getOffset();
        AsmTokenId tokId = AsmBaseTokenId.ASM_EMPTY;
        if (this.errorsNumber > 100) {
            this.length = this.scanner.getOffset() - start;
            return tokId;
        }
        try {
            AntlrToken antlrTok = (AntlrToken)this.scanner.nextToken();
            AsmToken asmTok = antlrTok.createAsmToken(this.resolver);
            tokId = asmTok.getId();
            this.length = this.scanner.getOffset() - start;
            if (!(tokId != AsmBaseTokenId.ASM_UNKWN_ID && tokId != AsmBaseTokenId.ASM_LABEL || asmTok.getText().startsWith(".") || asmTok.getText().startsWith("_"))) {
                tokId = AsmBaseTokenId.ASM_INSTRUCTION;
            }
            return tokId;
        }
        catch (TokenStreamException ex) {
            if (this.scanner.getPartState() != AntlrScanner.PartState.IN_COMMENT && this.scanner.getPartState() != AntlrScanner.PartState.IN_STRING) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Unresolved symbol at position " + start);
                ++this.errorsNumber;
                if (this.errorsNumber > 100) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "More than 100 unresolved symbols, skipping the rest");
                }
            }
            this.length = this.scanner.getOffset() - start;
            return tokId;
        }
    }

    @Override
    public int getLastLength() {
        return this.length;
    }

    @Override
    public Object getState() {
        return this.scanner.getIntState();
    }
}

