/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.assistance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;

public class CodeAnnotationSidebar
extends JComponent
implements ComponentListener {
    private List<AnnotationEntry> curAnnotations;
    private static final int SIDEBAR_WIDTH = 9;
    private static final Color colorBorder = new Color(102, 102, 102);
    private final EditorUI editorUI;
    private final JTextComponent target;
    private boolean enabled;

    public CodeAnnotationSidebar(JTextComponent target) {
        this.target = target;
        this.editorUI = Utilities.getEditorUI((JTextComponent)target);
        this.enabled = true;
        target.addComponentListener(this);
        this.updatePreferredSize();
    }

    public void setAnnotations(List<AnnotationEntry> annotations) {
        this.curAnnotations = annotations;
        this.repaint();
    }

    private boolean enableSideBarComponent(boolean enable) {
        if (enable == this.enabled) {
            return false;
        }
        this.enabled = enable;
        this.updatePreferredSize();
        return true;
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(9, this.target.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    @Override
    public void paintComponent(Graphics g) {
        JTextComponent component;
        super.paintComponent(g);
        Rectangle clip = g.getClipBounds();
        if (clip.y >= 16) {
            clip.y -= 16;
            clip.height += 16;
        }
        if ((component = this.editorUI.getComponent()) == null) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)component.getUI();
        View rootView = Utilities.getDocumentView((JTextComponent)component);
        if (rootView == null) {
            return;
        }
        g.setColor(this.target.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        try {
            int startPos = textUI.getPosFromY(clip.y);
            int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
            int rootViewCount = rootView.getViewCount();
            if (startViewIndex >= 0 && startViewIndex < rootViewCount) {
                Rectangle rec = textUI.modelToView(component, rootView.getView(startViewIndex).getStartOffset());
                int y = rec == null ? 0 : rec.y;
                int clipEndY = clip.y + clip.height;
                Element rootElem = textUI.getRootView(component).getElement();
                if (this.curAnnotations == null) {
                    return;
                }
                for (int i = startViewIndex; i < rootViewCount; ++i) {
                    View view = rootView.getView(i);
                    int line = rootElem.getElementIndex(view.getStartOffset()) + 1;
                    AnnotationEntry an = this.getAnnotationAtLine(line);
                    if (an != null) {
                        g.setColor(an.getColor());
                        g.fillRect(3, y, 6, this.editorUI.getLineHeight());
                        g.setColor(colorBorder);
                        int y1 = y + this.editorUI.getLineHeight();
                        if (line == an.getStartAnn()) {
                            g.drawLine(2, y, 8, y);
                        }
                        g.drawLine(2, y, 2, y1);
                        if (line == an.getEndAnn()) {
                            g.drawLine(2, y1, 8, y1);
                        }
                    }
                    if ((y += this.editorUI.getLineHeight()) >= clipEndY) break;
                }
            }
            this.revalidate();
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    private AnnotationEntry getAnnotationAtLine(int line) {
        for (AnnotationEntry ann : this.curAnnotations) {
            if (ann.getStartAnn() > line) {
                return null;
            }
            if (ann.getEndAnn() < line) continue;
            return ann;
        }
        return null;
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        this.revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public static class AnnotationEntry {
        private final Color color;
        private final int startAnn;
        private final int endAnn;

        public AnnotationEntry(Color color, int start, int end) {
            this.color = color;
            this.startAnn = start;
            this.endAnn = end;
        }

        public Color getColor() {
            return this.color;
        }

        public int getStartAnn() {
            return this.startAnn;
        }

        public int getEndAnn() {
            return this.endAnn;
        }
    }
}

