/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.openide.util.CharSequences;

public final class PersistentKey {
    private static final byte UID = 1;
    private static final byte NAMESPACE = 2;
    private static final byte DECLARATION = 4;
    private static final byte PROJECT = 8;
    private static final byte PROJECT_LIBS = 16;
    private static final byte STATE = 32;
    private static final byte MASK = 31;
    private final Object key;
    private final CsmProject project;
    private byte kind;

    private PersistentKey(CsmUID id, boolean state) {
        this.key = id;
        this.kind = 1;
        this.project = null;
        if (state) {
            this.kind = (byte)(this.kind | 0x20);
        }
    }

    private PersistentKey(CharSequence id, CsmProject host, byte type, boolean state) {
        this.key = id;
        this.project = host;
        this.kind = type;
        if (state) {
            this.kind = (byte)(this.kind | 0x20);
        }
    }

    public static PersistentKey createLibsKey(CsmProject project) {
        return new PersistentKey(CharSequences.empty(), project, 16, false);
    }

    public static PersistentKey createGlobalNamespaceKey(CsmProject project) {
        return new PersistentKey(CharSequences.empty(), project, 2, false);
    }

    public static PersistentKey createKey(Object object) {
        if (CsmKindUtilities.isNamespace((Object)object)) {
            CsmNamespace ns = (CsmNamespace)object;
            CharSequence uniq = ns.getQualifiedName();
            CsmProject project = ns.getProject();
            if (project != null) {
                return new PersistentKey(uniq, project, 2, false);
            }
        } else if (!CsmKindUtilities.isEnumerator((Object)object)) {
            if (CsmKindUtilities.isOffsetableDeclaration((Object)object)) {
                CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)object;
                CharSequence name = decl.getName();
                CharSequence uniq = decl.getUniqueName();
                CsmScope scope = decl.getScope();
                if (CsmKindUtilities.isCompoundClassifier((CsmObject)scope) && name.length() > 0) {
                    CsmCompoundClassifier cls = (CsmCompoundClassifier)scope;
                    name = cls.getName();
                }
                CsmProject project = decl.getContainingFile().getProject();
                if (name.length() > 0 && CharSequences.indexOf((CharSequence)uniq, (CharSequence)"::::") < 0 && project != null) {
                    return new PersistentKey(uniq, project, 4, PersistentKey.getStateBit(object));
                }
            } else if (CsmKindUtilities.isProject((Object)object)) {
                return new PersistentKey(null, (CsmProject)object, 8, false);
            }
        }
        return new PersistentKey(UIDs.get((Object)object), PersistentKey.getStateBit(object));
    }

    private static boolean getStateBit(Object object) {
        if (object instanceof CsmTypedef) {
            CsmClassifier cls;
            CsmTypedef typedef = (CsmTypedef)object;
            if (((CsmTypedef)object).isTypeUnnamed() && (cls = typedef.getType().getClassifier()) != null && cls.getName().length() == 0 && CsmKindUtilities.isCompoundClassifier((CsmObject)cls)) {
                return true;
            }
        }
        return false;
    }

    public Object getObject() {
        int maskKind = this.kind & 0x1F;
        switch (maskKind) {
            case 1: {
                return ((CsmUID)this.key).getObject();
            }
            case 2: {
                return this.project.findNamespace((CharSequence)this.key);
            }
            case 4: {
                return this.project.findDeclaration((CharSequence)this.key);
            }
            case 8: {
                return this.project;
            }
            case 16: {
                return this.project;
            }
        }
        return null;
    }

    public boolean isProjectLibs() {
        int maskKind = this.kind & 0x1F;
        return maskKind == 16;
    }

    public boolean equals(Object object) {
        if (object instanceof PersistentKey) {
            PersistentKey what = (PersistentKey)object;
            if (this.kind != what.kind) {
                return false;
            }
            int maskKind = this.kind & 0x1F;
            switch (maskKind) {
                case 1: {
                    return this.key.equals(what.key);
                }
                case 2: 
                case 4: {
                    if (this.project.equals(what.project)) {
                        return CharSequences.comparator().compare((CharSequence)this.key, (CharSequence)what.key) == 0;
                    }
                    return false;
                }
                case 8: {
                    return this.project.equals(what.project);
                }
                case 16: {
                    return this.project.equals(what.project);
                }
            }
        }
        return super.equals(object);
    }

    public int hashCode() {
        int maskKind = this.kind & 0x1F;
        int res = 0;
        if ((this.kind & 0x20) == 32) {
            res = 17;
        }
        switch (maskKind) {
            case 1: {
                return this.key.hashCode() + res;
            }
            case 2: 
            case 4: {
                return this.project.hashCode() ^ this.key.hashCode() + res;
            }
            case 8: {
                return this.project.hashCode() + res;
            }
            case 16: {
                return this.project.hashCode() + res;
            }
        }
        return 0;
    }

    public String toString() {
        int maskKind = this.kind & 0x1F;
        switch (maskKind) {
            case 1: {
                return "UID " + this.key.toString();
            }
            case 2: {
                return "Namespace " + this.key;
            }
            case 4: {
                return "Declaration " + this.key;
            }
            case 8: {
                return "Project " + this.project.getName();
            }
            case 16: {
                return "Libs " + this.project.getName();
            }
        }
        return super.toString();
    }
}

