/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.ActionsSynchronizer;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.WeakSet;

public abstract class JPDADebuggerActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    protected JPDADebuggerImpl debugger;
    private static final Set<JPDADebuggerActionProvider> providersToDisableOnLazyActions = new WeakSet();
    private volatile boolean disabled;

    protected JPDADebuggerActionProvider(JPDADebuggerImpl debugger) {
        this.debugger = debugger;
        debugger.addPropertyChangeListener("state", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("methodInvoke".equals(evt.getPropagationId())) {
            return;
        }
        this.checkEnabled(this.debugger.getState());
    }

    protected abstract void checkEnabled(int var1);

    public boolean isEnabled(Object action) {
        if (!this.disabled) {
            this.checkEnabled(this.debugger.getState());
        }
        return super.isEnabled(action);
    }

    protected JPDADebuggerImpl getDebuggerImpl() {
        return this.debugger;
    }

    protected void removeStepRequests(ThreadReference tr) {
        JPDADebuggerActionProvider.removeStepRequests(this.getDebuggerImpl(), tr);
    }

    static void removeStepRequests(JPDADebuggerImpl debugger, ThreadReference tr) {
        try {
            VirtualMachine vm = debugger.getVirtualMachine();
            if (vm == null) {
                return;
            }
            EventRequestManager erm = VirtualMachineWrapper.eventRequestManager(vm);
            List<StepRequest> l = EventRequestManagerWrapper.stepRequests(erm);
            for (StepRequest stepRequest : l) {
                if (!StepRequestWrapper.thread(stepRequest).equals(tr)) continue;
                try {
                    EventRequestManagerWrapper.deleteEventRequest(erm, stepRequest);
                }
                catch (InvalidRequestStateExceptionWrapper ex) {
                    // empty catch block
                }
                debugger.getOperator().unregister(stepRequest);
                break;
            }
        }
        catch (VMDisconnectedExceptionWrapper e) {
        }
        catch (InternalExceptionWrapper e) {
        }
        catch (IllegalThreadStateException e) {
        }
        catch (InvalidRequestStateException invalidRequestStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setProviderToDisableOnLazyAction(JPDADebuggerActionProvider provider) {
        Class<JPDADebuggerActionProvider> clazz = JPDADebuggerActionProvider.class;
        synchronized (JPDADebuggerActionProvider.class) {
            providersToDisableOnLazyActions.add(provider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doLazyAction(final Object action, final Runnable run) {
        JPDAThreadImpl threadWithActionsPending;
        final ActionsSynchronizer as = ActionsSynchronizer.get(this.debugger);
        as.actionScheduled(action);
        JPDAThread ct = this.debugger.getCurrentThread();
        if (ct instanceof JPDAThreadImpl && action != ActionsManager.ACTION_PAUSE) {
            threadWithActionsPending = (JPDAThreadImpl)ct;
            threadWithActionsPending.setPendingAction(action);
        } else {
            threadWithActionsPending = null;
        }
        Class<JPDADebuggerActionProvider> clazz = JPDADebuggerActionProvider.class;
        synchronized (JPDADebuggerActionProvider.class) {
            final HashSet<JPDADebuggerActionProvider> disabledActions = new HashSet<JPDADebuggerActionProvider>(providersToDisableOnLazyActions);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            for (JPDADebuggerActionProvider ap : disabledActions) {
                Set actions = ap.getActions();
                ap.disabled = true;
                for (Object a : actions) {
                    ap.setEnabled(a, false);
                }
            }
            this.debugger.getRequestProcessor().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        as.actionStarts(action);
                        run.run();
                        if (threadWithActionsPending != null) {
                            threadWithActionsPending.setPendingAction(null);
                        }
                        for (JPDADebuggerActionProvider ap : disabledActions) {
                            Set actions = ap.getActions();
                            ap.disabled = false;
                            ap.checkEnabled(JPDADebuggerActionProvider.this.debugger.getState());
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                    }
                    finally {
                        as.actionEnds(action);
                    }
                }
            });
            return;
        }
    }
}

