/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.RequestNotSupportedException;
import org.netbeans.modules.debugger.jpda.breakpoints.SourceRootsCache;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.jpda.BreakpointsClassFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LineBreakpointImpl
extends ClassBasedBreakpoint {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private int lineNumber;
    private int breakpointLineNumber;
    private int lineNumberForUpdate = -1;
    private final Object lineLock = new Object();
    private BreakpointsReader reader;

    LineBreakpointImpl(LineBreakpoint breakpoint, BreakpointsReader reader, JPDADebuggerImpl debugger, Session session, SourceRootsCache sourceRootsCache) {
        super((JPDABreakpoint)breakpoint, reader, debugger, session, sourceRootsCache);
        this.reader = reader;
        this.updateLineNumber();
        this.setSourceRoot(sourceRootsCache.getSourcePath().getSourceRoot(breakpoint.getURL()));
        this.set();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLineNumber() {
        LineBreakpoint lb = this.getBreakpoint();
        int theLineNumber = EditorContextBridge.getContext().getLineNumber((Object)lb, (Object)this.getDebugger());
        int lbln = lb.getLineNumber();
        Object object = this.lineLock;
        synchronized (object) {
            this.breakpointLineNumber = lbln;
            this.lineNumber = theLineNumber;
        }
    }

    protected LineBreakpoint getBreakpoint() {
        return (LineBreakpoint)super.getBreakpoint();
    }

    @Override
    void fixed() {
        logger.log(Level.FINE, "LineBreakpoint fixed: {0}", this);
        this.updateLineNumber();
        super.fixed();
    }

    @Override
    protected boolean isApplicable() {
        LineBreakpoint breakpoint = this.getBreakpoint();
        String[] preferredSourceRoot = new String[]{null};
        String sourcePath = this.getDebugger().getEngineContext().getRelativePath(breakpoint.getURL(), '/', true);
        if (sourcePath == null) {
            return false;
        }
        boolean isInSources = false;
        String srcRoot = this.getSourceRoot();
        if (srcRoot != null && this.isRootInSources(srcRoot)) {
            isInSources = true;
        }
        if (!isInSources) {
            return false;
        }
        return !isInSources || this.isEnabled(sourcePath, preferredSourceRoot);
    }

    @Override
    protected void setRequests() {
        String srcRoot;
        String sourcePath;
        LineBreakpoint breakpoint = this.getBreakpoint();
        this.updateLineNumber();
        String[] preferredSourceRoot = new String[]{null};
        boolean isEmptyURL = breakpoint.getURL().isEmpty();
        if (isEmptyURL) {
            sourcePath = null;
        } else {
            sourcePath = this.getDebugger().getEngineContext().getRelativePath(breakpoint.getURL(), '/', true);
            if (sourcePath == null) {
                String reason = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoSourceRoot", (Object)breakpoint.getURL());
                this.setInvalid(reason);
                return;
            }
        }
        JPDAClassType classType = this.getPreferredClassType(breakpoint);
        if (classType != null) {
            this.classLoaded(Collections.singletonList(((JPDAClassTypeImpl)classType).getType()));
            return;
        }
        String className = breakpoint.getPreferredClassName();
        if (!(className != null && !className.isEmpty() || (className = this.reader.findCachedClassName((JPDABreakpoint)breakpoint)) != null && !className.isEmpty() || (className = EditorContextBridge.getContext().getClassName(breakpoint.getURL(), this.lineNumber)) == null || className.isEmpty())) {
            this.reader.storeCachedClassName((JPDABreakpoint)breakpoint, className);
        }
        if (className == null || className.isEmpty()) {
            logger.log(Level.WARNING, "Class name not defined for breakpoint {0}", breakpoint);
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoBPClass"));
            return;
        }
        boolean isInSources = isEmptyURL;
        if (!isEmptyURL && (srcRoot = this.getSourceRoot()) != null && this.isRootInSources(srcRoot)) {
            isInSources = true;
        }
        if (!isInSources) {
            String relativePath = EditorContextBridge.getRelativePath(className);
            String classURL = this.getDebugger().getEngineContext().getURL(relativePath, true);
            if (classURL != null && !classURL.equals(breakpoint.getURL())) {
                logger.log(Level.FINE, "LineBreakpoint {0} NOT submitted, because it's URL ''{1}'' differes from class ''{2}'' URL ''{3}''.", new Object[]{breakpoint, breakpoint.getURL(), className, classURL});
                return;
            }
        }
        if (isInSources && sourcePath != null && !this.isEnabled(sourcePath, preferredSourceRoot)) {
            String reason = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_DifferentPrefferedSourceRoot", (Object)preferredSourceRoot[0]);
            this.setInvalid(reason);
            logger.log(Level.FINE, "LineBreakpoint {0} NOT submitted, because of ''{1}''.", new Object[]{breakpoint, reason});
            return;
        }
        logger.log(Level.FINE, "LineBreakpoint {0} - setting request for {1}", new Object[]{breakpoint, className});
        BreakpointsClassFilter.ClassNames classNames = this.getClassFilter().filterClassNames(new BreakpointsClassFilter.ClassNames(new String[]{className}, new String[0]), (JPDABreakpoint)breakpoint);
        String[] names = classNames.getClassNames();
        String[] excludedNames = classNames.getExcludedClassNames();
        boolean wasSet = this.setClassRequests(names, excludedNames, 1);
        if (wasSet) {
            for (String cn : names) {
                this.checkLoadedClasses(cn, excludedNames);
            }
        }
    }

    private void setInvalid(String reason) {
        logger.warning("Unable to submit line breakpoint to " + this.getBreakpoint().getURL() + " at line " + this.lineNumber + ", reason: " + reason);
        this.setValidity(Breakpoint.VALIDITY.INVALID, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classLoaded(List<ReferenceType> referenceTypes) {
        int newBreakpointLineNumber;
        int origBreakpointLineNumber;
        int lineNumberToSet;
        LineBreakpoint breakpoint = this.getBreakpoint();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Classes " + referenceTypes + " loaded for breakpoint " + breakpoint);
        }
        boolean submitted = false;
        String failReason = null;
        ReferenceType noLocRefType = null;
        Object object = this.lineLock;
        synchronized (object) {
            lineNumberToSet = this.lineNumber;
            newBreakpointLineNumber = origBreakpointLineNumber = this.breakpointLineNumber;
        }
        String currFailReason = null;
        for (int counter = 0; counter < 2; ++counter) {
            for (ReferenceType referenceType : referenceTypes) {
                String[] reason = new String[]{null};
                boolean[] isNoLocReason = new boolean[1];
                List<Location> locations = LineBreakpointImpl.getLocations(referenceType, breakpoint.getStratum(), breakpoint.getSourceName(), breakpoint.getSourcePath(), lineNumberToSet, reason, isNoLocReason);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Locations in " + referenceType + " are: " + locations + ", reason = '" + reason[0]);
                }
                if (locations.isEmpty()) {
                    failReason = reason[0];
                    if (!isNoLocReason[0]) continue;
                    noLocRefType = referenceType;
                    continue;
                }
                Location location = locations.get(0);
                com.sun.jdi.Method m0 = location.method();
                for (int li = 1; li < locations.size(); ++li) {
                    Location l = locations.get(li);
                    if (l.codeIndex() >= location.codeIndex() || !l.method().equals(m0)) continue;
                    location = l;
                }
                try {
                    BreakpointRequest br = EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), location);
                    this.setFilters(br);
                    this.addEventRequest(br);
                    submitted = true;
                }
                catch (VMDisconnectedExceptionWrapper e) {
                }
                catch (InternalExceptionWrapper e) {
                }
                catch (ObjectCollectedExceptionWrapper e) {
                }
                catch (InvalidRequestStateExceptionWrapper irse) {
                    Exceptions.printStackTrace((Throwable)irse);
                }
                catch (RequestNotSupportedException rnsex) {
                    this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_RequestNotSupported"));
                    return;
                }
            }
            if (counter == 0) {
                int newLineNumber;
                if (submitted || noLocRefType == null || !this.areNewOrSubmittedTypes0(referenceTypes) || (newLineNumber = this.findBreakableLine(breakpoint.getURL(), origBreakpointLineNumber)) == origBreakpointLineNumber || newLineNumber < 0 || LineBreakpointImpl.findBreakpoint(breakpoint.getURL(), newLineNumber) != null) break;
                newBreakpointLineNumber = newLineNumber;
                lineNumberToSet += newLineNumber - origBreakpointLineNumber;
                currFailReason = failReason;
                failReason = null;
                continue;
            }
            if (submitted) continue;
            failReason = currFailReason;
        }
        if (submitted) {
            if (origBreakpointLineNumber != newBreakpointLineNumber) {
                Object counter = this.lineLock;
                synchronized (counter) {
                    this.lineNumberForUpdate = newBreakpointLineNumber;
                }
                breakpoint.setLineNumber(newBreakpointLineNumber);
            }
            this.setValidity(Breakpoint.VALIDITY.VALID, failReason);
        } else {
            boolean all;
            String className = this.getBreakpoint().getPreferredClassName();
            boolean bl = all = className != null && (className.startsWith("*") || className.endsWith("*"));
            if (!all) {
                logger.warning("Unable to submit line breakpoint to " + referenceTypes.get(0).name() + " at line " + this.lineNumber + ", reason: " + failReason);
                this.setValidity(Breakpoint.VALIDITY.INVALID, failReason);
            }
        }
    }

    private boolean areNewOrSubmittedTypes0(List<ReferenceType> referenceTypes) {
        try {
            return this.areNewOrSubmittedTypes(referenceTypes);
        }
        catch (VMDisconnectedException vmdex) {
        }
        catch (InternalException e) {
        }
        catch (ObjectCollectedException e) {
        }
        catch (InvalidRequestStateException invalidRequestStateException) {
            // empty catch block
        }
        return false;
    }

    private boolean areNewOrSubmittedTypes(List<ReferenceType> referenceTypes) {
        List<EventRequest> eventRequests = this.getEventRequests();
        LinkedList<BreakpointRequest> brs = new LinkedList<BreakpointRequest>();
        for (EventRequest er : eventRequests) {
            if (!(er instanceof BreakpointRequest)) continue;
            brs.add((BreakpointRequest)er);
        }
        if (brs.isEmpty()) {
            return true;
        }
        for (ReferenceType rt : referenceTypes) {
            boolean contains = false;
            for (BreakpointRequest br : brs) {
                ReferenceType brt = br.location().declaringType();
                if (!rt.equals(brt)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EventRequest createEventRequest(EventRequest oldRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Location location = BreakpointRequestWrapper.location((BreakpointRequest)oldRequest);
        BreakpointRequest br = EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), location);
        this.setFilters(br);
        return br;
    }

    private void setFilters(BreakpointRequest br) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        ObjectVariable[] varFilters;
        JPDAThread[] threadFilters = this.getBreakpoint().getThreadFilters((JPDADebugger)this.getDebugger());
        if (threadFilters != null && threadFilters.length > 0) {
            for (JPDAThread t : threadFilters) {
                BreakpointRequestWrapper.addThreadFilter(br, ((JPDAThreadImpl)t).getThreadReference());
            }
        }
        if ((varFilters = this.getBreakpoint().getInstanceFilters((JPDADebugger)this.getDebugger())) != null && varFilters.length > 0) {
            for (ObjectVariable v : varFilters) {
                BreakpointRequestWrapper.addInstanceFilter(br, (ObjectReference)((JDIVariable)v).getJDIValue());
            }
        }
    }

    @Override
    public boolean processCondition(Event event) {
        if (event instanceof BreakpointEvent) {
            try {
                return this.processCondition(event, this.getBreakpoint().getCondition(), LocatableEventWrapper.thread((BreakpointEvent)event), null);
            }
            catch (InternalExceptionWrapper ex) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            try {
                return this.perform(event, LocatableEventWrapper.thread((BreakpointEvent)event), LocationWrapper.declaringType(LocatableWrapper.location((LocatableEvent)event)), null);
            }
            catch (InternalExceptionWrapper ex) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return false;
            }
        }
        return super.exec(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("lineNumber".equals(evt.getPropertyName())) {
            Object object = this.lineLock;
            synchronized (object) {
                if (this.lineNumberForUpdate != -1) {
                    this.lineNumber = this.lineNumberForUpdate;
                    this.lineNumberForUpdate = -1;
                    return;
                }
            }
            int old = this.lineNumber;
            this.updateLineNumber();
            if (this.lineNumber == old) {
                return;
            }
        }
        super.propertyChange(evt);
    }

    private static List<Location> getLocations(ReferenceType referenceType, String stratum, String sourceName, String bpSourcePath, int lineNumber, String[] reason, boolean[] noLocationReason) {
        try {
            reason[0] = null;
            noLocationReason[0] = false;
            List<Location> locations = LineBreakpointImpl.locationsOfLineInClass(referenceType, stratum, sourceName, bpSourcePath, lineNumber, reason);
            if (locations.isEmpty() && reason[0] == null) {
                reason[0] = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoLocation", (Object)Integer.toString(lineNumber), (Object)referenceType.name());
                noLocationReason[0] = true;
            }
            return locations;
        }
        catch (AbsentInformationException ex) {
            reason[0] = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoLineInfo", (Object)referenceType.name());
        }
        catch (ObjectCollectedException ex) {
            reason[0] = ex.getLocalizedMessage();
        }
        catch (ClassNotPreparedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InternalException iex) {
            iex = (InternalException)Exceptions.attachLocalizedMessage((Throwable)iex, (String)NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_jdi_internal_error"));
            Exceptions.printStackTrace((Throwable)iex);
            reason[0] = iex.getLocalizedMessage();
        }
        return Collections.EMPTY_LIST;
    }

    private static List<Location> locationsOfLineInClass(ReferenceType referenceType, String stratum, String sourceName, String bpSourcePath, int lineNumber, String[] reason) throws AbsentInformationException, ObjectCollectedException, ClassNotPreparedException, InternalException {
        List<Location> list;
        try {
            list = ReferenceTypeWrapper.locationsOfLine0(referenceType, stratum, sourceName, lineNumber);
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            throw ex.getCause();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("LineBreakpoint: locations for ReferenceType=" + referenceType + ", stratum=" + stratum + ", source name=" + sourceName + ", bpSourcePath=" + bpSourcePath + ", lineNumber=" + lineNumber + " are: {" + list + "}");
        }
        if (!list.isEmpty()) {
            if (bpSourcePath == null) {
                return list;
            }
            bpSourcePath = bpSourcePath.replace(File.separatorChar, '/');
            ArrayList<Location> locations = new ArrayList<Location>(list.size());
            for (Location l : list) {
                String lSourcePath;
                try {
                    lSourcePath = LocationWrapper.sourcePath(l).replace(File.separatorChar, '/');
                }
                catch (InternalExceptionWrapper ex) {
                    return Collections.emptyList();
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return Collections.emptyList();
                }
                lSourcePath = LineBreakpointImpl.normalize(lSourcePath);
                if (lSourcePath.equals(bpSourcePath)) {
                    locations.add(l);
                    continue;
                }
                reason[0] = "Breakpoint source path '" + bpSourcePath + "' is different from the location source path '" + lSourcePath + "'.";
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("LineBreakpoint: relevant location(s) for path '" + bpSourcePath + "': " + locations);
            }
            if (!locations.isEmpty()) {
                return locations;
            }
        }
        return Collections.emptyList();
    }

    private static String normalize(String path) {
        Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
        Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
        Matcher m = thisDirectoryPattern.matcher(path);
        while (m.find()) {
            path = m.replaceAll("$1");
            m = thisDirectoryPattern.matcher(path);
        }
        m = parentDirectoryPattern.matcher(path);
        while (m.find()) {
            if (m.group(2).equals("..")) continue;
            path = path.substring(0, m.start()) + m.group(1) + path.substring(m.end());
            m = parentDirectoryPattern.matcher(path);
        }
        return path;
    }

    private int findBreakableLine(String url, final int lineNumber) {
        FileObject fileObj = null;
        try {
            fileObj = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (fileObj == null) {
            return lineNumber;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)fileObj);
        if (js == null) {
            return lineNumber;
        }
        final int[] result = new int[]{lineNumber};
        try {
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController ci) throws Exception {
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        logger.warning("Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    SourcePositions positions = ci.getTrees().getSourcePositions();
                    CompilationUnitTree compUnit = ci.getCompilationUnit();
                    TreeUtilities treeUtils = ci.getTreeUtilities();
                    Document ciDoc = ci.getDocument();
                    if (!(ciDoc instanceof LineDocument)) {
                        return;
                    }
                    LineDocument doc = (LineDocument)ciDoc;
                    int rowStartOffset = LineDocumentUtils.getLineStartFromIndex((LineDocument)doc, (int)(lineNumber - 1));
                    TreePath path = treeUtils.pathFor(rowStartOffset);
                    Tree tree = path.getLeaf();
                    Tree.Kind kind = tree.getKind();
                    if (kind == Tree.Kind.ERRONEOUS) {
                        return;
                    }
                    int startOffs = (int)positions.getStartPosition(compUnit, tree);
                    int outerLineNumber = LineDocumentUtils.getLineIndex((LineDocument)doc, (int)startOffs) + 1;
                    if (outerLineNumber == lineNumber) {
                        return;
                    }
                    if (kind == Tree.Kind.COMPILATION_UNIT || TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind)) {
                        return;
                    }
                    if (kind == Tree.Kind.BLOCK) {
                        BlockTree blockTree = (BlockTree)tree;
                        Tree previousTree = null;
                        int previousTreeEndOffset = -1;
                        for (StatementTree statementTree : blockTree.getStatements()) {
                            int end = (int)positions.getStartPosition(compUnit, statementTree);
                            if (end <= rowStartOffset && end > previousTreeEndOffset) {
                                previousTree = statementTree;
                                previousTreeEndOffset = end;
                                continue;
                            }
                            if (end <= rowStartOffset) continue;
                            break;
                        }
                        if (previousTree == null) {
                            tree = path.getParentPath().getLeaf();
                            kind = tree.getKind();
                            if (kind != Tree.Kind.COMPILATION_UNIT && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind)) {
                                previousTree = tree;
                            } else {
                                return;
                            }
                        }
                        startOffs = (int)positions.getStartPosition(compUnit, previousTree);
                        outerLineNumber = LineDocumentUtils.getLineIndex((LineDocument)doc, (int)startOffs) + 1;
                    }
                    result[0] = outerLineNumber;
                }
            }, true);
        }
        catch (IOException ioex) {
            Exceptions.printStackTrace((Throwable)ioex);
            return lineNumber;
        }
        return result[0];
    }

    private static LineBreakpoint findBreakpoint(String url, int lineNumber) {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            LineBreakpoint lb;
            if (!(breakpoints[i] instanceof LineBreakpoint) || !(lb = (LineBreakpoint)breakpoints[i]).getURL().equals(url) || lb.getLineNumber() != lineNumber) continue;
            return lb;
        }
        return null;
    }

    private JPDAClassType getPreferredClassType(LineBreakpoint breakpoint) {
        try {
            Method getPreferredClassTypeMethod = breakpoint.getClass().getMethod("getPreferredClassType", new Class[0]);
            getPreferredClassTypeMethod.setAccessible(true);
            return (JPDAClassType)getPreferredClassTypeMethod.invoke((Object)breakpoint, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

