/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.specs.support.api;

import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.javaee.specs.support.bridge.IdeJaxWsStack;
import org.netbeans.modules.javaee.specs.support.bridge.JdkJaxWsStack;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.openide.util.Lookup;

public class JaxWsStackSupport {
    public static WSStack<JaxWs> getJaxWsStack(J2eePlatform j2eePlatform) {
        return WSStack.findWSStack((Lookup)j2eePlatform.getLookup(), JaxWs.class);
    }

    public static WSTool getJaxWsStackTool(J2eePlatform j2eePlatform, JaxWs.Tool toolId) {
        WSStack wsStack = WSStack.findWSStack((Lookup)j2eePlatform.getLookup(), JaxWs.class);
        if (wsStack != null) {
            return wsStack.getWSTool((WSStack.Tool)toolId);
        }
        return null;
    }

    public static WSStack<JaxWs> getJdkJaxWsStack() {
        return WsAccessor.JDK_JAX_WS_STACK;
    }

    public static WSStack<JaxWs> getIdeJaxWsStack() {
        return WsAccessor.IDE_JAX_WS_STACK;
    }

    private static String getJaxWsStackVersion(String javaVersion) {
        if (javaVersion.startsWith("1.6")) {
            int index = javaVersion.indexOf("_");
            if (index > 0) {
                String releaseVersion = JaxWsStackSupport.parseReleaseVersion(javaVersion.substring(index + 1));
                Integer rv = Integer.valueOf(releaseVersion);
                if (rv >= 4) {
                    return "2.1.1";
                }
                return "2.0";
            }
            return null;
        }
        try {
            Float version = Float.valueOf(javaVersion.substring(0, 3));
            if ((double)version.floatValue() > 1.6) {
                return "2.1.3";
            }
            return null;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static String parseReleaseVersion(String releaseVersion) {
        char c;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < releaseVersion.length() && Character.isDigit(c = releaseVersion.charAt(i)); ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    private static class WsAccessor {
        private static WSStack<JaxWs> JDK_JAX_WS_STACK;
        private static final WSStack<JaxWs> IDE_JAX_WS_STACK;

        private WsAccessor() {
        }

        static {
            IDE_JAX_WS_STACK = WSStackFactory.createWSStack(JaxWs.class, (WSStackImplementation)new IdeJaxWsStack(), (WSStack.Source)WSStack.Source.IDE);
            String jaxWsVersion = JaxWsStackSupport.getJaxWsStackVersion(System.getProperty("java.version"));
            if (jaxWsVersion != null) {
                JDK_JAX_WS_STACK = WSStackFactory.createWSStack(JaxWs.class, (WSStackImplementation)new JdkJaxWsStack(jaxWsVersion), (WSStack.Source)WSStack.Source.JDK);
            }
        }
    }
}

