/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.actions;

import java.awt.Dialog;
import javax.swing.Action;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.terminal.PinPanel;
import org.netbeans.modules.terminal.actions.TerminalAction;
import org.netbeans.modules.terminal.ioprovider.Terminal;
import org.netbeans.modules.terminal.support.TerminalPinSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PinTabAction
extends TerminalAction {
    public static final String pinMessage = PinTabAction.getMessage("CTL_PinTab");
    public static final String unpinMessage = PinTabAction.getMessage("CTL_UnpinTab");
    private final TerminalPinSupport support = TerminalPinSupport.getDefault();

    public PinTabAction(Terminal context) {
        super(context);
        Terminal terminal = this.getTerminal();
        this.putValue("Name", PinTabAction.getMessage(terminal.isPinned()));
        this.putValue("hideWhenDisabled", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction() {
        Terminal terminal = this.getTerminal();
        ActiveTerm term = terminal.term();
        TerminalPinSupport.TerminalPinningDetails pinningDetails = this.support.findPinningDetails((Term)term);
        boolean oldState = pinningDetails == null ? false : pinningDetails.isPinned();
        boolean newState = !oldState;
        this.putValue("Name", PinTabAction.getMessage(!terminal.isPinned()));
        if (newState) {
            boolean customTitle = terminal.isCustomTitle();
            String title = terminal.getTitle();
            String name = terminal.name();
            TerminalPinSupport.TerminalPinningDetails defaultValues = TerminalPinSupport.TerminalPinningDetails.create(customTitle, customTitle ? title : name, terminal.getCwd(), this.enabled);
            PinPanel pinPanel = new PinPanel(new TerminalPinSupport.TerminalDetails(this.support.findCreationDetails((Term)term), defaultValues));
            DialogDescriptor dd = new DialogDescriptor((Object)pinPanel, NbBundle.getMessage(Terminal.class, (String)"LBL_PinTab"), true, 2, DialogDescriptor.OK_OPTION, null);
            Dialog cfgDialog = DialogDisplayer.getDefault().createDialog(dd);
            try {
                cfgDialog.setVisible(true);
            }
            catch (Throwable th) {
                if (!(th.getCause() instanceof InterruptedException)) {
                    throw new RuntimeException(th);
                }
                dd.setValue(DialogDescriptor.CANCEL_OPTION);
            }
            finally {
                cfgDialog.dispose();
            }
            if (dd.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            String chosenTitle = pinPanel.getTitle();
            boolean chosenIsCustom = pinPanel.isCustomTitle();
            String chosenDirectory = pinPanel.getDirectory();
            if (chosenDirectory.isEmpty()) {
                chosenDirectory = null;
            }
            this.support.tabWasPinned((Term)term, TerminalPinSupport.TerminalPinningDetails.create(chosenIsCustom, chosenIsCustom ? chosenTitle : name, chosenDirectory, this.enabled));
            if (chosenIsCustom && !title.equals(chosenTitle)) {
                customTitle = true;
                terminal.updateName(chosenTitle);
            }
        } else {
            this.support.tabWasUnpinned((Term)term);
        }
        terminal.pin(newState);
    }

    public static String getMessage(boolean isPinned) {
        return isPinned ? unpinMessage : pinMessage;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new PinTabAction((Terminal)actionContext.lookup(Terminal.class));
    }
}

