/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.WeakSet;

public abstract class APTMacroCache {
    private static final int MACRO_MANAGER_DEFAULT_CAPACITY;
    private static final int MACRO_MANAGER_DEFAULT_SLICED_NUMBER;
    private static final APTMacroCache instance;

    private APTMacroCache() {
    }

    public abstract APTMacro getMacro(APTMacro var1);

    public abstract void dispose();

    private static APTMacroCache create(boolean single) {
        if (single) {
            return new APTSingleMacroManager(MACRO_MANAGER_DEFAULT_CAPACITY);
        }
        return new APTCompoundMacroManager(MACRO_MANAGER_DEFAULT_SLICED_NUMBER, MACRO_MANAGER_DEFAULT_CAPACITY);
    }

    public static APTMacroCache getManager() {
        return instance;
    }

    static {
        int nrProc = CndUtils.getConcurrencyLevel();
        if (nrProc <= 4) {
            MACRO_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            MACRO_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            MACRO_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            MACRO_MANAGER_DEFAULT_CAPACITY = 128;
        }
        instance = APTMacroCache.create(false);
    }

    private static final class APTCompoundMacroManager
    extends APTMacroCache {
        private final APTMacroCache[] instances;
        private final int segmentMask;

        private APTCompoundMacroManager(int sliceNumber) {
            this(sliceNumber, MACRO_MANAGER_DEFAULT_CAPACITY);
        }

        private APTCompoundMacroManager(int sliceNumber, int initialCapacity) {
            int ssize;
            for (ssize = 1; ssize < sliceNumber; ssize <<= 1) {
            }
            this.segmentMask = ssize - 1;
            this.instances = new APTMacroCache[ssize];
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i] = new APTSingleMacroManager(initialCapacity);
            }
        }

        private APTMacroCache getDelegate(APTMacro macro) {
            if (macro == null) {
                throw new NullPointerException("null macro is illegal to share");
            }
            int index = macro.hashCode() & this.segmentMask;
            return this.instances[index];
        }

        @Override
        public APTMacro getMacro(APTMacro macro) {
            return this.getDelegate(macro).getMacro(macro);
        }

        @Override
        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i].dispose();
            }
        }
    }

    private static final class APTSingleMacroManager
    extends APTMacroCache {
        private final WeakSet<APTMacro> storage;
        private final int initialCapacity;
        private final Object lock = new Lock();

        private APTSingleMacroManager(int initialCapacity) {
            this.storage = new WeakSet(initialCapacity);
            this.initialCapacity = initialCapacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public APTMacro getMacro(APTMacro macro) {
            if (macro == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            APTMacro outMacro = null;
            Object object = this.lock;
            synchronized (object) {
                outMacro = (APTMacro)this.storage.putIfAbsent((Object)macro);
            }
            assert (outMacro != null);
            assert (outMacro.equals(macro));
            return outMacro;
        }

        @Override
        public final void dispose() {
            if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                Object[] arr = this.storage.toArray();
                System.out.println("Dispose macro cache " + arr.length + " " + this.getClass().getName());
                HashMap classes = new HashMap();
                for (Object o : arr) {
                    if (o == null) continue;
                    Integer i = (Integer)classes.get(o.getClass());
                    i = i != null ? Integer.valueOf(i + 1) : Integer.valueOf(1);
                    classes.put(o.getClass(), i);
                }
                for (Map.Entry e : classes.entrySet()) {
                    System.out.println("   " + e.getValue() + " of " + ((Class)e.getKey()).getName());
                }
            }
            if (this.storage.size() > 0) {
                this.storage.clear();
                this.storage.resize(this.initialCapacity);
            }
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    public static enum CacheKind {
        Single,
        Sliced;

    }
}

