/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard;

import com.sun.javacard.Portability;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AID {
    public static final String AID_AUTHORITY = "//aid/";
    private byte[] rid;
    private byte[] pix;
    static final Pattern AID_PARSE_PATTERN = Pattern.compile("//aid/((.+)/(.+)|(.+))");

    private AID(byte[] rid, byte[] pix) {
        if (rid == null) {
            throw new NullPointerException("Null RID");
        }
        if (pix == null) {
            throw new NullPointerException("Null PIX");
        }
        if (rid.length != 5) {
            throw new IllegalArgumentException("RID must be exactly 5 bytes in length");
        }
        if (pix.length > 11) {
            throw new IllegalArgumentException("PIX must be 0-11 bytes in length");
        }
        this.rid = rid;
        this.pix = pix;
    }

    public AID increment() {
        byte[] newPix = this.getPix();
        if (newPix.length == 0) {
            newPix = new byte[]{1};
        } else {
            int n = newPix.length - 1;
            newPix[n] = (byte)(newPix[n] + 1);
        }
        return new AID(this.getRid(), newPix);
    }

    public byte[] getRid() {
        return (byte[])this.rid.clone();
    }

    public byte[] getPix() {
        return (byte[])this.pix.clone();
    }

    public String getRidAsString() {
        return AID.getStringForByteArray(this.rid);
    }

    public String getPixAsString() {
        return AID.getStringForByteArray(this.pix);
    }

    public boolean equals(Object o) {
        boolean res;
        if (o == this) {
            return true;
        }
        boolean bl = res = o != null && AID.class == o.getClass();
        if (res) {
            AID other = (AID)o;
            res = other.toString().equals(this.toString());
        }
        return res;
    }

    public int hashCode() {
        int hash = 571;
        hash = 3881 * hash + Arrays.hashCode(this.rid);
        hash = 5209 * hash + Arrays.hashCode(this.pix);
        return hash;
    }

    public String toString() {
        return AID_AUTHORITY + (AID.getStringForByteArray(this.rid) + '/' + AID.getStringForByteArray(this.pix)).toUpperCase();
    }

    public static AID parse(String aid) {
        if (aid == null) {
            throw new NullPointerException(Portability.getString("Null_aid"));
        }
        Matcher m = AID_PARSE_PATTERN.matcher(aid);
        if (m.lookingAt()) {
            if (m.groupCount() == 4) {
                String PIX;
                String RID = m.group(2) != null ? m.group(2) : m.group(4);
                String string = PIX = m.group(3) != null ? m.group(3) : "";
                if (RID.endsWith("/")) {
                    RID = RID.substring(0, RID.length() - 1);
                }
                if (RID.length() % 2 != 0) {
                    throw new IllegalArgumentException(Portability.getString("RID_does_not_have_an_even_number_of_characters"));
                }
                if (PIX.length() % 2 != 0) {
                    throw new IllegalArgumentException(Portability.getString("PIX_does_not_have_an_even_number_of_characters"));
                }
                if (RID.length() != 10) {
                    throw new IllegalArgumentException(Portability.getString("RID_is_not_5_bytes_long"));
                }
                if (PIX.length() > 22) {
                    throw new IllegalArgumentException(Portability.getString("Pix_too_long_-_must_be_0-11_bytes"));
                }
                byte[] rid = new byte[RID.length() / 2];
                try {
                    AID.getByteArrayForString(RID, rid, 0);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(Portability.getString("BAD_RID_HEX", RID), nfe);
                }
                byte[] pix = new byte[PIX.length() / 2];
                try {
                    AID.getByteArrayForString(PIX, pix, 0);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(Portability.getString("BAD_PIX_HEX", PIX), nfe);
                }
                for (char c : RID.toCharArray()) {
                    if (!Character.isLowerCase(c)) continue;
                    String s = new String(new char[]{c});
                    throw new IllegalArgumentException(Portability.getString("LOWER_CASE_IN_RID", s));
                }
                for (char c : PIX.toCharArray()) {
                    if (!Character.isLowerCase(c)) continue;
                    String s = new String(new char[]{c});
                    throw new IllegalArgumentException(Portability.getString("LOWER_CASE_IN_PIX", s));
                }
                return new AID(rid, pix);
            }
            if (m.groupCount() == 1) {
                String RID = m.group(1);
                if (RID.length() % 2 != 0) {
                    throw new IllegalArgumentException(Portability.getString("RID_does_not_have_an_even_number_of_characters"));
                }
                if (RID.length() != 10) {
                    throw new IllegalArgumentException(Portability.getString("RID_is_not_5_bytes_long"));
                }
                for (char c : RID.toCharArray()) {
                    if (!Character.isLowerCase(c)) continue;
                    String s = new String(new char[]{c});
                    throw new IllegalArgumentException(Portability.getString("LOWER_CASE_IN_RID", s));
                }
                byte[] b = new byte[RID.length() / 2];
                try {
                    AID.getByteArrayForString(RID, b, 0);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(Portability.getString("BAD_RID_HEX", RID), nfe);
                }
                return new AID(b, new byte[0]);
            }
            throw new IllegalArgumentException(Portability.getString("Could_not_find_an_AID_in_", aid));
        }
        throw new IllegalArgumentException(Portability.getString("Could_not_find_an_AID_in_", aid));
    }

    public static AID generatePackageAid(byte[] RID, String packageName) {
        byte[] PIX = AID.packageHash(packageName, 7);
        PIX[0] = AID.firstByteOfPackagePIX(packageName.hashCode());
        return new AID(RID, PIX);
    }

    public static AID generateApplicationAid(byte[] RID, String fqn) {
        int ix = fqn.lastIndexOf(46);
        String pkg = null;
        String clazz = null;
        if (ix > 0) {
            pkg = fqn.substring(0, ix);
            clazz = ix != fqn.length() - 2 ? fqn.substring(ix + 1) : "Foobar";
        } else {
            pkg = "com.foo.bar";
            clazz = "Baz";
        }
        return AID.generateApplicationAid(RID, pkg, clazz);
    }

    public static AID generateApplicationAid(byte[] RID, String packageName, String clazz) {
        byte[] PIX = AID.packageHash(packageName, 5);
        if (PIX.length == 0) {
            PIX = AID.packageHash("com.foo.bar.baz.myapp", 5);
        }
        PIX[PIX.length - 1] = AID.byteHash(clazz);
        return new AID(RID, PIX);
    }

    public static AID generateInstanceAid(byte[] RID, String packageName, String clazz) {
        byte[] PIX = new byte[7];
        Random r = new Random((packageName + clazz).hashCode());
        r.nextBytes(PIX);
        PIX[0] = AID.firstByteOfInstancePIX(clazz.hashCode());
        return new AID(RID, PIX);
    }

    private static byte firstByteOfInstancePIX(int seed) {
        Random r = new Random(seed);
        int range = 126;
        byte result = (byte)(r.nextInt(range) + 128);
        return result;
    }

    private static byte firstByteOfPackagePIX(int seed) {
        Random r = new Random(seed);
        int range = 127;
        byte result = (byte)r.nextInt(range);
        return result;
    }

    private static byte[] packageHash(String packageName, int maxBytes) {
        if (packageName.length() <= 1) {
            Random r = new Random(System.currentTimeMillis());
            byte[] result = new byte[maxBytes];
            r.nextBytes(result);
            return result;
        }
        String[] parts = packageName.split("\\.");
        byte[] result = new byte[Math.min(maxBytes, parts.length)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = AID.byteHash(parts[i]);
        }
        return result;
    }

    private static byte byteHash(String packageNamePart) {
        byte[] b = packageNamePart.getBytes();
        int min = 127;
        int max = -128;
        for (byte aB : b) {
            min = (byte)Math.min(min, aB);
            max = (byte)Math.max(max, aB);
        }
        byte multiplier = min != max ? (byte)(255 / (max - min)) : (byte)1;
        byte result = 0;
        for (int i = 0; i < b.length; ++i) {
            byte next = (byte)(b[i] * multiplier);
            if (i % 2 == 0) {
                next = (byte)(next + 1);
            }
            result = (byte)(result ^ next);
        }
        return result;
    }

    public static int getByteArrayForString(String number, byte[] outputArray, int offset) {
        int length = number.length();
        if (length % 2 != 0) {
            throw new NumberFormatException("Odd number of digits");
        }
        for (int startIndex = 0; startIndex < number.length(); startIndex += 2) {
            String smallNumber = number.substring(startIndex, startIndex + 2);
            outputArray[offset++] = (byte)Integer.parseInt(smallNumber, 16);
        }
        return offset;
    }

    public static String getStringForByteArray(byte[] input) {
        StringBuffer sb = new StringBuffer();
        for (byte num : input) {
            String hex = Integer.toHexString(num & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex);
        }
        return sb.toString().toUpperCase();
    }
}

