/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.filemodels.FileModelEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class FileModel<T extends FileModelEntry> {
    private volatile boolean closed;
    private final List<T> data = new ArrayList<T>();
    private volatile boolean error;
    private volatile boolean hasUnknownTags;
    private final Object dataLock = new Object();

    public final boolean hasUnknownTags() {
        return this.hasUnknownTags;
    }

    final void unknownTagEncountered() {
        this.hasUnknownTags = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(T t) {
        Object object = this.dataLock;
        synchronized (object) {
            this.data.remove(t);
        }
    }

    public abstract String toXml();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<? extends T> getData() {
        ArrayList<T> result = new ArrayList<T>();
        Object object = this.dataLock;
        synchronized (object) {
            result.addAll(this.data);
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(T entry) {
        if (this.closed) {
            throw new IllegalStateException("Adding to completed model");
        }
        Object object = this.dataLock;
        synchronized (object) {
            this.data.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.dataLock;
        synchronized (object) {
            this.data.clear();
        }
        this.closed = false;
    }

    public final void close() {
        this.closed = true;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.data.isEmpty();
        }
    }

    public final boolean isError() {
        return this.error;
    }

    protected final void error() {
        this.error = true;
    }

    protected String getProblemInternal() {
        return null;
    }

    public final String getProblem() {
        String problem;
        block1: {
            FileModelEntry entry;
            problem = this.getProblemInternal();
            if (problem != null) break block1;
            Iterator<T> i$ = this.getData().iterator();
            while (i$.hasNext() && (problem = (entry = (FileModelEntry)i$.next()).getProblem()) == null) {
            }
        }
        return problem;
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = o == null ? false : (result = o.getClass() == this.getClass());
        if (result) {
            FileModel other = (FileModel)o;
            List<T> myData = this.getData();
            List<T> otherData = other.getData();
            result = myData.equals(otherData);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.data.hashCode();
        }
    }
}

