/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.actions.Closable;
import org.netbeans.modules.web.inspect.webkit.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetHeader;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class RemoteStyleSheetCache {
    private static final RemoteStyleSheetCache DEFAULT = new RemoteStyleSheetCache();
    private final Map<StyleSheetBody, FileObject> cache = new HashMap<StyleSheetBody, FileObject>();

    public static RemoteStyleSheetCache getDefault() {
        return DEFAULT;
    }

    private RemoteStyleSheetCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFileObject(StyleSheetBody body) {
        RemoteStyleSheetCache remoteStyleSheetCache = this;
        synchronized (remoteStyleSheetCache) {
            FileObject fob = this.cache.get(body);
            if (fob == null) {
                fob = new StyleSheetFileObject(body);
                this.cache.put(body, fob);
            }
            return fob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        RemoteStyleSheetCache remoteStyleSheetCache = this;
        synchronized (remoteStyleSheetCache) {
            Collection<FileObject> files = this.cache.values();
            RemoteStyleSheetCache.closeFiles(new ArrayList<FileObject>(files));
            this.cache.clear();
        }
    }

    private static void closeFiles(final Collection<FileObject> files) {
        if (EventQueue.isDispatchThread()) {
            for (FileObject file : files) {
                try {
                    DataObject dob = DataObject.find((FileObject)file);
                    Closable close = (Closable)dob.getLookup().lookup(Closable.class);
                    if (close == null) continue;
                    close.close();
                }
                catch (DataObjectNotFoundException dnfex) {
                    Logger.getLogger(RemoteStyleSheetCache.class.getName()).log(Level.INFO, null, dnfex);
                }
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteStyleSheetCache.closeFiles(files);
                }
            });
        }
    }

    static class DummyFileSystem
    extends FileSystem {
        private final FileObject root;

        DummyFileSystem(FileObject root) {
            this.root = root;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DummyFileSystem.class, (String)"RemoteStyleSheetCache.downloadedStyleSheets");
        }

        public boolean isReadOnly() {
            return true;
        }

        public FileObject getRoot() {
            return this.root;
        }

        public FileObject findResource(String name) {
            return null;
        }

        public SystemAction[] getActions() {
            return new SystemAction[0];
        }
    }

    static class StyleSheetFileObject
    extends FileObject {
        private transient StyleSheetBody body;
        private StyleSheetFileObject child;
        private StyleSheetFileObject parent;
        private FileSystem fs;
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        StyleSheetFileObject(StyleSheetBody body) {
            this.body = body;
            this.parent = new StyleSheetFileObject(this);
            this.fs = this.parent.fs;
        }

        StyleSheetFileObject(StyleSheetFileObject child) {
            this.child = child;
            this.fs = new DummyFileSystem(this);
        }

        private String getSpecifiedName() {
            String name = null;
            if (this.body != null) {
                List rules = this.body.getRules();
                if (rules.isEmpty()) {
                    StyleSheetHeader header = this.body.getHeader();
                    if (header != null) {
                        name = header.getSourceURL();
                    }
                } else {
                    Rule rule = (Rule)rules.get(0);
                    name = rule.getSourceURL();
                }
                if (name == null) {
                    name = this.body.getStyleSheetId();
                } else {
                    int index = name.lastIndexOf(47);
                    if ((name = name.substring(index + 1)).endsWith(".css")) {
                        name = name.substring(0, name.length() - 4);
                    }
                }
            }
            return name;
        }

        public String getName() {
            String name = this.getSpecifiedName();
            if (name == null || name.isEmpty()) {
                name = Bundle.RemoteStyleSheetCache_generatedStylesheet();
            }
            return name;
        }

        public String getExt() {
            String name = this.getSpecifiedName();
            return name == null || name.isEmpty() ? "" : "css";
        }

        public String getMIMEType() {
            return "text/css";
        }

        public String getMIMEType(String ... withinMIMETypes) {
            return this.getMIMEType();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            throw new IOException();
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fs;
        }

        public FileObject getParent() {
            return this.parent;
        }

        public boolean isFolder() {
            return this.body == null;
        }

        public Date lastModified() {
            return new Date();
        }

        public boolean isRoot() {
            return this.isFolder();
        }

        public boolean isData() {
            return !this.isFolder();
        }

        public boolean isValid() {
            return true;
        }

        public void delete(FileLock lock) throws IOException {
            throw new IOException();
        }

        public Object getAttribute(String attrName) {
            return this.attributes.get(attrName);
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            this.attributes.put(attrName, value);
        }

        public Enumeration<String> getAttributes() {
            return Collections.enumeration(this.attributes.keySet());
        }

        public void addFileChangeListener(FileChangeListener fcl) {
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
        }

        public long getSize() {
            return this.body.getText().length();
        }

        public InputStream getInputStream() throws FileNotFoundException {
            return new ByteArrayInputStream(this.body.getText().getBytes());
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            throw new IOException();
        }

        public FileLock lock() throws IOException {
            return FileLock.NONE;
        }

        public void setImportant(boolean b) {
        }

        public FileObject[] getChildren() {
            FileObject[] children = this.child == null ? new FileObject[]{} : new FileObject[]{this.child};
            return children;
        }

        public FileObject getFileObject(String name, String ext) {
            return null;
        }

        public FileObject createFolder(String name) throws IOException {
            throw new IOException();
        }

        public FileObject createData(String name, String ext) throws IOException {
            throw new IOException();
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

