/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.impl.fileoperations.spi.RemoteVcsSupportUtil;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remotefs.versioning.spi.RemoteVcsSupportImplementation;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class RemoteVcsSupportImpl
implements RemoteVcsSupportImplementation {
    private static final Logger LOGGER = Logger.getLogger("remote.vcs.logger");

    public JFileChooser createFileChooser(VCSFileProxy proxy) {
        FileSystem fs = this.getFileSystem(proxy);
        FileChooserBuilder fcb = new FileChooserBuilder(FileSystemProvider.getExecutionEnvironment((FileSystem)fs));
        FileChooserBuilder.JFileChooserEx chooser = fcb.createFileChooser(proxy.getPath());
        return chooser;
    }

    public VCSFileProxy getSelectedFile(JFileChooser chooser) {
        if (chooser instanceof FileChooserBuilder.JFileChooserEx) {
            FileChooserBuilder.JFileChooserEx chooserEx = (FileChooserBuilder.JFileChooserEx)chooser;
            FileObject fo = chooserEx.getSelectedFileObject();
            if (fo != null) {
                return VCSFileProxy.createFileProxy((FileObject)fo);
            }
            File file = chooser.getSelectedFile();
            if (file != null) {
                String path = file.getPath();
                ExecutionEnvironment env = chooserEx.getExecutionEnvironment();
                FileSystem fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
                return VCSFileProxy.createFileProxy((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)fileSystem.getRoot()), (String)path);
            }
        } else {
            File file = chooser.getSelectedFile();
            if (file != null) {
                return VCSFileProxy.createFileProxy((File)file);
            }
        }
        return null;
    }

    public FileSystem getFileSystem(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            return FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        }
        VCSFileProxy root = this.getRootFileProxy(proxy);
        try {
            return root.toFileObject().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private VCSFileProxy getRootFileProxy(VCSFileProxy proxy) {
        VCSFileProxy root = proxy;
        while (root.getParentFile() != null) {
            root = root.getParentFile();
        }
        return root;
    }

    public FileSystem[] getFileSystems() {
        List execEnvs = ConnectionManager.getInstance().getRecentConnections();
        ArrayList<FileSystem> fileSystems = new ArrayList<FileSystem>(execEnvs.size());
        for (ExecutionEnvironment env : execEnvs) {
            if (!env.isRemote()) continue;
            fileSystems.add(FileSystemProvider.getFileSystem((ExecutionEnvironment)env));
        }
        return fileSystems.toArray(new FileSystem[fileSystems.size()]);
    }

    public FileSystem[] getConnectedFileSystems() {
        return RemoteVcsSupportUtil.getConnectedFileSystems();
    }

    public FileSystem getDefaultFileSystem() {
        FileSystem[] fsList = this.getFileSystems();
        return fsList.length > 0 ? fsList[0] : null;
    }

    public boolean isSymlink(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            Path path = file.toPath();
            return Files.isSymbolicLink(path);
        }
        return RemoteVcsSupportUtil.isSymbolicLink((FileSystem)this.getFileSystem(proxy), (String)proxy.getPath());
    }

    public String readSymbolicLinkPath(VCSFileProxy proxy) throws IOException {
        File file = proxy.toFile();
        if (file != null) {
            Path path = file.toPath();
            return Files.readSymbolicLink(path).toString();
        }
        return RemoteVcsSupportUtil.readSymbolicLinkPath((FileSystem)this.getFileSystem(proxy), (String)proxy.getPath());
    }

    public boolean canRead(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            return file.canRead();
        }
        return RemoteVcsSupportUtil.canRead((FileSystem)this.getFileSystem(proxy), (String)proxy.getPath());
    }

    public boolean canRead(VCSFileProxy base, String subdir) {
        File baseFile = base.toFile();
        if (baseFile != null) {
            if (baseFile.isFile()) {
                return false;
            }
            return new File(baseFile, subdir).canRead();
        }
        if (base.isFile()) {
            return false;
        }
        String path = base.getPath().trim();
        path = path + (path.endsWith("/") || subdir.startsWith("/") ? "" : "/") + subdir;
        return RemoteVcsSupportUtil.canRead((FileSystem)this.getFileSystem(base), (String)path);
    }

    public String getCanonicalPath(VCSFileProxy proxy) throws IOException {
        File file = proxy.toFile();
        if (file != null) {
            File canonicalFile = file.getCanonicalFile();
            return canonicalFile.getAbsolutePath();
        }
        String canonical = RemoteVcsSupportUtil.getCanonicalPath((FileSystem)this.getFileSystem(proxy), (String)proxy.getPath());
        return canonical == null ? proxy.getPath() : canonical;
    }

    public VCSFileProxy getCanonicalFile(VCSFileProxy proxy) throws IOException {
        File file = proxy.toFile();
        if (file != null) {
            File canonicalFile = file.getCanonicalFile();
            return VCSFileProxy.createFileProxy((File)canonicalFile);
        }
        String canonical = RemoteVcsSupportUtil.getCanonicalPath((FileSystem)this.getFileSystem(proxy), (String)proxy.getPath());
        if (canonical == null) {
            return proxy;
        }
        VCSFileProxy root = this.getRootFileProxy(proxy);
        return VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)canonical);
    }

    private void reportHostInfoNotAvailable(ExecutionEnvironment env) {
        IllegalStateException ex = new IllegalStateException("Host info is not available for " + env);
        Logger.getLogger(RemoteVcsSupportImpl.class.getName()).log(Level.SEVERE, null, ex);
    }

    private VCSFileProxy getFakeHome(FileSystem fs) {
        VCSFileProxy root = VCSFileProxy.createFileProxy((FileObject)fs.getRoot());
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
        return VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)("/home/" + env.getUser()));
    }

    public VCSFileProxy getHome(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            return VCSFileProxy.createFileProxy((File)new File(System.getProperty("user.home")));
        }
        FileSystem fs = this.getFileSystem(proxy);
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
            try {
                String userDir = HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir();
                VCSFileProxy root = this.getRootFileProxy(proxy);
                return VCSFileProxy.createFileProxy((VCSFileProxy)root, (String)userDir);
            }
            catch (IOException ex) {
                Logger.getLogger(RemoteVcsSupportImpl.class.getName()).log(Level.SEVERE, null, ex);
                return this.getFakeHome(fs);
            }
            catch (ConnectionManager.CancellationException ex) {
                return this.getFakeHome(fs);
            }
        }
        this.reportHostInfoNotAvailable(env);
        return this.getFakeHome(fs);
    }

    public boolean isMac(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            return Utilities.isMac();
        }
        FileSystem fs = this.getFileSystem(proxy);
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
            try {
                return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getOSFamily() == HostInfo.OSFamily.MACOSX;
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                Logger.getLogger(RemoteVcsSupportImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        this.reportHostInfoNotAvailable(env);
        return false;
    }

    public boolean isSolaris(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            return System.getProperty("os.name").startsWith("SunOS");
        }
        FileSystem fs = this.getFileSystem(proxy);
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
            try {
                return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getOSFamily() == HostInfo.OSFamily.SUNOS;
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                Logger.getLogger(RemoteVcsSupportImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        this.reportHostInfoNotAvailable(env);
        return false;
    }

    public boolean isUnix(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            return Utilities.isUnix();
        }
        FileSystem fs = this.getFileSystem(proxy);
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
            try {
                switch (HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getOSFamily()) {
                    case LINUX: 
                    case MACOSX: 
                    case SUNOS: {
                        return true;
                    }
                    case WINDOWS: {
                        return false;
                    }
                    case UNKNOWN: {
                        return false;
                    }
                }
                throw new IllegalStateException("Unexpected OSFamily: " + this);
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                Logger.getLogger(RemoteVcsSupportImpl.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        this.reportHostInfoNotAvailable(env);
        return false;
    }

    public long getSize(VCSFileProxy proxy) {
        File file = proxy.toFile();
        if (file != null) {
            return file.length();
        }
        return RemoteVcsSupportUtil.getSize((FileSystem)this.getFileSystem(proxy), (String)proxy.getPath());
    }

    public OutputStream getOutputStream(VCSFileProxy proxy) throws IOException {
        File file = proxy.toFile();
        if (file != null) {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            return new FileOutputStream(file);
        }
        return RemoteVcsSupportUtil.getOutputStream((FileSystem)this.getFileSystem(proxy), (String)proxy.getPath());
    }

    public String getFileSystemKey(FileSystem fs) {
        String toUrl = FileSystemProvider.toUrl((FileSystem)fs, (String)"/");
        return toUrl.substring(0, toUrl.indexOf(47));
    }

    public boolean isConnectedFileSystem(FileSystem file) {
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)file);
        return ConnectionManager.getInstance().isConnectedTo(env);
    }

    public void connectFileSystem(FileSystem file) {
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)file);
        ConnectionManager.getInstance().connect(env);
    }

    public String toString(VCSFileProxy proxy) {
        return FileSystemProvider.toUrl((FileSystem)this.getFileSystem(proxy), (String)proxy.getPath());
    }

    public VCSFileProxy fromString(String proxyString) {
        FileSystem fs = FileSystemProvider.urlToFileSystem((String)proxyString);
        VCSFileProxy rootProxy = VCSFileProxy.createFileProxy((FileObject)fs.getRoot());
        return VCSFileProxy.createFileProxy((VCSFileProxy)rootProxy, (String)proxyString);
    }

    public void delete(VCSFileProxy file) {
        File javaFile = file.toFile();
        if (javaFile != null) {
            RemoteVcsSupportImpl.deleteRecursively(javaFile);
        } else {
            RemoteVcsSupportUtil.delete((FileSystem)this.getFileSystem(file), (String)file.getPath());
        }
    }

    public void deleteExternally(VCSFileProxy file) {
        File javaFile = file.toFile();
        if (javaFile != null) {
            RemoteVcsSupportImpl.deleteRecursively(javaFile);
        } else {
            RemoteVcsSupportUtil.deleteExternally((FileSystem)this.getFileSystem(file), (String)file.getPath());
        }
    }

    private static void deleteRecursively(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                RemoteVcsSupportImpl.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public void setLastModified(VCSFileProxy file, VCSFileProxy referenceFile) {
        File javaFile = file.toFile();
        if (javaFile != null) {
            javaFile.setLastModified(referenceFile.lastModified());
        } else {
            RemoteVcsSupportUtil.setLastModified((FileSystem)this.getFileSystem(file), (String)file.getPath(), (String)referenceFile.getPath());
        }
    }

    public FileSystem readFileSystem(DataInputStream is) throws IOException {
        String uri = is.readUTF();
        try {
            return FileSystemProvider.getFileSystem((URI)new URI(uri));
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public void writeFileSystem(DataOutputStream os, FileSystem fs) throws IOException {
        os.writeUTF(fs.getRoot().toURI().toString());
    }

    public void refreshFor(FileSystem fs, String ... paths) throws ConnectException, IOException {
        RemoteVcsSupportUtil.refreshFor((FileSystem)fs, (String[])paths);
    }
}

