/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.BackendLauncher;
import org.netbeans.modules.php.dbgp.Bundle;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.SingleThread;
import org.netbeans.modules.php.dbgp.breakpoints.BreakpointModel;
import org.netbeans.modules.php.dbgp.models.AbstractIDEBridge;
import org.netbeans.modules.php.dbgp.models.CallStackModel;
import org.netbeans.modules.php.dbgp.models.ThreadsModel;
import org.netbeans.modules.php.dbgp.models.VariablesModel;
import org.netbeans.modules.php.dbgp.models.WatchesModel;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpMessage;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.netbeans.modules.php.dbgp.packets.Error;
import org.netbeans.modules.php.dbgp.packets.InitMessage;
import org.netbeans.modules.php.dbgp.packets.Reason;
import org.netbeans.modules.php.dbgp.packets.StackGetCommand;
import org.netbeans.modules.php.dbgp.packets.Status;
import org.netbeans.modules.php.dbgp.packets.StopCommand;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DebugSession
extends SingleThread {
    private static final Logger LOGGER = Logger.getLogger(DebugSession.class.getName());
    private static final int SLEEP_TIME = 100;
    private static final AtomicInteger TRANSACTION_ID = new AtomicInteger(0);
    private final DebuggerOptions options;
    private final BackendLauncher backendLauncher;
    private final AtomicReference<Status> status;
    private Session session;
    private Socket sessionSocket;
    private final AtomicBoolean detachRequest;
    private final AtomicBoolean stopRequest;
    private Thread sessionThread;
    private final List<DbgpCommand> commands = new LinkedList<DbgpCommand>();
    private AtomicReference<SessionId> sessionId;
    private AtomicReference<DebuggerEngine> engine;
    private IDESessionBridge myBridge;
    private AtomicReference<String> myFileName;

    DebugSession(DebuggerOptions options, BackendLauncher backendLauncher) {
        this.detachRequest = new AtomicBoolean(false);
        this.stopRequest = new AtomicBoolean(false);
        this.sessionId = new AtomicReference();
        this.backendLauncher = backendLauncher;
        this.status = new AtomicReference();
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessing(Socket socket) {
        Object object = this.getSync();
        synchronized (object) {
            try {
                Status stat = this.getStatus();
                this.detachRequest.set(true);
                if (stat != null) {
                    this.waitFinished();
                }
                this.sessionSocket = socket;
                FutureTask invokeLater = this.invokeLater();
                invokeLater.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.preprocess();
        try {
            while (!this.detachRequest.get()) {
                try {
                    this.sendCommands();
                    this.receiveData();
                    this.sleepTillNewCommand();
                }
                catch (SocketException exc) {
                    this.log(exc);
                    this.detachRequest.set(true);
                    this.stop();
                }
                catch (IOException e) {
                    this.log(e);
                }
                catch (Throwable e) {
                    this.log(e, Level.SEVERE);
                }
            }
        }
        finally {
            this.postprocess();
        }
    }

    private void preprocess() {
        this.detachRequest.set(false);
        this.stopRequest.set(false);
        this.commands.clear();
        this.sessionId.set(null);
        this.myBridge = new IDESessionBridge();
        this.myFileName = new AtomicReference();
        this.engine = new AtomicReference();
        this.setSessionThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postprocess() {
        try {
            this.getSocket().close();
        }
        catch (IOException e) {
            this.log(e);
        }
        finally {
            this.setSessionThread(null);
            IDESessionBridge bridge = this.getBridge();
            if (bridge != null) {
                bridge.destroy();
            }
        }
    }

    public void initConnection(InitMessage message) {
        DebuggerEngine[] engines;
        this.setSessionFile(message.getFileUri());
        for (DebuggerEngine nextEngine : engines = DebuggerManager.getDebuggerManager().getDebuggerEngines()) {
            SessionId id = (SessionId)nextEngine.lookupFirst(null, SessionId.class);
            if (id == null || !id.getId().equals(message.getSessionId())) continue;
            this.sessionId.set(id);
            id.initialize(message.getFileUri(), this.options.getPathMapping());
            this.engine.set(nextEngine);
        }
        IDESessionBridge bridge = this.getBridge();
        if (bridge != null) {
            bridge.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommands() throws IOException {
        ArrayList<DbgpCommand> list;
        List<DbgpCommand> list2 = this.commands;
        synchronized (list2) {
            list = new ArrayList<DbgpCommand>(this.commands);
            this.commands.clear();
        }
        for (DbgpCommand command : list) {
            if (this.detachRequest.get()) continue;
            command.send(this.getSocket().getOutputStream());
            if (!command.wantAcknowledgment()) continue;
            this.receiveData(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommandLater(DbgpCommand command) {
        DebugSession debugSession = this;
        synchronized (debugSession) {
            if (this.getSessionId() == null) {
                return;
            }
            if (this.getSessionThread() == null) {
                return;
            }
            this.addCommand(command);
        }
    }

    public DbgpResponse sendSynchronCommand(DbgpCommand command) {
        DbgpResponse retval = null;
        if (this.canSendSynchronCommand()) {
            try {
                DbgpMessage message;
                command.send(this.getSocket().getOutputStream());
                if (command.wantAcknowledgment() && (message = this.receiveData(command)) instanceof DbgpResponse) {
                    retval = (DbgpResponse)message;
                }
            }
            catch (SocketException e) {
                this.log(e);
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        return retval;
    }

    private void receiveData() throws IOException {
        this.receiveData(null);
    }

    private DbgpMessage receiveData(DbgpCommand command) throws IOException {
        if (command != null && command.getCommand().equals("stop")) {
            this.detachRequest.set(true);
        }
        if (command != null || this.getSocket().getInputStream().available() > 0) {
            DbgpMessage message;
            try {
                message = DbgpMessage.create(this.getSocket().getInputStream(), this.options.getProjectEncoding());
            }
            catch (SocketException ex) {
                LOGGER.log(Level.INFO, "COMMAND: " + command.toString() + "; TRANS_ID: " + command.getTransactionId() + "; WANT_ACK: " + command.wantAcknowledgment(), ex);
                throw ex;
            }
            this.handleMessage(command, message);
            return message;
        }
        return null;
    }

    private void handleMessage(DbgpCommand command, DbgpMessage message) throws IOException {
        if (message == null) {
            return;
        }
        if (command == null) {
            message.process(this, null);
            return;
        }
        boolean awaited = false;
        if (message instanceof DbgpResponse) {
            String id;
            DbgpResponse response = (DbgpResponse)message;
            Error error = response.getError();
            if (error != null) {
                String errorMessage = Bundle.XdebugError(error.getErrorCode(), error.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errorMessage, 2));
                LOGGER.log(Level.INFO, "PHP_XDEBUG_ERROR - code: {0}, message: {1}", new Object[]{error.getErrorCode(), error.getMessage()});
            }
            if ((id = response.getTransactionId()).equals(command.getTransactionId())) {
                awaited = true;
                message.process(this, command);
            }
        }
        if (!awaited) {
            message.process(this, null);
            this.receiveData(command);
        }
    }

    private boolean canSendSynchronCommand() {
        Thread currentSessionThread = this.getSessionThread();
        if (currentSessionThread == null) {
            return false;
        }
        if (currentSessionThread != Thread.currentThread()) {
            this.printing146558(Thread.currentThread());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printing146558(Thread currentThread) {
        IllegalStateException illegalStateException = new IllegalStateException("Method incorrect usage. It should be called in handler thread only. Called from thread: " + currentThread.getName());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            illegalStateException.printStackTrace(new PrintStream((OutputStream)bos, false, Charset.defaultCharset().name()));
            LOGGER.log(Level.WARNING, bos.toString(Charset.defaultCharset().name()));
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public boolean cancel() {
        return true;
    }

    public void processStatus(Status status, Reason reason, DbgpCommand command) {
        this.setStatus(status);
        if (status.isBreak() && reason.isOK()) {
            this.processBreakStatus();
        } else if (status.isStopping()) {
            this.processStoppingStatus();
        } else if (status.isStopped()) {
            this.processStoppedStatus();
        }
    }

    public void stopSession() {
        this.sendStopCommand();
        this.stop();
    }

    private void stop() {
        if (!this.stopRequest.get()) {
            this.stopRequest.set(true);
            this.stopEngines();
            this.stopBackend();
        }
    }

    private void processBreakStatus() {
        this.sendCommandLater(new StackGetCommand(this.getTransactionId()));
        IDESessionBridge bridge = this.getBridge();
        if (bridge != null) {
            bridge.setSuspended(true);
            ThreadsModel threadsModel = bridge.getThreadsModel();
            if (threadsModel != null) {
                threadsModel.updateSession(this);
            }
        }
    }

    private void processStoppingStatus() {
        this.detachRequest.set(true);
        this.processStoppedStatus();
    }

    private void processStoppedStatus() {
        if (this.getOptions().isDebugForFirstPageOnly()) {
            this.stop();
        }
    }

    private void sendStopCommand() {
        boolean isDetached = this.detachRequest.get();
        if (!isDetached) {
            Thread currentThread = Thread.currentThread();
            StopCommand stopCommand = new StopCommand(this.getTransactionId());
            if (currentThread == this.getSessionThread()) {
                this.sendSynchronCommand(stopCommand);
            } else {
                this.sendCommandLater(stopCommand);
            }
        }
    }

    private void stopEngines() {
        SessionManager.stopEngines(this.session);
    }

    public String getTransactionId() {
        return TRANSACTION_ID.getAndIncrement() + "";
    }

    public SessionId getSessionId() {
        return this.sessionId.get();
    }

    public IDESessionBridge getBridge() {
        return this.myBridge;
    }

    public String getFileName() {
        return this.myFileName.get();
    }

    private void setSessionFile(String fileName) {
        this.myFileName.set(fileName);
    }

    private void sleepTillNewCommand() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void setSessionThread(Thread thread) {
        this.sessionThread = thread;
    }

    private void warnUserInCaseOfSocketException() {
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)NbBundle.getMessage(DebugSession.class, (String)"MSG_SocketError"), NbBundle.getMessage(DebugSession.class, (String)"MSG_SocketErrorTitle"), 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommand(DbgpCommand command) {
        List<DbgpCommand> list = this.commands;
        synchronized (list) {
            this.commands.add(command);
        }
    }

    private synchronized Thread getSessionThread() {
        return this.sessionThread;
    }

    private Socket getSocket() {
        return this.sessionSocket;
    }

    private void log(IOException e) {
        this.log(e, Level.SEVERE);
    }

    private void log(Throwable e, Level level) {
        LOGGER.log(level, null, e);
    }

    private void log(SocketException e) {
        this.log(e, Level.INFO);
        this.warnUserInCaseOfSocketException();
    }

    public DebuggerOptions getOptions() {
        return this.options;
    }

    void startBackend() {
        if (this.backendLauncher != null) {
            this.backendLauncher.launch();
        }
    }

    void stopBackend() {
        if (this.backendLauncher != null) {
            this.backendLauncher.stop();
        }
    }

    public Status getStatus() {
        return this.status.get();
    }

    public void setStatus(Status status) {
        assert (status != null);
        if (status == Status.BREAK) {
            assert (this.getSession() != null);
            DebuggerManager.getDebuggerManager().setCurrentSession(this.getSession());
        }
        this.status.set(status);
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public class IDESessionBridge
    extends AbstractIDEBridge {
        @Override
        protected DebuggerEngine getEngine() {
            return (DebuggerEngine)DebugSession.this.engine.get();
        }

        @Override
        protected DebugSession getDebugSession() {
            return DebugSession.this;
        }

        private void init() {
            this.hideAnnotations();
            this.setSuspended(false);
            ThreadsModel threadsModel = this.getThreadsModel();
            if (threadsModel != null) {
                threadsModel.update();
            }
        }

        private void destroy() {
            WatchesModel watchesModel;
            VariablesModel variablesModel;
            ThreadsModel threadsModel;
            CallStackModel callStackModel;
            this.setSuspended(false);
            this.hideAnnotations();
            BreakpointModel breakpointModel = this.getBreakpointModel();
            if (breakpointModel != null) {
                breakpointModel.setCurrentStack(null, DebugSession.this);
            }
            if ((callStackModel = this.getCallStackModel()) != null) {
                callStackModel.clearModel();
            }
            if ((threadsModel = this.getThreadsModel()) != null) {
                threadsModel.update();
            }
            if ((variablesModel = this.getVariablesModel()) != null) {
                variablesModel.clearModel();
            }
            if ((watchesModel = this.getWatchesModel()) != null) {
                watchesModel.clearModel();
            }
        }
    }
}

