/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.ProxyClient;
import org.netbeans.modules.php.dbgp.SingleThread;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class ServerThread
extends SingleThread {
    private static final int TIMEOUT = 10000;
    private static final String PORT_OCCUPIED = "MSG_PortOccupied";
    private int myPort;
    private ServerSocket myServer;
    private AtomicBoolean isStopped = new AtomicBoolean(false);

    ServerThread() {
    }

    @Override
    public void run() {
        this.isStopped = new AtomicBoolean(false);
        DebugSession debugSession = this.getDebugSession();
        ProxyClient proxy = null;
        if (debugSession != null && this.createServerSocket(debugSession)) {
            proxy = ProxyClient.getInstance(debugSession.getOptions());
            if (proxy != null) {
                proxy.register();
            }
            debugSession.startBackend();
            while (!this.isStopped() && this.getDebugSession() != null) {
                try {
                    Socket sessionSocket = this.myServer.accept();
                    if (this.isStopped.get() || sessionSocket == null) continue;
                    debugSession.startProcessing(sessionSocket);
                }
                catch (SocketTimeoutException e) {
                    this.log(e, Level.FINEST);
                }
                catch (IOException e) {
                    this.log(e);
                }
            }
            this.closeSocket();
        }
        if (proxy != null) {
            proxy.unregister();
        }
    }

    private DebugSession getDebugSession() {
        DebugSession retval = (DebugSession)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, DebugSession.class);
        if (retval == null) {
            Session session;
            Session[] sessions;
            Session[] arr$ = sessions = DebuggerManager.getDebuggerManager().getSessions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (retval = (DebugSession)(session = arr$[i$]).lookupFirst(null, DebugSession.class)) == null; ++i$) {
            }
        }
        return retval;
    }

    private void log(Throwable exception) {
        this.log(exception, Level.FINE);
    }

    private void log(Throwable exception, Level level) {
        Logger.getLogger(ServerThread.class.getName()).log(level, null, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createServerSocket(DebugSession debugSession) {
        Class<ServerThread> clazz = ServerThread.class;
        synchronized (ServerThread.class) {
            try {
                this.myPort = debugSession.getOptions().getPort();
                this.myServer = new ServerSocket(this.myPort);
                this.myServer.setSoTimeout(10000);
                this.myServer.setReuseAddress(true);
            }
            catch (IOException e) {
                String mesg = NbBundle.getMessage(ServerThread.class, (String)PORT_OCCUPIED);
                mesg = MessageFormat.format(mesg, this.myPort);
                NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)mesg, 0);
                Object choice = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (choice.equals(0)) {
                    Utils.openPhpOptionsDialog();
                }
                this.log(e);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Class<ServerThread> clazz = ServerThread.class;
        synchronized (ServerThread.class) {
            if (this.myServer == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                if (!this.myServer.isClosed()) {
                    this.myServer.close();
                }
            }
            catch (IOException e) {
                this.log(e);
            }
            return;
        }
    }

    @Override
    public boolean cancel() {
        this.isStopped.set(true);
        this.closeSocket();
        return true;
    }

    private boolean isStopped() {
        return this.isStopped.get();
    }
}

