/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.packets.Input;
import org.w3c.dom.Node;

public class Stack
extends Input {
    private static final String INPUT = "input";
    private static final String CMDEND = "cmdend";
    private static final String CMDBEGIN = "cmdbegin";
    private static final String WHERE = "where";

    Stack(Node node) {
        super(node);
    }

    public String getCurrentCommandName() {
        return this.getAttribute(WHERE);
    }

    public Position getCurrentInstructionStart() {
        return this.getPosition(CMDBEGIN);
    }

    public Position getCurrentInstructionEnd() {
        return this.getPosition(CMDEND);
    }

    public Input getInput() {
        Node node = this.getChild(INPUT);
        if (node == null) {
            return null;
        }
        return new Input(node);
    }

    private Position getPosition(String attrName) {
        String value = this.getAttribute(attrName);
        if (value == null) {
            return null;
        }
        String[] values = value.split(":");
        assert (values.length == 2);
        return new Position(values[0], values[1]);
    }

    public static final class Position {
        private int myLine;
        private int myOffset;

        private Position(String line, String offset) {
            try {
                this.myLine = Integer.parseInt(line);
                this.myOffset = Integer.parseInt(offset);
            }
            catch (NumberFormatException e) {
                this.myLine = -1;
                this.myOffset = -1;
            }
        }

        public int getLine() {
            return this.myLine;
        }

        public int getOffset() {
            return this.myOffset;
        }
    }

    public static enum Type {
        FILE,
        EVAL,
        QUEST;


        public String toString() {
            if (this != QUEST) {
                return super.toString().toLowerCase();
            }
            return "?";
        }

        public static Type forString(String str) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            return null;
        }
    }
}

