/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.team;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.api.queries.VersioningQuery;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.team.ide.spi.ProjectServices;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.netbeans.modules.team.spi.TeamAccessor;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.netbeans.modules.team.spi.TeamBugtrackingConnector;
import org.netbeans.modules.team.spi.TeamProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class TeamRepositories
implements PropertyChangeListener {
    private static TeamRepositories instance;
    private final Map<String, Object> teamLocks = new HashMap<String, Object>(1);
    private final Map<RepositoryImpl, TeamProject> repoToTeam = new WeakHashMap<RepositoryImpl, TeamProject>(5);
    private final Map<String, RepositoryImpl> repositoriesCache = Collections.synchronizedMap(new HashMap());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    protected TeamRepositories() {
    }

    public static synchronized TeamRepositories getInstance() {
        if (instance == null && (instance = (TeamRepositories)Lookup.getDefault().lookup(TeamRepositories.class)) == null) {
            instance = new DefaultImpl();
        }
        return instance;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        TeamAccessor[] teamAccessors;
        this.support.addPropertyChangeListener(listener);
        for (TeamAccessor teamAccessor : teamAccessors = TeamAccessorUtils.getTeamAccessors()) {
            teamAccessor.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        TeamAccessor[] teamAccessors;
        this.support.removePropertyChangeListener(listener);
        for (TeamAccessor teamAccessor : teamAccessors = TeamAccessorUtils.getTeamAccessors()) {
            teamAccessor.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void fireProjectsChanged(Collection<RepositoryImpl> removed, Collection<RepositoryImpl> added) {
        this.support.firePropertyChange("bugtracking.repositories.changed", removed, added);
    }

    public RepositoryImpl getRepository(String url, String projectName) {
        TeamProject p = TeamAccessorUtils.getTeamProject((String)url, (String)projectName);
        if (p == null) {
            return null;
        }
        return this.getRepository(p);
    }

    public RepositoryImpl getRepository(TeamProject kp) {
        return this.getRepository(kp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryImpl getRepository(TeamProject kp, boolean forceCreate) {
        Object lock;
        String repositoryKey = kp.getWebLocation().toString();
        BugtrackingManager.LOG.log(Level.FINER, "requesting repository for {0}", repositoryKey);
        Object object = lock = this.getTeamLock(kp);
        synchronized (object) {
            RepositoryImpl repository = this.repositoriesCache.get(repositoryKey);
            if (repository == null && forceCreate) {
                repository = this.createRepository(kp);
                if (repository != null) {
                    this.repositoriesCache.put(repositoryKey, repository);
                } else {
                    BugtrackingManager.LOG.log(Level.FINER, "no repository available for {0}", repositoryKey);
                    return null;
                }
            }
            BugtrackingManager.LOG.log(Level.FINER, "returning repository {0}:{1} for {2}", new Object[]{repository != null ? repository.getDisplayName() : "null", repository != null ? repository.getUrl() : "", repositoryKey});
            return repository;
        }
    }

    public TeamProject getTeamProject(RepositoryImpl repoImpl) {
        return this.repoToTeam.get(repoImpl);
    }

    private RepositoryImpl createRepository(TeamProject project) {
        BugtrackingConnector[] connectors;
        for (BugtrackingConnector c : connectors = BugtrackingUtil.getBugtrackingConnectors()) {
            if (!TeamRepositories.isType(c, project.getType())) continue;
            BugtrackingManager.LOG.log(Level.FINER, "found suport for {0}", project.getWebLocation().toString());
            RepositoryInfo info = new RepositoryInfo(project.getName(), null, project.getHost(), project.getDisplayName(), project.getDisplayName());
            info.putValue("team.project.name", project.getName());
            Repository repo = c.createRepository(info);
            if (repo == null) continue;
            RepositoryImpl repoImpl = APIAccessor.IMPL.getImpl(repo);
            this.repoToTeam.put(repoImpl, project);
            return repoImpl;
        }
        return null;
    }

    private static boolean isSupported(TeamProject project) {
        BugtrackingConnector[] connectors;
        for (BugtrackingConnector c : connectors = BugtrackingUtil.getBugtrackingConnectors()) {
            if (!TeamRepositories.isType(c, project.getType())) continue;
            BugtrackingManager.LOG.log(Level.FINER, "found suport for {0}", project.getWebLocation().toString());
            return true;
        }
        return false;
    }

    private static boolean isType(BugtrackingConnector connector, TeamBugtrackingConnector.BugtrackingType type) {
        return connector instanceof TeamBugtrackingConnector && ((TeamBugtrackingConnector)connector).getType() == type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTeamLock(TeamProject kp) {
        TeamBugtrackingConnector.BugtrackingType type = kp.getType();
        Map<String, Object> map = this.teamLocks;
        synchronized (map) {
            String key = kp.getWebLocation().getHost() + ":" + type;
            BugtrackingManager.LOG.log(Level.FINER, "requesting lock for {0}", key);
            Object lock = this.teamLocks.get(key);
            if (lock == null) {
                lock = new Object();
                this.teamLocks.put(key, lock);
            }
            BugtrackingManager.LOG.log(Level.FINER, "returning lock {0} for {1}", new Object[]{lock, key});
            return lock;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("team.projects.changed") || evt.getPropertyName().equals("team.login.changed")) {
            this.fireProjectsChanged(null, null);
        }
    }

    public abstract Collection<RepositoryImpl> getRepositories(boolean var1, boolean var2);

    private static class DefaultImpl
    extends TeamRepositories {
        private DefaultImpl() {
        }

        @Override
        public Collection<RepositoryImpl> getRepositories(boolean includeIDEProjects, boolean onlyDashboardOpenProjects) {
            if ("true".equals(System.getProperty("netbeans.bugtracking.noOpenProjects", "false"))) {
                includeIDEProjects = false;
            }
            TeamProject[] teamProjects = includeIDEProjects ? DefaultImpl.union(this.getDashboardProjects(onlyDashboardOpenProjects), this.getProjectsViewProjects()) : this.getDashboardProjects(onlyDashboardOpenProjects);
            ArrayList<RepositoryImpl> result = new ArrayList<RepositoryImpl>(teamProjects.length);
            EnumSet<TeamBugtrackingConnector.BugtrackingType> reluctantSupports = EnumSet.noneOf(TeamBugtrackingConnector.BugtrackingType.class);
            for (TeamProject kp : teamProjects) {
                if (onlyDashboardOpenProjects && !TeamAccessorUtils.isLoggedIn((URL)kp.getWebLocation()) || kp.getType() == null) continue;
                if (!reluctantSupports.contains(kp.getType())) {
                    RepositoryImpl repo = this.getRepository(kp);
                    if (repo != null) {
                        result.add(repo);
                        continue;
                    }
                    if (!TeamRepositories.isSupported(kp) || kp.getFeatureLocation() == null) continue;
                    BugtrackingManager.LOG.log(Level.WARNING, "could not get repository for project {0} with {1} bugtracking type ", new Object[]{kp.getWebLocation(), kp.getType()});
                    reluctantSupports.add(kp.getType());
                    continue;
                }
                BugtrackingManager.LOG.log(Level.WARNING, "skipping getRepository for project {0} with {1} bugtracking type ", new Object[]{kp.getWebLocation(), kp.getType()});
            }
            return result;
        }

        private TeamProject[] getDashboardProjects(boolean onlyOpenProjects) {
            return TeamAccessorUtils.getDashboardProjects((boolean)onlyOpenProjects);
        }

        private TeamProject[] getProjectsViewProjects() {
            FileObject[] openProjectFiles;
            ProjectServices projectServices = BugtrackingManager.getInstance().getProjectServices();
            FileObject[] fileObjectArray = openProjectFiles = projectServices != null ? projectServices.getOpenProjectsDirectories() : null;
            if (openProjectFiles == null || openProjectFiles.length == 0) {
                return new TeamProject[0];
            }
            int count = 0;
            TeamProject[] teamProjects = new TeamProject[openProjectFiles.length];
            for (FileObject rootDir : openProjectFiles) {
                TeamProject teamProject = DefaultImpl.getTeamProject(rootDir);
                if (teamProject == null) continue;
                teamProjects[count++] = teamProject;
            }
            return DefaultImpl.stripTrailingNulls(teamProjects);
        }

        private static TeamProject getTeamProject(FileObject rootDir) {
            String url = null;
            try {
                url = VersioningQuery.getRemoteLocation((URI)rootDir.toURL().toURI());
            }
            catch (URISyntaxException ex) {
                BugtrackingManager.LOG.log(Level.WARNING, rootDir.getPath(), ex);
            }
            if (url == null) {
                return null;
            }
            TeamProject teamProject = null;
            try {
                if (NBBugzillaUtils.isNbRepository((String)url)) {
                    OwnerInfo owner = TeamAccessorUtils.getOwnerInfo((File)FileUtil.toFile((FileObject)rootDir));
                    if (owner != null) {
                        teamProject = TeamAccessorUtils.getTeamProject((String)url, (String)owner.getOwner());
                    } else {
                        BugtrackingManager.LOG.fine("team accessor not available");
                    }
                } else {
                    teamProject = TeamAccessorUtils.getTeamProjectForRepository((String)url);
                }
            }
            catch (IOException ex) {
                teamProject = null;
                BugtrackingManager.LOG.log(Level.WARNING, "No Team project is available for bugtracking repository  [" + url + "]");
                BugtrackingManager.LOG.log(Level.FINE, null, ex);
            }
            return teamProject;
        }

        private static TeamProject[] union(TeamProject[] ... projectArrays) {
            HashMap<String, TeamProject> union = new HashMap<String, TeamProject>();
            TeamProject[][] arr$ = projectArrays;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                TeamProject[] projectArray;
                for (TeamProject p : projectArray = arr$[i$]) {
                    String name = p.getName();
                    if (union.keySet().contains(name)) continue;
                    union.put(name, p);
                }
            }
            return union.values().toArray(new TeamProject[union.values().size()]);
        }

        private static <T> T[] stripTrailingNulls(T[] array) {
            int resultSize;
            for (resultSize = array.length; resultSize > 0 && array[resultSize - 1] == null; --resultSize) {
            }
            if (resultSize == array.length) {
                return array;
            }
            Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), resultSize);
            if (resultSize != 0) {
                System.arraycopy(array, 0, result, 0, resultSize);
            }
            return result;
        }
    }
}

