/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;

final class SharedMemoryBufferCache {
    private static final boolean REUSE_MEMORY_BUFFERS = Boolean.parseBoolean(System.getProperty("clank.reuse.mem.buffer", "true"));
    private final StringMap<MemoryBuffer, BumpPtrAllocator> MemoryBuffers;
    private final AtomicInteger cacheHits;
    private final AtomicInteger mainFileHits;
    private final AtomicInteger cacheMisses;
    private final SmallString buffer = new SmallString(1024);
    private static final MemoryBuffer DUMMY = (MemoryBuffer)MemoryBuffer.getNewUninitMemBuffer((int)0, (Twine)Twine.EMPTY).release();
    private static final ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> NO_MEMORY_BUFFER = new ErrorOr(std_errors.errc.no_such_file_or_directory.make_error_code());
    private StringRef skipMainFile = StringRef.EMPTY;

    SharedMemoryBufferCache(StringMap<MemoryBuffer, BumpPtrAllocator> MemoryBuffers, AtomicInteger cacheHits, AtomicInteger mainFileHits, AtomicInteger cacheMisses) {
        this.MemoryBuffers = MemoryBuffers;
        this.cacheHits = cacheHits;
        this.mainFileHits = mainFileHits;
        this.cacheMisses = cacheMisses;
    }

    void skipMainFile(StringRef mainFile) {
        this.skipMainFile = mainFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> get(Twine Name) {
        StringRef Key;
        if (REUSE_MEMORY_BUFFERS && (Key = Name.toStringRef(this.buffer)).$noteq(this.skipMainFile)) {
            MemoryBuffer value;
            char.ptr KeyData = Key.data();
            int KeySize = Key.size();
            StringMap<MemoryBuffer, BumpPtrAllocator> stringMap = this.MemoryBuffers;
            synchronized (stringMap) {
                StringMapEntry Entry2 = this.MemoryBuffers.GetOrCreateValue(KeyData, KeySize);
                value = (MemoryBuffer)Entry2.getValue();
            }
            if (value != null) {
                if (NativeTrace.VERBOSE_MODE) {
                    this.cacheHits.incrementAndGet();
                }
                if (value == DUMMY) {
                    return NO_MEMORY_BUFFER;
                }
                return new ErrorOr((Object)new std_ptr.unique_ptr((Object)new MemoryBufferWrapper(value)));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(Twine Name, ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> out) {
        if (REUSE_MEMORY_BUFFERS) {
            StringRef Key = Name.toStringRef(this.buffer);
            if (Key.$noteq(this.skipMainFile)) {
                char.ptr KeyData = Key.data();
                int KeySize = Key.size();
                MemoryBuffer value = out.$boolean() ? (MemoryBuffer)((std_ptr.unique_ptr)out.get()).get() : DUMMY;
                StringMap<MemoryBuffer, BumpPtrAllocator> stringMap = this.MemoryBuffers;
                synchronized (stringMap) {
                    StringMapEntry Entry2 = this.MemoryBuffers.GetOrCreateValue(KeyData, KeySize);
                    if (Entry2.getValue() == null) {
                        if (NativeTrace.VERBOSE_MODE) {
                            this.cacheMisses.incrementAndGet();
                        }
                        Entry2.setValue((Object)value);
                    }
                }
            } else if (NativeTrace.VERBOSE_MODE) {
                this.mainFileHits.incrementAndGet();
            }
        }
    }

    private static final class MemoryBufferWrapper
    extends MemoryBuffer {
        private final MemoryBuffer delegate;

        public boolean isInvalid() {
            return this.delegate.isInvalid();
        }

        public void setInvalid() {
            this.delegate.setInvalid();
        }

        public char.ptr getBufferStart() {
            return this.delegate.getBufferStart();
        }

        public char.ptr getBufferEnd() {
            return this.delegate.getBufferEnd();
        }

        public int getBufferSize() {
            return this.delegate.getBufferSize();
        }

        public StringRef getBuffer() {
            return this.delegate.getBuffer();
        }

        public char.ptr getBufferIdentifier() {
            return this.delegate.getBufferIdentifier();
        }

        public MemoryBufferWrapper(MemoryBuffer delegate) {
            this.delegate = delegate;
        }

        public MemoryBuffer.BufferKind getBufferKind() {
            return this.delegate.getBufferKind();
        }

        public void setSourceLineCache(int[] SourceLineCache, int NumLines) {
            this.delegate.setSourceLineCache(SourceLineCache, NumLines);
        }

        public int[] getSourceLineCache() {
            return this.delegate.getSourceLineCache();
        }

        public String toString() {
            return "MemoryBufferWrapper{delegate=" + this.delegate + '}';
        }

        public void $destroy() {
        }
    }
}

