/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.FileNotParsedException;
import org.netbeans.modules.languages.features.Index;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class HyperlinkListener
implements MouseMotionListener,
MouseListener,
KeyListener {
    private Highlighting.Highlight highlight;
    private Runnable runnable = null;
    private static AttributeSet hyperlinkAS = null;
    private static AttributeSet hyperlinkPressedAS = null;

    @Override
    public void mouseMoved(MouseEvent e) {
        JEditorPane c = (JEditorPane)e.getComponent();
        NbEditorDocument doc = (NbEditorDocument)c.getDocument();
        if (this.highlight != null) {
            this.highlight.remove();
        }
        this.highlight = null;
        this.runnable = null;
        if (((e.getModifiers() | e.getModifiersEx()) & 0x80) != 128) {
            return;
        }
        int offset = c.viewToModel(e.getPoint());
        this.highlight(doc, offset);
        c.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.runnable != null) {
            this.runnable.run();
            this.runnable = null;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!e.isControlDown()) {
            if (this.highlight != null) {
                this.highlight.remove();
                this.highlight = null;
            }
            this.runnable = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highlight(final NbEditorDocument document, int offset) {
        block18: {
            try {
                FileObject fileObject;
                ASTNode ast = ParserManagerImpl.getImpl((Document)document).getAST();
                if (ast == null) {
                    String mimeType = (String)document.getProperty((Object)"mimeType");
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                    document.readLock();
                    try {
                        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                        tokenSequence.move(offset);
                        tokenSequence.moveNext();
                        Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                        Token token = tokenSequence.token();
                        if (token == null) {
                            return;
                        }
                        Feature hyperlinkFeature = language.getFeatureList().getFeature("HYPERLINK", token.id().name());
                        if (hyperlinkFeature == null) {
                            return;
                        }
                        ASTToken stoken = ASTToken.create(language, token.id().ordinal(), token.text().toString(), tokenSequence.offset());
                        this.highlight = Highlighting.getHighlighting((Document)document).highlight(tokenSequence.offset(), tokenSequence.offset() + token.length(), HyperlinkListener.getHyperlinkAS());
                        this.runnable = (Runnable)hyperlinkFeature.getValue(Context.create((Document)document, offset));
                    }
                    finally {
                        document.readUnlock();
                    }
                    return;
                }
                ASTPath path = ast.findPath(offset);
                if (path == null) {
                    return;
                }
                int k = path.size();
                for (int i = 0; i < k; ++i) {
                    Feature hyperlinkFeature;
                    ASTPath p = path.subPath(i);
                    Language language = (Language)p.getLeaf().getLanguage();
                    if (language == null || (hyperlinkFeature = language.getFeatureList().getFeature("HYPERLINK", p)) == null) continue;
                    this.highlight = Highlighting.getHighlighting((Document)document).highlight(p.getLeaf().getOffset(), p.getLeaf().getEndOffset(), HyperlinkListener.getHyperlinkAS());
                    this.runnable = (Runnable)hyperlinkFeature.getValue(SyntaxContext.create((Document)document, p));
                }
                DatabaseContext root = DatabaseManager.getRoot(ast);
                if (root == null) break block18;
                final DatabaseItem item = root.getDatabaseItem(offset);
                if (item != null && item instanceof DatabaseUsage) {
                    this.highlight = Highlighting.getHighlighting((Document)document).highlight(path.getLeaf().getOffset(), path.getLeaf().getEndOffset(), HyperlinkListener.getHyperlinkAS());
                    this.runnable = new Runnable(){

                        @Override
                        public void run() {
                            DatabaseDefinition definition = ((DatabaseUsage)item).getDefinition();
                            int offset = definition.getOffset();
                            DataObject dobj = null;
                            Object docToGo = null;
                            URL url = definition.getSourceFileUrl();
                            if (url == null) {
                                dobj = NbEditorUtilities.getDataObject((Document)document);
                                docToGo = document;
                            } else {
                                File file = null;
                                try {
                                    file = new File(url.toURI());
                                }
                                catch (URISyntaxException ex) {
                                    ex.printStackTrace();
                                }
                                if (file != null && file.exists()) {
                                    file = FileUtil.normalizeFile((File)file);
                                    FileObject fobj = FileUtil.toFileObject((File)file);
                                    try {
                                        dobj = DataObject.find((FileObject)fobj);
                                    }
                                    catch (DataObjectNotFoundException ex) {
                                        ex.printStackTrace();
                                    }
                                    if (dobj != null) {
                                        Node nodeOfDobj = dobj.getNodeDelegate();
                                        EditorCookie ec = (EditorCookie)nodeOfDobj.getCookie(EditorCookie.class);
                                        try {
                                            docToGo = ec.openDocument();
                                        }
                                        catch (IOException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                }
                            }
                            if (dobj == null) {
                                return;
                            }
                            LineCookie lc = (LineCookie)dobj.getCookie(LineCookie.class);
                            Line.Set lineSet = lc.getLineSet();
                            Line line = lineSet.getCurrent(NbDocument.findLineNumber((StyledDocument)docToGo, (int)offset));
                            int column = NbDocument.findLineColumn((StyledDocument)docToGo, (int)offset);
                            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
                        }
                    };
                }
                if (item != null || (fileObject = NbEditorUtilities.getFileObject((Document)document)) == null) break block18;
                ASTItem leaf = path.getLeaf();
                if (!(leaf instanceof ASTToken)) {
                    return;
                }
                String name = ((ASTToken)leaf).getIdentifier();
                try {
                    Map<FileObject, List<DatabaseDefinition>> map = Index.getGlobalItem(fileObject, name, false);
                    if (!map.isEmpty()) {
                        final FileObject fo = map.keySet().iterator().next();
                        final DatabaseDefinition definition = map.get(fo).iterator().next();
                        this.highlight = Highlighting.getHighlighting((Document)document).highlight(path.getLeaf().getOffset(), path.getLeaf().getEndOffset(), HyperlinkListener.getHyperlinkAS());
                        this.runnable = new Runnable(){

                            @Override
                            public void run() {
                                int definitionOffset = definition.getOffset();
                                try {
                                    DataObject dobj = DataObject.find((FileObject)fo);
                                    EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                                    StyledDocument doc2 = ec.openDocument();
                                    LineCookie lc = (LineCookie)dobj.getCookie(LineCookie.class);
                                    Line.Set lineSet = lc.getLineSet();
                                    Line line = lineSet.getCurrent(NbDocument.findLineNumber((StyledDocument)doc2, (int)definitionOffset));
                                    int column = NbDocument.findLineColumn((StyledDocument)doc2, (int)definitionOffset);
                                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                        };
                    }
                }
                catch (FileNotParsedException ex) {}
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private static AttributeSet getHyperlinkAS() {
        if (hyperlinkAS == null) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            as.addAttribute(StyleConstants.Foreground, Color.blue);
            as.addAttribute(StyleConstants.Underline, Color.blue);
            hyperlinkAS = as;
        }
        return hyperlinkAS;
    }

    private static AttributeSet getHyperlinkPressedAS() {
        if (hyperlinkPressedAS == null) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            as.addAttribute(StyleConstants.Foreground, Color.red);
            as.addAttribute(StyleConstants.Underline, Color.red);
            hyperlinkPressedAS = as;
        }
        return hyperlinkPressedAS;
    }
}

