/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Utils;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

public class IndentFactory
implements IndentTask.Factory {
    public IndentTask createTask(Context context) {
        return new GLFIndentTask(context);
    }

    private static class GLFIndentTask
    implements IndentTask {
        private Context context;

        private GLFIndentTask(Context context) {
            this.context = context;
        }

        public void reindent() throws BadLocationException {
            StyledDocument document = (StyledDocument)this.context.document();
            try {
                MimePath mimePath = MimePath.parse((String)this.context.mimePath());
                String mimeType = mimePath.getMimeType(mimePath.size() - 1);
                Language l = LanguagesManager.getDefault().getLanguage(mimeType);
                Object indentValue = GLFIndentTask.getIndentProperties(l);
                if (indentValue == null) {
                    return;
                }
                if (indentValue instanceof Feature) {
                    Feature m = (Feature)indentValue;
                    m.getValue(org.netbeans.api.languages.Context.create(document, this.context.startOffset()));
                    return;
                }
                Object[] params = (Object[])indentValue;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                LanguagePath languagePath = LanguagePath.get((org.netbeans.api.lexer.Language)org.netbeans.api.lexer.Language.find((String)mimePath.getMimeType(0)));
                for (int i = 1; i < mimePath.size(); ++i) {
                    languagePath = languagePath.embedded(org.netbeans.api.lexer.Language.find((String)mimePath.getMimeType(i)));
                }
                List tokenSequences = tokenHierarchy.tokenSequenceList(languagePath, this.context.startOffset(), this.context.endOffset());
                Set<Integer> whitespaces = l.getAnalyser().getSkipTokenTypes();
                for (Context.Region region : this.context.indentRegions()) {
                    HashMap<Position, Integer> indentMap = new HashMap<Position, Integer>();
                    int ln = NbDocument.findLineNumber((StyledDocument)document, (int)region.getStartOffset());
                    int endLineNumber = NbDocument.findLineNumber((StyledDocument)document, (int)region.getEndOffset());
                    if (!Utils.getTokenSequence(document, this.context.lineStartOffset(region.getStartOffset())).language().mimeType().equals(mimeType)) {
                        ++ln;
                    }
                    int indent = 0;
                    if (ln > 0) {
                        int offset = NbDocument.findLineOffset((StyledDocument)document, (int)(ln - 1));
                        indent = this.context.lineIndent(offset);
                        if (!Utils.getTokenSequence(document, offset).language().mimeType().equals(mimeType)) {
                            indent += IndentUtils.indentLevelSize((Document)document);
                        }
                    }
                    while (ln <= endLineNumber && (ln != endLineNumber || !GLFIndentTask.isEmpty(ln, document, whitespaces) || Utils.getTokenSequence(document, region.getEndOffset()).language().mimeType().equals(mimeType))) {
                        indent = this.indent(this.context, document, params, ln++, indent, indentMap, whitespaces);
                    }
                    for (Position position : indentMap.keySet()) {
                        this.context.modifyIndent(position.getOffset(), ((Integer)indentMap.get(position)).intValue());
                    }
                }
            }
            catch (LanguageDefinitionNotFoundException ldnfe) {
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        public ExtraLock indentLock() {
            return null;
        }

        private int indent(Context context, StyledDocument document, Object[] params, int ln, int indent, Map<Position, Integer> indentMap, Set<Integer> whitespaces) throws BadLocationException {
            int ni;
            int n = ni = ln > 0 ? GLFIndentTask.computeIndent(ln - 1, document, context, params) : 0;
            if (ni > 0) {
                indent += IndentUtils.indentLevelSize((Document)document);
            } else if (ni < 0) {
                if (!GLFIndentTask.startsWithBrace(ln - 1, document, context, params, whitespaces)) {
                    indent -= IndentUtils.indentLevelSize((Document)document);
                }
            } else if (ni == 0 && ln > 1 && (ni = GLFIndentTask.computeIndent(ln - 2, document, context, params)) == 2) {
                indent -= IndentUtils.indentLevelSize((Document)document);
            }
            if (GLFIndentTask.startsWithBrace(ln, document, context, params, whitespaces)) {
                indent -= IndentUtils.indentLevelSize((Document)document);
            }
            indent = Math.max(indent, 0);
            indentMap.put(document.createPosition(NbDocument.findLineOffset((StyledDocument)document, (int)ln)), indent);
            return indent;
        }

        private static int getCurrentIndent(String line) {
            int indent = 0;
            int k = line.length() - 1;
            for (int i = 0; i < k && Character.isWhitespace(line.charAt(i)); ++i) {
                if (line.charAt(i) == '\t') {
                    indent += 8 - indent % 8;
                    continue;
                }
                ++indent;
            }
            return indent;
        }

        private static int computeIndent(int ln, StyledDocument document, Context context, Object[] params) throws BadLocationException {
            int start = NbDocument.findLineOffset((StyledDocument)document, (int)ln);
            int end = document.getLength();
            try {
                end = NbDocument.findLineOffset((StyledDocument)document, (int)(ln + 1)) - 1;
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            TokenSequence ts = Utils.getTokenSequence(document, start);
            HashMap<String, Integer> p = new HashMap<String, Integer>();
            do {
                Integer i;
                Token t;
                String id;
                if (((Set)params[1]).contains(id = (t = ts.token()).text().toString().trim())) {
                    i = (Integer)p.get(id);
                    i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
                    p.put(id, i);
                }
                if (!((Set)params[2]).contains(t.text().toString().trim())) continue;
                i = (Integer)p.get(id = (String)((Map)params[3]).get(id));
                i = i == null ? Integer.valueOf(-1) : Integer.valueOf(i - 1);
                p.put(id, i);
            } while (ts.moveNext() && ts.offset() < end);
            Iterator<Object> it = p.values().iterator();
            while (it.hasNext()) {
                int i = (Integer)it.next();
                if (i > 0) {
                    return 1;
                }
                if (i >= 0) continue;
                return -1;
            }
            String line = document.getText(start, end - start);
            for (Pattern pattern : (List)params[0]) {
                if (!pattern.matcher(line).matches()) continue;
                return 2;
            }
            return 0;
        }

        private static boolean startsWithBrace(int ln, StyledDocument document, Context context, Object[] params, Set<Integer> whitespaces) throws BadLocationException {
            int start = NbDocument.findLineOffset((StyledDocument)document, (int)ln);
            int end = document.getLength();
            try {
                end = NbDocument.findLineOffset((StyledDocument)document, (int)(ln + 1)) - 1;
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            TokenSequence ts = Utils.getTokenSequence(document, start);
            if (ts.token() == null) {
                return false;
            }
            while (whitespaces.contains(ts.token().id().ordinal())) {
                if (!ts.moveNext()) {
                    return false;
                }
                if (ts.offset() <= end) continue;
                return false;
            }
            Token t = ts.token();
            String id = t.text().toString();
            String trimedId = id.trim();
            int nlIdx = id.indexOf("\n");
            if (nlIdx >= 0 && (nlIdx = id.indexOf("\n", nlIdx + 1)) >= 0 && nlIdx < id.indexOf(trimedId)) {
                return false;
            }
            return ((Set)params[2]).contains(trimedId);
        }

        private static boolean isEmpty(int ln, StyledDocument document, Set<Integer> whitespaces) throws BadLocationException {
            int start = NbDocument.findLineOffset((StyledDocument)document, (int)ln);
            int end = document.getLength();
            try {
                end = NbDocument.findLineOffset((StyledDocument)document, (int)(ln + 1)) - 1;
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            TokenSequence ts = Utils.getTokenSequence(document, start);
            if (ts.token() == null) {
                return true;
            }
            while (whitespaces.contains(ts.token().id().ordinal())) {
                if (!ts.moveNext()) {
                    return true;
                }
                if (ts.offset() <= end) continue;
                return true;
            }
            return false;
        }

        private static Object getIndentProperties(Language l) {
            Object[] objectArray;
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            HashSet<String> start = new HashSet<String>();
            HashSet<String> end = new HashSet<String>();
            HashMap<String, String> endToStart = new HashMap<String, String>();
            List<Feature> indents = l.getFeatureList().getFeatures("INDENT");
            for (Feature indent : indents) {
                if (indent.getType() == Feature.Type.METHOD_CALL) {
                    return indent;
                }
                String s = (String)indent.getValue();
                int i = s.indexOf(58);
                if (i < 1) {
                    patterns.add(Pattern.compile(GLFIndentTask.c(s)));
                    continue;
                }
                start.add(s.substring(0, i));
                end.add(s.substring(i + 1));
                endToStart.put(s.substring(i + 1), s.substring(0, i));
            }
            if (indents.isEmpty()) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = patterns;
                objectArray2[1] = start;
                objectArray2[2] = end;
                objectArray = objectArray2;
                objectArray2[3] = endToStart;
            }
            return objectArray;
        }

        private static String c(String s) {
            s = s.replace("\\n", "\n");
            s = s.replace("\\r", "\r");
            s = s.replace("\\t", "\t");
            s = s.replace("\\\"", "\"");
            s = s.replace("\\'", "'");
            s = s.replace("\\\\", "\\");
            return s;
        }
    }
}

