/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.turbo.CacheIndex;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class FileStatusCache {
    public static final String PROP_FILE_STATUS_CHANGED = "status.changed";
    private final CacheIndex conflictedFiles;
    private final CacheIndex modifiedFiles;
    private final CacheIndex ignoredFiles;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.git.status.cache");
    private int MAX_COUNT_UPTODATE_FILES = 1024;
    private static final int CACHE_SIZE_WARNING_THRESHOLD = 50000;
    private boolean hugeCacheWarningLogged;
    int upToDateAccess = 0;
    private static final int UTD_NOTIFY_NUMBER = 100;
    private final Map<File, FileInformation> cachedFiles;
    private final LinkedHashSet<File> upToDateFiles = new LinkedHashSet(this.MAX_COUNT_UPTODATE_FILES);
    private final RequestProcessor rp = new RequestProcessor("Git.cache", 1, true, false);
    private final HashSet<File> nestedRepositories = new HashSet(2);
    private final PropertyChangeSupport listenerSupport = new PropertyChangeSupport(this);
    private static final FileInformation FILE_INFORMATION_UPTODATE = new FileInformation(EnumSet.of(FileInformation.Status.UPTODATE), false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_NOTMANAGED), false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), false);
    private static final FileInformation FILE_INFORMATION_NEWLOCALLY = new FileInformation(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.NEW_HEAD_WORKING_TREE), false);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(EnumSet.of(FileInformation.Status.UNKNOWN), false);
    private static final Map<File, File> SYNC_REPOSITORIES = new WeakHashMap<File, File>(5);
    private final IgnoredFilesHandler ignoredFilesHandler;
    private final RequestProcessor.Task ignoredFilesHandlerTask;
    private static final boolean USE_IGNORE_INDEX = !Boolean.getBoolean("versioning.git.noignoreindex");
    private final Git git = Git.getInstance();

    public FileStatusCache() {
        this.cachedFiles = new HashMap<File, FileInformation>();
        this.conflictedFiles = FileStatusCache.createCacheIndex();
        this.modifiedFiles = FileStatusCache.createCacheIndex();
        this.ignoredFiles = FileStatusCache.createCacheIndex();
        this.ignoredFilesHandler = new IgnoredFilesHandler();
        this.ignoredFilesHandlerTask = this.rp.create((Runnable)this.ignoredFilesHandler);
    }

    public FileInformation getStatus(File file) {
        return this.getStatus(file, true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerSupport.removePropertyChangeListener(listener);
    }

    public void refreshAllRoots(File ... roots) {
        this.refreshAllRoots(Arrays.asList(roots), GitUtils.NULL_PROGRESS_MONITOR);
    }

    public void refreshAllRoots(Collection<File> files) {
        this.refreshAllRoots(files, GitUtils.NULL_PROGRESS_MONITOR);
    }

    public void refreshAllRoots(Collection<File> files, ProgressMonitor pm) {
        long startTime = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
            LOG.log(Level.FINE, "refreshAll: starting for {0} files.", files.size());
        }
        if (files.isEmpty()) {
            return;
        }
        HashMap<File, Collection<File>> rootFiles = new HashMap<File, Collection<File>>(5);
        for (File file : files) {
            File parentRepository;
            File parentFile;
            if (pm.isCanceled()) {
                return;
            }
            File repository = this.git.getRepositoryRoot(file = FileUtil.normalizeFile((File)file));
            if (repository == null) continue;
            if (repository.equals(file) && (parentFile = file.getParentFile()) != null && (parentRepository = this.git.getRepositoryRoot(parentFile)) != null) {
                this.addUnderRoot(rootFiles, parentRepository, file);
            }
            this.addUnderRoot(rootFiles, repository, file);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "refreshAll: starting status scan for {0} after {1}", new Object[]{rootFiles.values(), System.currentTimeMillis() - startTime});
            startTime = System.currentTimeMillis();
        }
        if (!rootFiles.isEmpty()) {
            this.refreshAllRoots(rootFiles, pm);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "refreshAll: finishes status scan after {0}", System.currentTimeMillis() - startTime);
        }
    }

    public void refreshAllRoots(Map<File, Collection<File>> rootFiles) {
        this.refreshAllRoots(rootFiles, GitUtils.NULL_PROGRESS_MONITOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void refreshAllRoots(Map<File, Collection<File>> rootFiles, ProgressMonitor pm) {
        for (Map.Entry<File, Collection<File>> refreshEntry : rootFiles.entrySet()) {
            if (pm.isCanceled()) {
                return;
            }
            repository = refreshEntry.getKey();
            if (repository == null) continue;
            var7_7 = syncRepo = this.getSyncRepository(repository);
            synchronized (var7_7) {
                block26: {
                    block27: {
                        if (FileStatusCache.LOG.isLoggable(Level.FINE)) {
                            FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: {0}, repositoryRoot: {1} ", new Object[]{refreshEntry.getValue(), repository.getAbsolutePath()});
                        }
                        client = null;
                        client = this.git.getClient(repository);
                        interestingFiles = client.getStatus(refreshEntry.getValue().toArray(new File[refreshEntry.getValue().size()]), pm);
                        if (!pm.isCanceled()) break block26;
                        if (client != null) {
                            client.release();
                        }
                        if (!FileStatusCache.LOG.isLoggable(Level.FINE)) break block27;
                        FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: finished repositoryRoot: {0} ", new Object[]{repository.getAbsolutePath()});
                    }
                    return;
                }
                try {
                    for (File root : refreshEntry.getValue()) {
                        for (File file : this.listFiles(Collections.singleton(root), EnumSet.complementOf(EnumSet.of(FileInformation.Status.UPTODATE)))) {
                            fi = this.getInfo(file);
                            if (fi == null || fi.containsStatus(FileInformation.Status.UPTODATE)) {
                                FileStatusCache.LOG.log(Level.WARNING, "refreshAllRoots(): possibly concurrent refresh: {0}:{1}", new Object[]{file, fi});
                                fi = new FileInformation(EnumSet.of(FileInformation.Status.UPTODATE), file.isDirectory());
                                ea = false;
                                if (!FileStatusCache.$assertionsDisabled) {
                                    ea = true;
                                    if (!true) {
                                        throw new AssertionError();
                                    }
                                }
                                if (!ea) continue;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException ex) {
                                    // empty catch block
                                }
                                if (!new HashSet<File>(Arrays.asList(this.listFiles(Collections.singleton(file.getParentFile()), EnumSet.complementOf(EnumSet.of(FileInformation.Status.UPTODATE))))).contains(file)) continue;
                                FileStatusCache.LOG.log(Level.WARNING, "refreshAllRoots(): now we have a problem, index seems to be broken", new Object[]{file});
                                continue;
                            }
                            exists = file.exists();
                            filesOwner = null;
                            correctRepository = true;
                            if (!interestingFiles.containsKey(file) && (fi.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED) && (!exists || fi.isDirectory() && !GitUtils.isIgnored(file, true)) || !fi.isDirectory() && !fi.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) && (correctRepository = repository.equals(file) == false && repository.equals(filesOwner = this.git.getRepositoryRoot(file)) != false)) {
                                FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() uninteresting file: {0} {1}", new Object[]{file, fi});
                                this.refreshFileStatus(file, FileStatusCache.FILE_INFORMATION_UNKNOWN);
                            }
                            if (correctRepository || !this.nestedRepositories.add(filesOwner)) continue;
                            FileStatusCache.LOG.log(Level.INFO, "refreshAllRoots: nested repository found: {0} contains {1}", new File[]{repository, filesOwner});
                        }
                    }
                    this.refreshStatusesBatch(interestingFiles);
                    if (client != null) {
                        client.release();
                    }
                    ** if (!FileStatusCache.LOG.isLoggable((Level)Level.FINE)) goto lbl-1000
                }
                catch (GitException ex) {
                    try {
                        FileStatusCache.LOG.log(Level.INFO, "refreshAllRoots() file: {0} {1} {2} ", new Object[]{repository.getAbsolutePath(), refreshEntry.getValue(), ex.toString()});
                        if (client != null) {
                            client.release();
                        }
                        ** if (!FileStatusCache.LOG.isLoggable((Level)Level.FINE)) goto lbl-1000
                    }
                    catch (Throwable var20_22) {
                        if (client != null) {
                            client.release();
                        }
                        if (FileStatusCache.LOG.isLoggable(Level.FINE)) {
                            FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: finished repositoryRoot: {0} ", new Object[]{repository.getAbsolutePath()});
                        }
                        throw var20_22;
                    }
lbl-1000:
                    // 1 sources

                    {
                        FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: finished repositoryRoot: {0} ", new Object[]{repository.getAbsolutePath()});
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    FileStatusCache.LOG.log(Level.FINE, "refreshAllRoots() roots: finished repositoryRoot: {0} ", new Object[]{repository.getAbsolutePath()});
                }
lbl-1000:
                // 2 sources

                {
                }
            }
        }
    }

    public boolean containsFiles(VCSContext context, Set<FileInformation.Status> includeStatus, boolean addExcluded) {
        Set roots = context.getRootFiles();
        return this.containsFiles(roots, includeStatus, addExcluded);
    }

    public boolean containsFiles(Set<File> roots, Set<FileInformation.Status> includeStatus, boolean addExcluded) {
        Set<File> repositories = GitUtils.getRepositoryRoots(roots);
        for (File root : roots) {
            if (!this.containsFilesIntern(this.getIndexValues(root, includeStatus, repositories), includeStatus, !VersioningSupport.isFlat((File)root), addExcluded, 1, repositories)) continue;
            return true;
        }
        return this.containsFilesIntern(roots, includeStatus, false, addExcluded, 0, repositories);
    }

    public File[] listFiles(File ... roots) {
        return this.listFiles(Arrays.asList(roots), FileInformation.STATUS_ALL);
    }

    public File[] listFiles(File[] roots, EnumSet<FileInformation.Status> includeStatus) {
        return this.listFiles(Arrays.asList(roots), includeStatus);
    }

    public File[] listFiles(Collection<File> roots, EnumSet<FileInformation.Status> includeStatus) {
        HashSet<File> set = new HashSet<File>();
        Set<File> repositories = GitUtils.getRepositoryRoots(roots);
        for (File root : roots) {
            set.addAll(this.listFilesIntern(this.getIndexValues(root, includeStatus, repositories), includeStatus, !VersioningSupport.isFlat((File)root), repositories));
        }
        set.addAll(this.listFilesIntern(roots, includeStatus, false, repositories));
        return set.toArray(new File[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation getInfo(File file) {
        FileInformation info;
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            info = this.cachedFiles.get(file);
            LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
            synchronized (linkedHashSet) {
                if (info == null && this.upToDateFiles.contains(file)) {
                    this.addUpToDate(file);
                    info = FILE_INFORMATION_UPTODATE;
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInfo(File file, FileInformation info) {
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            this.cachedFiles.put(file, info);
            if (!this.hugeCacheWarningLogged && this.cachedFiles.size() > 50000) {
                LOG.log(Level.WARNING, "Cache contains too many entries: {0}", this.cachedFiles.size());
                this.hugeCacheWarningLogged = true;
            }
            this.removeUpToDate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInfo(File file) {
        Map<File, FileInformation> map = this.cachedFiles;
        synchronized (map) {
            this.cachedFiles.remove(file);
            this.removeUpToDate(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpToDate(File file) {
        LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
        synchronized (linkedHashSet) {
            this.upToDateFiles.remove(file);
            this.upToDateFiles.add(file);
            if (this.upToDateFiles.size() >= this.MAX_COUNT_UPTODATE_FILES) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.WARNING, "Cache of uptodate files grows too quickly: {0}", this.upToDateFiles.size());
                    this.MAX_COUNT_UPTODATE_FILES <<= 1;
                    assert (false);
                } else {
                    Iterator it = this.upToDateFiles.iterator();
                    int toDelete = this.MAX_COUNT_UPTODATE_FILES >> 3;
                    for (int i = 0; i < toDelete && it.hasNext(); ++i) {
                        it.next();
                        it.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeUpToDate(File file) {
        LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
        synchronized (linkedHashSet) {
            return this.upToDateFiles.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation getStatus(final File file, boolean seenInUI) {
        FileInformation info = this.getInfo(file);
        LOG.log(Level.FINER, "getCachedStatus for file {0}: {1}", new Object[]{file, info});
        boolean triggerGitScan = false;
        boolean addAsExcluded = false;
        if (info == null) {
            if (this.git.isManaged(file)) {
                triggerGitScan = seenInUI;
                info = this.checkForIgnoredFile(file);
                if (info == null) {
                    info = this.getInfo(file);
                }
                if (file.isDirectory()) {
                    info = info != null && info.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED) ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), true) : new FileInformation(EnumSet.of(FileInformation.Status.UPTODATE), true);
                    this.setInfo(file, info);
                } else if (info == null || info.containsStatus(FileInformation.Status.UPTODATE)) {
                    info = FILE_INFORMATION_UPTODATE;
                    this.addUpToDate(file);
                    if (++this.upToDateAccess > 100) {
                        this.upToDateAccess = 0;
                        if (LOG.isLoggable(Level.FINE)) {
                            LinkedHashSet<File> linkedHashSet = this.upToDateFiles;
                            synchronized (linkedHashSet) {
                                LOG.log(Level.FINE, "Another {0} U2D files added: {1}", new Object[]{100, this.upToDateFiles});
                            }
                        }
                    }
                } else if (info.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
                    addAsExcluded = true;
                }
            } else {
                info = file.isDirectory() ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_NOTMANAGED), true) : FILE_INFORMATION_NOTMANAGED;
            }
            LOG.log(Level.FINER, "getCachedStatus: default for file {0}: {1}", new Object[]{file, info});
        } else {
            if (info.containsStatus(FileInformation.Status.UPTODATE) && this.checkForIgnoredFile(file) != null) {
                info = FILE_INFORMATION_EXCLUDED;
                addAsExcluded = true;
            }
            boolean bl = triggerGitScan = seenInUI && !info.seenInUI();
        }
        if (addAsExcluded) {
            this.rp.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileStatusCache fileStatusCache = FileStatusCache.this;
                    synchronized (fileStatusCache) {
                        FileInformation info = FileStatusCache.this.getInfo(file);
                        if (info == null || info.containsStatus(FileInformation.Status.UPTODATE)) {
                            FileStatusCache.this.refreshFileStatus(file, file.isDirectory() ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), true) : FILE_INFORMATION_EXCLUDED);
                        }
                    }
                }
            });
        }
        if (triggerGitScan) {
            info.setSeenInUI(true);
            this.git.getVCSInterceptor().pingRepositoryRootFor(file);
        }
        return info;
    }

    private void fireFileStatusChanged(File file, FileInformation oldInfo, FileInformation newInfo) {
        this.fireFileStatusChanged(new ChangedEvent(file, oldInfo, newInfo));
    }

    private void fireFileStatusChanged(ChangedEvent event) {
        this.listenerSupport.firePropertyChange(PROP_FILE_STATUS_CHANGED, null, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFileStatus(File file, FileInformation fi) {
        FileInformation current;
        if (file == null || fi == null) {
            return;
        }
        boolean fireEvent = true;
        FileStatusCache fileStatusCache = this;
        synchronized (fileStatusCache) {
            file = FileUtil.normalizeFile((File)file);
            current = this.getInfo(file);
            fi = this.checkForIgnore(fi, current, file);
            if (FileStatusCache.equivalent(fi, current)) {
                if (Utilities.isWindows() || Utilities.isMac()) {
                    fireEvent = false;
                } else {
                    return;
                }
            }
            boolean addToIndex = this.updateCachedValue(fi, file);
            this.updateIndex(file, fi, addToIndex);
        }
        if (fireEvent) {
            this.fireFileStatusChanged(file, current, fi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshStatusesBatch(Map<File, GitStatus> interestingFiles) {
        ArrayList<ChangedEvent> events = new ArrayList<ChangedEvent>(interestingFiles.size());
        FileStatusCache fileStatusCache = this;
        synchronized (fileStatusCache) {
            ArrayList<IndexUpdateItem> indexUpdates = new ArrayList<IndexUpdateItem>(interestingFiles.size());
            for (Map.Entry<File, GitStatus> interestingEntry : interestingFiles.entrySet()) {
                File file = interestingEntry.getKey();
                FileInformation fi = new FileInformation(interestingEntry.getValue());
                LOG.log(Level.FINE, "refreshAllRoots() file status: {0} {1}", new Object[]{file.getAbsolutePath(), fi});
                boolean fireEvent = true;
                FileInformation current = this.getInfo(file);
                fi = this.checkForIgnore(fi, current, file);
                if (FileStatusCache.equivalent(fi, current)) {
                    if (!Utilities.isWindows() && !Utilities.isMac()) continue;
                    fireEvent = false;
                }
                boolean addToIndex = this.updateCachedValue(fi, file);
                indexUpdates.add(new IndexUpdateItem(file, fi, addToIndex));
                if (!fireEvent) continue;
                events.add(new ChangedEvent(file, current, fi));
            }
            this.updateIndexBatch(indexUpdates);
        }
        for (ChangedEvent event : events) {
            this.fireFileStatusChanged(event);
        }
    }

    private FileInformation checkForIgnore(FileInformation fi, FileInformation current, File file) {
        if ((FileStatusCache.equivalent(FILE_INFORMATION_NEWLOCALLY, fi) || current != null && fi.getStatus().contains((Object)FileInformation.Status.UPTODATE) && current.getStatus().contains((Object)FileInformation.Status.NOTVERSIONED_EXCLUDED)) && (GitUtils.isIgnored(file, true) || this.isParentIgnored(file))) {
            LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but is NotSharable", file.getAbsolutePath());
            fi = file.isDirectory() ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), true) : FILE_INFORMATION_EXCLUDED;
        }
        return fi;
    }

    private boolean updateCachedValue(FileInformation fi, File file) {
        boolean addToIndex = false;
        if (fi.getStatus().equals(EnumSet.of(FileInformation.Status.UNKNOWN))) {
            this.removeInfo(file);
        } else if (fi.getStatus().equals(EnumSet.of(FileInformation.Status.UPTODATE)) && file.isFile()) {
            this.removeInfo(file);
            this.addUpToDate(file);
        } else {
            this.setInfo(file, fi);
            addToIndex = true;
        }
        return addToIndex;
    }

    private static boolean equivalent(FileInformation main, FileInformation other) {
        boolean retval = other != null && main.getStatus().equals(other.getStatus()) && main.isDirectory() == other.isDirectory() ? main.getStatusText().equals(other.getStatusText()) : false;
        return retval;
    }

    private boolean containsFilesIntern(Set<File> indexRoots, Set<FileInformation.Status> includeStatus, boolean recursively, boolean addExcluded, int depth, Set<File> repositories) {
        if (indexRoots == null || indexRoots.isEmpty()) {
            return false;
        }
        for (File root : indexRoots) {
            Set<File> indexValues = this.getIndexValues(root, includeStatus, repositories);
            if (!recursively || !this.containsFilesIntern(indexValues, includeStatus, recursively, addExcluded, depth + 1, repositories)) continue;
            return true;
        }
        for (File root : indexRoots) {
            FileInformation fi = this.getInfo(root);
            if (fi == null || !fi.containsStatus(includeStatus) || !addExcluded && depth != 0 && GitModuleConfig.getDefault().isExcludedFromCommit(root.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private Set<File> listFilesIntern(Collection<File> roots, EnumSet<FileInformation.Status> includeStatus, boolean recursively, Set<File> queriedRepositories) {
        if (roots == null || roots.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<File> ret = new HashSet<File>();
        for (File root : roots) {
            FileInformation fi;
            if (recursively) {
                ret.addAll(this.listFilesIntern(this.getIndexValues(root, includeStatus, queriedRepositories), includeStatus, recursively, queriedRepositories));
            }
            if ((fi = this.getInfo(root)) == null || !fi.containsStatus(includeStatus)) continue;
            ret.add(root);
        }
        return ret;
    }

    private static CacheIndex createCacheIndex() {
        return new CacheIndex(){

            protected boolean isManaged(File file) {
                return Git.getInstance().isManaged(file);
            }
        };
    }

    private Set<File> getIndexValues(File root, Set<FileInformation.Status> includeStatus, Set<File> queriedRepositories) {
        File[] modified = new File[]{};
        File[] ignored = new File[]{};
        if (includeStatus.contains((Object)FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            ignored = this.ignoredFiles.get(root);
        }
        if (((AbstractSet)FileInformation.STATUS_LOCAL_CHANGES.clone()).removeAll(includeStatus)) {
            modified = includeStatus.equals(EnumSet.of(FileInformation.Status.IN_CONFLICT)) ? this.conflictedFiles.get(root) : this.modifiedFiles.get(root);
        }
        Set<File> values = new HashSet<File>(Arrays.asList(ignored));
        values.addAll(Arrays.asList(modified));
        if (queriedRepositories != null) {
            values = this.checkBelongToRepository(values, queriedRepositories);
        }
        return values;
    }

    private Set<File> checkBelongToRepository(Set<File> files, Set<File> repositories) {
        Iterator<File> it = files.iterator();
        while (it.hasNext()) {
            File repo;
            File f = it.next();
            if (f.equals(repo = this.git.getRepositoryRoot(f)) || repositories.contains(repo)) continue;
            it.remove();
        }
        return files;
    }

    private void updateIndex(File file, FileInformation fi, boolean addToIndex) {
        File parent = file.getParentFile();
        if (parent != null) {
            boolean ignoredChange;
            HashSet<File> conflicted = new HashSet<File>(Arrays.asList(this.conflictedFiles.get(parent)));
            HashSet<File> modified = new HashSet<File>(Arrays.asList(this.modifiedFiles.get(parent)));
            HashSet<File> ignored = new HashSet<File>(Arrays.asList(this.ignoredFiles.get(parent)));
            boolean modifiedChange = modified.remove(file);
            boolean conflictedChange = conflicted.remove(file);
            boolean bl = ignoredChange = USE_IGNORE_INDEX && ignored.remove(file);
            if (addToIndex) {
                if (fi.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
                    ignoredChange |= USE_IGNORE_INDEX && ignored.add(file);
                } else {
                    modifiedChange |= modified.add(file);
                    if (fi.containsStatus(FileInformation.Status.IN_CONFLICT)) {
                        conflictedChange |= conflicted.add(file);
                    }
                }
            }
            if (modifiedChange) {
                this.modifiedFiles.add(parent, modified);
            }
            if (conflictedChange) {
                this.conflictedFiles.add(parent, conflicted);
            }
            if (ignoredChange) {
                this.ignoredFiles.add(parent, ignored);
            }
        }
    }

    private void updateIndexBatch(List<IndexUpdateItem> updates) {
        HashMap<File, Set<File>> modifications = new HashMap<File, Set<File>>();
        HashMap<File, Set<File>> conflicts = new HashMap<File, Set<File>>();
        HashMap<File, Set<File>> ignores = new HashMap<File, Set<File>>();
        for (IndexUpdateItem indexUpdateItem : updates) {
            File file = indexUpdateItem.getFile();
            File parent = file.getParentFile();
            if (parent == null) continue;
            Set<File> modified = this.get(modifications, parent, this.modifiedFiles);
            Set<File> conflicted = this.get(conflicts, parent, this.conflictedFiles);
            modified.remove(file);
            conflicted.remove(file);
            Set<File> ignored = null;
            if (USE_IGNORE_INDEX) {
                ignored = this.get(ignores, parent, this.ignoredFiles);
                ignored.remove(file);
            }
            if (!indexUpdateItem.isAdd()) continue;
            FileInformation fi = indexUpdateItem.getInfo();
            if (fi.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
                if (!USE_IGNORE_INDEX) continue;
                ignored.add(file);
                continue;
            }
            modified.add(file);
            if (!fi.containsStatus(FileInformation.Status.IN_CONFLICT)) continue;
            conflicted.add(file);
        }
        for (Map.Entry entry : modifications.entrySet()) {
            this.modifiedFiles.add((File)entry.getKey(), (Set)entry.getValue());
        }
        for (Map.Entry entry : conflicts.entrySet()) {
            this.conflictedFiles.add((File)entry.getKey(), (Set)entry.getValue());
        }
        for (Map.Entry entry : ignores.entrySet()) {
            this.ignoredFiles.add((File)entry.getKey(), (Set)entry.getValue());
        }
    }

    private Set<File> get(Map<File, Set<File>> cached, File parent, CacheIndex index) {
        Set<File> modified = cached.get(parent);
        if (modified == null) {
            modified = new HashSet<File>(Arrays.asList(index.get(parent)));
            cached.put(parent, modified);
        }
        return modified;
    }

    private FileInformation checkForIgnoredFile(File file) {
        FileInformation fi = null;
        if (file.getParentFile() != null && this.isParentIgnored(file)) {
            fi = FILE_INFORMATION_EXCLUDED;
        } else {
            this.handleIgnoredFiles(Collections.singleton(file));
        }
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIgnoredFiles(Set<File> files) {
        boolean changed;
        Set set = this.ignoredFilesHandler.toHandle;
        synchronized (set) {
            changed = this.ignoredFilesHandler.toHandle.addAll(files);
        }
        if (changed) {
            this.ignoredFilesHandlerTask.schedule(0);
        }
    }

    private boolean isParentIgnored(File file) {
        File parentFile = file.getParentFile();
        boolean parentIgnored = this.getStatus(parentFile, false).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED);
        if (parentFile.equals(this.git.getRepositoryRoot(parentFile))) {
            parentIgnored = false;
        }
        return parentIgnored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getSyncRepository(File repository) {
        File cachedRepository = this.git.getRepositoryRoot(repository);
        if (repository.equals(cachedRepository)) {
            repository = cachedRepository;
        }
        Map<File, File> map = SYNC_REPOSITORIES;
        synchronized (map) {
            cachedRepository = SYNC_REPOSITORIES.get(repository);
            if (cachedRepository == null) {
                cachedRepository = new File(repository.getParentFile(), repository.getName());
                SYNC_REPOSITORIES.put(cachedRepository, cachedRepository);
            }
        }
        return cachedRepository;
    }

    private void addUnderRoot(HashMap<File, Collection<File>> rootFiles, File repository, File file) {
        Collection<File> filesUnderRoot = rootFiles.get(repository);
        if (filesUnderRoot == null) {
            filesUnderRoot = new HashSet<File>();
            rootFiles.put(repository, filesUnderRoot);
        }
        GitUtils.prepareRootFiles(repository, filesUnderRoot, file);
    }

    private static class IndexUpdateItem {
        private final File file;
        private final FileInformation fi;
        private final boolean add;

        public IndexUpdateItem(File file, FileInformation fi, boolean toBeAdded) {
            this.file = file;
            this.fi = fi;
            this.add = toBeAdded;
        }

        public File getFile() {
            return this.file;
        }

        public FileInformation getInfo() {
            return this.fi;
        }

        public boolean isAdd() {
            return this.add;
        }
    }

    public static class ChangedEvent {
        private final File file;
        private final FileInformation oldInfo;
        private final FileInformation newInfo;

        public ChangedEvent(File file, FileInformation oldInfo, FileInformation newInfo) {
            this.file = file;
            this.oldInfo = oldInfo;
            this.newInfo = newInfo;
        }

        public File getFile() {
            return this.file;
        }

        public FileInformation getOldInfo() {
            return this.oldInfo;
        }

        public FileInformation getNewInfo() {
            return this.newInfo;
        }
    }

    private class IgnoredFilesHandler
    implements Runnable {
        private final Set<File> toHandle = new LinkedHashSet<File>();

        private IgnoredFilesHandler() {
        }

        @Override
        public void run() {
            File f;
            while ((f = this.getNextFile()) != null) {
                if (!GitUtils.isIgnored(f, true)) continue;
                boolean isDirectory = f.isDirectory();
                boolean exists = f.exists();
                if (!exists) {
                    FileStatusCache.this.refreshFileStatus(f, FILE_INFORMATION_UNKNOWN);
                    continue;
                }
                FileStatusCache.this.refreshFileStatus(f, isDirectory ? new FileInformation(EnumSet.of(FileInformation.Status.NOTVERSIONED_EXCLUDED), true) : FILE_INFORMATION_EXCLUDED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File getNextFile() {
            File nextFile = null;
            Set<File> set = this.toHandle;
            synchronized (set) {
                Iterator<File> it = this.toHandle.iterator();
                if (it.hasNext()) {
                    nextFile = it.next();
                    it.remove();
                }
            }
            return nextFile;
        }
    }
}

