/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.checkout.AbstractCheckoutRevision;
import org.netbeans.modules.git.ui.checkout.Bundle;
import org.netbeans.modules.git.ui.checkout.CheckoutRevisionAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public abstract class AbstractCheckoutAction
extends SingleRepositoryAction {
    public static final String PREF_KEY_RECENT_BRANCHES = "recentlySwitchedBranches";
    private static final Logger LOG = Logger.getLogger(CheckoutRevisionAction.class.getName());

    protected AbstractCheckoutAction() {
        this(null);
    }

    protected AbstractCheckoutAction(String iconResource) {
        super(iconResource);
    }

    protected final void checkoutRevision(File repository, AbstractCheckoutRevision checkout, String progressLabelKey, HelpCtx helpCtx) {
        if (checkout.show(helpCtx)) {
            this.checkoutRevision(repository, checkout.getRevision(), checkout.isCreateBranchSelected() ? checkout.getBranchName() : null, NbBundle.getMessage(CheckoutRevisionAction.class, (String)progressLabelKey));
        }
    }

    public final void checkoutRevision(final File repository, final String revisionToCheckout, final String newBranchName, String progressLabel) {
        GitProgressSupport supp = new GitProgressSupport(){
            private String revision;
            private final Collection<File> notifiedFiles = new HashSet<File>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void perform() {
                Set<File> seenRoots = Git.getInstance().getSeenRoots(repository);
                final HashSet<String> seenPaths = new HashSet<String>(GitUtils.getRelativePaths(repository, seenRoots.toArray(new File[seenRoots.size()])));
                try {
                    final GitClient client = this.getClient();
                    this.revision = revisionToCheckout;
                    if (newBranchName != null) {
                        this.revision = newBranchName;
                        LOG.log(Level.FINE, "Creating branch: {0}:{1}", new Object[]{this.revision, revisionToCheckout});
                        GitBranch branch = client.createBranch(this.revision, revisionToCheckout, this.getProgressMonitor());
                        this.log(revisionToCheckout, branch);
                    }
                    client.addNotificationListener((NotificationListener)new FileListener(){

                        public void notifyFile(File file, String relativePathToRoot) {
                            if (this.isUnderRoots(relativePathToRoot)) {
                                notifiedFiles.add(file);
                            }
                        }

                        private boolean isUnderRoots(String relativePathToRoot) {
                            boolean underRoot;
                            boolean bl = underRoot = seenPaths.isEmpty() || seenPaths.contains(relativePathToRoot);
                            if (!underRoot) {
                                for (String path : seenPaths) {
                                    if (!relativePathToRoot.startsWith(path + "/")) continue;
                                    underRoot = true;
                                    break;
                                }
                            }
                            return underRoot;
                        }
                    });
                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new File[]{repository}));
                    GitUtils.runWithoutIndexing(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            boolean hadConflicts;
                            LOG.log(Level.FINE, "Checking out commit: {0}", revision);
                            boolean failOnConflict = true;
                            boolean cont = true;
                            boolean bl = hadConflicts = !client.getConflicts(new File[0], this.getProgressMonitor()).isEmpty();
                            while (cont) {
                                cont = false;
                                try {
                                    client.checkoutRevision(revision, failOnConflict, this.getProgressMonitor());
                                    if (this.isCanceled() || !this.isBranch(revision, client.getBranches(true, GitUtils.NULL_PROGRESS_MONITOR))) continue;
                                    Utils.insert((Preferences)NbPreferences.forModule(AbstractCheckoutAction.class), (String)(AbstractCheckoutAction.PREF_KEY_RECENT_BRANCHES + repository.getAbsolutePath()), (String)revision, (int)5);
                                }
                                catch (GitException.CheckoutConflictException ex) {
                                    File[] conflicts;
                                    if (LOG.isLoggable(Level.FINE)) {
                                        LOG.log(Level.FINE, "Conflicts during checkout: {0} - {1}", new Object[]{repository, Arrays.asList(ex.getConflicts())});
                                    }
                                    if (!this.resolveConflicts(conflicts = this.getFilesInConflict(ex.getConflicts()), failOnConflict && !hadConflicts)) continue;
                                    cont = true;
                                    failOnConflict = false;
                                }
                            }
                            return null;
                        }
                    }, repository);
                    if (this.notifiedFiles.isEmpty()) return;
                }
                catch (GitException ex) {
                    try {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                        if (this.notifiedFiles.isEmpty()) return;
                    }
                    catch (Throwable throwable) {
                        if (this.notifiedFiles.isEmpty()) throw throwable;
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, this.notifiedFiles));
                        GitUtils.headChanged(repository);
                        throw throwable;
                    }
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, this.notifiedFiles));
                    GitUtils.headChanged(repository);
                    return;
                }
                this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, this.notifiedFiles));
                GitUtils.headChanged(repository);
                return;
            }

            private boolean isBranch(String revision, Map<String, GitBranch> branches) {
                GitBranch b = branches.get(revision);
                return b != null && b.getName() != "(no branch)";
            }

            private void log(String revision, GitBranch branch) {
                OutputLogger logger = this.getLogger();
                logger.outputLine(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"MSG_CheckoutRevisionAction.branchCreated", (Object[])new Object[]{branch.getName(), revision, branch.getId()}));
            }

            private boolean resolveConflicts(File[] conflicts, boolean mergeAllowed) throws GitException {
                Object[] buttons;
                JButton initialValue;
                JButton merge = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)merge, (String)NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.mergeButton.text"));
                merge.setToolTipText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.mergeButton.TTtext"));
                JButton revert = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)revert, (String)NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.revertButton.text"));
                revert.setToolTipText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.revertButton.TTtext"));
                JButton review = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)review, (String)NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.reviewButton.text"));
                review.setToolTipText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.reviewButton.TTtext"));
                if (mergeAllowed) {
                    initialValue = merge;
                    buttons = new Object[]{merge, revert, review, NotifyDescriptor.CANCEL_OPTION};
                } else {
                    initialValue = review;
                    buttons = new Object[]{revert, review, NotifyDescriptor.CANCEL_OPTION};
                }
                Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(CheckoutRevisionAction.class, (String)"MSG_CheckoutRevisionAction.checkoutConflicts"), NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.checkoutConflicts"), 2, 3, buttons, (Object)initialValue));
                if (o == merge) {
                    return true;
                }
                if (o == revert) {
                    GitClient client = this.getClient();
                    LOG.log(Level.FINE, "Checking out paths from HEAD");
                    client.checkout(conflicts, "HEAD", true, this.getProgressMonitor());
                    LOG.log(Level.FINE, "Cleanup new files");
                    client.clean(conflicts, this.getProgressMonitor());
                    LOG.log(Level.FINE, "Checking out branch: {0}, second shot", this.revision);
                    client.checkoutRevision(this.revision, true, this.getProgressMonitor());
                    this.notifiedFiles.addAll(Arrays.asList(conflicts));
                } else if (o == review) {
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    GitUtils.openInVersioningView(Arrays.asList(conflicts), repository, this.getProgressMonitor());
                }
                return false;
            }

            private File[] getFilesInConflict(String[] conflicts) {
                ArrayList<File> files = new ArrayList<File>(conflicts.length);
                for (String path : conflicts) {
                    files.add(new File(repository, path));
                }
                return files.toArray(new File[files.size()]);
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, progressLabel);
    }

    protected final boolean canCheckout(RepositoryInfo info) {
        boolean canCheckout = true;
        if (!info.getRepositoryState().canCheckout()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_CheckoutRevisionAction_cannotCheckout_invalidState(info.getRepositoryState()), 1));
            canCheckout = false;
        }
        return canCheckout;
    }
}

