/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.fetch.FetchUtils;
import org.netbeans.modules.git.ui.history.Bundle;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;

class SearchExecutor
extends GitProgressSupport {
    private final SearchHistoryPanel master;
    private final int limitRevisions;
    private final boolean showMerges;
    private final String message;
    private final String username;
    private final String fromRevision;
    private final String toRevision;
    private final Date from;
    private final Date to;
    static final int DEFAULT_LIMIT = 10;
    static final int UNLIMITTED = -1;
    private final SearchCriteria sc;
    private final Mode mode;
    private final String branchName;
    private String errMessage;
    private String excludedCommitId;

    public SearchExecutor(SearchHistoryPanel master) throws IllegalArgumentException {
        this.master = master;
        assert (EventQueue.isDispatchThread());
        SearchCriteriaPanel criteria = master.getCriteria();
        this.from = criteria.getFrom();
        this.fromRevision = criteria.getFromRevision();
        this.to = criteria.getTo();
        this.toRevision = criteria.getToRevision();
        this.username = criteria.getUsername();
        this.message = criteria.getCommitMessage();
        int limit = criteria.getLimit();
        this.limitRevisions = limit <= 0 ? -1 : limit;
        this.showMerges = criteria.isIncludeMerges();
        this.branchName = criteria.getBranch();
        this.mode = criteria.getMode();
        this.sc = new SearchCriteria();
        File[] files = master.getRoots();
        if (this.mode == Mode.LOCAL && files != null && files.length > 0 && !files[0].equals(this.getRepositoryRoot())) {
            this.sc.setFiles(files);
            if (files.length == 1 && files[0].isFile()) {
                this.sc.setFollowRenames(true);
            }
        }
        this.sc.setUsername(this.username);
        this.sc.setMessage(this.message);
        this.sc.setIncludeMerges(this.showMerges);
        this.sc.setRevisionFrom(this.fromRevision);
        this.sc.setRevisionTo(this.toRevision);
        this.sc.setFrom(this.from);
        this.sc.setTo(this.to);
    }

    @Override
    public void perform() {
        this.errMessage = null;
        if (this.isCanceled()) {
            return;
        }
        try {
            switch (this.mode) {
                case REMOTE_IN: {
                    Map<String, GitBranch> branches = this.getClient().getBranches(true, this.getProgressMonitor());
                    GitBranch branch = branches.get(this.branchName);
                    if (branch == null) {
                        this.errMessage = Bundle.MSG_SearchExecutor_err_branchDoesNotExist(this.branchName);
                        this.setResults(Collections.emptyList());
                        return;
                    }
                    this.setDisplayName(Bundle.MSG_SearchExecutor_progress_fetching());
                    Revision fetchedHead = null;
                    try {
                        fetchedHead = FetchUtils.fetchToTemp(this.getClient(), this.getProgressMonitor(), branch);
                    }
                    catch (GitException ex) {
                        this.errMessage = ex.getMessage();
                    }
                    if (fetchedHead == null) {
                        this.setResults(Collections.emptyList());
                        return;
                    }
                    this.excludedCommitId = branch.getId();
                    this.sc.setRevisionTo(fetchedHead.getCommitId());
                    break;
                }
                case REMOTE_OUT: {
                    Map<String, GitBranch> branches = this.getClient().getBranches(true, this.getProgressMonitor());
                    GitBranch branch = branches.get(this.branchName);
                    if (branch == null) {
                        this.errMessage = Bundle.MSG_SearchExecutor_err_branchDoesNotExist(this.branchName);
                        this.setResults(Collections.emptyList());
                        return;
                    }
                    GitBranch tracked = branch.getTrackedBranch();
                    if (tracked == null || !tracked.isRemote()) {
                        this.errMessage = Bundle.MSG_SearchExecutor_err_noTrackedBranch(this.branchName);
                        this.setResults(Collections.emptyList());
                        return;
                    }
                    this.excludedCommitId = tracked.getId();
                    this.sc.setRevisionFrom(tracked.getName());
                }
            }
            this.setDisplayName(Bundle.MSG_SearchExecutor_progress_searching());
            List<RepositoryRevision> results = this.search(this.limitRevisions, this.getClient(), this.getProgressMonitor());
            this.setResults(results);
        }
        catch (GitException.MissingObjectException ex) {
            Git.LOG.log(Level.INFO, "Missing object for roots: {0}", Arrays.asList(this.master.getRoots()));
            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
            this.setResults(Collections.emptyList());
        }
        catch (GitException ex) {
            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
            this.setResults(Collections.emptyList());
        }
    }

    String getErrorMessage() {
        return this.errMessage;
    }

    List<RepositoryRevision> search(int limit, GitClient client, ProgressMonitor monitor) throws GitException {
        this.sc.setLimit(limit);
        List<RepositoryRevision> retval = Collections.emptyList();
        GitRevisionInfo[] messages = client.log(this.sc, true, monitor);
        if (!monitor.isCanceled()) {
            RepositoryInfo info = RepositoryInfo.getInstance(this.getRepositoryRoot());
            retval = this.appendResults(messages, info.getBranches().values(), info.getTags().values(), monitor);
        }
        return retval;
    }

    private List<RepositoryRevision> appendResults(GitRevisionInfo[] logMessages, Collection<GitBranch> allBranches, Collection<GitTag> allTags, ProgressMonitor monitor) {
        ArrayList<RepositoryRevision> results = new ArrayList<RepositoryRevision>();
        File dummyFile = null;
        String dummyFileRelativePath = null;
        if (this.master.getRoots().length == 1) {
            dummyFile = this.master.getRoots()[0];
            dummyFileRelativePath = GitUtils.getRelativePath(this.getRepositoryRoot(), dummyFile);
        }
        for (int i = 0; i < logMessages.length && !monitor.isCanceled(); ++i) {
            GitRevisionInfo logMessage = logMessages[i];
            if (logMessage.getRevision().equals(this.excludedCommitId)) continue;
            HashSet<GitBranch> branches = new HashSet<GitBranch>();
            HashSet<GitTag> tags = new HashSet<GitTag>();
            for (GitBranch b : allBranches) {
                if (!b.getId().equals(logMessage.getRevision())) continue;
                branches.add(b);
            }
            for (GitTag t : allTags) {
                if (!t.getTaggedObjectId().equals(logMessage.getRevision())) continue;
                tags.add(t);
            }
            RepositoryRevision rev = new RepositoryRevision(logMessage, this.master.getRepository(), this.master.getRoots(), tags, branches, dummyFile, dummyFileRelativePath, this.mode);
            results.add(rev);
        }
        return results;
    }

    private void setResults(final List<RepositoryRevision> results) {
        final Map<String, VCSKenaiAccessor.KenaiUser> kenaiUserMap = SearchHistoryPanel.createKenaiUsersMap(results);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (results.isEmpty()) {
                    SearchExecutor.this.master.setResults(null, kenaiUserMap, -1);
                } else {
                    SearchExecutor.this.master.setResults(results, kenaiUserMap, SearchExecutor.this.limitRevisions);
                }
            }
        });
    }

    static enum Mode {
        LOCAL,
        REMOTE_IN,
        REMOTE_OUT;

    }
}

