/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoTable;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.MACINFO;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.StringTableSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfMacroInfoSection
extends ElfSection {
    private final HashMap<Long, DwarfMacinfoTable> macinfoTables = new HashMap();
    private final boolean isMacro;
    private int offstSize = 4;
    private long headerSize = 0L;

    public DwarfMacroInfoSection(DwarfReader reader, int sectionIdx, boolean isMacro) {
        super(reader, sectionIdx);
        this.isMacro = isMacro;
    }

    public DwarfMacinfoTable getMacinfoTable(long offset) {
        Long lOffset = offset;
        DwarfMacinfoTable table = this.macinfoTables.get(lOffset);
        if (table == null) {
            table = new DwarfMacinfoTable(this, offset);
            this.macinfoTables.put(lOffset, table);
        }
        return table;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long readMacinfoTable(DwarfMacinfoTable table, long offset, boolean baseOnly) throws IOException {
        long currPos = this.reader.getFilePointer();
        this.reader.seek(this.header.getSectionOffset() + offset);
        this.offstSize = 4;
        long labelSectionAdress = -1L;
        if (this.isMacro) {
            short dwarfVersion = this.reader.readShort();
            byte bitness = this.reader.readByte();
            if ((bitness & 1) == 1) {
                this.offstSize = 8;
            }
            this.headerSize = this.reader.getFilePointer() - (this.header.getSectionOffset() + offset);
            if ((bitness & 2) == 2) {
                labelSectionAdress = this.offstSize == 4 ? (long)this.reader.readInt() : this.reader.readLong();
            }
            if ((bitness & 4) == 4) {
                int count = this.reader.readByte() & 0xFF;
                for (int i = 0; i < count; ++i) {
                    byte opcode = this.reader.readByte();
                    long arg = this.reader.readUnsignedLEB128();
                    this.reader.seek(this.reader.getFilePointer() + arg);
                }
            }
        }
        MACINFO type = MACINFO.get(this.reader.readByte());
        if (baseOnly && type != null && type.equals((Object)MACINFO.DW_MACINFO_start_file)) {
            long pos = this.reader.getFilePointer();
            long lineNum = this.reader.readUnsignedLEB128();
            if (lineNum == 0L) {
                long fileIdx = this.reader.readUnsignedLEB128();
            } else {
                this.reader.seek(pos);
            }
            type = MACINFO.get(this.reader.readByte());
        }
        Stack<Integer> fileIndeces = new Stack<Integer>();
        int fileIdx = -1;
        Stack<Long> indirect = new Stack<Long>();
        block10: while (!(type == null || baseOnly && fileIdx != -1)) {
            switch (type) {
                case DW_MACINFO_define: 
                case DW_MACINFO_undef: {
                    DwarfMacinfoEntry entry = new DwarfMacinfoEntry(type);
                    entry.lineNum = this.reader.readUnsignedLEB128();
                    entry.definition = this.reader.readString();
                    entry.fileIdx = fileIdx;
                    table.addEntry(entry);
                    break;
                }
                case DW_MACINFO_start_file: {
                    if (baseOnly) break block10;
                    DwarfMacinfoEntry entry = new DwarfMacinfoEntry(type);
                    entry.lineNum = this.reader.readUnsignedLEB128();
                    entry.fileIdx = this.reader.readUnsignedLEB128();
                    fileIndeces.push(fileIdx);
                    fileIdx = entry.fileIdx;
                    table.addEntry(entry);
                    break;
                }
                case DW_MACINFO_end_file: {
                    DwarfMacinfoEntry entry = new DwarfMacinfoEntry(type);
                    entry.fileIdx = fileIdx;
                    table.addEntry(entry);
                    if (fileIndeces.empty()) break;
                    fileIdx = (Integer)fileIndeces.pop();
                    break;
                }
                case DW_MACINFO_vendor_ext: {
                    this.reader.readUnsignedLEB128();
                    this.reader.readString();
                    break;
                }
                case DW_MACRO_define_indirect_alt: 
                case DW_MACRO_define_indirect: 
                case DW_MACRO_undef_indirect_alt: 
                case DW_MACRO_undef_indirect: {
                    DwarfMacinfoEntry entry = new DwarfMacinfoEntry(type);
                    entry.lineNum = this.reader.readUnsignedLEB128();
                    long adress = this.offstSize == 4 ? (long)this.reader.readInt() : this.reader.readLong();
                    if (type == MACINFO.DW_MACRO_define_indirect || type == MACINFO.DW_MACRO_undef_indirect) {
                        entry.definition = ((StringTableSection)this.reader.getSection(".debug_str")).getString(adress);
                    }
                    entry.fileIdx = fileIdx;
                    table.addEntry(entry);
                    break;
                }
                case DW_MACRO_transparent_include_alt: {
                    if (this.offstSize == 4) {
                        long index = this.reader.readInt();
                        break;
                    }
                    long index = this.reader.readLong();
                    break;
                }
                case DW_MACRO_transparent_include: {
                    long index = this.offstSize == 4 ? (long)this.reader.readInt() : this.reader.readLong();
                    if (index <= 0L) break;
                    long savePosition = this.reader.getFilePointer();
                    if (indirect.contains(savePosition)) {
                        System.err.println("infinite indirection in macro section of " + this.reader.getFileName());
                        break;
                    }
                    indirect.push(savePosition);
                    this.reader.seek(this.header.getSectionOffset() + index + this.headerSize);
                }
            }
            byte readByte = this.reader.readByte();
            while (readByte == 0 && !indirect.empty()) {
                long savePosition = (Long)indirect.pop();
                this.reader.seek(savePosition);
                readByte = this.reader.readByte();
            }
            type = MACINFO.get(readByte);
        }
        long readBytes = this.reader.getFilePointer() - (this.header.getSectionOffset() + offset + 1L);
        this.reader.seek(currPos);
        return readBytes;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<Integer> getCommandIncudedFiles(DwarfMacinfoTable table, long offset, long base) throws IOException {
        ArrayList<Integer> res = new ArrayList<Integer>();
        this.reader.seek(this.header.getSectionOffset() + offset);
        this.offstSize = 4;
        long labelSectionAdress = -1L;
        if (this.isMacro) {
            short dwarfVersion = this.reader.readShort();
            byte bitness = this.reader.readByte();
            if ((bitness & 1) == 1) {
                this.offstSize = 8;
            }
            this.headerSize = this.reader.getFilePointer() - (this.header.getSectionOffset() + offset);
            if ((bitness & 2) == 2) {
                labelSectionAdress = this.offstSize == 4 ? (long)this.reader.readInt() : this.reader.readLong();
            }
            if ((bitness & 4) == 4) {
                int count = this.reader.readByte() & 0xFF;
                for (int i = 0; i < count; ++i) {
                    byte opcode = this.reader.readByte();
                    long arg = this.reader.readUnsignedLEB128();
                    this.reader.seek(this.reader.getFilePointer() + arg);
                }
            }
        }
        int level = 0;
        Stack<Long> indirect = new Stack<Long>();
        while (true) {
            byte readByte = this.reader.readByte();
            while (readByte == 0 && !indirect.empty()) {
                long savePosition = (Long)indirect.pop();
                this.reader.seek(savePosition);
                readByte = this.reader.readByte();
            }
            MACINFO type = MACINFO.get(readByte);
            if (type == null) {
                return res;
            }
            switch (type) {
                case DW_MACINFO_start_file: {
                    int lineNum = this.reader.readUnsignedLEB128();
                    int fileIdx = this.reader.readUnsignedLEB128();
                    if (++level != 1) break;
                    if (lineNum != 0) return res;
                    res.add(fileIdx);
                    break;
                }
                case DW_MACINFO_end_file: {
                    if (level <= 0) break;
                    --level;
                    break;
                }
                case DW_MACINFO_vendor_ext: {
                    this.reader.readUnsignedLEB128();
                    this.reader.readString();
                    break;
                }
                case DW_MACINFO_define: 
                case DW_MACINFO_undef: {
                    int lineNum = this.reader.readUnsignedLEB128();
                    this.reader.readString();
                    break;
                }
                case DW_MACRO_define_indirect_alt: 
                case DW_MACRO_define_indirect: 
                case DW_MACRO_undef_indirect_alt: 
                case DW_MACRO_undef_indirect: {
                    long adress;
                    int lineNum = this.reader.readUnsignedLEB128();
                    if (this.offstSize == 4) {
                        adress = this.reader.readInt();
                        break;
                    }
                    adress = this.reader.readLong();
                    break;
                }
                case DW_MACRO_transparent_include_alt: {
                    long index;
                    if (this.offstSize == 4) {
                        index = this.reader.readInt();
                        break;
                    }
                    index = this.reader.readLong();
                    break;
                }
                case DW_MACRO_transparent_include: {
                    long index = this.offstSize == 4 ? (long)this.reader.readInt() : this.reader.readLong();
                    if (index <= 0L) break;
                    long savePosition = this.reader.getFilePointer();
                    if (indirect.contains(savePosition)) {
                        System.err.println("infinite indirection in macro section of " + this.reader.getFileName());
                        break;
                    }
                    indirect.push(savePosition);
                    this.reader.seek(this.header.getSectionOffset() + offset + index + this.headerSize);
                }
            }
        }
    }

    @Override
    public void dump(PrintStream out) {
        super.dump(out);
        for (DwarfMacinfoTable macinfoTable : this.macinfoTables.values()) {
            macinfoTable.dump(out);
        }
    }

    @Override
    public String toString() {
        try {
            ByteArrayOutputStream st = new ByteArrayOutputStream();
            PrintStream out = new PrintStream((OutputStream)st, false, "UTF-8");
            this.dump(out);
            return st.toString("UTF-8");
        }
        catch (IOException ex) {
            return "";
        }
    }
}

