/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.extjs.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.parsing.api.Snapshot;

public class ExtNamespaceFunctionInterceptor
implements FunctionInterceptor {
    public Collection<TypeUsage> intercept(Snapshot snapshot, String functionName, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (args.size() == 1) {
            Iterator<FunctionArgument> iterator = args.iterator();
            FunctionArgument arg1 = iterator.next();
            int offset = arg1.getOffset();
            if (arg1.getKind() == FunctionArgument.Kind.STRING) {
                JsObject parent;
                JsObject oldParent = parent = globalObject;
                StringTokenizer st = new StringTokenizer((String)arg1.getValue(), ".");
                while (st.hasMoreTokens()) {
                    OffsetRange offsetRange;
                    String name = st.nextToken();
                    JsObject jsObject = oldParent.getProperty(name);
                    if (jsObject == null) {
                        offsetRange = new OffsetRange(offset, offset + name.length());
                        jsObject = factory.newObject(parent, name, offsetRange, true);
                        parent.addProperty(name, jsObject);
                        oldParent = jsObject;
                    } else if (!jsObject.isDeclared()) {
                        offsetRange = new OffsetRange(offset, offset + name.length());
                        JsObject newJsObject = factory.newObject(parent, name, offsetRange, true);
                        parent.addProperty(name, newJsObject);
                        for (Occurrence occurrence : jsObject.getOccurrences()) {
                            newJsObject.addOccurrence(occurrence.getOffsetRange());
                        }
                        newJsObject.addOccurrence(jsObject.getDeclarationName().getOffsetRange());
                        oldParent = jsObject;
                        jsObject = newJsObject;
                    }
                    parent = jsObject;
                    offset += name.length() + 1;
                }
            }
        }
        return Collections.emptyList();
    }

    public Pattern getNamePattern() {
        return Pattern.compile("Ext\\.namespace");
    }
}

