/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.importexport.model.CreateJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    @Override
    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        DefaultRequest<CreateJobRequest> request = new DefaultRequest<CreateJobRequest>(createJobRequest, "AmazonImportExport");
        request.addParameter("Action", "CreateJob");
        request.addParameter("Version", "2010-06-01");
        if (createJobRequest != null && createJobRequest.getJobType() != null) {
            request.addParameter("JobType", StringUtils.fromString(createJobRequest.getJobType()));
        }
        if (createJobRequest != null && createJobRequest.getManifest() != null) {
            request.addParameter("Manifest", StringUtils.fromString(createJobRequest.getManifest()));
        }
        if (createJobRequest != null && createJobRequest.getManifestAddendum() != null) {
            request.addParameter("ManifestAddendum", StringUtils.fromString(createJobRequest.getManifestAddendum()));
        }
        if (createJobRequest != null && createJobRequest.isValidateOnly() != null) {
            request.addParameter("ValidateOnly", StringUtils.fromBoolean(createJobRequest.isValidateOnly()));
        }
        return request;
    }
}

